/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.util.indexing.ID;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class PerIndexDocumentVersionMap {
    private static final int INVALID_STAMP = -1;
    private volatile int mapVersion;
    private static final Key<List<IdVersionInfo>> KEY = Key.create((String)"UnsavedDocIdVersionInfo");

    PerIndexDocumentVersionMap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long set(@NotNull Document document, @NotNull ID<?, ?> indexId, long value2) {
        List list2 = (List)document.getUserData(KEY);
        if (list2 == null) {
            list2 = (List)((UserDataHolderEx)document).putUserDataIfAbsent(KEY, new ArrayList());
        }
        List list3 = list2;
        synchronized (list3) {
            for (IdVersionInfo info : list2) {
                if (info.id != indexId) continue;
                long old = info.docVersion;
                if (info.mapVersion != this.mapVersion) {
                    old = -1L;
                    info.mapVersion = this.mapVersion;
                }
                info.docVersion = value2;
                return old;
            }
            list2.add(new IdVersionInfo(indexId, value2, this.mapVersion));
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long get(@NotNull Document document, @NotNull ID<?, ?> indexId) {
        List list2 = (List)document.getUserData(KEY);
        if (list2 == null) {
            return -1L;
        }
        List list3 = list2;
        synchronized (list3) {
            for (IdVersionInfo info : list2) {
                if (info.id != indexId) continue;
                long old = info.docVersion;
                if (info.mapVersion != this.mapVersion) {
                    return -1L;
                }
                return old;
            }
            return -1L;
        }
    }

    void clearForDocument(@NotNull Document document) {
        document.putUserData(KEY, new ArrayList());
    }

    void clear() {
        ++this.mapVersion;
    }

    private static class IdVersionInfo {
        private final ID<?, ?> id;
        private int mapVersion;
        private long docVersion;

        private IdVersionInfo(@NotNull ID<?, ?> id2, long docVersion, int mapVersion) {
            this.docVersion = docVersion;
            this.mapVersion = mapVersion;
            this.id = id2;
        }
    }
}

