/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.flavor.FileIndexingFlavorProvider;
import com.intellij.util.indexing.flavor.HashBuilder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class IndexedHashesSupport {
    private static final HashFunction INDEXED_FILE_CONTENT_HASHER = Hashing.sha1();

    public static int getVersion() {
        return 3;
    }

    public static byte @NotNull [] getOrInitIndexedHash(@NotNull FileContentImpl content2) {
        byte[] hash = content2.getHash();
        if (hash == null) {
            hash = IndexedHashesSupport.calculateIndexedHashForFileContent(content2);
            content2.setHashes(hash);
        }
        return hash;
    }

    public static byte @NotNull [] getBinaryContentHash(byte @NotNull [] content2) {
        MessageDigest digest = FSRecords.getContentHashDigest();
        digest.update(String.valueOf(content2.length).getBytes(StandardCharsets.UTF_8));
        digest.update("\u0000".getBytes(StandardCharsets.UTF_8));
        digest.update(content2);
        return digest.digest();
    }

    private static byte @NotNull [] calculateIndexedHashForFileContent(@NotNull FileContentImpl content2) {
        final Hasher hasher = INDEXED_FILE_CONTENT_HASHER.newHasher();
        byte[] contentHash = PersistentFSImpl.getContentHashIfStored(content2.getFile());
        if (contentHash == null) {
            contentHash = IndexedHashesSupport.getBinaryContentHash(content2.getContent());
        }
        hasher.putBytes(contentHash);
        if (!content2.getFileTypeWithoutSubstitution().isBinary()) {
            hasher.putString((CharSequence)content2.getCharset().name(), StandardCharsets.UTF_8);
        }
        hasher.putString((CharSequence)content2.getFileName(), StandardCharsets.UTF_8);
        FileType fileType = content2.getFileType();
        hasher.putString((CharSequence)fileType.getName(), StandardCharsets.UTF_8);
        @Nullable FileIndexingFlavorProvider provider = (FileIndexingFlavorProvider)FileIndexingFlavorProvider.INSTANCE.forFileType(fileType);
        if (provider != null) {
            IndexedHashesSupport.buildFlavorHash((FileContent)content2, provider, new HashBuilder(){

                @NotNull
                public HashBuilder putInt(int val) {
                    hasher.putInt(val);
                    return this;
                }

                @NotNull
                public HashBuilder putBoolean(boolean val) {
                    hasher.putBoolean(val);
                    return this;
                }

                @NotNull
                public HashBuilder putString(@NotNull CharSequence charSequence) {
                    hasher.putString(charSequence, StandardCharsets.UTF_8);
                    return this;
                }
            });
        }
        return hasher.hash().asBytes();
    }

    private static <F> void buildFlavorHash(@NotNull FileContent content2, @NotNull FileIndexingFlavorProvider<F> flavorProvider, @NotNull HashBuilder hashBuilder) {
        Object flavor = flavorProvider.getFlavor((IndexedFile)content2);
        hashBuilder.putString((CharSequence)flavorProvider.getId());
        hashBuilder.putInt(flavorProvider.getVersion());
        if (flavor != null) {
            flavorProvider.buildHash(flavor, hashBuilder);
        }
    }
}

