/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.model.ModelBranch;
import com.intellij.model.ModelBranchImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexAccessValidator;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.InvertedIndexUtil;
import com.intellij.util.indexing.ProjectIndexableFilesFilter;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.impl.InvertedIndexValueIterator;
import com.intellij.util.indexing.roots.IndexableFilesProvider;
import com.intellij.util.indexing.roots.IndexableSetContributorFilesProvider;
import com.intellij.util.indexing.roots.LibraryIndexableFilesProvider;
import com.intellij.util.indexing.roots.ModuleIndexableFilesProvider;
import com.intellij.util.indexing.roots.SdkIndexableFilesProvider;
import com.intellij.util.indexing.roots.SyntheticLibraryIndexableFilesProvider;
import gnu.trove.THashSet;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class FileBasedIndexEx
extends FileBasedIndex {
    private final IndexAccessValidator myAccessValidator = new IndexAccessValidator();

    @ApiStatus.Internal
    @NotNull
    public abstract IntPredicate getAccessibleFileIdFilter(@Nullable Project var1);

    @ApiStatus.Internal
    public abstract ProjectIndexableFilesFilter projectIndexableFiles(@Nullable Project var1);

    @ApiStatus.Internal
    public abstract <K, V> UpdatableIndex<K, V, FileContent> getIndex(ID<K, V> var1);

    @ApiStatus.Internal
    public abstract void waitUntilIndicesAreInitialized();

    @ApiStatus.Internal
    public abstract <K> boolean ensureUpToDate(@NotNull ID<K, ?> var1, @Nullable Project var2, @Nullable GlobalSearchScope var3, @Nullable VirtualFile var4);

    @NotNull
    public <K, V> List<V> getValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull GlobalSearchScope filter2) {
        Iterator virtualFileIterator;
        VirtualFile restrictToFile = null;
        if (filter2 instanceof Iterable && (virtualFileIterator = ((Iterable)filter2).iterator()).hasNext()) {
            VirtualFile restrictToFileCandidate = (VirtualFile)virtualFileIterator.next();
            if (!virtualFileIterator.hasNext()) {
                restrictToFile = restrictToFileCandidate;
            }
        }
        SmartList values2 = new SmartList();
        FileBasedIndex.ValueProcessor processor2 = (arg_0, arg_1) -> FileBasedIndexEx.lambda$getValues$0((List)values2, arg_0, arg_1);
        if (restrictToFile != null) {
            this.processValuesInOneFile(indexId, dataKey, restrictToFile, filter2, processor2);
        } else {
            this.processValuesInScope(indexId, dataKey, true, filter2, null, processor2);
        }
        return values2;
    }

    @NotNull
    public <K> Collection<K> getAllKeys(@NotNull ID<K, ?> indexId, @NotNull Project project) {
        THashSet allKeys = new THashSet();
        this.processAllKeys(indexId, Processors.cancelableCollectProcessor((Collection)allKeys), project);
        return allKeys;
    }

    public <K> boolean processAllKeys(@NotNull ID<K, ?> indexId, @NotNull Processor<? super K> processor2, @Nullable Project project) {
        return this.processAllKeys(indexId, processor2, (GlobalSearchScope)(project == null ? new EverythingGlobalScope() : GlobalSearchScope.allScope((Project)project)), null);
    }

    public <K> boolean processAllKeys(@NotNull ID<K, ?> indexId, @NotNull Processor<? super K> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        try {
            this.waitUntilIndicesAreInitialized();
            UpdatableIndex index = this.getIndex(indexId);
            if (index == null) {
                return true;
            }
            if (!this.ensureUpToDate(indexId, scope.getProject(), scope, null)) {
                return true;
            }
            if (idFilter == null) {
                idFilter = this.projectIndexableFiles(scope.getProject());
            }
            @Nullable IdFilter finalIdFilter = idFilter;
            return (Boolean)this.myAccessValidator.validate(indexId, () -> index.processAllKeys(processor2, scope, finalIdFilter));
        }
        catch (StorageException e) {
            this.scheduleRebuild(indexId, e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StorageException || cause instanceof IOException) {
                this.scheduleRebuild(indexId, cause);
            }
            throw e;
        }
        return false;
    }

    @NotNull
    public <K, V> Map<K, V> getFileData(@NotNull ID<K, V> id2, @NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (!(virtualFile instanceof VirtualFileWithId)) {
            return Collections.emptyMap();
        }
        int fileId = FileBasedIndexEx.getFileId((VirtualFile)virtualFile);
        if (this.getAccessibleFileIdFilter(project).test(fileId)) {
            Map map2 = (Map)this.processExceptions(id2, virtualFile, GlobalSearchScope.fileScope((Project)project, (VirtualFile)virtualFile), index -> index.getIndexedFileData(fileId));
            return ContainerUtil.notNullize((Map)map2);
        }
        return Collections.emptyMap();
    }

    @NotNull
    public <K, V> Collection<VirtualFile> getContainingFiles(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull GlobalSearchScope filter2) {
        THashSet files2 = new THashSet();
        this.processValuesInScope(indexId, dataKey, false, filter2, null, (arg_0, arg_1) -> FileBasedIndexEx.lambda$getContainingFiles$3((Set)files2, arg_0, arg_1));
        return files2;
    }

    public <K, V> boolean processValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile inFile, @NotNull FileBasedIndex.ValueProcessor<? super V> processor2, @NotNull GlobalSearchScope filter2) {
        return this.processValues(indexId, dataKey, inFile, processor2, filter2, null);
    }

    public <K, V> boolean processValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile inFile, @NotNull FileBasedIndex.ValueProcessor<? super V> processor2, @NotNull GlobalSearchScope filter2, @Nullable IdFilter idFilter) {
        return inFile != null ? this.processValuesInOneFile(indexId, dataKey, inFile, filter2, processor2) : this.processValuesInScope(indexId, dataKey, false, filter2, idFilter, processor2);
    }

    public <K, V> long getIndexModificationStamp(@NotNull ID<K, V> indexId, @NotNull Project project) {
        UpdatableIndex<K, V, FileContent> index = this.getIndex(indexId);
        this.ensureUpToDate(indexId, project, GlobalSearchScope.allScope((Project)project));
        return index.getModificationStamp();
    }

    @Nullable
    private <K, V, R> R processExceptions(@NotNull ID<K, V> indexId, @Nullable VirtualFile restrictToFile, @NotNull GlobalSearchScope filter2, @NotNull ThrowableConvertor<? super UpdatableIndex<K, V, FileContent>, ? extends R, ? extends StorageException> computable) {
        try {
            this.waitUntilIndicesAreInitialized();
            UpdatableIndex index = this.getIndex(indexId);
            if (index == null) {
                return null;
            }
            Project project = filter2.getProject();
            if (!this.ensureUpToDate(indexId, project, filter2, restrictToFile)) {
                return null;
            }
            return (R)this.myAccessValidator.validate(indexId, () -> ConcurrencyUtil.withLock((Lock)index.getLock().readLock(), () -> computable.convert((Object)index)));
        }
        catch (StorageException e) {
            this.scheduleRebuild(indexId, e);
        }
        catch (RuntimeException e) {
            Throwable cause = FileBasedIndexImpl.getCauseToRebuildIndex(e);
            if (cause != null) {
                this.scheduleRebuild(indexId, cause);
            }
            throw e;
        }
        return null;
    }

    private <K, V> boolean processValuesInOneFile(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull VirtualFile restrictToFile, @NotNull GlobalSearchScope scope, @NotNull FileBasedIndex.ValueProcessor<? super V> processor2) {
        Project project = scope.getProject();
        if (!(restrictToFile instanceof VirtualFileWithId)) {
            return project == null || ModelBranch.getFileBranch((VirtualFile)restrictToFile) == null || this.processInMemoryFileData(indexId, dataKey, project, restrictToFile, processor2);
        }
        int restrictedFileId = FileBasedIndexEx.getFileId((VirtualFile)restrictToFile);
        if (!this.getAccessibleFileIdFilter(project).test(restrictedFileId)) {
            return true;
        }
        return this.processValueIterator(indexId, dataKey, restrictToFile, scope, valueIt -> {
            while (valueIt.hasNext()) {
                Object value2 = valueIt.next();
                if (valueIt.getValueAssociationPredicate().contains(restrictedFileId) && !processor2.process(restrictToFile, value2)) {
                    return false;
                }
                ProgressManager.checkCanceled();
            }
            return true;
        });
    }

    private <K, V> boolean processInMemoryFileData(ID<K, V> indexId, K dataKey, Project project, VirtualFile file2, FileBasedIndex.ValueProcessor<? super V> processor2) {
        Map<K, V> data2 = this.getFileData(indexId, file2, project);
        return !data2.containsKey(dataKey) || processor2.process(file2, data2.get(dataKey));
    }

    private <K, V> boolean processValuesInScope(@NotNull ID<K, V> indexId, @NotNull K dataKey, boolean ensureValueProcessedOnce, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter, @NotNull FileBasedIndex.ValueProcessor<? super V> processor2) {
        Project project = scope.getProject();
        if (project != null && !ModelBranchImpl.processBranchedFilesInScope(scope, (Processor<? super VirtualFile>)((Processor)file2 -> this.processInMemoryFileData(indexId, dataKey, project, (VirtualFile)file2, processor2)))) {
            return false;
        }
        PersistentFS fs = PersistentFS.getInstance();
        IdFilter filter2 = idFilter != null ? idFilter : this.projectIndexableFiles(project);
        IntPredicate accessibleFileFilter = this.getAccessibleFileIdFilter(project);
        return this.processValueIterator(indexId, dataKey, null, scope, valueIt -> {
            block0: while (valueIt.hasNext()) {
                Object value2 = valueIt.next();
                ValueContainer.IntIterator inputIdsIterator = valueIt.getInputIdsIterator();
                while (inputIdsIterator.hasNext()) {
                    int id2 = inputIdsIterator.next();
                    if (!accessibleFileFilter.test(id2) || filter2 != null && !filter2.containsFileId(id2)) continue;
                    VirtualFile file2 = IndexInfrastructure.findFileByIdIfCached(fs, id2);
                    if (file2 != null && scope.accept(file2)) {
                        if (!processor2.process(file2, value2)) {
                            return false;
                        }
                        if (ensureValueProcessedOnce) {
                            ProgressManager.checkCanceled();
                            continue block0;
                        }
                    }
                    ProgressManager.checkCanceled();
                }
            }
            return true;
        });
    }

    private <K, V> boolean processValueIterator(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile restrictToFile, @NotNull GlobalSearchScope scope, @NotNull Processor<? super InvertedIndexValueIterator<V>> valueProcessor) {
        Boolean result2 = (Boolean)this.processExceptions(indexId, restrictToFile, scope, index -> valueProcessor.process((Object)((InvertedIndexValueIterator)index.getData(dataKey).getValueIterator())));
        return result2 == null || result2 != false;
    }

    public <K, V> boolean processFilesContainingAllKeys(@NotNull ID<K, V> indexId, @NotNull Collection<? extends K> dataKeys, @NotNull GlobalSearchScope filter2, @Nullable Condition<? super V> valueChecker, @NotNull Processor<? super VirtualFile> processor2) {
        ProjectIndexableFilesFilter filesSet = this.projectIndexableFiles(filter2.getProject());
        IntSet set = this.collectFileIdsContainingAllKeys(indexId, dataKeys, filter2, valueChecker, filesSet);
        return set != null && FileBasedIndexEx.processVirtualFiles((IntIterable)set, (VirtualFileFilter)filter2, processor2);
    }

    public <K, V> boolean getFilesWithKey(@NotNull ID<K, V> indexId, @NotNull Set<? extends K> dataKeys, @NotNull Processor<? super VirtualFile> processor2, @NotNull GlobalSearchScope filter2) {
        return this.processFilesContainingAllKeys(indexId, dataKeys, filter2, null, processor2);
    }

    public <K> void scheduleRebuild(@NotNull ID<K, ?> indexId, @NotNull Throwable e) {
        this.requestRebuild(indexId, e);
    }

    public <K> void ensureUpToDate(@NotNull ID<K, ?> indexId, @Nullable Project project, @Nullable GlobalSearchScope filter2) {
        this.waitUntilIndicesAreInitialized();
        this.ensureUpToDate(indexId, project, filter2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterateIndexableFiles(@NotNull ContentIterator processor2, @NotNull Project project, @Nullable ProgressIndicator indicator) {
        List<IndexableFilesProvider> providers = this.getOrderedIndexableFilesProviders(project);
        ConcurrentBitSet visitedFileSet = new ConcurrentBitSet();
        boolean wasIndeterminate = false;
        if (indicator != null) {
            wasIndeterminate = indicator.isIndeterminate();
            indicator.setIndeterminate(false);
            indicator.setFraction(0.0);
            indicator.pushState();
        }
        try {
            for (int i2 = 0; i2 < providers.size(); ++i2) {
                IndexableFilesProvider provider;
                if (indicator != null) {
                    indicator.checkCanceled();
                }
                if (!(provider = providers.get(i2)).iterateFiles(project, processor2, visitedFileSet)) {
                    break;
                }
                if (indicator == null) continue;
                indicator.setFraction((double)(i2 + 1) * 1.0 / (double)providers.size());
            }
        }
        finally {
            if (indicator != null) {
                indicator.popState();
                indicator.setIndeterminate(wasIndeterminate);
            }
        }
    }

    @NotNull
    public List<IndexableFilesProvider> getOrderedIndexableFilesProviders(@NotNull Project project) {
        if (LightEdit.owns((Project)project)) {
            return Collections.emptyList();
        }
        return (List)ReadAction.compute(() -> {
            if (project.isDisposed()) {
                return Collections.emptyList();
            }
            HashSet<Library> seenLibraries = new HashSet<Library>();
            HashSet<Sdk> seenSdks = new HashSet<Sdk>();
            ArrayList<IndexableFilesProvider> providers = new ArrayList<IndexableFilesProvider>();
            Module[] modules2 = ModuleManager.getInstance((Project)project).getSortedModules();
            for (Module module : modules2) {
                OrderEntry[] orderEntries;
                providers.add(new ModuleIndexableFilesProvider(module));
                for (OrderEntry orderEntry : orderEntries = ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                    Sdk sdk2;
                    Library library;
                    if (orderEntry instanceof LibraryOrderEntry && (library = ((LibraryOrderEntry)orderEntry).getLibrary()) != null && seenLibraries.add(library)) {
                        providers.add(new LibraryIndexableFilesProvider(library));
                    }
                    if (!(orderEntry instanceof JdkOrderEntry) || (sdk2 = ((JdkOrderEntry)orderEntry).getJdk()) == null || !seenSdks.add(sdk2)) continue;
                    providers.add(new SdkIndexableFilesProvider(sdk2));
                }
            }
            for (IndexableSetContributor contributor : IndexableSetContributor.EP_NAME.getExtensionList()) {
                providers.add(new IndexableSetContributorFilesProvider(contributor));
            }
            for (AdditionalLibraryRootsProvider provider : AdditionalLibraryRootsProvider.EP_NAME.getExtensionList()) {
                for (SyntheticLibrary library : provider.getAdditionalProjectLibraries(project)) {
                    providers.add(new SyntheticLibraryIndexableFilesProvider(library));
                }
            }
            return providers;
        });
    }

    @Nullable
    private <K, V> IntSet collectFileIdsContainingAllKeys(@NotNull ID<K, V> indexId, @NotNull Collection<? extends K> dataKeys, @NotNull GlobalSearchScope filter2, @Nullable Condition<? super V> valueChecker, @Nullable ProjectIndexableFilesFilter projectFilesFilter) {
        IntPredicate accessibleFileFilter = this.getAccessibleFileIdFilter(filter2.getProject());
        ValueContainer.IntPredicate idChecker = projectFilesFilter == null ? accessibleFileFilter::test : id2 -> projectFilesFilter.containsFileId(id2) && accessibleFileFilter.test(id2);
        Condition keyChecker = __ -> {
            ProgressManager.checkCanceled();
            return true;
        };
        ThrowableConvertor convertor = index -> InvertedIndexUtil.collectInputIdsContainingAllKeys((InvertedIndex)index, (Collection)dataKeys, (Condition)keyChecker, (Condition)valueChecker, (ValueContainer.IntPredicate)idChecker);
        return (IntSet)this.processExceptions(indexId, null, filter2, convertor);
    }

    private static boolean processVirtualFiles(@NotNull IntIterable ids, @NotNull VirtualFileFilter filter2, @NotNull Processor<? super VirtualFile> processor2) {
        PersistentFS fs = PersistentFS.getInstance();
        IntIterator iterator2 = ids.iterator();
        while (iterator2.hasNext()) {
            ProgressManager.checkCanceled();
            int id2 = iterator2.nextInt();
            VirtualFile file2 = IndexInfrastructure.findFileByIdIfCached(fs, id2);
            if (file2 == null || !filter2.accept(file2)) continue;
            boolean processNext2 = processor2.process((Object)file2);
            ProgressManager.checkCanceled();
            if (processNext2) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$getContainingFiles$3(Set files2, VirtualFile file2, Object value2) {
        files2.add(file2);
        return true;
    }

    private static /* synthetic */ boolean lambda$getValues$0(List values2, VirtualFile file2, Object value2) {
        values2.add(value2);
        return true;
    }
}

