/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.plaf.UIResource;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TreeAction
extends AbstractAction
implements UIResource {
    private static final List<TreeAction> ACTIONS = Arrays.asList(new TreeAction(TreeAction::selectFirst, "selectFirst", KeyStroke.getKeyStroke(36, 0)), new TreeAction(TreeAction::selectFirstChangeLead, "selectFirstChangeLead", new KeyStroke[0]), new TreeAction(TreeAction::selectFirstExtendSelection, "selectFirstExtendSelection", new KeyStroke[0]), new TreeAction(TreeAction::selectLast, "selectLast", KeyStroke.getKeyStroke(35, 0)), new TreeAction(TreeAction::selectLastChangeLead, "selectLastChangeLead", new KeyStroke[0]), new TreeAction(TreeAction::selectLastExtendSelection, "selectLastExtendSelection", new KeyStroke[0]), new TreeAction(TreeAction::selectPrevious, "selectPrevious", KeyStroke.getKeyStroke(38, 0), KeyStroke.getKeyStroke(224, 0)), new TreeAction(TreeAction::selectPreviousChangeLead, "selectPreviousChangeLead", new KeyStroke[0]), new TreeAction(TreeAction::selectPreviousExtendSelection, "selectPreviousExtendSelection", new KeyStroke[0]), new TreeAction(TreeAction::selectNext, "selectNext", KeyStroke.getKeyStroke(40, 0), KeyStroke.getKeyStroke(225, 0)), new TreeAction(TreeAction::selectNextChangeLead, "selectNextChangeLead", new KeyStroke[0]), new TreeAction(TreeAction::selectNextExtendSelection, "selectNextExtendSelection", new KeyStroke[0]), new TreeAction(TreeAction::selectParent, "selectParent", KeyStroke.getKeyStroke(37, 0), KeyStroke.getKeyStroke(226, 0)), new TreeAction(TreeAction::selectChild, "selectChild", KeyStroke.getKeyStroke(39, 0), KeyStroke.getKeyStroke(227, 0)), new TreeAction(TreeAction::scrollUpChangeSelection, "scrollUpChangeSelection", KeyStroke.getKeyStroke(33, 0)), new TreeAction(TreeAction::scrollUpChangeLead, "scrollUpChangeLead", new KeyStroke[0]), new TreeAction(TreeAction::scrollUpExtendSelection, "scrollUpExtendSelection", new KeyStroke[0]), new TreeAction(TreeAction::scrollDownChangeSelection, "scrollDownChangeSelection", KeyStroke.getKeyStroke(34, 0)), new TreeAction(TreeAction::scrollDownChangeLead, "scrollDownChangeLead", new KeyStroke[0]), new TreeAction(TreeAction::scrollDownExtendSelection, "scrollDownExtendSelection", new KeyStroke[0]));
    private final String name;
    private final Consumer<JTree> action;
    private final List<KeyStroke> keys;

    private TreeAction(@NotNull Consumer<JTree> action2, @NotNull String name, KeyStroke ... keys2) {
        this.name = name;
        this.action = action2;
        this.keys = Arrays.asList(keys2);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source instanceof JTree) {
            this.action.accept((JTree)source);
        }
    }

    static void installTo(@NotNull ActionMap map2) {
        Object[] keys2 = map2.keys();
        if (keys2 != null && keys2.length != 0) {
            return;
        }
        for (TreeAction action2 : ACTIONS) {
            map2.put(action2.name, action2);
        }
    }

    static void installTo(@NotNull InputMap map2) {
        KeyStroke[] keys2 = map2.keys();
        if (keys2 != null && keys2.length != 0) {
            return;
        }
        for (TreeAction action2 : ACTIONS) {
            for (KeyStroke key : action2.keys) {
                map2.put(key, action2.name);
            }
        }
    }

    private static boolean isCycleScrollingAllowed(@NotNull MoveType type) {
        if (type == MoveType.ExtendSelection) {
            return false;
        }
        if (!Registry.is((String)"ide.tree.ui.cyclic.scrolling.allowed")) {
            return false;
        }
        UISettings settings = UISettings.getInstanceOrNull();
        return settings != null && settings.getCycleScrolling();
    }

    private static boolean isLeaf(@NotNull JTree tree, @NotNull TreePath path) {
        return tree.getModel().isLeaf(path.getLastPathComponent());
    }

    private static void lineDown(@NotNull MoveType type, @NotNull JTree tree) {
        TreePath lead = tree.getLeadSelectionPath();
        int row = tree.getRowForPath(lead);
        if (lead == null || row < 0) {
            TreeAction.selectFirst(type, tree);
        } else {
            if (TreeAction.isCycleScrollingAllowed(type) && ++row == tree.getRowCount()) {
                row = 0;
            }
            TreeAction.select(type, tree, row);
        }
    }

    private static void lineUp(@NotNull MoveType type, @NotNull JTree tree) {
        TreePath lead = tree.getLeadSelectionPath();
        int row = tree.getRowForPath(lead);
        if (lead == null || row < 0) {
            TreeAction.selectFirst(type, tree);
        } else {
            if (row == 0 && TreeAction.isCycleScrollingAllowed(type)) {
                row = tree.getRowCount();
            }
            TreeAction.select(type, tree, --row);
        }
    }

    private static void pageDown(@NotNull MoveType type, @NotNull JTree tree) {
        TreePath lead = tree.getLeadSelectionPath();
        Rectangle bounds2 = tree.getPathBounds(lead);
        if (lead == null || bounds2 == null) {
            TreeAction.selectLast(type, tree);
        } else {
            int height = Math.max(tree.getVisibleRect().height - bounds2.height * 4, 1);
            TreePath next = tree.getClosestPathForLocation(bounds2.x, bounds2.y + bounds2.height + height);
            if (next != null && !next.equals(lead)) {
                TreeAction.select(type, tree, next);
            }
        }
    }

    private static void pageUp(@NotNull MoveType type, @NotNull JTree tree) {
        TreePath lead = tree.getLeadSelectionPath();
        Rectangle bounds2 = tree.getPathBounds(lead);
        if (lead == null || bounds2 == null) {
            TreeAction.selectFirst(type, tree);
        } else {
            int height = Math.max(tree.getVisibleRect().height - bounds2.height * 4, 1);
            TreePath next = tree.getClosestPathForLocation(bounds2.x, bounds2.y - height);
            if (next != null && !next.equals(lead)) {
                TreeAction.select(type, tree, next);
            }
        }
    }

    private static void select(@NotNull MoveType type, @NotNull JTree tree, int row) {
        TreeAction.select(type, tree, tree.getPathForRow(row), row);
    }

    private static void select(@NotNull MoveType type, @NotNull JTree tree, @NotNull TreePath path) {
        TreeAction.select(type, tree, path, tree.getRowForPath(path));
    }

    private static void select(@NotNull MoveType type, @NotNull JTree tree, @Nullable TreePath path, int row) {
        if (path == null || row < 0) {
            return;
        }
        if (type == MoveType.ExtendSelection) {
            int anchorRow;
            TreePath anchor2 = tree.getAnchorSelectionPath();
            int n = anchorRow = anchor2 == null ? -1 : tree.getRowForPath(anchor2);
            if (anchorRow < 0) {
                tree.setSelectionPath(path);
            } else {
                tree.setSelectionInterval(row, anchorRow);
                tree.setAnchorSelectionPath(anchor2);
                tree.setLeadSelectionPath(path);
            }
        } else if (type == MoveType.ChangeLead && 4 == tree.getSelectionModel().getSelectionMode()) {
            tree.setLeadSelectionPath(path);
        } else {
            tree.setSelectionPath(path);
        }
        TreeUtil.scrollToVisible((JTree)tree, (TreePath)path, (boolean)false);
    }

    private static void selectChild(@NotNull MoveType type, @NotNull JTree tree) {
        TreePath lead = tree.getLeadSelectionPath();
        int row = tree.getRowForPath(lead);
        if (lead == null || row < 0) {
            TreeAction.selectFirst(type, tree);
        } else if (tree.isExpanded(lead) || TreeAction.isLeaf(tree, lead)) {
            TreeAction.select(type, tree, row + 1);
        } else {
            tree.expandPath(lead);
        }
    }

    private static void selectFirst(@NotNull MoveType type, @NotNull JTree tree) {
        TreeAction.select(type, tree, 0);
    }

    private static void selectLast(@NotNull MoveType type, @NotNull JTree tree) {
        TreeAction.select(type, tree, tree.getRowCount() - 1);
    }

    private static void selectParent(@NotNull MoveType type, @NotNull JTree tree) {
        TreePath lead = tree.getLeadSelectionPath();
        int row = tree.getRowForPath(lead);
        if (lead == null || row < 0) {
            TreeAction.selectFirst(type, tree);
        } else if (type == MoveType.ChangeSelection && tree.isExpanded(lead)) {
            tree.collapsePath(lead);
        } else {
            TreePath parent = lead.getParentPath();
            if (parent != null) {
                if (tree.isRootVisible() || null != parent.getParentPath()) {
                    TreeAction.select(type, tree, parent);
                } else if (row > 0) {
                    TreeAction.select(type, tree, row - 1);
                }
            }
        }
    }

    private static void addToSelection(@NotNull JTree tree) {
    }

    private static void cancel(@NotNull JTree tree) {
    }

    private static void clearSelection(@NotNull JTree tree) {
    }

    private static void collapse(@NotNull JTree tree) {
    }

    private static void expand(@NotNull JTree tree) {
    }

    private static void extendTo(@NotNull JTree tree) {
    }

    private static void moveSelectionTo(@NotNull JTree tree) {
    }

    private static void moveSelectionToParent(@NotNull JTree tree) {
    }

    private static void scrollDownChangeLead(@NotNull JTree tree) {
        TreeAction.pageDown(MoveType.ChangeLead, tree);
    }

    private static void scrollDownChangeSelection(@NotNull JTree tree) {
        TreeAction.pageDown(MoveType.ChangeSelection, tree);
    }

    private static void scrollDownExtendSelection(@NotNull JTree tree) {
        TreeAction.pageDown(MoveType.ExtendSelection, tree);
    }

    private static void scrollLeft(@NotNull JTree tree) {
    }

    private static void scrollLeftChangeLead(@NotNull JTree tree) {
    }

    private static void scrollLeftExtendSelection(@NotNull JTree tree) {
    }

    private static void scrollRight(@NotNull JTree tree) {
    }

    private static void scrollRightChangeLead(@NotNull JTree tree) {
    }

    private static void scrollRightExtendSelection(@NotNull JTree tree) {
    }

    private static void scrollUpChangeLead(@NotNull JTree tree) {
        TreeAction.pageUp(MoveType.ChangeLead, tree);
    }

    private static void scrollUpChangeSelection(@NotNull JTree tree) {
        TreeAction.pageUp(MoveType.ChangeSelection, tree);
    }

    private static void scrollUpExtendSelection(@NotNull JTree tree) {
        TreeAction.pageUp(MoveType.ExtendSelection, tree);
    }

    private static void selectAll(@NotNull JTree tree) {
    }

    private static void selectChild(@NotNull JTree tree) {
        TreeAction.selectChild(MoveType.ChangeSelection, tree);
    }

    private static void selectChildChangeLead(@NotNull JTree tree) {
        TreeAction.selectChild(MoveType.ChangeLead, tree);
    }

    private static void selectChildExtendSelection(@NotNull JTree tree) {
        TreeAction.selectChild(MoveType.ExtendSelection, tree);
    }

    private static void selectFirst(@NotNull JTree tree) {
        TreeAction.selectFirst(MoveType.ChangeSelection, tree);
    }

    private static void selectFirstChangeLead(@NotNull JTree tree) {
        TreeAction.selectFirst(MoveType.ChangeLead, tree);
    }

    private static void selectFirstExtendSelection(@NotNull JTree tree) {
        TreeAction.selectFirst(MoveType.ExtendSelection, tree);
    }

    private static void selectLast(@NotNull JTree tree) {
        TreeAction.selectLast(MoveType.ChangeSelection, tree);
    }

    private static void selectLastChangeLead(@NotNull JTree tree) {
        TreeAction.selectLast(MoveType.ChangeLead, tree);
    }

    private static void selectLastExtendSelection(@NotNull JTree tree) {
        TreeAction.selectLast(MoveType.ExtendSelection, tree);
    }

    private static void selectNext(@NotNull JTree tree) {
        TreeAction.lineDown(MoveType.ChangeSelection, tree);
    }

    private static void selectNextChangeLead(@NotNull JTree tree) {
        TreeAction.lineDown(MoveType.ChangeLead, tree);
    }

    private static void selectNextExtendSelection(@NotNull JTree tree) {
        TreeAction.lineDown(MoveType.ExtendSelection, tree);
    }

    private static void selectParent(@NotNull JTree tree) {
        TreeAction.selectParent(MoveType.ChangeSelection, tree);
    }

    private static void selectParentChangeLead(@NotNull JTree tree) {
        TreeAction.selectParent(MoveType.ChangeLead, tree);
    }

    private static void selectParentExtendSelection(@NotNull JTree tree) {
        TreeAction.selectParent(MoveType.ExtendSelection, tree);
    }

    private static void selectPrevious(@NotNull JTree tree) {
        TreeAction.lineUp(MoveType.ChangeSelection, tree);
    }

    private static void selectPreviousChangeLead(@NotNull JTree tree) {
        TreeAction.lineUp(MoveType.ChangeLead, tree);
    }

    private static void selectPreviousExtendSelection(@NotNull JTree tree) {
        TreeAction.lineUp(MoveType.ExtendSelection, tree);
    }

    private static void startEditing(@NotNull JTree tree) {
    }

    private static void toggle(@NotNull JTree tree) {
    }

    private static void toggleAndAnchor(@NotNull JTree tree) {
    }

    private static enum MoveType {
        ChangeLead,
        ChangeSelection,
        ExtendSelection;

    }
}

