/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public final class MapBasedTree<K, N> {
    private static final Logger LOG = Logger.getInstance(MapBasedTree.class);
    private final Map<K, Entry<N>> map;
    private final Function<? super N, ? extends K> keyFunction;
    private final TreePath path;
    private volatile Entry<N> root;
    private volatile Consumer<? super N> nodeRemoved;
    private volatile Consumer<? super N> nodeInserted;

    public MapBasedTree(boolean identity, @NotNull Function<? super N, ? extends K> keyFunction) {
        this(identity, keyFunction, null);
    }

    public MapBasedTree(boolean identity, @NotNull Function<? super N, ? extends K> keyFunction, TreePath path) {
        this.map = identity ? new IdentityHashMap() : new HashMap();
        this.keyFunction = keyFunction;
        this.path = path;
    }

    public void invalidate() {
        if (this.root != null) {
            this.root.invalidate();
        }
        this.map.values().forEach(entry -> entry.invalidate());
    }

    public void onRemove(@NotNull Consumer<? super N> consumer) {
        Consumer<N> old = this.nodeRemoved;
        this.nodeRemoved = old == null ? consumer : old.andThen(consumer);
    }

    public void onInsert(@NotNull Consumer<? super N> consumer) {
        Consumer<N> old = this.nodeInserted;
        this.nodeInserted = old == null ? consumer : old.andThen(consumer);
    }

    public Entry<N> findEntry(K key) {
        return key == null ? null : this.map.get(key);
    }

    public N findNode(K key) {
        Entry<N> entry = this.findEntry(key);
        return (N)(entry == null ? null : ((Entry)entry).node);
    }

    public Entry<N> getEntry(N node) {
        K key = this.getKey(node);
        Entry<N> entry = this.findEntry(key);
        return entry == null || ((Entry)entry).node == node ? entry : null;
    }

    public Entry<N> getRootEntry() {
        return this.root;
    }

    public K getKey(N node) {
        if (node == null) {
            return null;
        }
        K key = this.keyFunction.apply(node);
        if (key != null) {
            return key;
        }
        LOG.warn("MapBasedTree: key function provides null");
        return null;
    }

    public boolean updateRoot(Pair<? extends N, Boolean> pair) {
        Object node = Pair.getFirst(pair);
        if (this.root == null ? node == null : ((Entry)this.root).node == node) {
            return false;
        }
        if (this.root != null) {
            this.remove(this.root, this.keyFunction.apply(((Entry)this.root).node));
            this.root = null;
        }
        if (!this.map.isEmpty()) {
            this.map.clear();
            LOG.warn("MapBasedTree: clear lost entries");
        }
        if (node != null) {
            this.root = new Entry(this.path, null, node, (Boolean)pair.second);
            this.insert(this.root, this.keyFunction.apply(node));
        }
        return true;
    }

    public UpdateResult<N> update(@NotNull Entry<N> parent, List<? extends Pair<N, Boolean>> children2) {
        ArrayList newChildren = new ArrayList(children2 == null ? 0 : children2.size());
        List oldChildren = ((Entry)parent).children;
        IdentityHashMap<Entry, Object> mapInserted = new IdentityHashMap<Entry, Object>();
        IdentityHashMap mapContained = new IdentityHashMap();
        if (children2 != null && !children2.isEmpty()) {
            children2.forEach(pair -> {
                if (pair == null || pair.first == null) {
                    LOG.warn("MapBasedTree: ignore null node");
                    return;
                }
                K key = this.getKey(pair.first);
                if (key == null) {
                    return;
                }
                Entry<N> entry = this.findEntry(key);
                if (entry == null) {
                    entry = new Entry(parent, ((Entry)parent).node, pair.first, (Boolean)pair.second);
                    mapInserted.put(entry, key);
                } else {
                    if (parent != entry.getParentPath()) {
                        LOG.warn("MapBasedTree: ignore node that belongs to another parent");
                        return;
                    }
                    mapContained.put(entry, key);
                }
                ((Entry)entry).index = newChildren.size();
                newChildren.add(entry);
            });
        }
        ((Entry)parent).leaf = children2 == null;
        ((Entry)parent).children = MapBasedTree.guard(newChildren);
        ((Entry)parent).valid = true;
        List removed = oldChildren;
        List inserted = newChildren;
        List contained = null;
        if (!mapContained.isEmpty()) {
            if (oldChildren == null) {
                oldChildren = Collections.emptyList();
                LOG.warn("MapBasedTree: unexpected state");
            }
            removed = ContainerUtil.filter(oldChildren, entry -> !mapContained.containsKey(entry));
            inserted = ContainerUtil.filter(newChildren, entry -> !mapContained.containsKey(entry));
            contained = ContainerUtil.filter(newChildren, entry -> mapContained.containsKey(entry));
        }
        this.removeChildren(parent, removed);
        mapInserted.forEach(this::insert);
        return new UpdateResult(removed, inserted, contained);
    }

    private void removeChildren(Entry<N> parent, List<Entry<N>> children2) {
        if (children2 != null) {
            for (Entry<N> entry : children2) {
                if (((Entry)parent).loading == ((Entry)entry).node) {
                    ((Entry)parent).loading = null;
                    continue;
                }
                this.remove(entry, this.getKey(((Entry)entry).node));
            }
        }
    }

    private void remove(Entry<N> entry, K key) {
        if (key != null) {
            Entry<N> removed = this.map.remove(key);
            if (removed == null) {
                LOG.warn("MapBasedTree: expected entry is not found");
            } else if (removed != entry) {
                LOG.warn("MapBasedTree: do not remove unexpected entry");
                this.map.put(key, removed);
                return;
            }
        }
        this.removeChildren(entry, ((Entry)entry).children);
        Consumer<N> consumer = this.nodeRemoved;
        if (consumer != null) {
            consumer.accept(((Entry)entry).node);
        }
    }

    private void insert(Entry<N> entry, K key) {
        Entry<N> removed;
        if (key != null && (removed = this.map.put(key, entry)) != null) {
            LOG.warn("MapBasedTree: do not replace unexpected entry");
            this.map.put(key, removed);
            return;
        }
        Consumer<N> consumer = this.nodeInserted;
        if (consumer != null) {
            consumer.accept(((Entry)entry).node);
        }
    }

    private static <T> List<T> guard(List<? extends T> list2) {
        return list2 == null || list2.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(list2);
    }

    public static final class UpdateResult<N> {
        private final List<Entry<N>> removed;
        private final List<Entry<N>> inserted;
        private final List<Entry<N>> contained;

        private UpdateResult(List<Entry<N>> removed, List<Entry<N>> inserted, List<Entry<N>> contained) {
            this.removed = MapBasedTree.guard(removed);
            this.inserted = MapBasedTree.guard(inserted);
            this.contained = MapBasedTree.guard(contained);
        }

        public TreeModelEvent getEvent(@NotNull Object source, TreePath path, @NotNull List<Entry<N>> list2) {
            int size = list2.size();
            int[] indices = new int[size];
            Object[] nodes = new Object[size];
            int index = 0;
            for (Entry<N> entry : list2) {
                indices[index] = ((Entry)entry).index;
                nodes[index++] = ((Entry)entry).node;
            }
            return new TreeModelEvent(source, path, indices, nodes);
        }

        public List<Entry<N>> getRemoved() {
            return this.removed;
        }

        public List<Entry<N>> getInserted() {
            return this.inserted;
        }

        public List<Entry<N>> getContained() {
            return this.contained;
        }
    }

    public static final class Entry<N>
    extends TreePath {
        private final N node;
        private final N parent;
        private volatile int index;
        private volatile boolean leaf;
        private volatile List<Entry<N>> children;
        private volatile N loading;
        private volatile boolean valid;

        private Entry(TreePath path, N parent, N node, Boolean leaf) {
            super(path, node);
            this.node = node;
            this.parent = parent;
            this.leaf = Boolean.TRUE.equals(leaf);
            if (this.leaf) {
                this.children = Collections.emptyList();
            }
            this.invalidate();
        }

        public void invalidate() {
            this.valid = this.leaf;
        }

        public N getNode() {
            return this.node;
        }

        public N getParent() {
            return this.parent;
        }

        public boolean isLeaf() {
            return this.leaf;
        }

        public boolean isLoadingRequired() {
            return !this.valid || this.children == null;
        }

        public int getChildCount() {
            return this.children == null ? 0 : this.children.size();
        }

        public Entry<N> getChildEntry(int index) {
            if (this.children != null && 0 <= index && index < this.children.size()) {
                return this.children.get(index);
            }
            return null;
        }

        public N getChild(int index) {
            Entry<N> entry = this.getChildEntry(index);
            return entry == null ? null : (N)entry.getNode();
        }

        public int getIndexOf(N child2) {
            if (this.children != null) {
                for (int i2 = 0; i2 < this.children.size(); ++i2) {
                    if (child2 != this.children.get(i2).getNode()) continue;
                    return i2;
                }
            }
            return -1;
        }

        void setLoadingChildren(N loading) {
            if (this.children != null) {
                LOG.warn("MapBasedTree: rewrite loaded nodes");
            }
            this.loading = loading;
            this.children = loading == null ? Collections.emptyList() : Collections.singletonList(new Entry<N>(this, this.node, loading, true));
            this.valid = true;
        }
    }
}

