/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.mac.touchbar.BuildUtils;
import com.intellij.ui.mac.touchbar.StatsCounters;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;

class TouchBarStats {
    private static final Map<String, TouchBarStats> ourStats = new HashMap<String, TouchBarStats>();
    private final String name;
    private final Map<String, AnActionStats> actionStats = new ConcurrentHashMap<String, AnActionStats>();
    private final AtomicLong[] myCounters = new AtomicLong[StatsCounters.values().length];

    private TouchBarStats(String name) {
        this.name = name;
        Arrays.setAll(this.myCounters, i2 -> new AtomicLong(0L));
    }

    @NotNull
    static TouchBarStats getStats(@NotNull String touchbarName) {
        return ourStats.computeIfAbsent(touchbarName, s -> new TouchBarStats(touchbarName));
    }

    static void printAll(@NotNull PrintStream out) {
        for (TouchBarStats tbs : ourStats.values()) {
            tbs.print(out);
        }
    }

    static void startPrintStats() {
        Timer timer2 = new Timer(60000, ev -> TouchBarStats.printAll(System.out));
        timer2.setRepeats(true);
        timer2.start();
    }

    void print(@NotNull PrintStream out) {
        out.printf("========================= %s =========================", this.name);
        out.println();
        for (StatsCounters sc : StatsCounters.values()) {
            String name = sc.name();
            long val = this.myCounters[sc.ordinal()].get();
            if (val == 0L) continue;
            if (name.endsWith("DurationNs")) {
                if (val < 1000L) continue;
                name = name.replace("DurationNs", "DurationMs");
                val /= 1000000L;
            }
            out.printf("%s=%d\n", name, val);
        }
        if (!this.actionStats.isEmpty()) {
            AnActionStats total = new AnActionStats("total");
            for (AnActionStats as : this.actionStats.values()) {
                total.accumulate(as);
            }
            total.print(out);
        }
    }

    void incrementCounter(@NotNull StatsCounters cnt) {
        this.myCounters[cnt.ordinal()].incrementAndGet();
    }

    void incrementCounter(@NotNull StatsCounters cnt, long value2) {
        this.myCounters[cnt.ordinal()].addAndGet(value2);
    }

    @NotNull
    AnActionStats getActionStats(@NotNull String actionId) {
        return this.actionStats.computeIfAbsent(actionId, s -> new AnActionStats((String)s));
    }

    @NotNull
    AnActionStats getActionStats(@NotNull AnAction action2) {
        String actId = BuildUtils.getActionId(action2);
        return this.actionStats.computeIfAbsent(actId, s -> new AnActionStats((String)s));
    }

    static class AnActionStats {
        @NotNull
        final String actionId;
        long totalUpdateDurationNs;
        long maxUpdateDurationNs;
        boolean isBackgroundThread = false;
        long updateViewNs;
        int iconUpdateIconRasterCount;
        long iconUpdateNativePeerDurationNs;
        long iconGetDarkDurationNs;
        long iconRenderingDurationNs;
        long iconLoadingDurationNs;

        AnActionStats(@NotNull String actionId) {
            this.actionId = actionId;
        }

        void onUpdate(long updateDurationNs) {
            this.isBackgroundThread |= !ApplicationManager.getApplication().isDispatchThread();
            this.totalUpdateDurationNs += updateDurationNs;
            this.maxUpdateDurationNs = Math.max(this.maxUpdateDurationNs, updateDurationNs);
        }

        void accumulate(AnActionStats other) {
            this.totalUpdateDurationNs += other.totalUpdateDurationNs;
            this.maxUpdateDurationNs = Math.max(this.maxUpdateDurationNs, other.maxUpdateDurationNs);
            this.updateViewNs += other.updateViewNs;
            this.iconUpdateIconRasterCount += other.iconUpdateIconRasterCount;
            this.iconUpdateNativePeerDurationNs += other.iconUpdateNativePeerDurationNs;
            this.iconGetDarkDurationNs += other.iconGetDarkDurationNs;
            this.iconRenderingDurationNs += other.iconRenderingDurationNs;
            this.iconLoadingDurationNs += other.iconLoadingDurationNs;
        }

        void print(@NotNull PrintStream out) {
            out.printf("act '%s':\n", this.actionId);
            AnActionStats.printSignificantValue(out, "iconUpdateIconRasterCount", this.iconUpdateIconRasterCount);
            AnActionStats.printSignificantValue(out, "totalUpdateDurationNs", this.totalUpdateDurationNs);
            AnActionStats.printSignificantValue(out, "updateViewNs", this.updateViewNs);
            AnActionStats.printSignificantValue(out, "iconUpdateNativePeerDurationNs", this.iconUpdateNativePeerDurationNs);
            AnActionStats.printSignificantValue(out, "iconGetDarkDurationNs", this.iconGetDarkDurationNs);
            AnActionStats.printSignificantValue(out, "iconRenderingDurationNs", this.iconRenderingDurationNs);
        }

        private static void printSignificantValue(@NotNull PrintStream out, @NotNull String name, long val) {
            if (val == 0L) {
                return;
            }
            if (name.endsWith("DurationNs") || name.endsWith("Ns")) {
                if (val < 1000L) {
                    return;
                }
                name = name.replace("Ns", "Ms");
                val /= 1000000L;
            }
            out.printf("\t%s=%d\n", name, val);
        }
    }
}

