/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.touchbar.ItemListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class TBItem {
    @NotNull
    private final String myName;
    @Nullable
    private String myUid;
    @Nullable
    final ItemListener myListener;
    @NotNull
    ID myNativePeer = ID.NIL;
    boolean myIsVisible = true;
    @Nullable
    String myOptionalContextName;
    final Object myReleaseLock = new Object();

    TBItem(@NotNull String name, @Nullable ItemListener listener2) {
        this.myName = name;
        this.myListener = listener2;
    }

    public String toString() {
        return this.myUid == null ? String.format("%s [null-uid]", this.myName) : this.myUid;
    }

    @NotNull
    String getName() {
        return this.myName;
    }

    @Nullable
    String getUid() {
        return this.myUid;
    }

    void setUid(@Nullable String uid) {
        this.myUid = uid;
    }

    ID getNativePeer() {
        if (this.myNativePeer == ID.NIL) {
            this.myNativePeer = this._createNativePeer();
        }
        return this.myNativePeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseNativePeer() {
        Object object = this.myReleaseLock;
        synchronized (object) {
            Foundation.invoke((ID)this.myNativePeer, (String)"release", (Object[])new Object[0]);
            this.myNativePeer = ID.NIL;
        }
    }

    protected abstract ID _createNativePeer();
}

