/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ProgressSlidePainter;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ImageLoader;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.net.URL;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Splash
extends Window {
    private static final float JBUI_INIT_SCALE = JBUIScale.scale((float)1.0f);
    private final int myWidth;
    private final int myHeight;
    private final int myProgressHeight;
    private final int myProgressY;
    private double myProgress;
    private final Color myProgressColor;
    private int myProgressLastPosition = 0;
    private final Icon myProgressTail;
    @Nullable
    private final ProgressSlidePainter myProgressSlidePainter;
    private final Image myImage;

    public Splash(@NotNull ApplicationInfoEx info) {
        super((Frame)null);
        this.myProgressSlidePainter = info.getProgressSlides().isEmpty() ? null : new ProgressSlidePainter(info);
        this.myProgressHeight = Splash.uiScale(info.getProgressHeight());
        this.myProgressY = Splash.uiScale(info.getProgressY());
        this.myProgressTail = Splash.getProgressTailIcon(info);
        this.setFocusableWindowState(false);
        this.myImage = Splash.loadImage(info.getSplashImageUrl());
        this.myWidth = this.myImage.getWidth(null);
        this.myHeight = this.myImage.getHeight(null);
        long rgba = info.getProgressColor();
        this.myProgressColor = rgba == -1L ? null : new Color((int)rgba, rgba > 0xFFFFFFL);
        Dimension size = new Dimension(this.myWidth, this.myHeight);
        this.setAutoRequestFocus(false);
        this.setSize(size);
        this.setLocationInTheCenterOfScreen();
    }

    @Nullable
    private static Icon getProgressTailIcon(@NotNull ApplicationInfoEx info) {
        String progressTailIconName = info.getProgressTailIcon();
        JBImageIcon progressTail = null;
        if (progressTailIconName != null) {
            try {
                Image image = ImageLoader.loadFromUrl((URL)Splash.class.getResource(progressTailIconName));
                if (image != null) {
                    progressTail = new JBImageIcon(image);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return progressTail;
    }

    public void initAndShow(Boolean visible) {
        if (this.myProgressSlidePainter != null) {
            this.myProgressSlidePainter.startPreloading();
        }
        StartUpMeasurer.addInstantEvent((String)"splash shown");
        Activity activity = StartUpMeasurer.startActivity((String)"splash set visible");
        this.setVisible(visible);
        activity.end();
        if (visible.booleanValue()) {
            this.paint(this.getGraphics());
            this.toFront();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @NotNull
    private static Image loadImage(@NotNull String path) {
        Image result2 = ImageLoader.loadFromUrl((String)path, Splash.class, (int)1, null, (ScaleContext)ScaleContext.create());
        if (result2 == null) {
            throw new IllegalStateException("Cannot find image: " + path);
        }
        return result2;
    }

    @Override
    public void paint(Graphics g) {
        if (this.myProgress < 0.1 || this.myProgressSlidePainter == null) {
            StartupUiUtil.drawImage((Graphics)g, (Image)this.myImage, (int)0, (int)0, null);
        } else {
            this.paintProgress(g);
        }
    }

    private void setLocationInTheCenterOfScreen() {
        Rectangle bounds2 = this.getGraphicsConfiguration().getBounds();
        if (SystemInfo.isWindows) {
            JBInsets.removeFrom((Rectangle)bounds2, (Insets)ScreenUtil.getScreenInsets((GraphicsConfiguration)this.getGraphicsConfiguration()));
        }
        this.setLocation(StartupUiUtil.getCenterPoint((Rectangle)bounds2, (Dimension)this.getSize()));
    }

    public void showProgress(double progress2) {
        if (this.myProgressColor == null) {
            return;
        }
        if (progress2 - this.myProgress > 0.01 || progress2 > 0.99) {
            this.myProgress = progress2;
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                this.paintProgress(graphics);
            }
        }
    }

    private void paintProgress(@Nullable Graphics g) {
        Color progressColor;
        if (g == null) {
            return;
        }
        if (this.myProgressSlidePainter != null) {
            this.myProgressSlidePainter.paintSlides(g, this.myProgress);
        }
        if ((progressColor = this.myProgressColor) == null) {
            return;
        }
        int progressWidth = (int)((double)this.myWidth * this.myProgress);
        int currentWidth = progressWidth - this.myProgressLastPosition;
        if (currentWidth == 0) {
            return;
        }
        g.setColor(progressColor);
        int y = this.myProgressSlidePainter == null ? this.myProgressY : this.myHeight - this.myProgressHeight;
        g.fillRect(this.myProgressLastPosition, y, currentWidth, this.myProgressHeight);
        if (this.myProgressTail != null) {
            int tx = (int)((float)currentWidth - (float)this.myProgressTail.getIconWidth() / JBUI_INIT_SCALE / 2.0f * JBUI_INIT_SCALE);
            int ty = (int)((float)this.myProgressY - (float)(this.myProgressTail.getIconHeight() - this.myProgressHeight) / JBUI_INIT_SCALE / 2.0f * JBUI_INIT_SCALE);
            this.myProgressTail.paintIcon(this, g, tx, ty);
        }
        this.myProgressLastPosition = progressWidth;
    }

    private static int uiScale(int i2) {
        return (int)((float)i2 * JBUI_INIT_SCALE);
    }
}

