/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.text.NameUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpeedSearchComparator {
    protected String myRecentSearchText;
    private MinusculeMatcher myMinusculeMatcher;
    private final boolean myShouldMatchFromTheBeginning;
    private final boolean myShouldMatchCamelCase;

    public SpeedSearchComparator() {
        this(true);
    }

    public SpeedSearchComparator(boolean shouldMatchFromTheBeginning) {
        this(shouldMatchFromTheBeginning, false);
    }

    public SpeedSearchComparator(boolean shouldMatchFromTheBeginning, boolean shouldMatchCamelCase) {
        this.myShouldMatchFromTheBeginning = shouldMatchFromTheBeginning;
        this.myShouldMatchCamelCase = shouldMatchCamelCase;
    }

    public int matchingDegree(String pattern, String text) {
        return this.obtainMatcher(pattern).matchingDegree(text);
    }

    @Nullable
    public Iterable<TextRange> matchingFragments(@NotNull String pattern, @NotNull String text) {
        return this.obtainMatcher(pattern).matchingFragments(text);
    }

    private MinusculeMatcher obtainMatcher(@NotNull String pattern) {
        if (this.myRecentSearchText == null || !this.myRecentSearchText.equals(pattern)) {
            this.myRecentSearchText = pattern;
            if (this.myShouldMatchCamelCase) {
                pattern = StringUtil.join((String[])NameUtilCore.nameToWords((String)pattern), (String)"*");
            }
            if (!this.myShouldMatchFromTheBeginning && !pattern.startsWith("*")) {
                pattern = "*" + pattern;
            }
            this.myMinusculeMatcher = this.createMatcher(pattern);
        }
        return this.myMinusculeMatcher;
    }

    @NotNull
    protected MinusculeMatcher createMatcher(@NotNull String pattern) {
        return NameUtil.buildMatcher((String)pattern).build();
    }

    public String getRecentSearchText() {
        return this.myRecentSearchText;
    }
}

