/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.SystemNotificationsImpl;
import com.intellij.util.messages.MessageBusConnection;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import org.jetbrains.annotations.NotNull;

class LibNotifyWrapper
implements SystemNotificationsImpl.Notifier {
    private static LibNotifyWrapper ourInstance;
    private final LibNotify myLibNotify;
    private final String myIcon;
    private final Object myLock = new Object();
    private boolean myDisposed = false;

    public static synchronized LibNotifyWrapper getInstance() {
        if (ourInstance == null && JnaLoader.isLoaded()) {
            ourInstance = new LibNotifyWrapper();
        }
        return ourInstance;
    }

    private LibNotifyWrapper() {
        this.myLibNotify = (LibNotify)Native.load((String)"libnotify.so.4", LibNotify.class);
        String appName = ApplicationNamesInfo.getInstance().getProductName();
        if (this.myLibNotify.notify_init(appName) == 0) {
            throw new IllegalStateException("notify_init failed");
        }
        String icon2 = AppUIUtil.findIcon();
        this.myIcon = icon2 != null ? icon2 : "dialog-information";
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void appClosing() {
                Object object = LibNotifyWrapper.this.myLock;
                synchronized (object) {
                    LibNotifyWrapper.this.myDisposed = true;
                    LibNotifyWrapper.this.myLibNotify.notify_uninit();
                }
            }
        });
    }

    @Override
    public void notify(@NotNull String name, @NotNull String title, @NotNull String description) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Object object = this.myLock;
            synchronized (object) {
                if (!this.myDisposed) {
                    Pointer notification = this.myLibNotify.notify_notification_new(title, description, this.myIcon);
                    this.myLibNotify.notify_notification_show(notification, null);
                }
            }
        });
    }

    private static interface LibNotify
    extends Library {
        public int notify_init(String var1);

        public void notify_uninit();

        public Pointer notify_notification_new(String var1, String var2, String var3);

        public int notify_notification_show(Pointer var1, Pointer var2);
    }
}

