/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.Expandable;
import java.util.function.Consumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class ExpandableActions
extends DumbAwareAction {
    private final Consumer<? super Expandable> consumer;

    private ExpandableActions(Consumer<? super Expandable> consumer) {
        this.setEnabledInModalContext(true);
        this.consumer = consumer;
    }

    private static Expandable getExpandable(AnActionEvent event) {
        JComponent container2;
        Object property;
        Object component2 = event.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        if (component2 instanceof Expandable) {
            return (Expandable)component2;
        }
        if (component2 instanceof JComponent && (property = (container2 = (JComponent)component2).getClientProperty(Expandable.class)) instanceof Expandable) {
            return (Expandable)property;
        }
        return null;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Expandable expandable = ExpandableActions.getExpandable(event);
        if (expandable != null) {
            this.consumer.accept((Expandable)expandable);
        }
    }

    public static final class Collapse
    extends ExpandableActions {
        public Collapse() {
            super(Expandable::collapse);
        }

        public void update(@NotNull AnActionEvent event) {
            Expandable expandable = ExpandableActions.getExpandable(event);
            event.getPresentation().setEnabled(expandable != null && expandable.isExpanded());
        }
    }

    public static final class Expand
    extends ExpandableActions {
        public Expand() {
            super(Expandable::expand);
        }

        public void update(@NotNull AnActionEvent event) {
            Expandable expandable = ExpandableActions.getExpandable(event);
            event.getPresentation().setEnabled(expandable != null && !expandable.isExpanded());
        }
    }
}

