/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.SpeedSearchBase;
import java.util.function.Function;
import javax.swing.ComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComboboxSpeedSearch
extends SpeedSearchBase<JComboBox> {
    public static <T> void installSpeedSearch(JComboBox<T> comboBox2, final Function<T, String> textGetter) {
        new ComboboxSpeedSearch(comboBox2){

            @Override
            protected String getElementText(Object element2) {
                return (String)textGetter.apply(element2);
            }
        };
    }

    public ComboboxSpeedSearch(@NotNull JComboBox comboBox2) {
        super(comboBox2);
        ComboboxSpeedSearch.removeKeyStroke(comboBox2.getInputMap(1), KeyStroke.getKeyStroke(32, 0));
    }

    private static void removeKeyStroke(@Nullable InputMap map2, KeyStroke ks) {
        while (map2 != null) {
            map2.remove(ks);
            map2 = map2.getParent();
        }
    }

    @Override
    protected void selectElement(Object element2, String selectedText) {
        ((JComboBox)this.myComponent).setSelectedItem(element2);
        ((JComboBox)this.myComponent).repaint();
    }

    @Override
    protected int getSelectedIndex() {
        return ((JComboBox)this.myComponent).getSelectedIndex();
    }

    @Override
    protected Object @NotNull [] getAllElements() {
        ComboBoxModel model = ((JComboBox)this.myComponent).getModel();
        Object[] elements2 = new Object[model.getSize()];
        for (int i2 = 0; i2 < elements2.length; ++i2) {
            elements2[i2] = model.getElementAt(i2);
        }
        return elements2;
    }

    @Override
    protected String getElementText(Object element2) {
        return element2 == null ? null : element2.toString();
    }
}

