/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComboBox;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class ComboboxEditorTextField
extends EditorTextField {
    public ComboboxEditorTextField(@NotNull String text, Project project, FileType fileType) {
        super(text, project, fileType);
        this.setOneLineMode(true);
    }

    public ComboboxEditorTextField(Document document, Project project, FileType fileType) {
        this(document, project, fileType, false);
        this.setOneLineMode(true);
    }

    public ComboboxEditorTextField(Document document, Project project, FileType fileType, boolean isViewer) {
        super(document, project, fileType, isViewer);
        this.setOneLineMode(true);
    }

    @Override
    protected boolean shouldHaveBorder() {
        return UIManager.getBorder("ComboBox.border") == null && !StartupUiUtil.isUnderDarcula() && !UIUtil.isUnderIntelliJLaF();
    }

    @Override
    protected void updateBorder(@NotNull EditorEx editor) {
    }

    @Override
    protected EditorEx createEditor() {
        EditorEx result2 = super.createEditor();
        result2.addFocusListener(new FocusChangeListener(){

            @Override
            public void focusGained(@NotNull Editor editor) {
                ComboboxEditorTextField.this.repaintComboBox();
            }

            @Override
            public void focusLost(@NotNull Editor editor) {
                ComboboxEditorTextField.this.repaintComboBox();
            }
        });
        return result2;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private void repaintComboBox() {
        if (StartupUiUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()) {
            IdeFocusManager.getInstance((Project)this.getProject()).doWhenFocusSettlesDown(() -> {
                JComboBox comboBox2 = (JComboBox)ComponentUtil.getParentOfType(JComboBox.class, (Component)((Object)this));
                if (comboBox2 != null) {
                    comboBox2.repaint();
                }
            });
        }
    }
}

