/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.testIntegration.LanguageTestCreators;
import com.intellij.testIntegration.TestCreator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateFromTestCreatorsGroup
extends ActionGroup {
    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            return AnAction.EMPTY_ARRAY;
        }
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        final PsiFile file2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        final Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (project == null || file2 == null) {
            return AnAction.EMPTY_ARRAY;
        }
        SmartList result2 = new SmartList();
        for (final TestCreator creator : LanguageTestCreators.INSTANCE.allForLanguage(file2.getLanguage())) {
            result2.add(new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    creator.createTest(project, editor, file2);
                }

                public void update(@NotNull AnActionEvent e) {
                    String text = creator instanceof ItemPresentation ? ((ItemPresentation)creator).getPresentableText() : null;
                    Presentation presentation2 = e.getPresentation();
                    presentation2.setText((String)ObjectUtils.notNull((Object)text, (Object)"Test..."));
                    presentation2.setEnabledAndVisible(creator.isAvailable(project, editor, file2));
                }

                public boolean isDumbAware() {
                    return DumbService.isDumbAware((Object)creator);
                }
            });
        }
        return result2.toArray(AnAction.EMPTY_ARRAY);
    }
}

