/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.terminal.JBTerminalSchemeColorPalette;
import com.intellij.terminal.JBTerminalWidgetListener;
import com.intellij.terminal.TerminalSettingsListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.jediterm.terminal.TerminalColor;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.emulator.ColorPalette;
import com.jediterm.terminal.ui.TerminalAction;
import com.jediterm.terminal.ui.TerminalActionPresentation;
import com.jediterm.terminal.ui.settings.DefaultTabbedSettingsProvider;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.KeyStroke;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBTerminalSystemSettingsProviderBase
extends DefaultTabbedSettingsProvider
implements Disposable {
    private final MyColorsSchemeDelegate myColorsScheme;
    private JBTerminalSchemeColorPalette myColorPalette;
    private final Set<TerminalSettingsListener> myListeners = new HashSet<TerminalSettingsListener>();

    public JBTerminalSystemSettingsProviderBase() {
        this.myColorsScheme = JBTerminalSystemSettingsProviderBase.createBoundColorSchemeDelegate();
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connection.subscribe(UISettingsListener.TOPIC, uiSettings -> {
            int newSize;
            int oldSize = this.myColorsScheme.getConsoleFontSize();
            if (oldSize != (newSize = this.myColorsScheme.detectConsoleFontSize())) {
                this.myColorsScheme.setConsoleFontSize(newSize);
                this.fireFontChanged();
            }
        });
        connection.subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public void globalSchemeChange(@Nullable EditorColorsScheme scheme) {
                JBTerminalSystemSettingsProviderBase.this.myColorsScheme.updateGlobalScheme(scheme);
                JBTerminalSystemSettingsProviderBase.this.myColorsScheme.setConsoleFontSize(JBTerminalSystemSettingsProviderBase.this.myColorsScheme.detectConsoleFontSize());
                JBTerminalSystemSettingsProviderBase.this.myColorPalette = null;
                JBTerminalSystemSettingsProviderBase.this.fireFontChanged();
            }
        });
    }

    @NotNull
    public TerminalActionPresentation getNewSessionActionPresentation() {
        TerminalActionPresentation presentation2 = super.getNewSessionActionPresentation();
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.NewSession.text", (Object[])new Object[0]), presentation2.getKeyStrokes());
    }

    @NotNull
    public TerminalActionPresentation getOpenUrlActionPresentation() {
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.OpenAsUrl.text", (Object[])new Object[0]), Collections.emptyList());
    }

    @NotNull
    public TerminalActionPresentation getCopyActionPresentation() {
        List<KeyStroke> strokes = JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("Terminal.CopySelectedText");
        if (strokes.isEmpty()) {
            strokes = JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("$Copy");
        }
        return new TerminalActionPresentation(UIUtil.removeMnemonic((String)ActionsBundle.message((String)"action.$Copy.text", (Object[])new Object[0])), strokes);
    }

    @NotNull
    public TerminalActionPresentation getPasteActionPresentation() {
        List<KeyStroke> strokes = JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("Terminal.Paste");
        if (strokes.isEmpty()) {
            strokes = JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("$Paste");
        }
        return new TerminalActionPresentation(UIUtil.removeMnemonic((String)ActionsBundle.message((String)"action.$Paste.text", (Object[])new Object[0])), strokes);
    }

    @NotNull
    public TerminalActionPresentation getClearBufferActionPresentation() {
        TerminalActionPresentation presentation2 = super.getClearBufferActionPresentation();
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.ClearBuffer.text", (Object[])new Object[0]), presentation2.getKeyStrokes());
    }

    @NotNull
    public TerminalActionPresentation getPageUpActionPresentation() {
        TerminalActionPresentation presentation2 = super.getPageUpActionPresentation();
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.PageUp.text", (Object[])new Object[0]), presentation2.getKeyStrokes());
    }

    @NotNull
    public TerminalActionPresentation getPageDownActionPresentation() {
        TerminalActionPresentation presentation2 = super.getPageDownActionPresentation();
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.PageDown.text", (Object[])new Object[0]), presentation2.getKeyStrokes());
    }

    @NotNull
    public TerminalActionPresentation getLineUpActionPresentation() {
        TerminalActionPresentation presentation2 = super.getLineUpActionPresentation();
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.LineUp.text", (Object[])new Object[0]), presentation2.getKeyStrokes());
    }

    @NotNull
    public TerminalActionPresentation getLineDownActionPresentation() {
        TerminalActionPresentation presentation2 = super.getLineDownActionPresentation();
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.LineDown.text", (Object[])new Object[0]), presentation2.getKeyStrokes());
    }

    @NotNull
    public TerminalActionPresentation getCloseSessionActionPresentation() {
        TerminalActionPresentation presentation2 = super.getCloseSessionActionPresentation();
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.CloseSession.text", (Object[])new Object[0]), presentation2.getKeyStrokes());
    }

    @NotNull
    public TerminalActionPresentation getFindActionPresentation() {
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.Find.text", (Object[])new Object[0]), JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("Find"));
    }

    @NotNull
    public ColorPalette getTerminalColorPalette() {
        JBTerminalSchemeColorPalette colorPalette = this.myColorPalette;
        if (colorPalette == null) {
            this.myColorPalette = colorPalette = new JBTerminalSchemeColorPalette(this.myColorsScheme);
        }
        return colorPalette;
    }

    @NotNull
    public static String getGotoNextSplitTerminalActionText(boolean forward) {
        return forward ? ActionsBundle.message((String)"action.NextSplitter.text", (Object[])new Object[0]) : ActionsBundle.message((String)"action.PrevSplitter.text", (Object[])new Object[0]);
    }

    @NotNull
    public TerminalAction getGotoNextSplitTerminalAction(@Nullable JBTerminalWidgetListener listener2, boolean forward) {
        String actionId = forward ? "Terminal.NextSplitter" : "Terminal.PrevSplitter";
        String text = UIUtil.removeMnemonic((String)JBTerminalSystemSettingsProviderBase.getGotoNextSplitTerminalActionText(forward));
        return new TerminalAction(new TerminalActionPresentation(text, JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId(actionId)), event -> {
            if (listener2 != null) {
                listener2.gotoNextSplitTerminal(forward);
            }
            return true;
        });
    }

    @NotNull
    private static List<KeyStroke> getKeyStrokesByActionId(@NotNull String actionId) {
        Shortcut[] shortcuts;
        ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>();
        for (Shortcut sc : shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)actionId).getShortcuts()) {
            if (!(sc instanceof KeyboardShortcut)) continue;
            KeyStroke ks = ((KeyboardShortcut)sc).getFirstKeyStroke();
            keyStrokes.add(ks);
        }
        return keyStrokes;
    }

    public void dispose() {
    }

    public void addListener(TerminalSettingsListener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeListener(TerminalSettingsListener listener2) {
        this.myListeners.remove(listener2);
    }

    public void fireFontChanged() {
        for (TerminalSettingsListener l : this.myListeners) {
            l.fontChanged();
        }
    }

    @NotNull
    public TerminalActionPresentation getNextTabActionPresentation() {
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.SelectNextTab.text", (Object[])new Object[0]), JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("NextTab"));
    }

    @NotNull
    public TerminalActionPresentation getPreviousTabActionPresentation() {
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.SelectPreviousTab.text", (Object[])new Object[0]), JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("PreviousTab"));
    }

    @NotNull
    public TerminalActionPresentation getMoveTabRightActionPresentation() {
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.MoveRight.text", (Object[])new Object[0]), JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("Terminal.MoveToolWindowTabRight"));
    }

    @NotNull
    public TerminalActionPresentation getMoveTabLeftActionPresentation() {
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.MoveLeft.text", (Object[])new Object[0]), JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("Terminal.MoveToolWindowTabLeft"));
    }

    @NotNull
    public TerminalActionPresentation getShowTabsActionPresentation() {
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.ShowTabs.text", (Object[])new Object[0]), JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("ShowContent"));
    }

    @NotNull
    private static MyColorsSchemeDelegate createBoundColorSchemeDelegate() {
        return new MyColorsSchemeDelegate();
    }

    @NotNull
    MyColorsSchemeDelegate getColorsScheme() {
        return this.myColorsScheme;
    }

    public float getLineSpace() {
        return this.myColorsScheme.getConsoleLineSpacing();
    }

    public TextStyle getSelectionColor() {
        return new TextStyle(TerminalColor.awt((Color)this.myColorsScheme.getColor(EditorColors.SELECTION_FOREGROUND_COLOR)), TerminalColor.awt((Color)this.myColorsScheme.getColor(EditorColors.SELECTION_BACKGROUND_COLOR)));
    }

    public TextStyle getFoundPatternColor() {
        return new TextStyle(TerminalColor.awt((Color)this.myColorsScheme.getAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES).getForegroundColor()), TerminalColor.awt((Color)this.myColorsScheme.getAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES).getBackgroundColor()));
    }

    public TextStyle getHyperlinkColor() {
        return new TextStyle(TerminalColor.awt((Color)this.myColorsScheme.getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR).getForegroundColor()), TerminalColor.awt((Color)this.myColorsScheme.getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR).getBackgroundColor()));
    }

    public TextStyle getDefaultStyle() {
        return new TextStyle(TerminalColor.index((int)JBTerminalSchemeColorPalette.getDefaultForegroundIndex()), TerminalColor.index((int)JBTerminalSchemeColorPalette.getDefaultBackgroundIndex()));
    }

    public Font getTerminalFont() {
        return new Font(this.getFontName(), 0, (int)this.getTerminalFontSize());
    }

    public String getFontName() {
        List fonts = this.myColorsScheme.getConsoleFontPreferences().getEffectiveFontFamilies();
        if (fonts.size() > 0) {
            return (String)fonts.get(0);
        }
        return "Monospaced-14";
    }

    public float getTerminalFontSize() {
        return this.myColorsScheme.getConsoleFontSize();
    }

    public boolean useAntialiasing() {
        return true;
    }

    public int caretBlinkingMs() {
        if (!EditorSettingsExternalizable.getInstance().isBlinkCaret()) {
            return 0;
        }
        return EditorSettingsExternalizable.getInstance().getBlinkPeriod();
    }

    public int getBufferMaxLinesCount() {
        int linesCount = Registry.get((String)"terminal.buffer.max.lines.count").asInteger();
        if (linesCount > 0) {
            return linesCount;
        }
        return super.getBufferMaxLinesCount();
    }

    public boolean overrideIdeShortcuts() {
        return false;
    }

    public boolean useInverseSelectionColor() {
        return false;
    }

    static class MyColorsSchemeDelegate
    implements EditorColorsScheme {
        private final FontPreferencesImpl myFontPreferences = new FontPreferencesImpl();
        private final HashMap<TextAttributesKey, TextAttributes> myOwnAttributes = new HashMap();
        private final HashMap<ColorKey, Color> myOwnColors = new HashMap();
        private Map<EditorFontType, Font> myFontsMap = null;
        private String myFaceName = null;
        private EditorColorsScheme myGlobalScheme;
        private int myConsoleFontSize;

        private MyColorsSchemeDelegate() {
            this.updateGlobalScheme(null);
            this.myConsoleFontSize = this.detectConsoleFontSize();
            this.initFonts();
        }

        @NotNull
        private EditorColorsScheme getGlobal() {
            return this.myGlobalScheme;
        }

        @NotNull
        public String getName() {
            return this.getGlobal().getName();
        }

        private void initFonts() {
            String consoleFontName = this.getConsoleFontName();
            int consoleFontSize = this.getConsoleFontSize();
            this.myFontPreferences.clear();
            this.myFontPreferences.register(consoleFontName, consoleFontSize);
            this.myFontsMap = new EnumMap<EditorFontType, Font>(EditorFontType.class);
            Font plainFont = new Font(consoleFontName, 0, consoleFontSize);
            Font boldFont = new Font(consoleFontName, 1, consoleFontSize);
            Font italicFont = new Font(consoleFontName, 2, consoleFontSize);
            Font boldItalicFont = new Font(consoleFontName, 3, consoleFontSize);
            this.myFontsMap.put(EditorFontType.PLAIN, plainFont);
            this.myFontsMap.put(EditorFontType.BOLD, boldFont);
            this.myFontsMap.put(EditorFontType.ITALIC, italicFont);
            this.myFontsMap.put(EditorFontType.BOLD_ITALIC, boldItalicFont);
        }

        public void setName(String name) {
            this.getGlobal().setName(name);
        }

        @NotNull
        public String getDisplayName() {
            return this.getGlobal().getDisplayName();
        }

        public TextAttributes getAttributes(TextAttributesKey key) {
            if (this.myOwnAttributes.containsKey(key)) {
                return this.myOwnAttributes.get(key);
            }
            return this.getGlobal().getAttributes(key);
        }

        public void setAttributes(@NotNull TextAttributesKey key, TextAttributes attributes) {
            this.myOwnAttributes.put(key, attributes);
        }

        @NotNull
        public Color getDefaultBackground() {
            Color color = this.getGlobal().getColor(ConsoleViewContentType.CONSOLE_BACKGROUND_KEY);
            return color != null ? color : this.getGlobal().getDefaultBackground();
        }

        @NotNull
        public Color getDefaultForeground() {
            Color foregroundColor = this.getGlobal().getAttributes(ConsoleViewContentType.NORMAL_OUTPUT_KEY).getForegroundColor();
            return foregroundColor != null ? foregroundColor : this.getGlobal().getDefaultForeground();
        }

        public Color getColor(ColorKey key) {
            if (this.myOwnColors.containsKey(key)) {
                return this.myOwnColors.get(key);
            }
            return this.getGlobal().getColor(key);
        }

        public void setColor(ColorKey key, Color color) {
            this.myOwnColors.put(key, color);
        }

        @NotNull
        public FontPreferences getFontPreferences() {
            return this.myGlobalScheme.getFontPreferences();
        }

        public void setFontPreferences(@NotNull FontPreferences preferences) {
            throw new IllegalStateException();
        }

        public int getEditorFontSize() {
            return this.getGlobal().getEditorFontSize();
        }

        public void setEditorFontSize(int fontSize) {
        }

        public String getEditorFontName() {
            return this.getGlobal().getEditorFontName();
        }

        public void setEditorFontName(String fontName) {
            throw new IllegalStateException();
        }

        @NotNull
        public Font getFont(EditorFontType key) {
            Font font;
            if (this.myFontsMap != null && (font = this.myFontsMap.get(key)) != null) {
                return font;
            }
            return this.getGlobal().getFont(key);
        }

        public void setFont(EditorFontType key, Font font) {
            if (this.myFontsMap == null) {
                this.initFonts();
            }
            this.myFontsMap.put(key, font);
        }

        public float getLineSpacing() {
            return this.getGlobal().getLineSpacing();
        }

        public void setLineSpacing(float lineSpacing) {
            this.getGlobal().setLineSpacing(lineSpacing);
        }

        @Nullable
        public Object clone() {
            return null;
        }

        public void readExternal(Element element2) {
        }

        private void updateGlobalScheme(@Nullable EditorColorsScheme scheme) {
            this.myFontsMap = null;
            this.myGlobalScheme = scheme != null ? scheme : EditorColorsManager.getInstance().getGlobalScheme();
        }

        @NotNull
        public FontPreferences getConsoleFontPreferences() {
            return this.myFontPreferences;
        }

        public void setConsoleFontPreferences(@NotNull FontPreferences preferences) {
            preferences.copyTo((FontPreferences)this.myFontPreferences);
            this.initFonts();
        }

        public String getConsoleFontName() {
            if (this.myFaceName == null) {
                return this.getGlobal().getConsoleFontName();
            }
            return this.myFaceName;
        }

        public void setConsoleFontName(String fontName) {
            this.myFaceName = fontName;
            this.initFonts();
        }

        private int detectConsoleFontSize() {
            if (UISettings.getInstance().getPresentationMode()) {
                return UISettings.getInstance().getPresentationModeFontSize();
            }
            return this.getGlobal().getConsoleFontSize();
        }

        public int getConsoleFontSize() {
            return this.myConsoleFontSize;
        }

        public void setConsoleFontSize(int fontSize) {
            this.myConsoleFontSize = fontSize;
            this.initFonts();
        }

        public float getConsoleLineSpacing() {
            return this.getGlobal().getConsoleLineSpacing();
        }

        public void setConsoleLineSpacing(float lineSpacing) {
            this.getGlobal().setConsoleLineSpacing(lineSpacing);
        }

        @NotNull
        public Properties getMetaProperties() {
            return this.myGlobalScheme.getMetaProperties();
        }
    }
}

