/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ReportValue;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsTaskHandler;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.serialization.SerializationException;
import com.intellij.tasks.BranchInfo;
import com.intellij.tasks.ChangeListInfo;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskListener;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.context.WorkingContextManager;
import com.intellij.tasks.impl.LocalTaskImpl;
import com.intellij.tasks.impl.RequestFailedException;
import com.intellij.tasks.impl.TaskProjectConfiguration;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.ui.TimerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Icon;
import javax.swing.Timer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="TaskManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class TaskManagerImpl
extends TaskManager
implements PersistentStateComponent<Config>,
Disposable {
    private static final Logger LOG = Logger.getInstance(TaskManagerImpl.class);
    private static final DecimalFormat LOCAL_TASK_ID_FORMAT = new DecimalFormat("LOCAL-00000");
    public static final Comparator<Task> TASK_UPDATE_COMPARATOR = (o1, o2) -> {
        int i2 = Comparing.compare((Comparable)o2.getUpdated(), (Comparable)o1.getUpdated());
        return i2 == 0 ? Comparing.compare((Comparable)o2.getCreated(), (Comparable)o1.getCreated()) : i2;
    };
    private static final Convertor<Task, String> KEY_CONVERTOR = o -> o.getId();
    private final Project myProject;
    private final Map<String, Task> myIssueCache = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<String, LocalTask> myTasks = Collections.synchronizedMap(new LinkedHashMap<String, LocalTask>(){

        @Override
        public LocalTask put(String key, LocalTask task2) {
            LocalTask result2 = super.put(key, task2);
            if (this.size() > ((TaskManagerImpl)TaskManagerImpl.this).myConfig.taskHistoryLength) {
                ArrayList list2 = new ArrayList(this.entrySet());
                list2.sort((o1, o2) -> TASK_UPDATE_COMPARATOR.compare((Task)o2.getValue(), (Task)o1.getValue()));
                for (Map.Entry oldest : list2) {
                    if (((LocalTask)oldest.getValue()).isDefault()) continue;
                    this.remove(oldest.getKey());
                    break;
                }
            }
            return result2;
        }
    });
    @NotNull
    private LocalTask myActiveTask = TaskManagerImpl.createDefaultTask();
    private Timer myCacheRefreshTimer;
    private volatile boolean myUpdating;
    private final Config myConfig = new Config();
    private final ChangeListAdapter myChangeListListener;
    private final List<TaskRepository> myRepositories = new ArrayList<TaskRepository>();
    private final EventDispatcher<TaskListener> myDispatcher = EventDispatcher.create(TaskListener.class);
    private final Set<TaskRepository> myBadRepositories = ContainerUtil.newConcurrentSet();

    public TaskManagerImpl(@NotNull Project project) {
        this.myProject = project;
        this.myChangeListListener = new ChangeListAdapter(){

            public void changeListRemoved(ChangeList list2) {
                LocalTask task2 = TaskManagerImpl.this.getAssociatedTask((LocalChangeList)list2);
                if (task2 != null) {
                    for (ChangeListInfo info : task2.getChangeLists()) {
                        if (!Objects.equals(info.id, ((LocalChangeList)list2).getId())) continue;
                        info.id = "";
                    }
                }
            }

            public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList, boolean automatic) {
                if (automatic) {
                    return;
                }
                LocalTask associatedTask = TaskManagerImpl.this.getAssociatedTask((LocalChangeList)newDefaultList);
                if (associatedTask != null && !TaskManagerImpl.this.getActiveTask().equals((Object)associatedTask)) {
                    ApplicationManager.getApplication().invokeLater(() -> TaskManagerImpl.this.activateTask((Task)associatedTask, true), TaskManagerImpl.this.myProject.getDisposed());
                }
            }
        };
        project.getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                if (TaskManagerImpl.this.myProject == project) {
                    TaskManagerImpl.this.projectOpened();
                }
            }
        });
        TaskRepositoryType.addEPListChangeListener((Disposable)this, () -> {
            List<TaskRepository> repositories = this.myRepositories;
            List possibleRepositoryClasses = TaskRepositoryType.getRepositoryClasses();
            boolean removed = repositories.removeIf(repository -> !ContainerUtil.exists((Iterable)possibleRepositoryClasses, clazz -> clazz.isAssignableFrom(repository.getClass())));
            if (removed) {
                this.setRepositories(repositories);
            }
        });
    }

    public void prepareForNextTest() {
        this.myTasks.clear();
        LocalTaskImpl defaultTask = TaskManagerImpl.createDefaultTask();
        this.addTask(defaultTask);
        this.myActiveTask = defaultTask;
        this.setRepositories(Collections.emptyList());
    }

    public TaskRepository[] getAllRepositories() {
        return this.myRepositories.toArray(new TaskRepository[0]);
    }

    public <T extends TaskRepository> void setRepositories(@NotNull List<T> repositories) {
        HashSet<TaskRepository> set = new HashSet<TaskRepository>(this.myRepositories);
        set.removeAll(repositories);
        this.myBadRepositories.removeAll(set);
        this.myIssueCache.clear();
        this.myRepositories.clear();
        this.myRepositories.addAll(repositories);
        List<TaskProjectConfiguration.SharedServer> servers = this.getProjectConfiguration().servers;
        servers.clear();
        block0: for (TaskRepository repository : repositories) {
            if (!repository.isShared() || repository.getUrl() == null) continue;
            TaskRepositoryType type = repository.getRepositoryType();
            for (TaskProjectConfiguration.SharedServer server : servers) {
                if (!repository.getUrl().equals(server.url) || !type.getName().equals(server.type)) continue;
                continue block0;
            }
            TaskProjectConfiguration.SharedServer server = new TaskProjectConfiguration.SharedServer();
            server.type = type.getName();
            server.url = repository.getUrl();
            servers.add(server);
        }
        this.clearNonExistentRepositoriesFromTasks();
    }

    private void clearNonExistentRepositoriesFromTasks() {
        for (LocalTask task2 : this.myTasks.values()) {
            TaskRepository repository = task2.getRepository();
            if (repository == null || this.myRepositories.contains(repository) || !(task2 instanceof LocalTaskImpl)) continue;
            ((LocalTaskImpl)task2).setRepository(null);
        }
    }

    public void removeTask(@NotNull LocalTask task2) {
        if (task2.isDefault()) {
            return;
        }
        if (this.myActiveTask.equals((Object)task2)) {
            this.activateTask((Task)this.myTasks.get("Default"), true);
        }
        this.myTasks.remove(task2.getId());
        ((TaskListener)this.myDispatcher.getMulticaster()).taskRemoved(task2);
        WorkingContextManager.getInstance(this.myProject).removeContext((Task)task2);
    }

    public void addTaskListener(TaskListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void addTaskListener(@NotNull TaskListener listener2, @NotNull Disposable parentDisposable) {
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeTaskListener(TaskListener listener2) {
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    @NotNull
    public LocalTask getActiveTask() {
        return this.myActiveTask;
    }

    @Nullable
    public LocalTask findTask(String id2) {
        return this.myTasks.get(id2);
    }

    @NotNull
    public List<Task> getIssues(@Nullable String query) {
        return this.getIssues(query, true);
    }

    public List<Task> getIssues(@Nullable String query, boolean forceRequest) {
        return this.getIssues(query, 0, 50, true, (ProgressIndicator)new EmptyProgressIndicator(), forceRequest);
    }

    public List<Task> getIssues(@Nullable String query, int offset, int limit, boolean withClosed, @NotNull ProgressIndicator indicator, boolean forceRequest) {
        List<Task> tasks = this.getIssuesFromRepositories(query, offset, limit, withClosed, forceRequest, indicator);
        if (tasks == null) {
            return this.getCachedIssues(withClosed);
        }
        this.myIssueCache.putAll(ContainerUtil.newMapFromValues(tasks.iterator(), KEY_CONVERTOR));
        return ContainerUtil.filter(tasks, task2 -> withClosed || !task2.isClosed());
    }

    public List<Task> getCachedIssues() {
        return this.getCachedIssues(true);
    }

    public List<Task> getCachedIssues(boolean withClosed) {
        return ContainerUtil.filter(this.myIssueCache.values(), task2 -> withClosed || !task2.isClosed());
    }

    private void updateIssue(@NotNull String id2) {
        for (TaskRepository repository : this.getAllRepositories()) {
            if (repository.extractId(id2) == null) continue;
            try {
                LOG.info("Searching for task '" + id2 + "' in " + repository);
                Task issue = repository.findTask(id2);
                if (issue == null) continue;
                LocalTask localTask = this.findTask(id2);
                if (localTask != null) {
                    localTask.updateFromIssue(issue);
                    return;
                }
                return;
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
            }
        }
    }

    public List<LocalTask> getLocalTasks() {
        return this.getLocalTasks(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LocalTask> getLocalTasks(boolean withClosed) {
        Map<String, LocalTask> map2 = this.myTasks;
        synchronized (map2) {
            return ContainerUtil.filter(this.myTasks.values(), task2 -> withClosed || !this.isLocallyClosed((LocalTask)task2));
        }
    }

    public LocalTask addTask(@NotNull Task issue) {
        LocalTaskImpl task2 = issue instanceof LocalTaskImpl ? (LocalTaskImpl)issue : new LocalTaskImpl(issue);
        this.addTask(task2);
        return task2;
    }

    public LocalTaskImpl createLocalTask(@NotNull String summary) {
        return TaskManagerImpl.createTask(LOCAL_TASK_ID_FORMAT.format(this.myConfig.localTasksCounter++), summary);
    }

    private static LocalTaskImpl createTask(@NotNull String id2, @NotNull String summary) {
        LocalTaskImpl task2 = new LocalTaskImpl(id2, summary);
        Date date = new Date();
        task2.setCreated(date);
        task2.setUpdated(date);
        return task2;
    }

    public LocalTask activateTask(@NotNull Task origin, boolean clearContext) {
        return this.activateTask(origin, clearContext, false);
    }

    public LocalTask activateTask(@NotNull Task origin, boolean clearContext, boolean newTask) {
        LocalTask activeTask = this.getActiveTask();
        if (origin.equals((Object)activeTask)) {
            return activeTask;
        }
        this.saveActiveTask();
        LocalTask task2 = this.doActivate(origin, true);
        Runnable restore = () -> {
            WorkingContextManager contextManager = WorkingContextManager.getInstance(this.myProject);
            if (clearContext) {
                contextManager.clearContext();
            }
            contextManager.restoreContext(origin);
        };
        boolean switched = false;
        if (this.isVcsEnabled()) {
            this.restoreVcsContext(task2, newTask);
            if (!newTask) {
                switched = this.switchBranch(task2, restore);
            }
        }
        if (!switched) {
            restore.run();
        }
        return task2;
    }

    private void restoreVcsContext(LocalTask task2, boolean newTask) {
        List changeLists = task2.getChangeLists();
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        if (changeLists.isEmpty()) {
            task2.addChangelist(new ChangeListInfo(changeListManager.getDefaultChangeList()));
        } else {
            ChangeListInfo info = (ChangeListInfo)changeLists.get(0);
            LocalChangeList changeList = changeListManager.getChangeList(info.id);
            if (changeList == null) {
                changeList = changeListManager.addChangeList(info.name, info.comment);
                info.id = changeList.getId();
            }
            changeListManager.setDefaultChangeList(changeList);
        }
        this.unshelveChanges(task2);
    }

    private boolean switchBranch(LocalTask task2, Runnable invokeAfter) {
        List branches = task2.getBranches(false);
        MultiMap multiMap = new MultiMap();
        for (BranchInfo branch : branches) {
            multiMap.putValue((Object)branch.repository, (Object)branch);
        }
        block1: for (String repo : multiMap.keySet()) {
            Collection infos = multiMap.get((Object)repo);
            if (infos.size() <= 1) continue;
            List<BranchInfo> existing = this.getAllBranches(repo);
            Iterator iterator2 = infos.iterator();
            while (iterator2.hasNext()) {
                BranchInfo info = (BranchInfo)iterator2.next();
                if (existing.contains(info)) continue;
                iterator2.remove();
                if (infos.size() != 1) continue;
                continue block1;
            }
        }
        VcsTaskHandler.TaskInfo info = TaskManagerImpl.fromBranches(new ArrayList<BranchInfo>(multiMap.values()));
        VcsTaskHandler[] handlers = VcsTaskHandler.getAllHandlers((Project)this.myProject);
        boolean switched = false;
        for (VcsTaskHandler handler2 : handlers) {
            switched |= handler2.switchToTask(info, invokeAfter);
        }
        return switched;
    }

    public void shelveChanges(LocalTask task2, @NotNull String shelfName) {
        Collection changes = ChangeListManager.getInstance((Project)this.myProject).getDefaultChangeList().getChanges();
        if (changes.isEmpty()) {
            return;
        }
        try {
            ShelveChangesManager.getInstance((Project)this.myProject).shelveChanges(changes, shelfName, true);
            task2.setShelfName(shelfName);
        }
        catch (Exception e) {
            LOG.warn("Can't shelve changes", (Throwable)e);
        }
    }

    private void unshelveChanges(LocalTask task2) {
        String name = task2.getShelfName();
        if (name != null) {
            ShelveChangesManager manager = ShelveChangesManager.getInstance((Project)this.myProject);
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
            for (ShelvedChangeList list2 : manager.getShelvedChangeLists()) {
                if (!name.equals(list2.DESCRIPTION)) continue;
                manager.unshelveChangeList(list2, null, list2.getBinaryFiles(), changeListManager.getDefaultChangeList(), true);
                return;
            }
        }
    }

    private List<BranchInfo> getAllBranches(String repo) {
        VcsTaskHandler[] handlers;
        ArrayList<BranchInfo> infos = new ArrayList<BranchInfo>();
        for (VcsTaskHandler handler2 : handlers = VcsTaskHandler.getAllHandlers((Project)this.myProject)) {
            VcsTaskHandler.TaskInfo[] tasks;
            for (VcsTaskHandler.TaskInfo info : tasks = handler2.getAllExistingTasks()) {
                infos.addAll(ContainerUtil.filter((Collection)BranchInfo.fromTaskInfo((VcsTaskHandler.TaskInfo)info, (boolean)false), info1 -> Objects.equals(info1.repository, repo)));
            }
        }
        return infos;
    }

    private static VcsTaskHandler.TaskInfo fromBranches(List<BranchInfo> branches) {
        if (branches.isEmpty()) {
            return new VcsTaskHandler.TaskInfo(null, Collections.emptyList());
        }
        MultiMap map2 = new MultiMap();
        for (BranchInfo branch : branches) {
            map2.putValue((Object)branch.name, (Object)branch.repository);
        }
        Map.Entry next = (Map.Entry)map2.entrySet().iterator().next();
        return new VcsTaskHandler.TaskInfo((String)next.getKey(), (Collection)next.getValue());
    }

    public void createBranch(LocalTask task2, LocalTask previousActive, String name, @Nullable VcsTaskHandler.TaskInfo branchFrom) {
        VcsTaskHandler[] handlers;
        for (VcsTaskHandler handler2 : handlers = VcsTaskHandler.getAllHandlers((Project)this.myProject)) {
            VcsTaskHandler.TaskInfo[] info = handler2.getCurrentTasks();
            if (previousActive != null && previousActive.getBranches(false).isEmpty()) {
                TaskManagerImpl.addBranches(previousActive, info, false);
            }
            TaskManagerImpl.addBranches(task2, info, true);
            if (info.length == 0 && branchFrom != null) {
                TaskManagerImpl.addBranches(task2, new VcsTaskHandler.TaskInfo[]{branchFrom}, true);
            }
            TaskManagerImpl.addBranches(task2, new VcsTaskHandler.TaskInfo[]{handler2.startNewTask(name)}, false);
        }
    }

    public void mergeBranch(LocalTask task2) {
        VcsTaskHandler[] handlers;
        VcsTaskHandler.TaskInfo original = TaskManagerImpl.fromBranches(task2.getBranches(true));
        VcsTaskHandler.TaskInfo feature = TaskManagerImpl.fromBranches(task2.getBranches(false));
        for (VcsTaskHandler handler2 : handlers = VcsTaskHandler.getAllHandlers((Project)this.myProject)) {
            handler2.closeTask(feature, original);
        }
    }

    public static void addBranches(LocalTask task2, VcsTaskHandler.TaskInfo[] info, boolean original) {
        for (VcsTaskHandler.TaskInfo taskInfo : info) {
            List branchInfos = BranchInfo.fromTaskInfo((VcsTaskHandler.TaskInfo)taskInfo, (boolean)original);
            for (BranchInfo branchInfo : branchInfos) {
                task2.addBranch(branchInfo);
            }
        }
    }

    private void saveActiveTask() {
        WorkingContextManager.getInstance(this.myProject).saveContext((Task)this.myActiveTask);
        this.myActiveTask.setUpdated(new Date());
        String shelfName = this.myActiveTask.getShelfName();
        if (shelfName != null) {
            this.shelveChanges(this.myActiveTask, shelfName);
        }
    }

    private LocalTask doActivate(Task origin, boolean explicitly) {
        LocalTask oldActiveTask;
        LocalTaskImpl task2;
        LocalTaskImpl localTaskImpl = task2 = origin instanceof LocalTaskImpl ? (LocalTaskImpl)origin : new LocalTaskImpl(origin);
        if (explicitly) {
            task2.setUpdated(new Date());
        }
        this.myActiveTask.setActive(false);
        task2.setActive(true);
        this.addTask(task2);
        if (task2.isIssue()) {
            StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> ProgressManager.getInstance().run((com.intellij.openapi.progress.Task)new Task.Backgroundable(this.myProject, TaskBundle.message("progress.title.updating", task2.getPresentableId())){

                public void run(@NotNull ProgressIndicator indicator) {
                    TaskManagerImpl.this.updateIssue(task2.getId());
                }
            }));
        }
        boolean isChanged = !task2.equals(oldActiveTask = this.myActiveTask);
        this.myActiveTask = task2;
        if (isChanged) {
            ((TaskListener)this.myDispatcher.getMulticaster()).taskDeactivated(oldActiveTask);
            ((TaskListener)this.myDispatcher.getMulticaster()).taskActivated((LocalTask)task2);
        }
        return task2;
    }

    private void addTask(@NotNull LocalTaskImpl task2) {
        this.myTasks.put(task2.getId(), task2);
        ((TaskListener)this.myDispatcher.getMulticaster()).taskAdded((LocalTask)task2);
    }

    public boolean testConnection(final TaskRepository repository) {
        TestConnectionTask task2 = new TestConnectionTask("Test connection"){

            /*
             * Unable to fully structure code
             */
            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setText(TaskBundle.message("progress.text.connecting.to", new Object[]{repository.getUrl()}));
                indicator.setFraction(0.0);
                indicator.setIndeterminate(true);
                try {
                    this.myConnection = repository.createCancellableConnection();
                    if (this.myConnection != null) {
                        future = ApplicationManager.getApplication().executeOnPooledThread((Callable)this.myConnection);
                        while (true) lbl-1000:
                        // 2 sources

                        {
                            try {
                                this.myException = (Exception)future.get(100L, TimeUnit.MILLISECONDS);
                                return;
                            }
                            catch (TimeoutException ignore) {
                                try {
                                    indicator.checkCanceled();
                                    continue;
                                }
                                catch (ProcessCanceledException e) {
                                    this.myException = e;
                                    this.myConnection.cancel();
                                    return;
                                }
                            }
                            ** while (true)
                            catch (Exception e) {
                                this.myException = e;
                                return;
                            }
                            break;
                        }
                    }
                    try {
                        repository.testConnection();
                    }
                    catch (Exception e) {
                        TaskManagerImpl.access$300().info((Throwable)e);
                        this.myException = e;
                    }
                }
                catch (Exception e) {
                    this.myException = e;
                }
            }
        };
        ProgressManager.getInstance().run((com.intellij.openapi.progress.Task)task2);
        Exception e = task2.myException;
        if (e == null) {
            this.myBadRepositories.remove(repository);
            Messages.showMessageDialog((Project)this.myProject, (String)TaskBundle.message("dialog.message.connection.successful", new Object[0]), (String)TaskBundle.message("dialog.title.connection", new Object[0]), (Icon)Messages.getInformationIcon());
        } else if (!(e instanceof ProcessCanceledException)) {
            String message = e.getMessage();
            if (e instanceof UnknownHostException) {
                message = "Unknown host: " + message;
            }
            if (message == null) {
                LOG.error((Throwable)e);
                message = "Unknown error";
            }
            Messages.showErrorDialog((Project)this.myProject, (String)StringUtil.capitalize((String)message), (String)TaskBundle.message("dialog.title.error", new Object[0]));
        }
        return e == null;
    }

    @NotNull
    public Config getState() {
        this.myConfig.tasks = ContainerUtil.map(this.myTasks.values(), task2 -> new LocalTaskImpl((Task)task2));
        this.myConfig.servers = XmlSerializer.serialize((Object)this.getAllRepositories());
        return this.myConfig;
    }

    public void loadState(@NotNull Config config2) {
        config2.branchNameFormat = TaskUtil.updateToVelocity(config2.branchNameFormat);
        config2.changelistNameFormat = TaskUtil.updateToVelocity(config2.changelistNameFormat);
        XmlSerializerUtil.copyBean((Object)config2, (Object)this.myConfig);
        this.myRepositories.clear();
        Element element2 = config2.servers;
        ArrayList<TaskRepository> repositories = TaskManagerImpl.loadRepositories(element2);
        this.myRepositories.addAll(repositories);
        this.myTasks.clear();
        for (LocalTaskImpl task2 : config2.tasks) {
            String url;
            if (task2.getRepository() == null && (url = task2.getIssueUrl()) != null) {
                for (TaskRepository repository : repositories) {
                    if (repository.getUrl() == null || !url.startsWith(repository.getUrl())) continue;
                    task2.setRepository(repository);
                }
            }
            this.addTask(task2);
        }
    }

    public static ArrayList<TaskRepository> loadRepositories(@NotNull Element element2) {
        ArrayList<TaskRepository> repositories = new ArrayList<TaskRepository>();
        for (TaskRepositoryType repositoryType : TaskRepositoryType.getRepositoryTypes()) {
            for (Element o : element2.getChildren(repositoryType.getName())) {
                try {
                    TaskRepository repository = (TaskRepository)XmlSerializer.deserialize((Element)o, (Class)repositoryType.getRepositoryClass());
                    repository.setRepositoryType(repositoryType);
                    repository.initializeRepository();
                    repositories.add(repository);
                }
                catch (SerializationException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return repositories;
    }

    public void callProjectOpened() {
        this.projectOpened();
    }

    private void projectOpened() {
        TaskProjectConfiguration projectConfiguration = this.getProjectConfiguration();
        block0: for (TaskProjectConfiguration.SharedServer server : projectConfiguration.servers) {
            if (server.type == null || server.url == null) continue;
            for (TaskRepositoryType repositoryType : TaskRepositoryType.getRepositoryTypes()) {
                if (!repositoryType.getName().equals(server.type)) continue;
                for (TaskRepository repository : this.myRepositories) {
                    if (!repositoryType.equals(repository.getRepositoryType()) || !server.url.equals(repository.getUrl())) continue;
                    continue block0;
                }
                TaskRepository repository = repositoryType.createRepository();
                repository.setUrl(server.url);
                repository.setShared(true);
                this.myRepositories.add(repository);
            }
        }
        LocalTask defaultTask = this.findTask("Default");
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        LocalChangeList defaultList = changeListManager.findChangeList(LocalChangeList.getDefaultName());
        if (defaultList != null && defaultTask != null) {
            ChangeListInfo listInfo = new ChangeListInfo(defaultList);
            if (!defaultTask.getChangeLists().contains(listInfo)) {
                defaultTask.addChangelist(listInfo);
            }
        }
        for (LocalTask localTask : this.getLocalTasks()) {
            Iterator iterator2 = localTask.getChangeLists().iterator();
            while (iterator2.hasNext()) {
                ChangeListInfo changeListInfo = (ChangeListInfo)iterator2.next();
                if (changeListManager.getChangeList(changeListInfo.id) != null) continue;
                iterator2.remove();
            }
        }
        changeListManager.addChangeListListener((ChangeListListener)this.myChangeListListener, (Disposable)this.myProject);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> WorkingContextManager.getInstance(this.myProject).pack(200, 50));
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.startRefreshTimer();
        }
    }

    private TaskProjectConfiguration getProjectConfiguration() {
        return (TaskProjectConfiguration)ServiceManager.getService((Project)this.myProject, TaskProjectConfiguration.class);
    }

    public void initializeComponent() {
        LocalTask defaultTask = this.findTask("Default");
        if (defaultTask == null) {
            defaultTask = TaskManagerImpl.createDefaultTask();
            this.addTask((Task)defaultTask);
        }
        LocalTask activeTask = null;
        List<LocalTask> tasks = this.getLocalTasks();
        tasks.sort(TASK_UPDATE_COMPARATOR);
        for (LocalTask task2 : tasks) {
            if (activeTask == null) {
                if (!task2.isActive()) continue;
                activeTask = task2;
                continue;
            }
            task2.setActive(false);
        }
        if (activeTask == null) {
            activeTask = defaultTask;
        }
        this.myActiveTask = activeTask;
        this.doActivate((Task)this.myActiveTask, false);
        ((TaskListener)this.myDispatcher.getMulticaster()).taskActivated(this.myActiveTask);
    }

    void startRefreshTimer() {
        this.myCacheRefreshTimer = TimerUtil.createNamedTimer((String)"TaskManager refresh", (int)(this.myConfig.updateInterval * 60 * 1000), (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (((TaskManagerImpl)TaskManagerImpl.this).myConfig.updateEnabled && !TaskManagerImpl.this.myUpdating) {
                    LOG.debug("Updating issues cache (every " + ((TaskManagerImpl)TaskManagerImpl.this).myConfig.updateInterval + " min)");
                    TaskManagerImpl.this.updateIssues(null);
                }
            }
        });
        this.myCacheRefreshTimer.setInitialDelay(0);
        this.myCacheRefreshTimer.start();
    }

    @NotNull
    private static LocalTaskImpl createDefaultTask() {
        LocalTaskImpl task2 = new LocalTaskImpl("Default", "Default task");
        Date date = new Date();
        task2.setCreated(date);
        task2.setUpdated(date);
        return task2;
    }

    public void dispose() {
        if (this.myCacheRefreshTimer != null) {
            this.myCacheRefreshTimer.stop();
        }
    }

    public void updateIssues(@Nullable Runnable onComplete) {
        TaskRepository first = (TaskRepository)ContainerUtil.find((Object[])this.getAllRepositories(), repository -> repository.isConfigured());
        if (first == null) {
            this.myIssueCache.clear();
            if (onComplete != null) {
                onComplete.run();
            }
            return;
        }
        this.myUpdating = true;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.doUpdate(onComplete);
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.doUpdate(onComplete));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate(@Nullable Runnable onComplete) {
        try {
            List<Task> issues = this.getIssuesFromRepositories(null, 0, this.myConfig.updateIssuesCount, false, false, (ProgressIndicator)new EmptyProgressIndicator());
            if (issues == null) {
                return;
            }
            Map<String, Task> map2 = this.myIssueCache;
            synchronized (map2) {
                this.myIssueCache.clear();
                for (Task task2 : issues) {
                    this.myIssueCache.put(task2.getId(), task2);
                }
            }
            map2 = this.myTasks;
            synchronized (map2) {
                for (Map.Entry entry : this.myTasks.entrySet()) {
                    Task issue = this.myIssueCache.get(entry.getKey());
                    if (issue == null) continue;
                    ((LocalTask)entry.getValue()).updateFromIssue(issue);
                }
            }
        }
        finally {
            if (onComplete != null) {
                onComplete.run();
            }
            this.myUpdating = false;
        }
    }

    @Nullable
    private List<Task> getIssuesFromRepositories(@Nullable String request2, int offset, int limit, boolean withClosed, boolean forceRequest, @NotNull ProgressIndicator cancelled) {
        ArrayList<Task> issues = null;
        for (TaskRepository repository : this.getAllRepositories()) {
            if (!repository.isConfigured() || !forceRequest && this.myBadRepositories.contains(repository)) continue;
            try {
                long start2 = System.currentTimeMillis();
                Object[] tasks = repository.getIssues(request2, offset, limit, withClosed, cancelled);
                long timeSpent = System.currentTimeMillis() - start2;
                LOG.debug(String.format("Total %s ms to download %d issues from '%s' (pattern '%s')", timeSpent, tasks.length, repository.getUrl(), request2));
                this.myBadRepositories.remove(repository);
                if (issues == null) {
                    issues = new ArrayList<Task>(tasks.length);
                }
                if (!repository.isSupported(16) && request2 != null) {
                    List<Task> filteredTasks = TaskUtil.filterTasks(request2, Arrays.asList(tasks));
                    issues.addAll(filteredTasks);
                    continue;
                }
                ContainerUtil.addAll(issues, (Object[])tasks);
            }
            catch (ProcessCanceledException start2) {
            }
            catch (Exception e) {
                String reason = "";
                if (e.getClass() == Exception.class || e instanceof RequestFailedException) {
                    reason = e.getMessage();
                }
                if (e instanceof SocketTimeoutException || e instanceof HttpRequests.HttpStatusException) {
                    LOG.warn("Can't connect to " + repository + ": " + e.getMessage());
                } else {
                    LOG.warn("Cannot connect to " + repository, (Throwable)e);
                }
                this.myBadRepositories.add(repository);
                if (!forceRequest) continue;
                throw new RequestFailedException(repository, reason);
            }
        }
        return issues;
    }

    public boolean isVcsEnabled() {
        return ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss().length > 0;
    }

    public AbstractVcs getActiveVcs() {
        AbstractVcs[] vcss = ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss();
        if (vcss.length == 0) {
            return null;
        }
        for (AbstractVcs vcs : vcss) {
            if (vcs.getType() != VcsType.distributed) continue;
            return vcs;
        }
        return vcss[0];
    }

    public boolean isLocallyClosed(@NotNull LocalTask localTask) {
        if (!this.isVcsEnabled()) {
            return false;
        }
        List lists = localTask.getChangeLists();
        return lists.isEmpty() || lists.stream().anyMatch(list2 -> StringUtil.isEmpty((String)list2.id));
    }

    @Nullable
    public LocalTask getAssociatedTask(@NotNull LocalChangeList list2) {
        if (TaskManagerImpl.hasChangelist(this.getActiveTask(), list2)) {
            return this.getActiveTask();
        }
        for (LocalTask task2 : this.getLocalTasks()) {
            if (!TaskManagerImpl.hasChangelist(task2, list2)) continue;
            return task2;
        }
        return null;
    }

    private static boolean hasChangelist(LocalTask task2, LocalChangeList list2) {
        for (ChangeListInfo changeListInfo : new ArrayList(task2.getChangeLists())) {
            if (!changeListInfo.id.equals(list2.getId())) continue;
            return true;
        }
        return false;
    }

    public void trackContext(@NotNull LocalChangeList changeList) {
        ChangeListInfo changeListInfo = new ChangeListInfo(changeList);
        String changeListName = changeList.getName();
        LocalTaskImpl task2 = this.createLocalTask(changeListName);
        task2.addChangelist(changeListInfo);
        this.addTask(task2);
        if (changeList.isDefault()) {
            this.activateTask((Task)task2, false);
        }
    }

    public void createChangeList(@NotNull LocalTask task2, String name) {
        String comment = TaskUtil.getChangeListComment((Task)task2);
        this.createChangeList(task2, name, comment);
    }

    private void createChangeList(LocalTask task2, String name, @Nullable String comment) {
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        LocalChangeList changeList = changeListManager.findChangeList(name);
        if (changeList == null) {
            changeList = changeListManager.addChangeList(name, comment);
        } else {
            LocalTask associatedTask = this.getAssociatedTask(changeList);
            if (associatedTask != null) {
                associatedTask.removeChangelist(new ChangeListInfo(changeList));
            }
            changeListManager.editComment(name, comment);
        }
        task2.addChangelist(new ChangeListInfo(changeList));
        changeListManager.setDefaultChangeList(changeList);
    }

    public String getChangelistName(Task task2) {
        String name = task2.isIssue() && this.myConfig.changelistNameFormat != null ? TaskUtil.formatTask(task2, this.myConfig.changelistNameFormat) : task2.getSummary();
        return StringUtil.shortenTextWithEllipsis((String)name, (int)100, (int)0);
    }

    @NotNull
    public String suggestBranchName(@NotNull Task task2, String separator) {
        String name = this.constructDefaultBranchName(task2);
        if (task2.isIssue()) {
            return name.replace(" ", separator);
        }
        List words = StringUtil.getWordsIn((String)name);
        String[] strings = ArrayUtilRt.toStringArray((Collection)words);
        return StringUtil.join((String[])strings, (int)0, (int)Math.min(2, strings.length), (String)separator);
    }

    @NotNull
    public String suggestBranchName(@NotNull Task task2) {
        return this.suggestBranchName(task2, "-");
    }

    @NotNull
    public String constructDefaultBranchName(@NotNull Task task2) {
        return task2.isIssue() ? TaskUtil.formatTask(task2, this.myConfig.branchNameFormat) : task2.getSummary();
    }

    public ChangeListAdapter getChangeListListener() {
        return this.myChangeListListener;
    }

    private static class Activity
    implements StartupActivity.DumbAware {
        private Activity() {
        }

        public void runActivity(@NotNull Project project) {
            ((TaskManagerImpl)TaskManager.getManager((Project)project)).projectOpened();
        }
    }

    private abstract class TestConnectionTask
    extends Task.Modal {
        protected Exception myException;
        @Nullable
        protected TaskRepository.CancellableConnection myConnection;

        TestConnectionTask(String title) {
            super(TaskManagerImpl.this.myProject, title, true);
        }

        public void onCancel() {
            if (this.myConnection != null) {
                this.myConnection.cancel();
            }
        }
    }

    public static class Config {
        @Property(surroundWithTag=false)
        @XCollection(elementName="task")
        public List<LocalTaskImpl> tasks = new ArrayList<LocalTaskImpl>();
        public int localTasksCounter = 1;
        @ReportValue
        public int taskHistoryLength = 50;
        public boolean updateEnabled = true;
        @ReportValue
        public int updateInterval = 20;
        @ReportValue
        public int updateIssuesCount = 100;
        public boolean clearContext = true;
        public boolean createChangelist = true;
        public boolean createBranch = true;
        public boolean useBranch = false;
        public boolean shelveChanges = false;
        public boolean commitChanges = true;
        public boolean mergeBranch = true;
        public boolean saveContextOnCommit = true;
        public boolean trackContextForNewChangelist = false;
        public String changelistNameFormat = "${id} ${summary}";
        public String branchNameFormat = "${id}";
        public boolean searchClosedTasks = false;
        @Tag(value="servers")
        public Element servers = new Element("servers");
    }
}

