/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration.deployment;

import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunDialog;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurationManager;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerConfigurationType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerConfigurationTypesRegistrar;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentConfigurationManagerImpl
extends DeploymentConfigurationManager {
    private final Project myProject;

    public DeploymentConfigurationManagerImpl(Project project) {
        this.myProject = project;
    }

    @NotNull
    public List<RunnerAndConfigurationSettings> getDeploymentConfigurations(@NotNull ServerType<?> serverType) {
        DeployToServerConfigurationType configurationType = DeployToServerConfigurationTypesRegistrar.getDeployConfigurationType(serverType);
        return RunManager.getInstance((Project)this.myProject).getConfigurationSettingsList((ConfigurationType)configurationType);
    }

    public void createAndRunConfiguration(@NotNull ServerType<?> serverType, @Nullable RemoteServer<?> remoteServer, @Nullable DeploymentSourceType<?> sourceType) {
        DeployToServerConfigurationType configurationType = DeployToServerConfigurationTypesRegistrar.getDeployConfigurationType(serverType);
        RunManager runManager = RunManager.getInstance((Project)this.myProject);
        ConfigurationFactory factory2 = configurationType.getFactoryForType(sourceType);
        RunnerAndConfigurationSettings settings = runManager.createConfiguration(configurationType.getDisplayName(), factory2);
        DeployToServerRunConfiguration runConfiguration = (DeployToServerRunConfiguration)settings.getConfiguration();
        runConfiguration.onNewConfigurationCreated();
        if (remoteServer != null) {
            runConfiguration.setServerName(remoteServer.getName());
        }
        if (RunDialog.editConfiguration(this.myProject, settings, CloudBundle.message((String)"dialog.title.create.deployment.configuration", (Object[])new Object[0]), DefaultRunExecutor.getRunExecutorInstance())) {
            runManager.addConfiguration(settings);
            runManager.setSelectedConfiguration(settings);
            ProgramRunnerUtil.executeConfiguration(settings, DefaultRunExecutor.getRunExecutorInstance());
        }
    }
}

