/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.impl.configuration.SingleRemoteServerConfigurable;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.ui.JBUI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteServerListConfigurable
extends MasterDetailsComponent
implements SearchableConfigurable {
    @NonNls
    public static final String ID = "RemoteServers";
    private final RemoteServersManager myServersManager;
    private RemoteServer<?> myLastSelectedServer;
    private final String myInitialSelectedName;
    private final List<ServerType<?>> myDisplayedServerTypes;
    private boolean isTreeInitialized;

    private RemoteServerListConfigurable(@NotNull RemoteServersManager manager, @NotNull ServerType<?> type, @Nullable String initialSelectedName) {
        this(manager, Collections.singletonList(type), initialSelectedName);
    }

    protected RemoteServerListConfigurable(@NotNull RemoteServersManager manager, @NotNull List<ServerType<?>> displayedServerTypes, @Nullable String initialSelectedName) {
        this.myServersManager = manager;
        this.myDisplayedServerTypes = displayedServerTypes;
        this.myToReInitWholePanel = true;
        this.myInitialSelectedName = initialSelectedName;
    }

    @NotNull
    public JComponent createComponent() {
        if (!this.isTreeInitialized) {
            this.initTree();
            this.isTreeInitialized = true;
        }
        return super.createComponent();
    }

    @Nullable
    private ServerType<?> getSingleServerType() {
        List<ServerType<?>> serverTypes = this.getDisplayedServerTypes();
        return serverTypes.size() == 1 ? serverTypes.get(0) : null;
    }

    @NotNull
    public List<ServerType<?>> getDisplayedServerTypes() {
        return this.myDisplayedServerTypes != null ? this.myDisplayedServerTypes : Collections.emptyList();
    }

    @Nullable
    protected String getEmptySelectionString() {
        String typeNames = StringUtil.join(this.getDisplayedServerTypes(), ServerType::getPresentableName, (String)", ");
        if (typeNames.length() > 0) {
            return CloudBundle.message((String)"clouds.configure.empty.selection.string", (Object[])new Object[]{typeNames});
        }
        return null;
    }

    public static RemoteServerListConfigurable createConfigurable(@NotNull ServerType<?> type) {
        return RemoteServerListConfigurable.createConfigurable(type, null);
    }

    public static RemoteServerListConfigurable createConfigurable(@NotNull ServerType<?> type, @Nullable String nameToSelect) {
        return new RemoteServerListConfigurable(RemoteServersManager.getInstance(), type, nameToSelect);
    }

    @Nls
    public String getDisplayName() {
        ServerType<?> singleServerType = this.getSingleServerType();
        return singleServerType == null ? CloudBundle.message((String)"configurable.display.name.clouds", (Object[])new Object[0]) : singleServerType.getPresentableName();
    }

    public void reset() {
        this.myRoot.removeAllChildren();
        for (RemoteServer<?> server : this.getServers()) {
            this.addServerNode(server, false);
        }
        super.reset();
        if (this.myInitialSelectedName != null) {
            this.selectNodeInTree(this.myInitialSelectedName);
        }
    }

    @NotNull
    private List<? extends RemoteServer<?>> getServers() {
        return ContainerUtil.filter((Collection)this.myServersManager.getServers(), s -> this.myDisplayedServerTypes.contains(s.getType()));
    }

    private MasterDetailsComponent.MyNode addServerNode(RemoteServer<?> server, boolean isNew) {
        MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode((NamedConfigurable)new SingleRemoteServerConfigurable(server, this.TREE_UPDATER, isNew));
        this.addNode(node, this.myRoot);
        return node;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @Nullable
    public Runnable enableSearch(String option2) {
        return () -> Objects.requireNonNull(SpeedSearchSupply.getSupply((JComponent)this.myTree, (boolean)true)).findAndSelectElement(option2);
    }

    protected void initTree() {
        super.initTree();
        new TreeSpeedSearch(this.myTree, (Convertor<? super TreePath, String>)((Convertor)treePath -> ((MasterDetailsComponent.MyNode)treePath.getLastPathComponent()).getDisplayName()), true);
    }

    protected void processRemovedItems() {
        HashSet<Object> servers = new HashSet<Object>();
        for (NamedConfigurable<RemoteServer<?>> configurable2 : this.getConfiguredServers()) {
            servers.add(configurable2.getEditableObject());
        }
        ArrayList toDelete = new ArrayList();
        for (RemoteServer<?> remoteServer : this.getServers()) {
            if (servers.contains(remoteServer)) continue;
            toDelete.add(remoteServer);
        }
        for (RemoteServer remoteServer : toDelete) {
            this.myServersManager.removeServer(remoteServer);
        }
    }

    public void apply() throws ConfigurationException {
        super.apply();
        HashSet servers = new HashSet(this.getServers());
        for (NamedConfigurable<RemoteServer<?>> configurable2 : this.getConfiguredServers()) {
            RemoteServer server = (RemoteServer)configurable2.getEditableObject();
            server.setName(configurable2.getDisplayName());
            if (servers.contains(server)) continue;
            this.myServersManager.addServer(server);
        }
    }

    @Nullable
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        ServerType<?> singleServerType = this.getSingleServerType();
        if (singleServerType == null) {
            actions.add((AnAction)new AddRemoteServerGroup());
        } else {
            actions.add((AnAction)new AddRemoteServerAction(singleServerType, IconUtil.getAddIcon()));
        }
        actions.add((AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this));
        return actions;
    }

    protected boolean wasObjectStored(Object editableObject) {
        return true;
    }

    public String getHelpTopic() {
        ServerType<?> singleServerType;
        String result2 = super.getHelpTopic();
        if (result2 == null && (singleServerType = this.getSingleServerType()) != null) {
            result2 = singleServerType.getHelpTopic();
        }
        return result2 != null ? result2 : "reference.settings.clouds";
    }

    public void disposeUIResources() {
        Object selectedObject = this.getSelectedObject();
        this.myLastSelectedServer = selectedObject instanceof RemoteServer ? (RemoteServer)selectedObject : null;
        super.disposeUIResources();
    }

    @Nullable
    public RemoteServer<?> getLastSelectedServer() {
        return this.myLastSelectedServer;
    }

    protected void reInitWholePanelIfNeeded() {
        super.reInitWholePanelIfNeeded();
        if (this.myWholePanel.getBorder() == null) {
            this.myWholePanel.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        }
    }

    private List<NamedConfigurable<RemoteServer<?>>> getConfiguredServers() {
        ArrayList configurables = new ArrayList();
        for (int i2 = 0; i2 < this.myRoot.getChildCount(); ++i2) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i2);
            configurables.add(node.getConfigurable());
        }
        return configurables;
    }

    private class AddRemoteServerAction
    extends DumbAwareAction {
        private final ServerType<?> myServerType;

        private AddRemoteServerAction(ServerType<?> serverType, Icon icon2) {
            super(serverType.getPresentableName(), null, icon2);
            this.myServerType = serverType;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String name = UniqueNameGenerator.generateUniqueName((String)this.myServerType.getPresentableName(), s -> {
                for (NamedConfigurable configurable2 : RemoteServerListConfigurable.this.getConfiguredServers()) {
                    if (!configurable2.getDisplayName().equals(s)) continue;
                    return false;
                }
                return true;
            });
            MasterDetailsComponent.MyNode node = RemoteServerListConfigurable.this.addServerNode(RemoteServerListConfigurable.this.myServersManager.createServer(this.myServerType, name), true);
            RemoteServerListConfigurable.this.selectNodeInTree((DefaultMutableTreeNode)node);
        }
    }

    private class AddRemoteServerGroup
    extends ActionGroup
    implements MasterDetailsComponent.ActionGroupWithPreselection {
        private AddRemoteServerGroup() {
            super(CloudBundle.message((String)"group.action.AddRemoteServerGroup.text", (Object[])new Object[0]), "", IconUtil.getAddIcon());
            this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)RemoteServerListConfigurable.this.myTree);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            List<ServerType<?>> serverTypes = RemoteServerListConfigurable.this.getDisplayedServerTypes();
            AnAction[] actions = new AnAction[serverTypes.size()];
            for (int i2 = 0; i2 < serverTypes.size(); ++i2) {
                actions[i2] = new AddRemoteServerAction(serverTypes.get(i2), serverTypes.get(i2).getIcon());
            }
            return actions;
        }

        public ActionGroup getActionGroup() {
            return this;
        }
    }
}

