/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.agent.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.lang.JavaVersion;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class RemoteAgentClassLoaderCache {
    private static final Logger LOG = Logger.getInstance(RemoteAgentClassLoaderCache.class);
    private final Map<Set<URL>, URLClassLoader> myUrls2ClassLoader = new HashMap<Set<URL>, URLClassLoader>();

    public URLClassLoader getOrCreateClassLoader(Set<URL> libraryUrls) {
        URLClassLoader result2 = this.myUrls2ClassLoader.get(libraryUrls);
        if (result2 == null) {
            result2 = RemoteAgentClassLoaderCache.createClassLoaderWithoutApplicationParent(libraryUrls);
            this.myUrls2ClassLoader.put(libraryUrls, result2);
        }
        return result2;
    }

    public static URLClassLoader createClassLoaderWithoutApplicationParent(Set<URL> libraryUrls) {
        ClassLoader platformOrBootstrap = PlatformClassLoaderHolder.ourInstance;
        LOG.info("platform class loader: " + platformOrBootstrap);
        return new URLClassLoader(libraryUrls.toArray(new URL[0]), platformOrBootstrap);
    }

    private static final class PlatformClassLoaderHolder {
        public static final ClassLoader ourInstance = PlatformClassLoaderHolder.initPlatformClassLoader();

        private PlatformClassLoaderHolder() {
        }

        private static ClassLoader initPlatformClassLoader() {
            if (JavaVersion.current().isAtLeast(9)) {
                try {
                    Object result2 = ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]).invoke(null, new Object[0]);
                    return (ClassLoader)result2;
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    LOG.error("Can't access platform classloader for " + JavaVersion.current(), (Throwable)e);
                }
            }
            return null;
        }
    }
}

