/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="RemoteMappingsManager", storages={@Storage(value="remote-mappings.xml")})
public class RemoteMappingsManager
implements PersistentStateComponent<State> {
    private final State myState = new State();

    public static RemoteMappingsManager getInstance(@NotNull Project project) {
        return (RemoteMappingsManager)ServiceManager.getService((Project)project, RemoteMappingsManager.class);
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this.myState);
    }

    public void setForServer(@NotNull Mappings mappings) {
        List<Mappings> list2 = this.myState.getList();
        Iterator<Mappings> iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            Mappings current2 = iterator2.next();
            if (!mappings.getServerId().equals(current2.getServerId())) continue;
            iterator2.remove();
        }
        list2.add(mappings);
    }

    @Nullable
    public Mappings getForServer(@NotNull String prefix, @NotNull String serverId) {
        String compoundId = RemoteMappingsManager.combineWithPrefix(prefix, serverId);
        List<Mappings> list2 = this.myState.getList();
        for (Mappings mappings : list2) {
            if (!compoundId.equals(mappings.getServerId())) continue;
            return mappings;
        }
        return null;
    }

    public Mappings create(@NotNull String prefix, @NotNull String serverId, @NotNull List<PathMappingSettings.PathMapping> settings) {
        Mappings mappings = new Mappings();
        mappings.setServerId(prefix, serverId);
        mappings.setSettings(settings);
        return mappings;
    }

    @NotNull
    private static String combineWithPrefix(String prefix, String serverId) {
        return prefix + "@" + serverId;
    }

    @Tag(value="remote-mappings")
    public static class Mappings {
        private String myServerId;
        private List<PathMappingSettings.PathMapping> mySettings = new ArrayList<PathMappingSettings.PathMapping>();
        private Map<String, String> myDisabled = new HashMap<String, String>();

        @Attribute(value="server-id")
        public String getServerId() {
            return this.myServerId;
        }

        @Tag(value="settings")
        public List<PathMappingSettings.PathMapping> getSettings() {
            return this.mySettings;
        }

        @Tag(value="disabled")
        public Map<String, String> getDisabled() {
            return this.myDisabled;
        }

        public void setSettings(List<PathMappingSettings.PathMapping> settings) {
            this.mySettings = settings;
        }

        public void setServerId(String serverId) {
            this.myServerId = serverId;
        }

        public void setServerId(String prefix, String serverId) {
            this.myServerId = RemoteMappingsManager.combineWithPrefix(prefix, serverId);
        }

        public void setDisabled(Map<String, String> disabled) {
            this.myDisabled = disabled;
        }
    }

    @Tag(value="state")
    public static class State {
        @Tag(value="list")
        private List<Mappings> myList = new ArrayList<Mappings>();

        public List<Mappings> getList() {
            return this.myList;
        }
    }
}

