/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import java.util.Arrays;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public abstract class DirectoryRenameHandlerBase
implements RenameHandler,
TitledHandler {
    private static final Logger LOG = Logger.getInstance(DirectoryRenameHandlerBase.class);

    public String getActionTitle() {
        return RefactoringBundle.message((String)"rename.directory.title");
    }

    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        PsiDirectory directory = this.adjustForRename(dataContext, PsiElementRenameHandler.getElement(dataContext));
        if (directory != null) {
            VirtualFile virtualFile = directory.getVirtualFile();
            Project project = directory.getProject();
            if (Comparing.equal((Object)project.getBaseDir(), (Object)virtualFile)) {
                return false;
            }
            if (ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(virtualFile)) {
                return true;
            }
        }
        return false;
    }

    protected PsiDirectory adjustForRename(DataContext dataContext, PsiElement element2) {
        Module module;
        if (element2 instanceof PsiDirectoryContainer && (module = (Module)LangDataKeys.MODULE.getData(dataContext)) != null) {
            PsiDirectory[] directories = ((PsiDirectoryContainer)element2).getDirectories(GlobalSearchScope.moduleScope((Module)module));
            Optional<PsiDirectory> directoryWithPackage = Arrays.stream(directories).filter(this::isSuitableDirectory).findFirst();
            return directoryWithPackage.orElse(null);
        }
        return element2 instanceof PsiDirectory && this.isSuitableDirectory((PsiDirectory)element2) ? (PsiDirectory)element2 : null;
    }

    protected abstract boolean isSuitableDirectory(PsiDirectory var1);

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        PsiDirectory element2 = this.adjustForRename(dataContext, PsiElementRenameHandler.getElement(dataContext));
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement nameSuggestionContext = file2.findElementAt(editor.getCaretModel().getOffset());
        this.doRename((PsiElement)element2, project, nameSuggestionContext, editor);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements2, DataContext dataContext) {
        PsiElement element2;
        PsiElement psiElement = element2 = elements2.length == 1 ? elements2[0] : null;
        if (element2 == null) {
            element2 = PsiElementRenameHandler.getElement(dataContext);
        }
        PsiElement nameSuggestionContext = element2;
        LOG.assertTrue((element2 = this.adjustForRename(dataContext, element2)) != null);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        this.doRename(element2, project, nameSuggestionContext, editor);
    }

    protected abstract void doRename(PsiElement var1, Project var2, PsiElement var3, Editor var4);
}

