/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature.inplace;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.refactoring.changeSignature.inplace.InplaceChangeSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EscapeHandler
extends EditorActionHandler {
    private final EditorActionHandler myOriginalHandler;

    public EscapeHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        InplaceChangeSignature currentRefactoring = InplaceChangeSignature.getCurrentRefactoring(editor);
        if (currentRefactoring != null) {
            currentRefactoring.cancel();
            return;
        }
        if (this.myOriginalHandler.isEnabled(editor, caret, dataContext)) {
            this.myOriginalHandler.execute(editor, caret, dataContext);
        }
    }

    public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        InplaceChangeSignature currentRefactoring = InplaceChangeSignature.getCurrentRefactoring(editor);
        if (currentRefactoring != null) {
            return true;
        }
        return this.myOriginalHandler.isEnabled(editor, caret, dataContext);
    }
}

