/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureUsageProcessor;
import com.intellij.refactoring.changeSignature.PossiblyIncorrectUsage;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.UndoRefactoringElementListener;
import com.intellij.refactoring.listeners.impl.RefactoringTransaction;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangeSignatureProcessorBase
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(ChangeSignatureProcessorBase.class);
    protected static final String REFACTORING_ID = "refactoring.changeSignature";
    protected final ChangeInfo myChangeInfo;
    protected final PsiManager myManager;

    protected ChangeSignatureProcessorBase(Project project, ChangeInfo changeInfo) {
        super(project);
        this.myChangeInfo = changeInfo;
        this.myManager = PsiManager.getInstance((Project)project);
    }

    @Override
    protected UsageInfo @NotNull [] findUsages() {
        return ChangeSignatureProcessorBase.findUsages(this.myChangeInfo);
    }

    public static void collectConflictsFromExtensions(@NotNull Ref<UsageInfo[]> refUsages, MultiMap<PsiElement, String> conflictDescriptions, ChangeInfo changeInfo) {
        for (ChangeSignatureUsageProcessor usageProcessor : (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions()) {
            MultiMap conflicts = usageProcessor.findConflicts(changeInfo, refUsages);
            for (PsiElement key : conflicts.keySet()) {
                HashSet collection = conflictDescriptions.get((Object)key);
                if (collection.isEmpty()) {
                    collection = new HashSet();
                }
                collection.addAll(conflicts.get((Object)key));
                conflictDescriptions.put((Object)key, collection);
            }
        }
    }

    public static UsageInfo @NotNull [] findUsages(ChangeInfo changeInfo) {
        ChangeSignatureUsageProcessor[] processors;
        List<Object> infos = new ArrayList();
        for (ChangeSignatureUsageProcessor processor2 : processors = (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions()) {
            for (UsageInfo info : processor2.findUsages(changeInfo)) {
                LOG.assertTrue(info != null, (Object)processor2);
                infos.add(info);
            }
        }
        infos = ChangeSignatureProcessorBase.filterUsages(infos);
        return infos.toArray(UsageInfo.EMPTY_ARRAY);
    }

    protected static List<UsageInfo> filterUsages(List<? extends UsageInfo> infos) {
        HashMap<PsiElement, MoveRenameUsageInfo> moveRenameInfos = new HashMap<PsiElement, MoveRenameUsageInfo>();
        HashSet<PsiElement> usedElements = new HashSet<PsiElement>();
        ArrayList<UsageInfo> result2 = new ArrayList<UsageInfo>(infos.size() / 2);
        for (UsageInfo usageInfo : infos) {
            LOG.assertTrue(usageInfo != null);
            PsiElement element2 = usageInfo.getElement();
            if (usageInfo instanceof MoveRenameUsageInfo) {
                if (usedElements.contains(element2)) continue;
                moveRenameInfos.put(element2, (MoveRenameUsageInfo)usageInfo);
                continue;
            }
            moveRenameInfos.remove(element2);
            usedElements.add(element2);
            if (usageInfo instanceof PossiblyIncorrectUsage && !((PossiblyIncorrectUsage)usageInfo).isCorrect()) continue;
            result2.add(usageInfo);
        }
        result2.addAll(moveRenameInfos.values());
        return result2;
    }

    @Override
    protected boolean isPreviewUsages(UsageInfo @NotNull [] usages) {
        for (ChangeSignatureUsageProcessor processor2 : (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions()) {
            if (!processor2.shouldPreviewUsages(this.myChangeInfo, usages)) continue;
            return true;
        }
        return super.isPreviewUsages(usages);
    }

    @Override
    @Nullable
    protected String getRefactoringId() {
        return REFACTORING_ID;
    }

    @Override
    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data2 = new RefactoringEventData();
        data2.addElement(this.getChangeInfo().getMethod());
        return data2;
    }

    @Override
    @Nullable
    protected RefactoringEventData getAfterData(UsageInfo @NotNull [] usages) {
        RefactoringEventData data2 = new RefactoringEventData();
        data2.addElement(this.getChangeInfo().getMethod());
        return data2;
    }

    @Override
    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        RefactoringTransaction transaction = this.getTransaction();
        final ChangeInfo changeInfo = this.myChangeInfo;
        final RefactoringElementListener elementListener = transaction == null ? null : transaction.getElementListener(changeInfo.getMethod());
        final String fqn = CopyReferenceAction.elementToFqn(changeInfo.getMethod());
        if (fqn != null) {
            BasicUndoableAction action2 = new BasicUndoableAction(){

                public void undo() {
                    if (elementListener instanceof UndoRefactoringElementListener) {
                        ((UndoRefactoringElementListener)elementListener).undoElementMovedOrRenamed(changeInfo.getMethod(), fqn);
                    }
                }

                public void redo() {
                }
            };
            UndoManager.getInstance((Project)this.myProject).undoableActionPerformed((UndoableAction)action2);
        }
        try {
            ChangeSignatureProcessorBase.doChangeSignature(changeInfo, usages);
            PsiElement method2 = changeInfo.getMethod();
            LOG.assertTrue(method2.isValid());
            if (elementListener != null && changeInfo.isNameChanged()) {
                elementListener.elementRenamed(method2);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public static void doChangeSignature(ChangeInfo changeInfo, UsageInfo @NotNull [] usages) {
        ChangeSignatureUsageProcessor[] processors = (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions();
        ResolveSnapshotProvider resolveSnapshotProvider = changeInfo.isParameterNamesChanged() ? (ResolveSnapshotProvider)VariableInplaceRenamer.INSTANCE.forLanguage(changeInfo.getMethod().getLanguage()) : null;
        ArrayList snapshots = new ArrayList();
        for (ChangeSignatureUsageProcessor changeSignatureUsageProcessor : processors) {
            if (resolveSnapshotProvider == null) continue;
            changeSignatureUsageProcessor.registerConflictResolvers(snapshots, resolveSnapshotProvider, usages, changeInfo);
        }
        for (ChangeSignatureUsageProcessor changeSignatureUsageProcessor : usages) {
            for (ChangeSignatureUsageProcessor processor3 : processors) {
                if (processor3.processUsage(changeInfo, (UsageInfo)changeSignatureUsageProcessor, true, usages)) break;
            }
        }
        LOG.assertTrue(changeInfo.getMethod().isValid());
        for (ChangeSignatureUsageProcessor changeSignatureUsageProcessor : processors) {
            if (changeSignatureUsageProcessor.processPrimaryMethod(changeInfo)) break;
        }
        for (ChangeSignatureUsageProcessor changeSignatureUsageProcessor : usages) {
            for (ChangeSignatureUsageProcessor processor2 : processors) {
                if (processor2.processUsage(changeInfo, (UsageInfo)changeSignatureUsageProcessor, false, usages)) break;
            }
        }
        if (!snapshots.isEmpty()) {
            for (ChangeSignatureUsageProcessor changeSignatureUsageProcessor : changeInfo.getNewParameters()) {
                for (ResolveSnapshotProvider.ResolveSnapshot snapshot : snapshots) {
                    snapshot.apply(changeSignatureUsageProcessor.getName());
                }
            }
        }
    }

    @Override
    @NotNull
    protected String getCommandName() {
        return RefactoringBundle.message((String)"changing.signature.of.0", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myChangeInfo.getMethod())});
    }

    public ChangeInfo getChangeInfo() {
        return this.myChangeInfo;
    }
}

