/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util.proximity;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.proximity.ProximityWeigher;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;

public class DirectoryTypeWeigher
extends ProximityWeigher {
    @Override
    public Comparable weigh(@NotNull PsiElement element2, @NotNull ProximityLocation location) {
        Project project = location.getProject();
        if (project == null) {
            return Integer.valueOf(0);
        }
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)element2);
        if (file2 == null) {
            return Integer.valueOf(0);
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (fileIndex.isUnderSourceRootOfType(file2, Collections.singleton(JavaSourceRootType.SOURCE))) {
            return Integer.valueOf(3);
        }
        if (fileIndex.isUnderSourceRootOfType(file2, Collections.singleton(JavaSourceRootType.TEST_SOURCE))) {
            return Integer.valueOf(2);
        }
        if (fileIndex.isUnderSourceRootOfType(file2, (Set)ContainerUtil.newHashSet((Object[])new JavaResourceRootType[]{JavaResourceRootType.RESOURCE, JavaResourceRootType.TEST_RESOURCE}))) {
            return Integer.valueOf(1);
        }
        return Integer.valueOf(0);
    }
}

