/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexImpl;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.DirectInputDataDiffBuilder;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StubCumulativeInputDiffBuilder
extends DirectInputDataDiffBuilder<Integer, SerializedStubTree> {
    private static final Logger LOG = Logger.getInstance(SerializedStubTree.class);
    private final int myInputId;
    @Nullable
    private final SerializedStubTree myCurrentTree;

    StubCumulativeInputDiffBuilder(int inputId, @Nullable SerializedStubTree currentTree) {
        super(inputId);
        this.myInputId = inputId;
        this.myCurrentTree = currentTree;
    }

    public boolean differentiate(@NotNull Map<Integer, SerializedStubTree> newData, @NotNull KeyValueUpdateProcessor<? super Integer, ? super SerializedStubTree> addProcessor, @NotNull KeyValueUpdateProcessor<? super Integer, ? super SerializedStubTree> updateProcessor, @NotNull RemovedKeyProcessor<? super Integer> removeProcessor) throws StorageException {
        if (!newData.isEmpty()) {
            SerializedStubTree newSerializedStubTree = newData.values().iterator().next();
            if (this.myCurrentTree != null) {
                if (StubCumulativeInputDiffBuilder.treesAreEqual(newSerializedStubTree, this.myCurrentTree)) {
                    return false;
                }
                removeProcessor.process((Object)this.myInputId, this.myInputId);
            }
            addProcessor.process((Object)this.myInputId, (Object)newSerializedStubTree, this.myInputId);
            this.updateStubIndices(newSerializedStubTree);
        } else {
            removeProcessor.process((Object)this.myInputId, this.myInputId);
            this.updateStubIndices(null);
        }
        return true;
    }

    @NotNull
    public Collection<Integer> getKeys() {
        return this.myCurrentTree != null ? Collections.singleton(this.myInputId) : Collections.emptySet();
    }

    private static boolean treesAreEqual(@NotNull SerializedStubTree newSerializedStubTree, @NotNull SerializedStubTree currentTree) {
        return Arrays.equals(currentTree.getTreeHash(), newSerializedStubTree.getTreeHash()) && StubCumulativeInputDiffBuilder.treesAreReallyEqual(newSerializedStubTree, currentTree);
    }

    private static boolean treesAreReallyEqual(@NotNull SerializedStubTree newSerializedStubTree, @NotNull SerializedStubTree currentTree) {
        if (newSerializedStubTree.equals(currentTree)) {
            return true;
        }
        if (IndexDebugProperties.DEBUG) {
            StubCumulativeInputDiffBuilder.reportStubTreeHashCollision(newSerializedStubTree, currentTree);
        }
        return false;
    }

    private void updateStubIndices(@Nullable SerializedStubTree newTree) {
        Map oldForwardIndex = this.myCurrentTree == null ? Collections.emptyMap() : this.myCurrentTree.getStubIndicesValueMap();
        Map<Object, Object> newForwardIndex = newTree == null ? Collections.emptyMap() : newTree.getStubIndicesValueMap();
        Set affectedIndexes = ContainerUtil.union(oldForwardIndex.keySet(), newForwardIndex.keySet());
        if (FileBasedIndexImpl.DO_TRACE_STUB_INDEX_UPDATE) {
            StubIndexImpl.LOG.info("stub indexes" + (newTree == null ? "deletion" : "update") + ": file = " + this.myInputId + " indexes " + affectedIndexes);
        }
        StubIndexImpl stubIndex = (StubIndexImpl)StubIndex.getInstance();
        for (StubIndexKey key : affectedIndexes) {
            Set oldKeys = oldForwardIndex.getOrDefault(key, Collections.emptyMap()).keySet();
            Set newKeys = newForwardIndex.getOrDefault(key, Collections.emptyMap()).keySet();
            stubIndex.updateIndex(key, this.myInputId, oldKeys, newKeys);
        }
    }

    private static void reportStubTreeHashCollision(@NotNull SerializedStubTree newTree, @NotNull SerializedStubTree existingTree) {
        String oldTreeDump = "\nexisting tree " + StubCumulativeInputDiffBuilder.dumpStub(existingTree);
        String newTreeDump = "\nnew tree " + StubCumulativeInputDiffBuilder.dumpStub(newTree);
        byte[] hash = newTree.getTreeHash();
        LOG.info("Stub tree hashing collision. Different trees have the same hash = " + StubCumulativeInputDiffBuilder.toHexString(hash, hash.length) + ". " + oldTreeDump + newTreeDump, (Throwable)new Exception());
    }

    private static String toHexString(byte[] hash, int length) {
        return IntStreamEx.of((byte[])hash).limit((long)length).mapToObj(b -> String.format("%02x", b & 0xFF)).joining();
    }

    @NotNull
    private static String dumpStub(@NotNull SerializedStubTree tree) {
        String deserialized;
        try {
            deserialized = "stub: " + DebugUtil.stubTreeToString(tree.getStub());
        }
        catch (SerializerNotFoundException e) {
            LOG.error((Throwable)e);
            deserialized = "error while stub deserialization: " + e.getMessage();
        }
        return deserialized + "\n bytes: " + StubCumulativeInputDiffBuilder.toHexString(tree.myTreeBytes, tree.myTreeByteLength);
    }
}

