/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.Forceable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElementTypeHolderEP;
import com.intellij.psi.stubs.StubFieldAccessor;
import com.intellij.psi.stubs.StubSerializationHelper;
import com.intellij.psi.stubs.StubSerializer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.StubFileElementType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.io.DataEnumeratorEx;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.InMemoryDataEnumerator;
import com.intellij.util.io.PersistentHashMapValueStorage;
import com.intellij.util.io.PersistentStringEnumerator;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SerializationManagerImpl
extends SerializationManagerEx
implements Disposable {
    private static final Logger LOG = Logger.getInstance(SerializationManagerImpl.class);
    private final AtomicBoolean myNameStorageCrashed = new AtomicBoolean(false);
    private final Path myFile;
    private final boolean myUnmodifiable;
    private final AtomicBoolean myShutdownPerformed = new AtomicBoolean(false);
    private DataEnumeratorEx<String> myNameStorage;
    private volatile StubSerializationHelper myStubSerializationHelper;
    private volatile boolean mySerializersLoaded;

    public SerializationManagerImpl() {
        this(FileBasedIndex.USE_IN_MEMORY_INDEX ? null : new File(PathManager.getIndexRoot(), "rep.names").toPath(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerializationManagerImpl(@Nullable Path nameStorageFile, boolean unmodifiable) {
        this.myFile = nameStorageFile;
        this.myUnmodifiable = unmodifiable;
        try {
            this.myNameStorage = this.openNameStorage();
            this.myStubSerializationHelper = new StubSerializationHelper(this.myNameStorage, unmodifiable, this);
        }
        catch (IOException e) {
            this.nameStorageCrashed();
            LOG.info((Throwable)e);
            this.repairNameStorage();
            this.nameStorageCrashed();
        }
        finally {
            ShutDownTracker.getInstance().registerShutdownTask(this::performShutdown, (Disposable)this);
        }
        StubElementTypeHolderEP.EP_NAME.addChangeListener(this::dropSerializerData, (Disposable)this);
    }

    @NotNull
    private DataEnumeratorEx<String> openNameStorage() throws IOException {
        if (this.myFile == null) {
            return new InMemoryDataEnumerator();
        }
        Boolean lastValue = null;
        if (this.myUnmodifiable) {
            lastValue = (Boolean)PersistentHashMapValueStorage.CreationTimeOptions.READONLY.get();
            PersistentHashMapValueStorage.CreationTimeOptions.READONLY.set(Boolean.TRUE);
        }
        try {
            PersistentStringEnumerator persistentStringEnumerator = new PersistentStringEnumerator(this.myFile, true);
            return persistentStringEnumerator;
        }
        finally {
            if (this.myUnmodifiable) {
                PersistentHashMapValueStorage.CreationTimeOptions.READONLY.set(lastValue);
            }
        }
    }

    @Override
    public boolean isNameStorageCorrupted() {
        return this.myNameStorageCrashed.get();
    }

    @Override
    public void repairNameStorage() {
        if (this.myNameStorageCrashed.getAndSet(false)) {
            try {
                LOG.info("Name storage is repaired");
                this.closeNameStorage();
                StubSerializationHelper prevHelper = this.myStubSerializationHelper;
                if (this.myUnmodifiable) {
                    LOG.error("Data provided by unmodifiable serialization manager can be invalid after repair");
                }
                if (this.myFile != null) {
                    IOUtil.deleteAllFilesStartingWith((File)this.myFile.toFile());
                }
                this.myNameStorage = this.openNameStorage();
                this.myStubSerializationHelper = new StubSerializationHelper(this.myNameStorage, this.myUnmodifiable, this);
                this.myStubSerializationHelper.copyFrom(prevHelper);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                this.nameStorageCrashed();
            }
        }
    }

    @Override
    public void flushNameStorage() {
        if (this.myNameStorage instanceof Forceable && ((Forceable)this.myNameStorage).isDirty()) {
            ((Forceable)this.myNameStorage).force();
        }
    }

    @Override
    public String internString(String string) {
        return this.myStubSerializationHelper.intern(string);
    }

    @Override
    public void reinitializeNameStorage() {
        this.nameStorageCrashed();
        this.repairNameStorage();
    }

    private void nameStorageCrashed() {
        this.myNameStorageCrashed.set(true);
    }

    public void dispose() {
        this.performShutdown();
    }

    private void performShutdown() {
        if (!this.myShutdownPerformed.compareAndSet(false, true)) {
            return;
        }
        String name = this.myFile != null ? this.myFile.toString() : "in-memory storage";
        LOG.info("Start shutting down " + name);
        try {
            this.closeNameStorage();
            LOG.info("Finished shutting down " + name);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void closeNameStorage() throws IOException {
        if (this.myNameStorage instanceof Closeable) {
            ((Closeable)this.myNameStorage).close();
        }
    }

    @Override
    protected void registerSerializer(String externalId, Computable<ObjectStubSerializer> lazySerializer) {
        try {
            this.myStubSerializationHelper.assignId(lazySerializer, externalId);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            this.nameStorageCrashed();
        }
    }

    @Override
    public void serialize(@NotNull Stub rootStub, @NotNull OutputStream stream) {
        this.initSerializers();
        try {
            this.myStubSerializationHelper.serialize(rootStub, stream);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            this.nameStorageCrashed();
        }
    }

    @Override
    @NotNull
    public Stub deserialize(@NotNull InputStream stream) throws SerializerNotFoundException {
        this.initSerializers();
        try {
            return this.myStubSerializationHelper.deserialize(stream);
        }
        catch (IOException e) {
            this.nameStorageCrashed();
            LOG.info((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void reSerialize(@NotNull InputStream inStub, @NotNull OutputStream outStub, @NotNull SerializationManagerEx newSerializationManager) throws IOException {
        this.initSerializers();
        newSerializationManager.initSerializers();
        this.myStubSerializationHelper.reSerializeStub(new DataInputStream(inStub), new DataOutputStream(outStub), ((SerializationManagerImpl)newSerializationManager).myStubSerializationHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initSerializers() {
        SerializationManagerImpl serializationManagerImpl = this;
        synchronized (serializationManagerImpl) {
            if (this.mySerializersLoaded) {
                return;
            }
            this.registerSerializer((ObjectStubSerializer)PsiFileStubImpl.TYPE);
            List lazySerializers = IStubElementType.loadRegisteredStubElementTypes();
            IElementType[] stubElementTypes = IElementType.enumerate(type -> type instanceof StubSerializer);
            for (IElementType type2 : stubElementTypes) {
                if (type2 instanceof StubFileElementType && "psi.file".equals(((StubFileElementType)type2).getExternalId())) continue;
                this.registerSerializer((ObjectStubSerializer)((StubSerializer)type2));
            }
            for (StubFieldAccessor lazySerializer : lazySerializers) {
                this.registerSerializer(lazySerializer.externalId, (Computable<ObjectStubSerializer>)lazySerializer);
            }
            this.mySerializersLoaded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropSerializerData() {
        SerializationManagerImpl serializationManagerImpl = this;
        synchronized (serializationManagerImpl) {
            IStubElementType.dropRegisteredTypes();
            StubSerializationHelper helper = this.myStubSerializationHelper;
            if (helper != null) {
                helper.dropRegisteredSerializers();
            } else {
                this.nameStorageCrashed();
            }
            this.mySerializersLoaded = false;
        }
    }
}

