/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.PersistentStringEnumerator;
import gnu.trove.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class CompositeBinaryBuilderMap {
    private static final Logger LOG = Logger.getInstance(CompositeBinaryBuilderMap.class);
    private static final FileAttribute VERSION_STAMP = new FileAttribute("stubIndex.cumulativeBinaryBuilder", 1, true);
    private final TObjectIntHashMap<FileType> myCumulativeVersionMap;

    CompositeBinaryBuilderMap() throws IOException {
        try (PersistentStringEnumerator cumulativeVersionEnumerator = new PersistentStringEnumerator(CompositeBinaryBuilderMap.registeredCompositeBinaryBuilderFiles());){
            this.myCumulativeVersionMap = new TObjectIntHashMap();
            for (Map.Entry entry : BinaryFileStubBuilders.INSTANCE.getAllRegisteredExtensions().entrySet()) {
                FileType fileType = (FileType)entry.getKey();
                BinaryFileStubBuilder builder2 = (BinaryFileStubBuilder)entry.getValue();
                if (!(builder2 instanceof BinaryFileStubBuilder.CompositeBinaryFileStubBuilder)) continue;
                StringBuilder cumulativeVersion = new StringBuilder();
                cumulativeVersion.append(fileType.getName()).append("->").append(builder2.getClass().getName()).append(':').append(builder2.getStubVersion());
                BinaryFileStubBuilder.CompositeBinaryFileStubBuilder compositeBuilder = (BinaryFileStubBuilder.CompositeBinaryFileStubBuilder)builder2;
                compositeBuilder.getAllSubBuilders().forEach(b -> cumulativeVersion.append(';').append(compositeBuilder.getSubBuilderVersion(b)));
                int enumeratedId = cumulativeVersionEnumerator.enumerate(cumulativeVersion.toString());
                LOG.debug("composite binary stub builder for " + fileType + " registered:  id = " + enumeratedId + ", value" + cumulativeVersion.toString());
                this.myCumulativeVersionMap.put((Object)fileType, enumeratedId);
            }
        }
    }

    void persistState(int fileId, @NotNull VirtualFile file2) throws IOException {
        int version2 = this.getBuilderCumulativeVersion(file2);
        if (version2 == 0) {
            return;
        }
        try (DataOutputStream stream = FSRecords.writeAttribute(fileId, VERSION_STAMP);){
            DataInputOutputUtil.writeINT((DataOutput)stream, (int)version2);
        }
    }

    boolean isUpToDateState(int fileId, @NotNull VirtualFile file2) throws IOException {
        int indexedVersion;
        DataInputStream stream = FSRecords.readAttributeWithLock(fileId, VERSION_STAMP);
        int n = indexedVersion = stream != null ? DataInputOutputUtil.readINT((DataInput)stream) : 0;
        if (indexedVersion == 0) {
            return false;
        }
        int actualVersion = this.getBuilderCumulativeVersion(file2);
        return actualVersion == indexedVersion;
    }

    private int getBuilderCumulativeVersion(@NotNull VirtualFile file2) {
        FileType type = (FileType)ProgressManager.getInstance().computeInNonCancelableSection(() -> file2.getFileType());
        return this.myCumulativeVersionMap.get((Object)type);
    }

    @NotNull
    private static Path registeredCompositeBinaryBuilderFiles() {
        return new File(IndexInfrastructure.getIndexRootDir(StubUpdatingIndex.INDEX_ID), ".binary_builders").toPath();
    }
}

