/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.BlockSupportImpl;
import com.intellij.psi.impl.BooleanRunnable;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DiffLog;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.smartPointers.Identikit;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.injected.DocumentWindowImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.InjectionResult;
import com.intellij.psi.impl.source.tree.injected.LeafPatcher;
import com.intellij.psi.impl.source.tree.injected.MultiHostRegistrarImpl;
import com.intellij.psi.impl.source.tree.injected.MultipleRootsInjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.impl.source.tree.injected.PlaceInfo;
import com.intellij.psi.impl.source.tree.injected.ShredImpl;
import com.intellij.psi.impl.source.tree.injected.SingleRootInjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.VirtualFileWindowImpl;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InjectionRegistrarImpl
extends MultiHostRegistrarImpl
implements MultiHostRegistrar {
    private final PsiDocumentManagerBase myDocumentManagerBase;
    private List<PsiFile> resultFiles;
    private List<Pair<ReferenceInjector, Place>> resultReferences;
    private Language myLanguage;
    private List<PlaceInfo> placeInfos;
    private boolean cleared = true;
    private String fileExtension;
    private final Project myProject;
    private final DocumentEx myHostDocument;
    private final VirtualFile myHostVirtualFile;
    private final PsiElement myContextElement;
    private final PsiFile myHostPsiFile;
    private Thread currentThread;
    private static final Key<ASTNode> TREE_HARD_REF = Key.create((String)"TREE_HARD_REF");

    InjectionRegistrarImpl(@NotNull Project project, @NotNull PsiFile hostPsiFile, @NotNull PsiElement contextElement, @NotNull PsiDocumentManager docManager) {
        this.myProject = project;
        this.myContextElement = contextElement;
        this.myHostPsiFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)hostPsiFile);
        FileViewProvider viewProvider = this.myHostPsiFile.getViewProvider();
        if (viewProvider instanceof InjectedFileViewProvider) {
            throw new IllegalArgumentException(viewProvider + " must not be injected");
        }
        this.myHostVirtualFile = viewProvider.getVirtualFile();
        this.myDocumentManagerBase = (PsiDocumentManagerBase)docManager;
        this.myHostDocument = (DocumentEx)viewProvider.getDocument();
    }

    @Nullable
    InjectionResult getInjectedResult() {
        return this.resultFiles == null && this.resultReferences == null ? null : new InjectionResult(this.myHostPsiFile, this.resultFiles, this.resultReferences);
    }

    @Override
    @NotNull
    public MultiHostRegistrar startInjecting(@NotNull Language language) {
        return this.startInjecting(language, null);
    }

    @NotNull
    public MultiHostRegistrar startInjecting(@NotNull Language language, @Nullable String extension) {
        this.fileExtension = extension;
        this.placeInfos = new SmartList();
        if (!this.cleared) {
            this.clear();
            throw new IllegalStateException("Seems you haven't called doneInjecting()");
        }
        this.currentThread = Thread.currentThread();
        if (LanguageParserDefinitions.INSTANCE.forLanguage(language) == null) {
            throw new UnsupportedOperationException("Cannot inject language '" + language + "' because it has no ParserDefinition");
        }
        this.myLanguage = language;
        return this;
    }

    private void clear() {
        this.fileExtension = null;
        this.myLanguage = null;
        this.cleared = true;
        this.placeInfos = null;
        this.currentThread = null;
    }

    @NotNull
    public MultiHostRegistrar addPlace(@NonNls @Nullable String prefix, @NonNls @Nullable String suffix, @NotNull PsiLanguageInjectionHost host, @NotNull TextRange rangeInsideHost) {
        this.checkThreading();
        if (this.myLanguage == null) {
            this.clear();
            throw new IllegalStateException("Seems you haven't called startInjecting()");
        }
        if (!host.isValidHost()) {
            throw new IllegalArgumentException(host + ".isValidHost() in " + host.getClass() + " returned false so you mustn't inject here.");
        }
        PsiFile containingFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)host);
        assert (containingFile == this.myHostPsiFile) : InjectionRegistrarImpl.exceptionContext("Trying to inject into foreign file: " + containingFile, this.myLanguage, this.myHostPsiFile, this.myHostVirtualFile, this.myHostDocument, this.placeInfos, this.myDocumentManagerBase);
        TextRange hostTextRange = host.getTextRange();
        if (!hostTextRange.contains(rangeInsideHost.shiftRight(hostTextRange.getStartOffset()))) {
            this.clear();
            throw new IllegalArgumentException("rangeInsideHost must lie within host text range. rangeInsideHost:" + rangeInsideHost + "; host textRange:" + hostTextRange);
        }
        this.cleared = false;
        String nnPrefix = StringUtil.isEmpty((String)prefix) ? "" : prefix;
        String nnSuffix = StringUtil.isEmpty((String)suffix) ? "" : suffix;
        PlaceInfo info = new PlaceInfo(nnPrefix, nnSuffix, host, rangeInsideHost);
        this.placeInfos.add(info);
        return this;
    }

    private void checkThreading() {
        if (this.currentThread != Thread.currentThread()) {
            throw new IllegalStateException("Wow, you must not start injecting in one thread (" + this.currentThread + ") and finish in the other (" + Thread.currentThread() + ")");
        }
    }

    private static void decode(@NotNull PlaceInfo info, @NotNull StringBuilder outChars) {
        int startOffset = outChars.length();
        outChars.append(info.prefix);
        LiteralTextEscaper<? extends PsiLanguageInjectionHost> textEscaper = info.myEscaper;
        TextRange relevantRange = info.getRelevantRangeInsideHost();
        if (relevantRange == null) {
            relevantRange = TextRange.from((int)textEscaper.getRelevantTextRange().getStartOffset(), (int)0);
        } else {
            int before = outChars.length();
            boolean decodeSuccessful = textEscaper.decode(relevantRange, outChars);
            int after2 = outChars.length();
            assert (after2 >= before) : "Escaper " + textEscaper + "(" + textEscaper.getClass() + ") must not mangle char buffer";
            if (!decodeSuccessful) {
                int charsDecodedSuccessfully = outChars.length() - before;
                int startOffsetInHost = textEscaper.getOffsetInHost(0, info.registeredRangeInsideHost);
                assert (relevantRange.containsOffset(startOffsetInHost)) : textEscaper.getClass() + " is inconsistent: its.getOffsetInHost(0) = " + startOffsetInHost + " while its relevantRange=" + relevantRange;
                int endOffsetInHost = textEscaper.getOffsetInHost(charsDecodedSuccessfully, info.registeredRangeInsideHost);
                assert (relevantRange.containsOffset(endOffsetInHost)) : textEscaper.getClass() + " is inconsistent: its.getOffsetInHost(" + charsDecodedSuccessfully + ") = " + startOffsetInHost + " while its relevantRange=" + relevantRange;
                ProperTextRange successfulHostRange = new ProperTextRange(startOffsetInHost, endOffsetInHost);
                relevantRange = relevantRange.intersection((TextRange)successfulHostRange);
            }
        }
        outChars.append(info.suffix);
        int endOffset = outChars.length();
        info.rangeInDecodedPSI = new ProperTextRange(startOffset, endOffset);
        info.rangeInHostElement = relevantRange;
    }

    @NotNull
    private static ShredImpl createShred(@NotNull PlaceInfo info, @NotNull StringBuilder outChars, @NotNull PsiFile hostPsiFile) {
        InjectionRegistrarImpl.decode(info, outChars);
        TextRange relevantRange = info.rangeInHostElement;
        TextRange hostTextRange = info.host.getTextRange();
        TextRange relevantRangeInHostFile = relevantRange.shiftRight(hostTextRange.getStartOffset());
        SmartPointerManagerImpl manager = (SmartPointerManagerImpl)SmartPointerManager.getInstance((Project)hostPsiFile.getProject());
        return new ShredImpl(manager.createSmartPsiFileRangePointer(hostPsiFile, relevantRangeInHostFile, true), manager.createSmartPsiElementPointer(info.host, hostPsiFile, true), info.prefix, info.suffix, (TextRange)info.rangeInDecodedPSI, false, info.myEscaper.isOneLine());
    }

    public void doneInjecting() {
        this.checkThreading();
        try {
            if (this.myLanguage == null) {
                throw new IllegalStateException("Seems you haven't called startInjecting()");
            }
            if (this.placeInfos.isEmpty()) {
                throw new IllegalStateException("Seems you haven't called addPlace()");
            }
            Language forcedLanguage = (Language)this.myContextElement.getUserData(SingleRootInjectedFileViewProvider.LANGUAGE_FOR_INJECTED_COPY_KEY);
            InjectionRegistrarImpl.checkForCorrectContextElement(this.placeInfos, this.myContextElement, this.myLanguage, this.myHostPsiFile, this.myHostVirtualFile, this.myHostDocument, this.myDocumentManagerBase);
            this.createAndRegisterInjected(forcedLanguage);
        }
        finally {
            this.clear();
        }
    }

    private static void checkForCorrectContextElement(@NotNull List<PlaceInfo> placeInfos, @NotNull PsiElement contextElement, @NotNull Language language, @NotNull PsiFile hostPsiFile, @NotNull VirtualFile hostVirtualFile, @NotNull DocumentEx hostDocument, @NotNull PsiDocumentManagerBase documentManager) {
        boolean isAncestor = false;
        for (PlaceInfo info : placeInfos) {
            isAncestor |= PsiTreeUtil.isAncestor((PsiElement)contextElement, (PsiElement)info.host, (boolean)false);
        }
        assert (isAncestor) : InjectionRegistrarImpl.exceptionContext("Context element " + contextElement.getTextRange() + ": '" + contextElement + "' (" + contextElement.getClass() + ");  must be the parent of at least one of injection hosts", language, hostPsiFile, hostVirtualFile, hostDocument, placeInfos, documentManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndRegisterInjected(Language forcedLanguage) {
        ASTNode[] parsedNodes;
        StringBuilder decodedChars = new StringBuilder();
        Place place = new Place();
        for (PlaceInfo info : this.placeInfos) {
            ShredImpl shred = InjectionRegistrarImpl.createShred(info, decodedChars, this.myHostPsiFile);
            place.add(shred);
            info.newInjectionHostRange = shred.getSmartPointer().getRange();
        }
        DocumentWindowImpl documentWindow = new DocumentWindowImpl(this.myHostDocument, place);
        String fileName = PathUtil.makeFileName((String)this.myHostVirtualFile.getName(), (String)this.fileExtension);
        for (ASTNode node : parsedNodes = InjectionRegistrarImpl.parseFile(this.myLanguage, forcedLanguage, documentWindow, this.myHostVirtualFile, this.myHostDocument, this.myHostPsiFile, this.myProject, documentWindow.getText(), this.placeInfos, decodedChars, fileName, this.myDocumentManagerBase)) {
            PsiFile psiFile = (PsiFile)node.getPsi();
            InjectedFileViewProvider viewProvider = (InjectedFileViewProvider)psiFile.getViewProvider();
            Object object = InjectedLanguageManagerImpl.ourInjectionPsiLock;
            synchronized (object) {
                if (psiFile.getLanguage() == viewProvider.getBaseLanguage()) {
                    psiFile = InjectionRegistrarImpl.createOrMergeInjectedFile(this.myHostPsiFile, this.myDocumentManagerBase, place, documentWindow, psiFile, viewProvider);
                    this.addFileToResults(psiFile);
                } else {
                    InjectionRegistrarImpl.cacheEverything(place, documentWindow, viewProvider, psiFile);
                    InjectedLanguageUtil.setHighlightTokens(psiFile, InjectedLanguageUtil.getHighlightTokens(psiFile));
                }
                DocumentWindowImpl retrieved = (DocumentWindowImpl)this.myDocumentManagerBase.getDocument(psiFile);
                InjectionRegistrarImpl.assertEverythingIsAllright(this.myDocumentManagerBase, retrieved, psiFile);
            }
        }
    }

    @NotNull
    private static PsiFile createOrMergeInjectedFile(@NotNull PsiFile hostPsiFile, @NotNull PsiDocumentManagerBase documentManager, @NotNull Place place, @NotNull DocumentWindowImpl documentWindow, @NotNull PsiFile psiFile, @NotNull InjectedFileViewProvider viewProvider) {
        InjectionRegistrarImpl.cacheEverything(place, documentWindow, viewProvider, psiFile);
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile((Document)documentWindow);
        PsiFile cachedPsiFile = ((PsiManagerEx)psiFile.getManager()).getFileManager().findCachedViewProvider(virtualFile).getPsi(psiFile.getLanguage());
        assert (cachedPsiFile == psiFile) : "Cached psi :" + cachedPsiFile + " instead of " + psiFile;
        assert (place.isValid());
        assert (viewProvider.isValid());
        List<InjectedLanguageUtil.TokenInfo> newTokens = InjectedLanguageUtil.getHighlightTokens(psiFile);
        PsiFile newFile = InjectionRegistrarImpl.registerDocument(documentWindow, psiFile, place, hostPsiFile, documentManager);
        boolean mergeHappened = newFile != psiFile;
        Place mergedPlace = place;
        if (mergeHappened) {
            boolean shredsReused;
            InjectedLanguageUtil.clearCaches(psiFile, documentWindow);
            psiFile = newFile;
            viewProvider = (InjectedFileViewProvider)psiFile.getViewProvider();
            documentWindow = viewProvider.getDocument();
            boolean bl = shredsReused = !InjectionRegistrarImpl.cacheEverything(place, documentWindow, viewProvider, psiFile);
            if (shredsReused) {
                place.dispose();
                mergedPlace = documentWindow.getShreds();
            }
            InjectedLanguageUtil.setHighlightTokens(psiFile, newTokens);
        }
        assert (psiFile.isValid());
        assert (mergedPlace.isValid());
        assert (viewProvider.isValid());
        return psiFile;
    }

    private static void patchLeaves(@NotNull List<? extends PlaceInfo> placeInfos, @NotNull InjectedFileViewProvider viewProvider, @NotNull ASTNode parsedNode, @NotNull CharSequence documentText) throws PatchException {
        Runnable patch = () -> {
            LeafPatcher patcher = new LeafPatcher(placeInfos, parsedNode.getTextLength());
            patcher.patch(parsedNode, placeInfos);
        };
        if (viewProvider instanceof SingleRootInjectedFileViewProvider) {
            ((SingleRootInjectedFileViewProvider)viewProvider).doNotInterruptMeWhileImPatchingLeaves(patch);
        } else if (viewProvider instanceof MultipleRootsInjectedFileViewProvider) {
            ((MultipleRootsInjectedFileViewProvider)viewProvider).doNotInterruptMeWhileImPatchingLeaves(patch);
        }
        if (!((FileElement)parsedNode).textMatches(documentText)) {
            throw new PatchException("After patch: doc:\n'" + documentText + "'\n---PSI:\n'" + parsedNode.getText());
        }
    }

    void injectReference(@NotNull Language language, @NotNull String prefix, @NotNull String suffix, @NotNull PsiLanguageInjectionHost host, @NotNull TextRange rangeInsideHost) {
        ParserDefinition parser = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        if (parser != null) {
            throw new IllegalArgumentException("Language " + language + " being injected as reference must not have ParserDefinition and yet - " + parser);
        }
        ReferenceInjector injector = ReferenceInjector.findById((String)language.getID());
        if (injector == null) {
            throw new IllegalArgumentException("Language " + language + " being injected as reference must register reference injector");
        }
        this.placeInfos = new SmartList();
        if (!this.cleared) {
            this.clear();
            throw new IllegalStateException("Seems you haven't called doneInjecting()");
        }
        this.myLanguage = language;
        this.currentThread = Thread.currentThread();
        this.addPlace(prefix, suffix, host, rangeInsideHost);
        Place place = new Place();
        StringBuilder decodedChars = new StringBuilder();
        ShredImpl shred = InjectionRegistrarImpl.createShred(this.placeInfos.get(0), decodedChars, this.myHostPsiFile);
        place.add(shred);
        this.addReferenceToResults((Pair<ReferenceInjector, Place>)Pair.create((Object)injector, (Object)((Object)place)));
        this.clear();
    }

    private static boolean cacheEverything(@NotNull Place place, @NotNull DocumentWindowImpl documentWindow, @NotNull InjectedFileViewProvider viewProvider, @NotNull PsiFile psiFile) {
        FileDocumentManagerImpl.registerDocument(documentWindow, viewProvider.getVirtualFile());
        DebugUtil.performPsiModification("MultiHostRegistrar cacheEverything", () -> viewProvider.forceCachedPsi(psiFile));
        SmartPsiElementPointer<PsiLanguageInjectionHost> pointer = ((ShredImpl)place.get(0)).getSmartPointer();
        psiFile.putUserData(FileContextUtil.INJECTED_IN_ELEMENT, pointer);
        InjectionRegistrarImpl.keepTreeFromChameleoningBack(psiFile);
        return viewProvider.setShreds(place);
    }

    @NonNls
    private static String exceptionContext(@NonNls @NotNull String msg, @NotNull Language language, @NotNull PsiFile hostPsiFile, @NotNull VirtualFile hostVirtualFile, @NotNull DocumentEx hostDocument, @NotNull List<PlaceInfo> placeInfos, @NotNull PsiDocumentManagerBase documentManager) {
        return msg + ".\nOK let's see. Host file: " + hostPsiFile + " in '" + hostVirtualFile.getPresentableUrl() + "' (" + hostPsiFile.getLanguage() + ") " + (documentManager.isUncommited(hostDocument) ? " (uncommitted)" : "") + "\nWas injected " + language + " at ranges: " + placeInfos;
    }

    private static ASTNode keepTreeFromChameleoningBack(PsiFile psiFile) {
        FileASTNode node = psiFile.getNode();
        ASTNode child2 = node.getFirstChildNode();
        assert (!TreeUtil.isCollapsedChameleon((ASTNode)node)) : "Chameleon " + node + " is collapsed; file: " + psiFile + "; language: " + psiFile.getLanguage();
        psiFile.putUserData(TREE_HARD_REF, (Object)node);
        if (child2 == null) assert (node != null);
        return node;
    }

    private static void assertEverythingIsAllright(@NotNull PsiDocumentManagerBase documentManager, @NotNull DocumentWindowImpl documentWindow, @NotNull PsiFile psiFile) {
        InjectedFileViewProvider injectedFileViewProvider = (InjectedFileViewProvider)psiFile.getViewProvider();
        assert (injectedFileViewProvider.isValid()) : "Invalid view provider: " + injectedFileViewProvider;
        DocumentEx frozenWindow = documentManager.getLastCommittedDocument(documentWindow);
        assert (psiFile.textMatches((CharSequence)frozenWindow.getText())) : "Document window text mismatch";
        assert (injectedFileViewProvider.getDocument() == documentWindow) : "Provider document mismatch";
        assert (documentManager.getCachedDocument(psiFile) == documentWindow) : "Cached document mismatch";
        assert (Comparing.equal((Object)psiFile.getVirtualFile(), (Object)injectedFileViewProvider.getVirtualFile())) : "Virtual file mismatch: " + psiFile.getVirtualFile() + "; " + injectedFileViewProvider.getVirtualFile();
        PsiDocumentManagerBase.checkConsistency(psiFile, frozenWindow);
    }

    void addToResults(@NotNull InjectionResult result2) {
        if (result2.files != null) {
            for (PsiFile psiFile : result2.files) {
                this.addFileToResults(psiFile);
            }
        }
        if (result2.references != null) {
            for (Pair pair : result2.references) {
                this.addReferenceToResults((Pair<ReferenceInjector, Place>)pair);
            }
        }
    }

    private void addFileToResults(@NotNull PsiFile psiFile) {
        if (this.resultFiles == null) {
            this.resultFiles = new SmartList();
        }
        this.resultFiles.add(psiFile);
    }

    private void addReferenceToResults(@NotNull Pair<ReferenceInjector, Place> pair) {
        if (this.resultReferences == null) {
            this.resultReferences = new SmartList();
        }
        this.resultReferences.add(pair);
    }

    @NotNull
    private static PsiFile registerDocument(@NotNull DocumentWindowImpl newDocumentWindow, @NotNull PsiFile newInjectedPsi, @NotNull Place shreds, @NotNull PsiFile hostPsiFile, @NotNull PsiDocumentManager documentManager) {
        ConcurrentList<DocumentWindow> injected = InjectedLanguageUtil.getCachedInjectedDocuments(hostPsiFile);
        for (int i2 = injected.size() - 1; i2 >= 0; --i2) {
            FileViewProvider viewProvider;
            DocumentWindowImpl oldDocument = (DocumentWindowImpl)injected.get(i2);
            PsiFileImpl oldFile = (PsiFileImpl)documentManager.getCachedPsiFile((Document)oldDocument);
            if (oldFile == null || !oldFile.isValid() || !((viewProvider = oldFile.getViewProvider()) instanceof InjectedFileViewProvider) || ((InjectedFileViewProvider)viewProvider).isDisposed()) {
                injected.remove(i2);
                Disposer.dispose((Disposable)oldDocument);
                continue;
            }
            FileASTNode newInjectedNode = newInjectedPsi.getNode();
            FileASTNode oldFileNode = oldFile.getNode();
            assert (newInjectedNode != null) : "New node is null";
            if (oldDocument.areRangesEqual(newDocumentWindow)) {
                if (oldFile.getFileType() != newInjectedPsi.getFileType() || oldFile.getLanguage() != newInjectedPsi.getLanguage()) {
                    injected.remove(i2);
                    Disposer.dispose((Disposable)oldDocument);
                    continue;
                }
                oldFile.putUserData(FileContextUtil.INJECTED_IN_ELEMENT, newInjectedPsi.getUserData(FileContextUtil.INJECTED_IN_ELEMENT));
                assert (shreds.isValid());
                InjectionRegistrarImpl.mergePsi(oldFile, (ASTNode)oldFileNode, newInjectedPsi, (ASTNode)newInjectedNode);
                assert (shreds.isValid());
                return oldFile;
            }
            if (!InjectionRegistrarImpl.intersect(oldDocument, newDocumentWindow)) continue;
            injected.remove(i2);
        }
        injected.add(newDocumentWindow);
        return newInjectedPsi;
    }

    private static void mergePsi(@NotNull PsiFile oldFile, @NotNull ASTNode oldFileNode, @NotNull PsiFile injectedPsi, @NotNull ASTNode injectedNode) {
        if (!oldFile.textMatches((PsiElement)injectedPsi)) {
            InjectedFileViewProvider oldViewProvider = (InjectedFileViewProvider)oldFile.getViewProvider();
            oldViewProvider.performNonPhysically(() -> DebugUtil.performPsiModification("injected tree diff", () -> {
                DiffLog diffLog = BlockSupportImpl.mergeTrees((PsiFileImpl)oldFile, oldFileNode, injectedNode, new DaemonProgressIndicator(), oldFileNode.getText());
                diffLog.doActualPsiChange(oldFile);
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BooleanRunnable reparse(@NotNull Language language, @NotNull DocumentWindowImpl oldDocumentWindow, @NotNull PsiFile oldInjectedPsi, @NotNull VirtualFileWindow oldInjectedVirtualFile, @NotNull VirtualFile hostVirtualFile, @NotNull PsiFile hostPsiFile, @NotNull DocumentEx hostDocument, @NotNull ProgressIndicator indicator, @NotNull ASTNode oldRoot, @NotNull ASTNode newRoot, @NotNull PsiDocumentManagerBase documentManager) {
        Project project = hostPsiFile.getProject();
        String newText = oldDocumentWindow.getText();
        FileASTNode oldNode = oldInjectedPsi.getNode();
        InjectedFileViewProvider oldInjectedPsiViewProvider = (InjectedFileViewProvider)oldInjectedPsi.getViewProvider();
        String oldPsiText = oldNode.getText();
        if (newText.equals(oldPsiText)) {
            return () -> true;
        }
        if (oldDocumentWindow.isOneLine() && newText.contains("\n") != oldPsiText.contains("\n")) {
            return null;
        }
        Place oldPlace = oldDocumentWindow.getShreds();
        StringBuilder newDocumentText = new StringBuilder(newText.length());
        SmartList placeInfos = new SmartList();
        StringBuilder chars = new StringBuilder();
        Iterator iterator2 = oldPlace.iterator();
        while (iterator2.hasNext()) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)iterator2.next();
            PsiLanguageInjectionHost oldHost = shred.getHost();
            if (oldHost == null) {
                return null;
            }
            SmartPsiElementPointer<PsiLanguageInjectionHost> hostPointer = ((ShredImpl)shred).getSmartPointer();
            Segment newInjectionHostRange = InjectionRegistrarImpl.calcActualRange(hostPsiFile, hostDocument, hostPointer.getPsiRange());
            if (newInjectionHostRange == null) {
                return null;
            }
            PsiLanguageInjectionHost newDummyInjectionHost = InjectionRegistrarImpl.findNewInjectionHost(hostPsiFile, oldRoot, newRoot, oldHost, newInjectionHostRange);
            if (newDummyInjectionHost == null) {
                return null;
            }
            newInjectionHostRange = newDummyInjectionHost.getTextRange().shiftRight(oldRoot.getTextRange().getStartOffset());
            Segment hostInjectionRange = shred.getHostRangeMarker();
            if (hostInjectionRange == null) {
                return null;
            }
            TextRange rangeInsideHost = TextRange.create((Segment)hostInjectionRange).shiftLeft(newInjectionHostRange.getStartOffset());
            PlaceInfo info = new PlaceInfo(shred.getPrefix(), shred.getSuffix(), newDummyInjectionHost, rangeInsideHost);
            placeInfos.add(info);
            info.newInjectionHostRange = newInjectionHostRange;
            InjectionRegistrarImpl.decode(info, chars);
            TextRange rangeInHostElementPSI = info.rangeInHostElement;
            newDocumentText.append(shred.getPrefix());
            newDocumentText.append(newDummyInjectionHost.getText(), rangeInHostElementPSI.getStartOffset(), rangeInHostElementPSI.getEndOffset());
            newDocumentText.append(shred.getSuffix());
        }
        assert (documentManager.isUncommited(hostDocument));
        String fileName = ((VirtualFileWindowImpl)oldInjectedVirtualFile).getName();
        ASTNode[] parsedNodes = InjectionRegistrarImpl.parseFile(language, language, oldDocumentWindow, hostVirtualFile, hostDocument, hostPsiFile, project, newDocumentText, (List<PlaceInfo>)placeInfos, chars, fileName, documentManager);
        List<PsiFile> oldFiles = ((AbstractFileViewProvider)((Object)oldInjectedPsiViewProvider)).getCachedPsiFiles();
        Object object = InjectedLanguageManagerImpl.ourInjectionPsiLock;
        synchronized (object) {
            DiffLog[] diffLogs = new DiffLog[parsedNodes.length];
            for (int i2 = 0; i2 < parsedNodes.length; ++i2) {
                ASTNode parsedNode = parsedNodes[i2];
                PsiFile oldFile = oldFiles.get(i2);
                diffLogs[i2] = BlockSupportImpl.mergeTrees((PsiFileImpl)oldFile, (ASTNode)oldFile.getNode(), parsedNode, indicator, oldPsiText);
            }
            return () -> InjectionRegistrarImpl.lambda$reparse$7(oldInjectedPsiViewProvider, diffLogs, oldFiles, oldPlace, (List)placeInfos, hostPsiFile, oldDocumentWindow, newText, newDocumentText);
        }
    }

    private static Segment calcActualRange(@NotNull PsiFile containingFile, @NotNull Document document, @NotNull Segment range2) {
        return SelfElementInfo.calcActualRangeAfterDocumentEvents(containingFile, document, range2, true);
    }

    private static ASTNode @NotNull [] parseFile(@NotNull Language language, Language forcedLanguage, @NotNull DocumentWindowImpl documentWindow, @NotNull VirtualFile hostVirtualFile, @NotNull DocumentEx hostDocument, @NotNull PsiFile hostPsiFile, @NotNull Project project, @NotNull CharSequence documentText, @NotNull List<PlaceInfo> placeInfos, @NotNull StringBuilder decodedChars, @NotNull String fileName, @NotNull PsiDocumentManagerBase documentManager) {
        VirtualFileWindowImpl virtualFile = new VirtualFileWindowImpl(fileName, hostVirtualFile, documentWindow, language, decodedChars);
        Language finalLanguage = forcedLanguage == null ? LanguageSubstitutors.getInstance().substituteLanguage(language, (VirtualFile)virtualFile, project) : forcedLanguage;
        InjectedFileViewProvider viewProvider = InjectedFileViewProvider.create(PsiManagerEx.getInstanceEx(project), virtualFile, documentWindow, finalLanguage);
        Set languages = viewProvider.getLanguages();
        ASTNode[] parsedNodes = new ASTNode[languages.size()];
        int i2 = 0;
        for (Language lang : languages) {
            IElementType elementType;
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
            assert (parserDefinition != null) : "Parser definition for language " + finalLanguage + " is null";
            PsiFileImpl psiFile = (PsiFileImpl)parserDefinition.createFile((FileViewProvider)viewProvider);
            if (viewProvider instanceof TemplateLanguageFileViewProvider && (elementType = ((TemplateLanguageFileViewProvider)viewProvider).getContentElementType(lang)) != null) {
                psiFile.setContentElementType(elementType);
            }
            ASTNode parsedNode = InjectionRegistrarImpl.keepTreeFromChameleoningBack(psiFile);
            assert (parsedNode instanceof FileElement) : "Parsed to " + parsedNode + " instead of FileElement";
            assert (((FileElement)parsedNode).textMatches(decodedChars)) : InjectionRegistrarImpl.exceptionContext("Before patch: doc:\n'" + documentText + "'\n---PSI:\n'" + parsedNode.getText() + "'\n---chars:\n'" + decodedChars + "'", finalLanguage, hostPsiFile, hostVirtualFile, hostDocument, placeInfos, documentManager);
            try {
                InjectionRegistrarImpl.patchLeaves(placeInfos, viewProvider, parsedNode, documentText);
            }
            catch (PatchException e) {
                throw new RuntimeException(InjectionRegistrarImpl.exceptionContext(e.getMessage() + "'\n---chars:\n'" + decodedChars + "'", finalLanguage, hostPsiFile, hostVirtualFile, hostDocument, placeInfos, documentManager));
            }
            try {
                List<InjectedLanguageUtil.TokenInfo> tokens = InjectionRegistrarImpl.obtainHighlightTokensFromLexer(decodedChars, virtualFile, project, placeInfos);
                InjectedLanguageUtil.setHighlightTokens(psiFile, tokens);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new RuntimeException(InjectionRegistrarImpl.exceptionContext("Obtaining tokens error", language, hostPsiFile, hostVirtualFile, hostDocument, placeInfos, documentManager), e);
            }
            parsedNodes[i2++] = parsedNode;
        }
        return parsedNodes;
    }

    private static PsiLanguageInjectionHost findNewInjectionHost(@NotNull PsiFile hostPsiFile, @NotNull ASTNode oldRoot, @NotNull ASTNode newRoot, @NotNull PsiLanguageInjectionHost oldInjectionHost, @NotNull Segment newInjectionHostRange) {
        int endToLook;
        int startToLook;
        PsiFile toLookIn;
        TextRange oldRootRange = oldRoot.getTextRange();
        TextRange newRootRange = newRoot.getTextRange();
        if (newInjectionHostRange.getEndOffset() <= oldRootRange.getStartOffset()) {
            toLookIn = hostPsiFile;
            startToLook = newInjectionHostRange.getStartOffset();
            endToLook = newInjectionHostRange.getEndOffset();
        } else if (newInjectionHostRange.getStartOffset() >= oldRootRange.getStartOffset() + newRootRange.getLength()) {
            toLookIn = hostPsiFile;
            startToLook = newInjectionHostRange.getStartOffset() + newRootRange.getLength() - oldRootRange.getLength();
            endToLook = newInjectionHostRange.getEndOffset() + newRootRange.getLength() - oldRootRange.getLength();
        } else {
            toLookIn = newRoot.getPsi();
            if (toLookIn instanceof PsiFile) {
                FileViewProvider viewProvider = toLookIn.getViewProvider();
                toLookIn = (PsiElement)ObjectUtils.notNull((Object)viewProvider.getPsi(hostPsiFile.getLanguage()), (Object)viewProvider.getPsi(viewProvider.getBaseLanguage()));
            }
            startToLook = newInjectionHostRange.getStartOffset() - oldRootRange.getStartOffset();
            endToLook = newInjectionHostRange.getEndOffset() - oldRootRange.getStartOffset();
        }
        try {
            Identikit.ByType kit = Identikit.fromPsi((PsiElement)oldInjectionHost, hostPsiFile.getLanguage());
            return (PsiLanguageInjectionHost)kit.findInside((PsiElement)toLookIn, startToLook, endToLook);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    static boolean intersect(DocumentWindowImpl doc1, DocumentWindowImpl doc2) {
        Segment[] hostRanges1 = doc1.getHostRanges();
        Segment[] hostRanges2 = doc2.getHostRanges();
        for (Segment segment1 : hostRanges1) {
            for (Segment segment2 : hostRanges2) {
                if (Math.max(segment1.getStartOffset(), segment2.getStartOffset()) >= Math.min(segment1.getEndOffset(), segment2.getEndOffset())) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static List<InjectedLanguageUtil.TokenInfo> obtainHighlightTokensFromLexer(@NotNull CharSequence outChars, @NotNull VirtualFileWindow virtualFile, @NotNull Project project, @NotNull List<? extends PlaceInfo> placeInfos) {
        VirtualFile file2 = (VirtualFile)virtualFile;
        FileType fileType = file2.getFileType();
        EditorHighlighterProvider provider = (EditorHighlighterProvider)FileTypeEditorHighlighterProviders.INSTANCE.forFileType(fileType);
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        EditorHighlighter highlighter = provider.getEditorHighlighter(project, fileType, file2, scheme);
        highlighter.setText(outChars);
        HighlighterIterator iterator2 = highlighter.createIterator(0);
        int hostNum = -1;
        int prevHostEndOffset = 0;
        LiteralTextEscaper<? extends PsiLanguageInjectionHost> escaper = null;
        int prefixLength = 0;
        int suffixLength = 0;
        TextRange rangeInsideHost = null;
        int shredEndOffset = -1;
        ArrayList<InjectedLanguageUtil.TokenInfo> tokens = new ArrayList<InjectedLanguageUtil.TokenInfo>(outChars.length() / 5);
        while (!iterator2.atEnd()) {
            IElementType tokenType = iterator2.getTokenType();
            ProperTextRange range2 = new ProperTextRange(iterator2.getStart(), iterator2.getEnd());
            while (range2 != null && !range2.isEmpty()) {
                if (range2.getStartOffset() >= shredEndOffset) {
                    PlaceInfo info = placeInfos.get(++hostNum);
                    shredEndOffset = info.rangeInDecodedPSI.getEndOffset();
                    prevHostEndOffset = range2.getStartOffset();
                    escaper = info.myEscaper;
                    rangeInsideHost = info.rangeInHostElement;
                    prefixLength = info.prefix.length();
                    suffixLength = info.suffix.length();
                }
                if (range2.getStartOffset() < prevHostEndOffset + prefixLength) {
                    range2 = new UnfairTextRange(prevHostEndOffset + prefixLength, range2.getEndOffset());
                }
                UnfairTextRange spilled = null;
                if (range2.getEndOffset() > shredEndOffset - suffixLength) {
                    spilled = new UnfairTextRange(shredEndOffset, range2.getEndOffset());
                    range2 = new UnfairTextRange(range2.getStartOffset(), shredEndOffset - suffixLength);
                }
                if (!range2.isEmpty()) {
                    int end;
                    int start2 = escaper.getOffsetInHost(range2.getStartOffset() - prevHostEndOffset - prefixLength, rangeInsideHost);
                    if (start2 == -1) {
                        start2 = rangeInsideHost.getStartOffset();
                    }
                    if ((end = escaper.getOffsetInHost(range2.getEndOffset() - prevHostEndOffset - prefixLength, rangeInsideHost)) == -1) {
                        end = rangeInsideHost.getEndOffset();
                        prevHostEndOffset = shredEndOffset;
                    }
                    ProperTextRange rangeInHost = new ProperTextRange(start2, end);
                    tokens.add(new InjectedLanguageUtil.TokenInfo(tokenType, rangeInHost, hostNum, iterator2.getTextAttributes()));
                }
                range2 = spilled;
            }
            iterator2.advance();
        }
        return tokens;
    }

    public String toString() {
        return String.valueOf(this.resultFiles);
    }

    @NotNull
    PsiFile getHostPsiFile() {
        return this.myHostPsiFile;
    }

    private static /* synthetic */ boolean lambda$reparse$7(InjectedFileViewProvider oldInjectedPsiViewProvider, DiffLog[] diffLogs, List oldFiles, Place oldPlace, List placeInfos, PsiFile hostPsiFile, DocumentWindowImpl oldDocumentWindow, String newText, StringBuilder newDocumentText) {
        oldInjectedPsiViewProvider.performNonPhysically(() -> DebugUtil.performPsiModification("injected tree diff", () -> {
            for (int i2 = 0; i2 < diffLogs.length; ++i2) {
                DiffLog diffLog = diffLogs[i2];
                diffLog.doActualPsiChange((PsiFile)oldFiles.get(i2));
                Place newPlace = new Place();
                for (int j = 0; j < oldPlace.size(); ++j) {
                    PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)oldPlace.get(j);
                    PlaceInfo info = (PlaceInfo)placeInfos.get(j);
                    ProperTextRange rangeInDecodedPSI = info.rangeInDecodedPSI;
                    TextRange rangeInHostElementPSI = info.rangeInHostElement;
                    FileASTNode root = hostPsiFile.getNode();
                    PsiLanguageInjectionHost newHost = InjectionRegistrarImpl.findNewInjectionHost(hostPsiFile, (ASTNode)root, (ASTNode)root, info.host, info.newInjectionHostRange);
                    ShredImpl newShred = ((ShredImpl)shred).withRange((TextRange)rangeInDecodedPSI, rangeInHostElementPSI, newHost);
                    newPlace.add(newShred);
                }
                InjectionRegistrarImpl.cacheEverything(newPlace, oldDocumentWindow, oldInjectedPsiViewProvider, (PsiFile)oldFiles.get(i2));
                String docText = oldDocumentWindow.getText();
                assert (docText.equals(newText)) : "=\n" + docText + "\n==\n" + newDocumentText + "\n===\n";
            }
        }));
        return true;
    }

    private static class PatchException
    extends Exception {
        PatchException(String message) {
            super(message);
        }
    }
}

