/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.CaretActionListener;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.impl.source.tree.injected.InjectedCaret;
import com.intellij.psi.impl.source.tree.injected.ListenerWrapperMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CaretModelWindow
implements CaretModel {
    private final CaretModel myDelegate;
    private final EditorEx myHostEditor;
    private final EditorWindow myEditorWindow;
    private final Map<Caret, InjectedCaret> myInjectedCaretMap = new WeakHashMap<Caret, InjectedCaret>();
    private final ListenerWrapperMap<CaretListener> myCaretListeners = new ListenerWrapperMap();

    CaretModelWindow(CaretModel delegate, EditorWindow editorWindow) {
        this.myDelegate = delegate;
        this.myHostEditor = (EditorEx)editorWindow.getDelegate();
        this.myEditorWindow = editorWindow;
    }

    public void addCaretListener(final @NotNull CaretListener listener2) {
        CaretListener wrapper2 = new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (!CaretModelWindow.this.myEditorWindow.getDocument().isValid()) {
                    return;
                }
                Caret caret = e.getCaret();
                assert (caret != null);
                CaretEvent event = new CaretEvent((Caret)CaretModelWindow.this.createInjectedCaret(caret), CaretModelWindow.this.myEditorWindow.hostToInjected(e.getOldPosition()), CaretModelWindow.this.myEditorWindow.hostToInjected(e.getNewPosition()));
                listener2.caretPositionChanged(event);
            }
        };
        this.myCaretListeners.registerWrapper(listener2, wrapper2);
        this.myDelegate.addCaretListener(wrapper2);
    }

    public void removeCaretListener(@NotNull CaretListener listener2) {
        CaretListener wrapper2 = this.myCaretListeners.removeWrapper(listener2);
        if (wrapper2 != null) {
            this.myDelegate.removeCaretListener(wrapper2);
        }
    }

    public void disposeModel() {
        for (CaretListener wrapper2 : this.myCaretListeners.wrappers()) {
            this.myDelegate.removeCaretListener(wrapper2);
        }
        this.myCaretListeners.clear();
    }

    public TextAttributes getTextAttributes() {
        return this.myDelegate.getTextAttributes();
    }

    public boolean supportsMultipleCarets() {
        return this.myDelegate.supportsMultipleCarets();
    }

    @NotNull
    public Caret getCurrentCaret() {
        return this.createInjectedCaret(this.myDelegate.getCurrentCaret());
    }

    @NotNull
    public Caret getPrimaryCaret() {
        return this.createInjectedCaret(this.myDelegate.getPrimaryCaret());
    }

    public int getCaretCount() {
        return this.myDelegate.getCaretCount();
    }

    @NotNull
    public List<Caret> getAllCarets() {
        List hostCarets = this.myDelegate.getAllCarets();
        ArrayList<Caret> carets = new ArrayList<Caret>(hostCarets.size());
        for (Caret hostCaret : hostCarets) {
            carets.add(this.createInjectedCaret(hostCaret));
        }
        return carets;
    }

    @Nullable
    public Caret getCaretAt(@NotNull VisualPosition pos) {
        LogicalPosition hostPos = this.myEditorWindow.injectedToHost(this.myEditorWindow.visualToLogicalPosition(pos));
        Caret caret = this.myDelegate.getCaretAt(this.myHostEditor.logicalToVisualPosition(hostPos));
        return this.createInjectedCaret(caret);
    }

    @Nullable
    public Caret addCaret(@NotNull VisualPosition pos, boolean makePrimary) {
        LogicalPosition hostPos = this.myEditorWindow.injectedToHost(this.myEditorWindow.visualToLogicalPosition(pos));
        Caret caret = this.myDelegate.addCaret(this.myHostEditor.logicalToVisualPosition(hostPos));
        return this.createInjectedCaret(caret);
    }

    @Nullable
    public Caret addCaret(@NotNull LogicalPosition pos, boolean makePrimary) {
        LogicalPosition hostPos = this.myEditorWindow.injectedToHost(pos);
        Caret caret = this.myDelegate.addCaret(hostPos, makePrimary);
        return this.createInjectedCaret(caret);
    }

    public boolean removeCaret(@NotNull Caret caret) {
        if (caret instanceof InjectedCaret) {
            caret = ((InjectedCaret)caret).myDelegate;
        }
        return this.myDelegate.removeCaret(caret);
    }

    public void removeSecondaryCarets() {
        this.myDelegate.removeSecondaryCarets();
    }

    public void setCaretsAndSelections(@NotNull List<? extends CaretState> caretStates) {
        List<CaretState> convertedStates = this.convertCaretStates(caretStates);
        this.myDelegate.setCaretsAndSelections(convertedStates);
    }

    public void setCaretsAndSelections(@NotNull List<? extends CaretState> caretStates, boolean updateSystemSelection) {
        List<CaretState> convertedStates = this.convertCaretStates(caretStates);
        this.myDelegate.setCaretsAndSelections(convertedStates, updateSystemSelection);
    }

    private List<CaretState> convertCaretStates(List<? extends CaretState> caretStates) {
        ArrayList<CaretState> convertedStates = new ArrayList<CaretState>(caretStates.size());
        for (CaretState caretState : caretStates) {
            convertedStates.add(new CaretState(this.injectedToHost(caretState.getCaretPosition()), this.injectedToHost(caretState.getSelectionStart()), this.injectedToHost(caretState.getSelectionEnd())));
        }
        return convertedStates;
    }

    private LogicalPosition injectedToHost(@Nullable LogicalPosition position) {
        return position == null ? null : this.myEditorWindow.injectedToHost(position);
    }

    @NotNull
    public List<CaretState> getCaretsAndSelections() {
        List caretsAndSelections = this.myDelegate.getCaretsAndSelections();
        ArrayList<CaretState> convertedStates = new ArrayList<CaretState>(caretsAndSelections.size());
        for (CaretState state : caretsAndSelections) {
            convertedStates.add(new CaretState(this.hostToInjected(state.getCaretPosition()), this.hostToInjected(state.getSelectionStart()), this.hostToInjected(state.getSelectionEnd())));
        }
        return convertedStates;
    }

    private LogicalPosition hostToInjected(@Nullable LogicalPosition position) {
        return position == null ? null : this.myEditorWindow.hostToInjected(position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="null -> null; !null -> !null")
    private InjectedCaret createInjectedCaret(Caret caret) {
        if (caret == null) {
            return null;
        }
        Map<Caret, InjectedCaret> map2 = this.myInjectedCaretMap;
        synchronized (map2) {
            InjectedCaret injectedCaret = this.myInjectedCaretMap.get(caret);
            if (injectedCaret == null) {
                injectedCaret = new InjectedCaret(this.myEditorWindow, caret);
                this.myInjectedCaretMap.put(caret, injectedCaret);
            }
            return injectedCaret;
        }
    }

    public void runForEachCaret(@NotNull CaretAction action2) {
        this.myDelegate.runForEachCaret(caret -> action2.perform((Caret)this.createInjectedCaret(caret)));
    }

    public void runForEachCaret(@NotNull CaretAction action2, boolean reverseOrder) {
        this.myDelegate.runForEachCaret(caret -> action2.perform((Caret)this.createInjectedCaret(caret)), reverseOrder);
    }

    public void addCaretActionListener(@NotNull CaretActionListener listener2, @NotNull Disposable disposable2) {
        this.myDelegate.addCaretActionListener(listener2, disposable2);
    }

    public void runBatchCaretOperation(@NotNull Runnable runnable2) {
        this.myDelegate.runBatchCaretOperation(runnable2);
    }
}

