/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStrongWhitespaceHolderElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TreeUtil {
    private static final Key<String> UNCLOSED_ELEMENT_PROPERTY = Key.create((String)"UNCLOSED_ELEMENT_PROPERTY");
    public static final Key<FileElement> CONTAINING_FILE_KEY_AFTER_REPARSE = Key.create((String)"CONTAINING_FILE_KEY_AFTER_REPARSE");

    public static void ensureParsed(ASTNode node) {
        if (node != null) {
            node.getFirstChildNode();
        }
    }

    public static boolean isCollapsedChameleon(ASTNode node) {
        return node instanceof LazyParseableElement && !((LazyParseableElement)node).isParsed();
    }

    @Nullable
    public static ASTNode findChildBackward(ASTNode parent, IElementType type) {
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED && parent instanceof TreeElement) {
            ((TreeElement)parent).assertReadAccessAllowed();
        }
        for (ASTNode element2 = parent.getLastChildNode(); element2 != null; element2 = element2.getTreePrev()) {
            if (element2.getElementType() != type) continue;
            return element2;
        }
        return null;
    }

    @Nullable
    public static ASTNode skipElements(@Nullable ASTNode element2, @NotNull TokenSet types) {
        ASTNode candidate;
        for (candidate = element2; candidate != null && types.contains(candidate.getElementType()); candidate = candidate.getTreeNext()) {
        }
        return candidate;
    }

    @Nullable
    public static ASTNode skipElementsBack(@Nullable ASTNode element2, @NotNull TokenSet types) {
        ASTNode candidate;
        for (candidate = element2; candidate != null && types.contains(candidate.getElementType()); candidate = candidate.getTreePrev()) {
        }
        return candidate;
    }

    @Nullable
    public static ASTNode findParent(ASTNode element2, IElementType type) {
        for (ASTNode parent = element2.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
            if (parent.getElementType() != type) continue;
            return parent;
        }
        return null;
    }

    @Nullable
    public static ASTNode findParent(ASTNode element2, TokenSet types) {
        for (ASTNode parent = element2.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
            if (!types.contains(parent.getElementType())) continue;
            return parent;
        }
        return null;
    }

    @Nullable
    public static ASTNode findParent(@NotNull ASTNode element2, @NotNull TokenSet types, @Nullable TokenSet stopAt) {
        for (ASTNode parent = element2.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
            if (types.contains(parent.getElementType())) {
                return parent;
            }
            if (stopAt == null || !stopAt.contains(parent.getElementType())) continue;
            return null;
        }
        return null;
    }

    @Nullable
    public static LeafElement findFirstLeaf(ASTNode element2) {
        return (LeafElement)TreeUtil.findFirstLeaf(element2, true);
    }

    public static ASTNode findFirstLeaf(ASTNode element2, boolean expandChameleons) {
        if (element2 instanceof LeafElement || !expandChameleons && TreeUtil.isCollapsedChameleon(element2)) {
            return element2;
        }
        for (ASTNode child2 = element2.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
            ASTNode leaf = TreeUtil.findFirstLeaf(child2, expandChameleons);
            if (leaf == null) continue;
            return leaf;
        }
        return null;
    }

    @Nullable
    public static ASTNode findLastLeaf(ASTNode element2) {
        return TreeUtil.findLastLeaf(element2, true);
    }

    public static ASTNode findLastLeaf(ASTNode element2, boolean expandChameleons) {
        if (element2 instanceof LeafElement || !expandChameleons && TreeUtil.isCollapsedChameleon(element2)) {
            return element2;
        }
        for (ASTNode child2 = element2.getLastChildNode(); child2 != null; child2 = child2.getTreePrev()) {
            ASTNode leaf = TreeUtil.findLastLeaf(child2);
            if (leaf == null) continue;
            return leaf;
        }
        return null;
    }

    @Nullable
    public static ASTNode findSibling(ASTNode start2, IElementType elementType) {
        ASTNode child2 = start2;
        while (child2 != null) {
            if (child2.getElementType() == elementType) {
                return child2;
            }
            child2 = child2.getTreeNext();
        }
        return null;
    }

    @Nullable
    public static ASTNode findSibling(ASTNode start2, TokenSet types) {
        ASTNode child2 = start2;
        while (child2 != null) {
            if (types.contains(child2.getElementType())) {
                return child2;
            }
            child2 = child2.getTreeNext();
        }
        return null;
    }

    @Nullable
    public static ASTNode findSiblingBackward(ASTNode start2, IElementType elementType) {
        ASTNode child2 = start2;
        while (child2 != null) {
            if (child2.getElementType() == elementType) {
                return child2;
            }
            child2 = child2.getTreePrev();
        }
        return null;
    }

    @Nullable
    public static ASTNode findSiblingBackward(ASTNode start2, TokenSet types) {
        ASTNode child2 = start2;
        while (child2 != null) {
            if (types.contains(child2.getElementType())) {
                return child2;
            }
            child2 = child2.getTreePrev();
        }
        return null;
    }

    @Nullable
    public static ASTNode findCommonParent(ASTNode one, ASTNode two) {
        if (one == two) {
            return one;
        }
        HashSet<ASTNode> parents2 = new HashSet<ASTNode>(20);
        while (one != null) {
            parents2.add(one);
            one = one.getTreeParent();
        }
        while (two != null) {
            if (parents2.contains(two)) {
                return two;
            }
            two = two.getTreeParent();
        }
        return null;
    }

    public static Couple<ASTNode> findTopmostSiblingParents(ASTNode one, ASTNode two) {
        if (one == two) {
            return Couple.of(null, null);
        }
        LinkedList<ASTNode> oneParents = new LinkedList<ASTNode>();
        while (one != null) {
            oneParents.add(one);
            one = one.getTreeParent();
        }
        LinkedList<ASTNode> twoParents = new LinkedList<ASTNode>();
        while (two != null) {
            twoParents.add(two);
            two = two.getTreeParent();
        }
        while ((one = (ASTNode)oneParents.pollLast()) == (two = (ASTNode)twoParents.pollLast()) && one != null) {
        }
        return Couple.of((Object)one, (Object)two);
    }

    public static void clearCaches(@NotNull TreeElement tree) {
        tree.acceptTree(new RecursiveTreeElementWalkingVisitor(false){

            @Override
            protected void visitNode(TreeElement element2) {
                element2.clearCaches();
                super.visitNode(element2);
            }
        });
    }

    @Nullable
    public static ASTNode nextLeaf(@NotNull ASTNode node) {
        return TreeUtil.nextLeaf((TreeElement)node, null);
    }

    @Nullable
    public static LeafElement nextLeaf(@NotNull LeafElement node) {
        return TreeUtil.nextLeaf(node, null);
    }

    public static FileElement getFileElement(@NotNull TreeElement element2) {
        TreeElement parent;
        for (parent = element2; parent != null && !(parent instanceof FileElement); parent = parent.getTreeParent()) {
        }
        if (parent == null) {
            parent = (TreeElement)element2.getUserData(CONTAINING_FILE_KEY_AFTER_REPARSE);
        }
        return (FileElement)parent;
    }

    @Nullable
    public static ASTNode prevLeaf(ASTNode node) {
        return TreeUtil.prevLeaf((TreeElement)node, null);
    }

    public static boolean isStrongWhitespaceHolder(IElementType type) {
        return type instanceof IStrongWhitespaceHolderElementType;
    }

    public static String getTokenText(Lexer lexer) {
        return lexer.getBufferSequence().subSequence(lexer.getTokenStart(), lexer.getTokenEnd()).toString();
    }

    @Nullable
    public static LeafElement nextLeaf(@NotNull TreeElement start2, CommonParentState commonParent) {
        return (LeafElement)TreeUtil.nextLeaf(start2, commonParent, null, true);
    }

    @Nullable
    public static TreeElement nextLeaf(@NotNull TreeElement start2, CommonParentState commonParent, IElementType searchedType, boolean expandChameleons) {
        for (TreeElement element2 = start2; element2 != null; element2 = element2.getTreeParent()) {
            if (commonParent != null) {
                commonParent.startLeafBranchStart = element2;
                TreeUtil.initStrongWhitespaceHolder(commonParent, element2, true);
            }
            TreeElement nextTree = element2;
            TreeElement next = null;
            while (next == null && (nextTree = nextTree.getTreeNext()) != null) {
                if (nextTree.getElementType() == searchedType) {
                    return nextTree;
                }
                next = TreeUtil.findFirstLeafOrType(nextTree, searchedType, commonParent, expandChameleons);
            }
            if (next == null) continue;
            if (commonParent != null) {
                commonParent.nextLeafBranchStart = nextTree;
            }
            return next;
        }
        return null;
    }

    private static void initStrongWhitespaceHolder(CommonParentState commonParent, ASTNode start2, boolean slopeSide) {
        if (start2 instanceof CompositeElement && (TreeUtil.isStrongWhitespaceHolder(start2.getElementType()) || slopeSide && start2.getUserData(UNCLOSED_ELEMENT_PROPERTY) != null)) {
            commonParent.strongWhiteSpaceHolder = (CompositeElement)start2;
            commonParent.isStrongElementOnRisingSlope = slopeSide;
        }
    }

    @Nullable
    private static TreeElement findFirstLeafOrType(@NotNull TreeElement element2, final IElementType searchedType, final CommonParentState commonParent, final boolean expandChameleons) {
        class MyVisitor
        extends RecursiveTreeElementWalkingVisitor {
            private TreeElement result;

            MyVisitor(boolean doTransform) {
                super(doTransform);
            }

            @Override
            protected void visitNode(TreeElement node) {
                if (this.result != null) {
                    return;
                }
                if (commonParent != null) {
                    TreeUtil.initStrongWhitespaceHolder(commonParent, node, false);
                }
                if (!expandChameleons && TreeUtil.isCollapsedChameleon(node) || node instanceof LeafElement || node.getElementType() == searchedType) {
                    this.result = node;
                    return;
                }
                super.visitNode(node);
            }
        }
        MyVisitor visitor = new MyVisitor(expandChameleons);
        element2.acceptTree(visitor);
        return visitor.result;
    }

    @Nullable
    public static ASTNode prevLeaf(TreeElement start2, @Nullable CommonParentState commonParent) {
        while (start2 != null) {
            if (commonParent != null) {
                if (commonParent.strongWhiteSpaceHolder != null && start2.getUserData(UNCLOSED_ELEMENT_PROPERTY) != null) {
                    commonParent.strongWhiteSpaceHolder = (CompositeElement)start2;
                }
                commonParent.nextLeafBranchStart = start2;
            }
            TreeElement prevTree = start2;
            ASTNode prev = null;
            while (prev == null && (prevTree = prevTree.getTreePrev()) != null) {
                prev = TreeUtil.findLastLeaf(prevTree);
            }
            if (prev != null) {
                if (commonParent != null) {
                    commonParent.startLeafBranchStart = prevTree;
                }
                return prev;
            }
            start2 = start2.getTreeParent();
        }
        return null;
    }

    @Nullable
    public static ASTNode nextLeaf(@Nullable ASTNode start2, boolean expandChameleons) {
        while (start2 != null) {
            for (ASTNode each = start2.getTreeNext(); each != null; each = each.getTreeNext()) {
                ASTNode leaf = TreeUtil.findFirstLeaf(each, expandChameleons);
                if (leaf == null) continue;
                return leaf;
            }
            start2 = start2.getTreeParent();
        }
        return null;
    }

    @Nullable
    public static ASTNode prevLeaf(@Nullable ASTNode start2, boolean expandChameleons) {
        while (start2 != null) {
            for (ASTNode each = start2.getTreePrev(); each != null; each = each.getTreePrev()) {
                ASTNode leaf = TreeUtil.findLastLeaf(each, expandChameleons);
                if (leaf == null) continue;
                return leaf;
            }
            start2 = start2.getTreeParent();
        }
        return null;
    }

    @Nullable
    public static ASTNode getLastChild(ASTNode element2) {
        ASTNode child2 = element2;
        while (child2 != null) {
            element2 = child2;
            child2 = element2.getLastChildNode();
        }
        return element2;
    }

    public static boolean containsOuterLanguageElements(@NotNull ASTNode node) {
        final AtomicBoolean result2 = new AtomicBoolean(false);
        ((TreeElement)node).acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            protected void visitNode(TreeElement element2) {
                if (element2 instanceof OuterLanguageElement) {
                    result2.set(true);
                    this.stopWalking();
                    return;
                }
                super.visitNode(element2);
            }
        });
        return result2.get();
    }

    @Nullable
    public static ASTNode skipWhitespaceAndComments(@Nullable ASTNode node, boolean forward) {
        return TreeUtil.skipWhitespaceCommentsAndTokens(node, TokenSet.EMPTY, forward);
    }

    @Nullable
    public static ASTNode skipWhitespaceCommentsAndTokens(@Nullable ASTNode node, @NotNull TokenSet alsoSkip, boolean forward) {
        ASTNode element2 = node;
        while (true) {
            if (element2 == null) {
                return null;
            }
            if (!TreeUtil.isWhitespaceOrComment(element2) && !alsoSkip.contains(element2.getElementType())) break;
            element2 = forward ? element2.getTreeNext() : element2.getTreePrev();
        }
        return element2;
    }

    public static boolean isWhitespaceOrComment(@NotNull ASTNode element2) {
        return element2.getPsi() instanceof PsiWhiteSpace || element2.getPsi() instanceof PsiComment;
    }

    public static final class CommonParentState {
        TreeElement startLeafBranchStart;
        public ASTNode nextLeafBranchStart;
        CompositeElement strongWhiteSpaceHolder;
        boolean isStrongElementOnRisingSlope = true;
    }
}

