/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.diff.ShallowNodeComparator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ASTShallowComparator
implements ShallowNodeComparator<ASTNode, ASTNode> {
    private final ProgressIndicator myIndicator;

    public ASTShallowComparator(@NotNull ProgressIndicator indicator) {
        this.myIndicator = indicator;
    }

    @NotNull
    public ThreeState deepEqual(@NotNull ASTNode oldNode, @NotNull ASTNode newNode) {
        return this.textMatches(oldNode, newNode);
    }

    private ThreeState textMatches(ASTNode oldNode, ASTNode newNode) {
        String newText;
        this.myIndicator.checkCanceled();
        String oldText = TreeUtil.isCollapsedChameleon(oldNode) ? oldNode.getText() : null;
        String string = newText = TreeUtil.isCollapsedChameleon(newNode) ? newNode.getText() : null;
        if (oldText != null && newText != null) {
            return oldText.equals(newText) ? ThreeState.YES : ThreeState.UNSURE;
        }
        if (oldText != null) {
            return this.compareTreeToText((TreeElement)newNode, oldText) ? ThreeState.YES : ThreeState.UNSURE;
        }
        if (newText != null) {
            return this.compareTreeToText((TreeElement)oldNode, newText) ? ThreeState.YES : ThreeState.UNSURE;
        }
        if (oldNode instanceof ForeignLeafPsiElement) {
            return newNode instanceof ForeignLeafPsiElement && oldNode.getText().equals(newNode.getText()) ? ThreeState.YES : ThreeState.NO;
        }
        if (newNode instanceof ForeignLeafPsiElement) {
            return ThreeState.NO;
        }
        if (oldNode instanceof LeafElement) {
            return ((LeafElement)oldNode).textMatches(newNode.getChars()) ? ThreeState.YES : ThreeState.NO;
        }
        if (newNode instanceof LeafElement) {
            return ((LeafElement)newNode).textMatches(oldNode.getChars()) ? ThreeState.YES : ThreeState.NO;
        }
        if (oldNode instanceof PsiErrorElement && newNode instanceof PsiErrorElement) {
            PsiErrorElement e1 = (PsiErrorElement)oldNode;
            PsiErrorElement e2 = (PsiErrorElement)newNode;
            if (!Objects.equals(e1.getErrorDescription(), e2.getErrorDescription())) {
                return ThreeState.NO;
            }
        }
        return ThreeState.UNSURE;
    }

    private boolean compareTreeToText(@NotNull TreeElement root, final @NotNull String text) {
        final int[] curOffset = new int[]{0};
        root.acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            public void visitLeaf(LeafElement leaf) {
                this.matchText(leaf);
            }

            private void matchText(TreeElement leaf) {
                curOffset[0] = leaf.textMatches(text, curOffset[0]);
                if (curOffset[0] < 0) {
                    this.stopWalking();
                }
            }

            @Override
            public void visitComposite(CompositeElement composite) {
                ASTShallowComparator.this.myIndicator.checkCanceled();
                if (composite instanceof LazyParseableElement && !((LazyParseableElement)composite).isParsed()) {
                    this.matchText(composite);
                } else {
                    super.visitComposite(composite);
                }
            }
        });
        return curOffset[0] == text.length();
    }

    public boolean typesEqual(@NotNull ASTNode n1, @NotNull ASTNode n2) {
        return n1.getElementType() == n2.getElementType();
    }

    public boolean hashCodesEqual(@NotNull ASTNode n1, @NotNull ASTNode n2) {
        if (n1 instanceof LeafElement && n2 instanceof LeafElement) {
            return this.textMatches(n1, n2) == ThreeState.YES;
        }
        if (n1 instanceof PsiErrorElement && n2 instanceof PsiErrorElement) {
            PsiErrorElement e1 = (PsiErrorElement)n1;
            PsiErrorElement e2 = (PsiErrorElement)n2;
            if (!Objects.equals(e1.getErrorDescription(), e2.getErrorDescription())) {
                return false;
            }
        }
        return ((TreeElement)n1).hc() == ((TreeElement)n2).hc();
    }
}

