/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IdempotenceChecker;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.lang.ref.ReferenceQueue;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolveCache
implements Disposable {
    private final AtomicReferenceArray<Map<?, ?>> myPhysicalMaps = new AtomicReferenceArray(4);
    private final AtomicReferenceArray<Map<?, ?>> myNonPhysicalMaps = new AtomicReferenceArray(4);
    private static final Object NULL_RESULT = ObjectUtils.sentinel((String)"ResolveCache.NULL_RESULT");
    private static final StrongValueReference<?, ?> NULL_VALUE_REFERENCE = new StrongValueReference(NULL_RESULT);
    private static final StrongValueReference<?, ?> EMPTY_RESOLVE_RESULT = new StrongValueReference(ResolveResult.EMPTY_ARRAY);

    public static ResolveCache getInstance(@NotNull Project project) {
        ProgressIndicatorProvider.checkCanceled();
        return (ResolveCache)project.getService(ResolveCache.class);
    }

    public ResolveCache(@NotNull Project project) {
        this.clearCacheOnPsiChange(project.getMessageBus());
        LowMemoryWatcher.register(() -> this.onLowMemory(), (Disposable)this);
    }

    @Deprecated
    public ResolveCache(@NotNull MessageBus bus) {
        this.clearCacheOnPsiChange(bus);
    }

    private void clearCacheOnPsiChange(@NotNull MessageBus bus) {
        bus.connect().subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, (Object)new AnyPsiChangeListener(){

            @Override
            public void beforePsiChanged(boolean isPhysical) {
                ResolveCache.this.clearCache(isPhysical);
            }
        });
    }

    private void onLowMemory() {
        ResolveCache.clearArray(this.myPhysicalMaps);
        ResolveCache.clearArray(this.myNonPhysicalMaps);
    }

    public void dispose() {
    }

    @NotNull
    private static <K, V> Map<K, V> createWeakMap() {
        return new ConcurrentWeakKeySoftValueHashMap<K, V>(100, 0.75f, Runtime.getRuntime().availableProcessors(), ContainerUtil.canonicalStrategy()){

            @NotNull
            protected ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> createValueReference(@NotNull V value2, @NotNull ReferenceQueue<? super V> queue) {
                StrongValueReference result2 = value2 == NULL_RESULT || value2 instanceof Object[] && ((Object[])value2).length == 0 ? ResolveCache.createStrongReference(value2) : super.createValueReference(value2, queue);
                return result2;
            }

            public V get(@NotNull Object key) {
                Object v = super.get(key);
                return v == NULL_RESULT ? null : v;
            }

            public boolean equals(Object obj) {
                return this == obj;
            }

            public int hashCode() {
                return System.identityHashCode((Object)this);
            }
        };
    }

    public void clearCache(boolean isPhysical) {
        if (isPhysical) {
            ResolveCache.clearArray(this.myPhysicalMaps);
        }
        ResolveCache.clearArray(this.myNonPhysicalMaps);
    }

    private static void clearArray(@NotNull AtomicReferenceArray<?> array2) {
        for (int i2 = 0; i2 < array2.length(); ++i2) {
            array2.set(i2, null);
        }
    }

    @Nullable
    private <TRef extends PsiReference, TResult> TResult resolve(@NotNull TRef ref, @NotNull AbstractResolver<? super TRef, TResult> resolver, boolean needToPreventRecursion, boolean incompleteCode, boolean isPoly, boolean isPhysical) {
        ProgressIndicatorProvider.checkCanceled();
        if (isPhysical) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        int index = ResolveCache.getIndex(incompleteCode, isPoly);
        return ResolveCache.resolve(ref, this.getMap(isPhysical, index), needToPreventRecursion, () -> resolver.resolve((Object)ref, incompleteCode));
    }

    public <T extends PsiPolyVariantReference> ResolveResult @NotNull [] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantResolver<T> resolver, boolean needToPreventRecursion, boolean incompleteCode) {
        return this.resolveWithCaching(ref, resolver, needToPreventRecursion, incompleteCode, ref.getElement().getContainingFile());
    }

    public <T extends PsiPolyVariantReference> ResolveResult @NotNull [] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantResolver<T> resolver, boolean needToPreventRecursion, boolean incompleteCode, @NotNull PsiFile containingFile) {
        ResolveResult[] result2 = (ResolveResult[])this.resolve((PsiReference)ref, (AbstractResolver)resolver, needToPreventRecursion, incompleteCode, true, containingFile.isPhysical());
        return result2 == null ? ResolveResult.EMPTY_ARRAY : result2;
    }

    public <T extends PsiPolyVariantReference> ResolveResult @NotNull [] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantContextResolver<T> resolver, boolean needToPreventRecursion, boolean incompleteCode, @NotNull PsiFile containingFile) {
        ProgressIndicatorProvider.checkCanceled();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        boolean physical = containingFile.isPhysical();
        int index = ResolveCache.getIndex(incompleteCode, true);
        Map map2 = this.getMap(physical, index);
        ResolveResult[] results = (ResolveResult[])ResolveCache.resolve(ref, map2, needToPreventRecursion, () -> resolver.resolve(ref, containingFile, incompleteCode));
        return results == null ? ResolveResult.EMPTY_ARRAY : results;
    }

    private static <TRef extends PsiReference, TResult> TResult resolve(@NotNull TRef ref, @NotNull Map<TRef, TResult> cache, boolean preventRecursion, @NotNull Computable<? extends TResult> resolver) {
        Object result2;
        TResult cachedResult = cache.get(ref);
        if (cachedResult != null) {
            if (IdempotenceChecker.areRandomChecksEnabled()) {
                IdempotenceChecker.applyForRandomCheck(cachedResult, ref, ResolveCache.loggingResolver(ref, resolver));
            }
            return cachedResult;
        }
        RecursionGuard.StackStamp stamp = RecursionManager.markStack();
        Computable<? extends TResult> loggingResolver = ResolveCache.loggingResolver(ref, resolver);
        Object object = result2 = preventRecursion ? RecursionManager.doPreventingRecursion((Object)Pair.create(ref, cache), (boolean)true, loggingResolver) : loggingResolver.get();
        if (result2 instanceof ResolveResult) {
            ResolveCache.ensureValidPsi((ResolveResult)result2);
        } else if (result2 instanceof ResolveResult[]) {
            ResolveCache.ensureValidResults((ResolveResult[])result2);
        } else if (result2 instanceof PsiElement) {
            PsiUtilCore.ensureValid((PsiElement)((PsiElement)result2));
        }
        if (stamp.mayCacheNow()) {
            ResolveCache.cache(ref, cache, result2, loggingResolver);
        }
        return (TResult)result2;
    }

    @NotNull
    private static <R> Computable<R> loggingResolver(@NotNull Object ref, @NotNull Computable<? extends R> resolver) {
        return () -> {
            if (IdempotenceChecker.isLoggingEnabled()) {
                IdempotenceChecker.logTrace("Resolving " + ref + " of " + ref.getClass());
            }
            return resolver.get();
        };
    }

    private static void ensureValidResults(ResolveResult @NotNull [] result2) {
        for (ResolveResult resolveResult : result2) {
            ResolveCache.ensureValidPsi(resolveResult);
        }
    }

    private static void ensureValidPsi(@NotNull ResolveResult resolveResult) {
        PsiElement element2 = resolveResult.getElement();
        if (element2 != null) {
            PsiUtilCore.ensureValid((PsiElement)element2);
        }
    }

    public <T extends PsiPolyVariantReference> ResolveResult @Nullable [] getCachedResults(@NotNull T ref, boolean physical, boolean incompleteCode, boolean isPoly) {
        Map map2 = this.getMap(physical, ResolveCache.getIndex(incompleteCode, isPoly));
        return (ResolveResult[])map2.get(ref);
    }

    @Nullable
    public <TRef extends PsiReference, TResult> TResult resolveWithCaching(@NotNull TRef ref, @NotNull AbstractResolver<TRef, TResult> resolver, boolean needToPreventRecursion, boolean incompleteCode) {
        return this.resolve(ref, resolver, needToPreventRecursion, incompleteCode, false, ref.getElement().isPhysical());
    }

    @NotNull
    private <TRef extends PsiReference, TResult> Map<TRef, TResult> getMap(boolean physical, int index) {
        AtomicReferenceArray<Map<?, ?>> array2 = physical ? this.myPhysicalMaps : this.myNonPhysicalMaps;
        Map<Object, Object> map2 = array2.get(index);
        while (map2 == null) {
            Map newMap = ResolveCache.createWeakMap();
            map2 = array2.compareAndSet(index, null, newMap) ? newMap : array2.get(index);
        }
        return map2;
    }

    private static int getIndex(boolean incompleteCode, boolean isPoly) {
        return (incompleteCode ? 0 : 1) * 2 + (isPoly ? 0 : 1);
    }

    private static <TRef extends PsiReference, TResult> void cache(@NotNull TRef ref, @NotNull Map<? super TRef, TResult> map2, TResult result2, @NotNull Computable<TResult> doResolve) {
        Object cached = map2.get(ref);
        if (cached != null) {
            if (cached == result2) {
                return;
            }
            IdempotenceChecker.checkEquivalence(cached, result2, ref.getClass(), doResolve);
        }
        cached = result2 == null ? NULL_RESULT : result2;
        map2.put(ref, cached);
    }

    @NotNull
    private static <K, V> StrongValueReference<K, V> createStrongReference(@NotNull V value2) {
        return value2 == NULL_RESULT ? NULL_VALUE_REFERENCE : (value2 == ResolveResult.EMPTY_ARRAY ? EMPTY_RESOLVE_RESULT : new StrongValueReference(value2));
    }

    private static class StrongValueReference<K, V>
    implements ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> {
        private final V myValue;

        StrongValueReference(@NotNull V value2) {
            this.myValue = value2;
        }

        @NotNull
        public ConcurrentWeakKeySoftValueHashMap.KeyReference<K, V> getKeyReference() {
            throw new UnsupportedOperationException();
        }

        public V get() {
            return this.myValue;
        }
    }

    @FunctionalInterface
    public static interface Resolver
    extends AbstractResolver<PsiReference, PsiElement> {
    }

    @FunctionalInterface
    public static interface PolyVariantContextResolver<T extends PsiPolyVariantReference> {
        public ResolveResult @NotNull [] resolve(@NotNull T var1, @NotNull PsiFile var2, boolean var3);
    }

    @FunctionalInterface
    public static interface PolyVariantResolver<T extends PsiPolyVariantReference>
    extends AbstractResolver<T, ResolveResult[]> {
        @Override
        public ResolveResult @NotNull [] resolve(@NotNull T var1, boolean var2);
    }

    @FunctionalInterface
    public static interface AbstractResolver<TRef extends PsiReference, TResult> {
        public TResult resolve(@NotNull TRef var1, boolean var2);
    }
}

