/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.options.SchemeImportUtil;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class CodeStyleSettingsLoader {
    public CodeStyleSettings loadSettings(@NotNull VirtualFile file2) throws SchemeImportException {
        Element rootElement = SchemeImportUtil.loadSchemeDom(file2);
        CodeStyleSettings settings = CodeStyleSettingsManager.getInstance().createSettings();
        CodeStyleSettingsLoader.loadSettings(rootElement, settings);
        return settings;
    }

    protected static void loadSettings(@NotNull Element rootElement, @NotNull CodeStyleSettings settings) throws SchemeImportException {
        try {
            settings.readExternal(CodeStyleSettingsLoader.findSchemeRoot(rootElement));
        }
        catch (InvalidDataException e) {
            throw new SchemeImportException(ApplicationBundle.message((String)"settings.code.style.import.xml.error.can.not.load", (Object[])new Object[]{e.getMessage()}));
        }
    }

    protected static Element findSchemeRoot(@NotNull Element rootElement) throws SchemeImportException {
        String rootName = rootElement.getName();
        if ("project".equals(rootName)) {
            Element child2 = rootElement.getChild("component");
            if (child2 != null && "ProjectCodeStyleSettingsManager".equals(child2.getAttributeValue("name")) && (child2 = child2.getChild("option")) != null && "PER_PROJECT_SETTINGS".equals(child2.getAttributeValue("name")) && (child2 = child2.getChild("value")) != null) {
                return child2;
            }
            throw new SchemeImportException("Invalid scheme root: " + rootName);
        }
        if ("component".equals(rootName)) {
            Element child3;
            if ("ProjectCodeStyleConfiguration".equals(rootElement.getAttributeValue("name")) && (child3 = rootElement.getChild("code_scheme")) != null) {
                return child3;
            }
            throw new SchemeImportException("Invalid scheme root: " + rootName);
        }
        return rootElement;
    }
}

