/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SubstrateRef {
    private static final Logger LOG = Logger.getInstance(SubstrateRef.class);

    @NotNull
    public abstract ASTNode getNode();

    @Nullable
    public Stub getStub() {
        return null;
    }

    @Nullable
    public Stub getGreenStub() {
        return this.getStub();
    }

    public abstract boolean isValid();

    @NotNull
    public abstract PsiFile getContainingFile();

    @NotNull
    static SubstrateRef createInvalidRef(final @NotNull StubBasedPsiElementBase<?> psi) {
        return new SubstrateRef(){

            @Override
            @NotNull
            public ASTNode getNode() {
                throw new PsiInvalidElementAccessException((PsiElement)psi);
            }

            @Override
            public boolean isValid() {
                return false;
            }

            @Override
            @NotNull
            public PsiFile getContainingFile() {
                throw new PsiInvalidElementAccessException((PsiElement)psi);
            }
        };
    }

    public static SubstrateRef createAstStrongRef(final @NotNull ASTNode node) {
        return new SubstrateRef(){

            @Override
            @NotNull
            public ASTNode getNode() {
                return node;
            }

            @Override
            public boolean isValid() {
                FileASTNode fileElement = SharedImplUtil.findFileElement(node);
                PsiElement file2 = fileElement == null ? null : fileElement.getPsi();
                return file2 != null && file2.isValid();
            }

            @Override
            @NotNull
            public PsiFile getContainingFile() {
                PsiFile file2 = SharedImplUtil.getContainingFile(node);
                if (file2 == null) {
                    throw PsiInvalidElementAccessException.createByNode((ASTNode)node, null);
                }
                return file2;
            }
        };
    }

    public static class StubRef
    extends SubstrateRef {
        private final StubElement myStub;

        public StubRef(@NotNull StubElement stub) {
            this.myStub = stub;
        }

        @Override
        @NotNull
        public ASTNode getNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Stub getStub() {
            return this.myStub;
        }

        @Override
        public boolean isValid() {
            StubElement parent = this.myStub.getParentStub();
            if (parent == null) {
                LOG.error("No parent for stub " + this.myStub + " of class " + this.myStub.getClass());
                return false;
            }
            PsiElement psi = parent.getPsi();
            return psi != null && psi.isValid();
        }

        @Override
        @NotNull
        public PsiFile getContainingFile() {
            StubElement stub = this.myStub;
            while (!(stub instanceof PsiFileStub)) {
                stub = stub.getParentStub();
            }
            PsiFile psi = (PsiFile)stub.getPsi();
            if (psi != null) {
                return psi;
            }
            return this.reportError(stub);
        }

        private PsiFile reportError(StubElement stub) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            String reason = ((PsiFileStubImpl)stub).getInvalidationReason();
            PsiInvalidElementAccessException exception = new PsiInvalidElementAccessException(this.myStub.getPsi(), "no psi for file stub " + stub + ", invalidation reason=" + reason, null);
            if ("stub-psi mismatch".equals(reason)) {
                throw new ProcessCanceledException((Throwable)exception);
            }
            throw exception;
        }
    }
}

