/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.impl.search.TodoItemImpl;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternOccurrence;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.search.TodoPattern;
import org.jetbrains.annotations.NotNull;

public class TodoItemsCreator {
    private static final Logger LOG = Logger.getInstance(TodoItemsCreator.class);
    private final TodoPattern[] myTodoPatterns = TodoConfiguration.getInstance().getTodoPatterns();

    public TodoItem createTodo(IndexPatternOccurrence occurrence) {
        TextRange occurrenceRange = occurrence.getTextRange();
        return new TodoItemImpl(occurrence.getFile(), occurrenceRange.getStartOffset(), occurrenceRange.getEndOffset(), this.mapPattern(occurrence.getPattern()), occurrence.getAdditionalTextRanges());
    }

    @NotNull
    private TodoPattern mapPattern(@NotNull IndexPattern pattern) {
        for (TodoPattern todoPattern : this.myTodoPatterns) {
            if (todoPattern.getIndexPattern() != pattern) continue;
            return todoPattern;
        }
        LOG.error("Could not find matching TODO pattern for index pattern " + pattern.getPatternString());
        return null;
    }
}

