/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncUtil;
import com.intellij.concurrency.JobLauncher;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbUtil;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.search.BulkOccurrenceProcessor;
import com.intellij.psi.impl.search.LowLevelSearchUtil;
import com.intellij.psi.impl.search.WordRequestInfo;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiNonJavaFileReferenceProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.PsiSearchRequest;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.QuerySearchRequest;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.ScopeOptimizer;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.UseScopeEnlarger;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.codeInsight.CommentUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.text.StringSearcher;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSearchHelperImpl
implements PsiSearchHelper {
    private static final ExtensionPointName<ScopeOptimizer> USE_SCOPE_OPTIMIZER_EP_NAME = ExtensionPointName.create((String)"com.intellij.useScopeOptimizer");
    private static final Logger LOG = Logger.getInstance(PsiSearchHelperImpl.class);
    private final PsiManagerEx myManager;
    private final DumbService myDumbService;

    @NotNull
    public SearchScope getUseScope(@NotNull PsiElement element2) {
        SearchScope scope = element2.getUseScope();
        for (UseScopeEnlarger enlarger : (UseScopeEnlarger[])UseScopeEnlarger.EP_NAME.getExtensions()) {
            ProgressManager.checkCanceled();
            SearchScope additionalScope = enlarger.getAdditionalUseScope(element2);
            if (additionalScope == null) continue;
            scope = scope.union(additionalScope);
        }
        SearchScope scopeToRestrict = ScopeOptimizer.calculateOverallRestrictedUseScope((ScopeOptimizer[])((ScopeOptimizer[])USE_SCOPE_OPTIMIZER_EP_NAME.getExtensions()), (PsiElement)element2);
        if (scopeToRestrict != null) {
            scope = scope.intersectWith(scopeToRestrict);
        }
        return scope;
    }

    public PsiSearchHelperImpl(@NotNull Project project) {
        this.myManager = PsiManagerEx.getInstanceEx(project);
        this.myDumbService = DumbService.getInstance((Project)this.myManager.getProject());
    }

    @Deprecated
    public PsiSearchHelperImpl(@NotNull PsiManagerEx psiManager) {
        this.myManager = psiManager;
        this.myDumbService = DumbService.getInstance((Project)this.myManager.getProject());
    }

    public PsiElement @NotNull [] findCommentsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope) {
        List result2 = Collections.synchronizedList(new ArrayList());
        Processor processor2 = Processors.cancelableCollectProcessor(result2);
        this.processCommentsContainingIdentifier(identifier, searchScope, (Processor<? super PsiElement>)processor2);
        return PsiUtilCore.toPsiElementArray(result2);
    }

    public boolean processCommentsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope, @NotNull Processor<? super PsiElement> processor2) {
        TextOccurenceProcessor occurrenceProcessor2 = (element2, offsetInElement) -> {
            if (CommentUtilCore.isCommentTextElement(element2) && element2.findReferenceAt(offsetInElement) == null) {
                return processor2.process((Object)element2);
            }
            return true;
        };
        return this.processElementsWithWord(occurrenceProcessor2, searchScope, identifier, (short)2, true);
    }

    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor processor2, @NotNull SearchScope searchScope, @NotNull String text, short searchContext, boolean caseSensitive) {
        return this.processElementsWithWord(processor2, searchScope, text, searchContext, caseSensitive, PsiSearchHelperImpl.shouldProcessInjectedPsi(searchScope));
    }

    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor processor2, @NotNull SearchScope searchScope, @NotNull String text, short searchContext, boolean caseSensitive, boolean processInjectedPsi) {
        EnumSet<Options> options2 = PsiSearchHelperImpl.makeOptions(caseSensitive, processInjectedPsi);
        return this.processElementsWithWord(searchScope, text, searchContext, options2, null, new SearchSession(), processor2);
    }

    public boolean hasIdentifierInFile(@NotNull PsiFile file2, @NotNull String name) {
        PsiUtilCore.ensureValid((PsiElement)file2);
        if (file2.getVirtualFile() == null || DumbService.isDumb((Project)file2.getProject())) {
            return StringUtil.contains((CharSequence)file2.getViewProvider().getContents(), (CharSequence)name);
        }
        GlobalSearchScope fileScope = GlobalSearchScope.fileScope((PsiFile)file2);
        IdIndexEntry key = new IdIndexEntry(name, true);
        return !FileBasedIndex.getInstance().getContainingFiles(IdIndex.NAME, (Object)key, fileScope).isEmpty();
    }

    @NotNull
    private static EnumSet<Options> makeOptions(boolean caseSensitive, boolean processInjectedPsi) {
        EnumSet<Options> options2 = EnumSet.of(Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE);
        if (caseSensitive) {
            options2.add(Options.CASE_SENSITIVE_SEARCH);
        }
        if (processInjectedPsi) {
            options2.add(Options.PROCESS_INJECTED_PSI);
        }
        return options2;
    }

    @NotNull
    public AsyncFuture<Boolean> processElementsWithWordAsync(@NotNull TextOccurenceProcessor processor2, @NotNull SearchScope searchScope, @NotNull String text, short searchContext, boolean caseSensitively) {
        boolean result2 = this.processElementsWithWord(processor2, searchScope, text, searchContext, caseSensitively, PsiSearchHelperImpl.shouldProcessInjectedPsi(searchScope));
        return AsyncUtil.wrapBoolean((boolean)result2);
    }

    @Deprecated
    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor processor2, @NotNull SearchScope searchScope, @NotNull String text, short searchContext, @NotNull EnumSet<Options> options2, @Nullable String containerName) {
        return this.processElementsWithWord(searchScope, text, searchContext, options2, containerName, new SearchSession(), processor2);
    }

    public boolean processElementsWithWord(@NotNull SearchScope searchScope, @NotNull String text, short searchContext, @NotNull EnumSet<Options> options2, @Nullable String containerName, @NotNull SearchSession session2, @NotNull TextOccurenceProcessor processor2) {
        return this.bulkProcessElementsWithWord(searchScope, text, searchContext, options2, containerName, session2, (scope, offsetsInScope, searcher) -> LowLevelSearchUtil.processElementsAtOffsets(scope, searcher, options2.contains((Object)Options.PROCESS_INJECTED_PSI), PsiSearchHelperImpl.getOrCreateIndicator(), offsetsInScope, processor2));
    }

    boolean bulkProcessElementsWithWord(@NotNull SearchScope searchScope, @NotNull String text, short searchContext, @NotNull EnumSet<Options> options2, @Nullable String containerName, @NotNull SearchSession session2, final @NotNull BulkOccurrenceProcessor processor2) {
        if (text.isEmpty()) {
            throw new IllegalArgumentException("Cannot search for elements with empty text");
        }
        ProgressIndicator progress2 = PsiSearchHelperImpl.getOrCreateIndicator();
        if (searchScope instanceof GlobalSearchScope) {
            StringSearcher searcher = new StringSearcher(text, options2.contains((Object)Options.CASE_SENSITIVE_SEARCH), true, searchContext == 4, options2.contains((Object)Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE));
            return this.processElementsWithTextInGlobalScope((GlobalSearchScope)searchScope, searcher, searchContext, options2.contains((Object)Options.CASE_SENSITIVE_SEARCH), containerName, session2, progress2, processor2);
        }
        LocalSearchScope scope = (LocalSearchScope)searchScope;
        PsiElement[] scopeElements = scope.getScope();
        final StringSearcher searcher = new StringSearcher(text, options2.contains((Object)Options.CASE_SENSITIVE_SEARCH), true, searchContext == 4, options2.contains((Object)Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE));
        ReadActionProcessor<PsiElement> localProcessor = new ReadActionProcessor<PsiElement>(){

            public boolean processInReadAction(PsiElement scopeElement) {
                if (!scopeElement.isValid()) {
                    return true;
                }
                if (!scopeElement.isPhysical() || scopeElement instanceof PsiCompiledElement) {
                    scopeElement = scopeElement.getNavigationElement();
                }
                if (scopeElement instanceof PsiCompiledElement) {
                    return true;
                }
                if (scopeElement.getTextRange() == null) {
                    LOG.debug("Element " + scopeElement + " of class " + scopeElement.getClass() + " has null range");
                    return true;
                }
                return processor2.execute(scopeElement, LowLevelSearchUtil.getTextOccurrencesInScope(scopeElement, searcher), searcher);
            }

            public String toString() {
                return processor2.toString();
            }
        };
        return JobLauncher.getInstance().invokeConcurrentlyUnderProgress(Arrays.asList(scopeElements), progress2, localProcessor);
    }

    @NotNull
    private static ProgressIndicator getOrCreateIndicator() {
        ProgressIndicator progress2 = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progress2 == null) {
            progress2 = new EmptyProgressIndicator();
        }
        progress2.setIndeterminate(false);
        return progress2;
    }

    public static boolean shouldProcessInjectedPsi(@NotNull SearchScope scope) {
        return !(scope instanceof LocalSearchScope) || !((LocalSearchScope)scope).isIgnoreInjectedPsi();
    }

    @NotNull
    static Processor<PsiElement> localProcessor(final @NotNull StringSearcher searcher, final @NotNull BulkOccurrenceProcessor processor2) {
        return new ReadActionProcessor<PsiElement>(){

            public boolean processInReadAction(PsiElement scopeElement) {
                if (scopeElement instanceof PsiCompiledElement) {
                    return true;
                }
                return scopeElement.isValid() && processor2.execute(scopeElement, LowLevelSearchUtil.getTextOccurrencesInScope(scopeElement, searcher), searcher);
            }

            public String toString() {
                return processor2.toString();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processElementsWithTextInGlobalScope(@NotNull GlobalSearchScope scope, @NotNull StringSearcher searcher, short searchContext, boolean caseSensitively, @Nullable String containerName, @NotNull SearchSession session2, @NotNull ProgressIndicator progress2, @NotNull BulkOccurrenceProcessor processor2) {
        progress2.pushState();
        try {
            progress2.setText(IndexingBundle.message((String)"psi.scanning.files.progress", (Object[])new Object[0]));
            Processor<PsiElement> localProcessor = PsiSearchHelperImpl.localProcessor(searcher, processor2);
            List<List<VirtualFile>> priorities = this.computePriorities(scope, searcher, searchContext, caseSensitively, containerName, session2);
            if (priorities.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            int totalSize = priorities.stream().mapToInt(l -> l.size()).sum();
            progress2.setText(IndexingBundle.message((String)"psi.search.for.word.progress", (Object[])new Object[]{searcher.getPattern(), totalSize}));
            int alreadyProcessedFiles = 0;
            for (List<VirtualFile> files2 : priorities) {
                if (!this.processPsiFileRoots(files2, totalSize, alreadyProcessedFiles, progress2, localProcessor)) {
                    boolean bl = false;
                    return bl;
                }
                alreadyProcessedFiles += files2.size();
            }
        }
        finally {
            progress2.popState();
        }
        return true;
    }

    @NotNull
    private List<List<VirtualFile>> computePriorities(@NotNull GlobalSearchScope scope, @NotNull StringSearcher searcher, short searchContext, boolean caseSensitively, @Nullable String containerName, @NotNull SearchSession session2) {
        List directories;
        String text = searcher.getPattern();
        THashSet allFiles = new THashSet();
        this.getFilesWithText(scope, searchContext, caseSensitively, text, (Collection<? super VirtualFile>)allFiles);
        ArrayList<List<VirtualFile>> priorities = new ArrayList<List<VirtualFile>>();
        List targets2 = (List)ReadAction.compute(() -> ContainerUtil.filter((Collection)session2.getTargetVirtualFiles(), arg_0 -> ((GlobalSearchScope)scope).contains(arg_0)));
        if (!targets2.isEmpty()) {
            priorities.add(targets2);
            allFiles.removeAll(targets2);
            directories = ContainerUtil.mapNotNull((Collection)targets2, v -> v.getParent());
            DelegatingGlobalSearchScope directoryNearTargetScope = new DelegatingGlobalSearchScope(scope){

                public boolean contains(@NotNull VirtualFile file2) {
                    return super.contains(file2) && directories.contains(file2.getParent());
                }
            };
            List directoryNearTargetFiles = (List)ReadAction.compute(() -> PsiSearchHelperImpl.lambda$computePriorities$6((Set)allFiles, (GlobalSearchScope)directoryNearTargetScope, targets2));
            if (!directoryNearTargetFiles.isEmpty()) {
                priorities.add(directoryNearTargetFiles);
                allFiles.removeAll(directoryNearTargetFiles);
            }
        } else {
            directories = Collections.emptyList();
        }
        if (containerName != null) {
            THashSet intersectionWithContainerFiles = new THashSet();
            this.getFilesWithText(scope, searchContext, caseSensitively, text + " " + containerName, (Collection<? super VirtualFile>)intersectionWithContainerFiles);
            intersectionWithContainerFiles.removeAll(targets2);
            intersectionWithContainerFiles.removeAll(directories);
            if (!intersectionWithContainerFiles.isEmpty()) {
                priorities.add(new ArrayList(intersectionWithContainerFiles));
                allFiles.removeAll((Collection<?>)intersectionWithContainerFiles);
            }
        }
        if (!allFiles.isEmpty()) {
            priorities.add(new ArrayList(allFiles));
        }
        return priorities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processPsiFileRoots(@NotNull List<? extends VirtualFile> files2, int totalSize, int alreadyProcessedFiles, @NotNull ProgressIndicator progress2, @NotNull Processor<? super PsiFile> localProcessor) {
        this.myManager.startBatchFilesProcessingMode();
        try {
            AtomicInteger counter = new AtomicInteger(alreadyProcessedFiles);
            AtomicBoolean stopped = new AtomicBoolean(false);
            ProgressIndicator originalIndicator = ProgressWrapper.unwrapAll(progress2);
            boolean bl = PsiSearchHelperImpl.processFilesConcurrentlyDespiteWriteActions(this.myManager.getProject(), files2, progress2, stopped, (Processor<? super VirtualFile>)((Processor)vfile -> {
                TooManyUsagesStatus.getFrom(originalIndicator).pauseProcessingIfTooManyUsages();
                try {
                    this.processVirtualFile((VirtualFile)vfile, stopped, localProcessor);
                }
                catch (ProcessCanceledException | IndexNotReadyException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error("Error during processing of: " + vfile.getName(), e);
                    throw e;
                }
                if (progress2.isRunning()) {
                    double fraction = (double)counter.incrementAndGet() / (double)totalSize;
                    progress2.setFraction(fraction);
                }
                return !stopped.get();
            }));
            return bl;
        }
        finally {
            this.myManager.finishBatchFilesProcessingMode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean processFilesConcurrentlyDespiteWriteActions(@NotNull Project project, @NotNull List<? extends VirtualFile> files2, @NotNull ProgressIndicator progress2, @NotNull AtomicBoolean stopped, @NotNull Processor<? super VirtualFile> localProcessor) {
        ApplicationEx app = (ApplicationEx)ApplicationManager.getApplication();
        if (!app.isDispatchThread()) {
            CoreProgressManager.assertUnderProgress(progress2);
        }
        List<? extends VirtualFile> processedFiles = Collections.synchronizedList(new ArrayList(files2.size()));
        while (true) {
            ProgressManager.checkCanceled();
            final SensitiveProgressWrapper wrapper2 = new SensitiveProgressWrapper(progress2);
            ApplicationListener listener2 = new ApplicationListener(){

                public void beforeWriteActionStart(@NotNull Object action2) {
                    wrapper2.cancel();
                }
            };
            processedFiles.clear();
            Disposable disposable2 = Disposer.newDisposable();
            app.addApplicationListener(listener2, disposable2);
            boolean processorCanceled = false;
            try {
                if (app.isWriteAccessAllowed() || app.isReadAccessAllowed() && app.isWriteActionPending()) {
                    boolean bl = processorCanceled = !ContainerUtil.process(files2, localProcessor);
                    if (processorCanceled) {
                        stopped.set(true);
                    }
                    processedFiles.addAll(files2);
                } else if (app.isWriteActionPending()) {
                } else {
                    AtomicBoolean someTaskFailed = new AtomicBoolean();
                    Processor processor2 = vfile -> {
                        ProgressManager.checkCanceled();
                        if (someTaskFailed.get()) {
                            return false;
                        }
                        try {
                            app.executeByImpatientReader(() -> {
                                if (localProcessor.process(vfile)) {
                                    processedFiles.add((VirtualFile)vfile);
                                } else {
                                    stopped.set(true);
                                }
                            });
                        }
                        catch (ProcessCanceledException e) {
                            someTaskFailed.set(true);
                            throw e;
                        }
                        return !stopped.get();
                    };
                    try {
                        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(files2, wrapper2, processor2);
                        processorCanceled = stopped.get();
                    }
                    catch (ProcessCanceledException e) {
                        progress2.checkCanceled();
                    }
                }
            }
            finally {
                Disposer.dispose((Disposable)disposable2);
            }
            if (processorCanceled) {
                return false;
            }
            if (processedFiles.size() == files2.size()) break;
            DumbService.getInstance((Project)project).runReadActionInSmartMode(EmptyRunnable.getInstance());
            THashSet t = new THashSet(files2);
            List<? extends VirtualFile> list2 = processedFiles;
            synchronized (list2) {
                t.removeAll(processedFiles);
            }
            files2 = new ArrayList<VirtualFile>((Collection<? extends VirtualFile>)t);
        }
        return true;
    }

    private void processVirtualFile(@NotNull VirtualFile vfile, @NotNull AtomicBoolean stopped, @NotNull Processor<? super PsiFile> localProcessor) throws ApplicationUtil.CannotRunReadActionException {
        PsiFile file2 = (PsiFile)ApplicationUtil.tryRunReadAction(() -> vfile.isValid() ? this.myManager.findFile(vfile) : null);
        if (file2 != null && !(file2 instanceof PsiBinaryFile)) {
            ApplicationUtil.tryRunReadAction(() -> {
                Project project = this.myManager.getProject();
                if (project.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                if (!DumbUtil.getInstance((Project)project).mayUseIndices()) {
                    throw ApplicationUtil.CannotRunReadActionException.create();
                }
                List psiRoots = file2.getViewProvider().getAllFiles();
                THashSet processed2 = new THashSet(psiRoots.size() * 2, 0.5f);
                for (PsiFile psiRoot : psiRoots) {
                    ProgressManager.checkCanceled();
                    assert (psiRoot != null) : "One of the roots of file " + file2 + " is null. All roots: " + psiRoots + "; ViewProvider: " + file2.getViewProvider() + "; Virtual file: " + file2.getViewProvider().getVirtualFile();
                    if (!processed2.add(psiRoot) || !psiRoot.isValid() || localProcessor.process((Object)psiRoot)) continue;
                    stopped.set(true);
                    break;
                }
            });
        }
    }

    private void getFilesWithText(@NotNull GlobalSearchScope scope, short searchContext, boolean caseSensitively, @NotNull String text, @NotNull Collection<? super VirtualFile> result2) {
        this.processCandidateFilesForText(scope, searchContext, caseSensitively, text, (Processor<? super VirtualFile>)Processors.cancelableCollectProcessor(result2));
    }

    public boolean processCandidateFilesForText(@NotNull GlobalSearchScope scope, short searchContext, boolean caseSensitively, @NotNull String text, @NotNull Processor<? super VirtualFile> processor2) {
        List<IdIndexEntry> entries = PsiSearchHelperImpl.getWordEntries(text, caseSensitively);
        if (entries.isEmpty()) {
            return true;
        }
        Condition<Integer> contextMatches = PsiSearchHelperImpl.matchContextCondition(searchContext);
        return PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), scope, contextMatches, entries, processor2);
    }

    public PsiFile @NotNull [] findFilesWithPlainTextWords(@NotNull String word) {
        return CacheManager.getInstance(this.myManager.getProject()).getFilesWithWord(word, (short)16, GlobalSearchScope.projectScope((Project)this.myManager.getProject()), true);
    }

    public boolean processUsagesInNonJavaFiles(@NotNull String qName, @NotNull PsiNonJavaFileReferenceProcessor processor2, @NotNull GlobalSearchScope searchScope) {
        return this.processUsagesInNonJavaFiles(null, qName, processor2, searchScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processUsagesInNonJavaFiles(@Nullable PsiElement originalElement, @NotNull String qName, @NotNull PsiNonJavaFileReferenceProcessor processor2, @NotNull GlobalSearchScope initialScope) {
        int dollarIndex;
        if (qName.isEmpty()) {
            throw new IllegalArgumentException("Cannot search for elements with empty text. Element: " + originalElement + "; " + (originalElement == null ? null : originalElement.getClass()));
        }
        ProgressIndicator progress2 = PsiSearchHelperImpl.getOrCreateIndicator();
        int dotIndex = qName.lastIndexOf(46);
        int maxIndex = Math.max(dotIndex, dollarIndex = qName.lastIndexOf(36));
        String wordToSearch = maxIndex >= 0 ? qName.substring(maxIndex + 1) : qName;
        GlobalSearchScope theSearchScope = (GlobalSearchScope)ReadAction.compute(() -> {
            if (originalElement != null && this.myManager.isInProject(originalElement) && initialScope.isSearchInLibraries()) {
                return initialScope.intersectWith(GlobalSearchScope.projectScope((Project)this.myManager.getProject()));
            }
            return initialScope;
        });
        PsiFile[] files2 = (PsiFile[])this.myDumbService.runReadActionInSmartMode(() -> CacheManager.getInstance(this.myManager.getProject()).getFilesWithWord(wordToSearch, (short)16, theSearchScope, true));
        StringSearcher searcher = new StringSearcher(qName, true, true, false);
        progress2.pushState();
        Ref stopped = Ref.create((Object)Boolean.FALSE);
        try {
            progress2.setText(IndexingBundle.message((String)"psi.search.in.non.java.files.progress", (Object[])new Object[0]));
            SearchScope useScope = originalElement == null ? null : (SearchScope)this.myDumbService.runReadActionInSmartMode(() -> this.getUseScope(originalElement));
            int patternLength = qName.length();
            for (int i2 = 0; i2 < files2.length; ++i2) {
                ProgressManager.checkCanceled();
                PsiFile psiFile = files2[i2];
                if (psiFile instanceof PsiBinaryFile) continue;
                CharSequence text = (CharSequence)ReadAction.compute(() -> psiFile.getViewProvider().getContents());
                LowLevelSearchUtil.processTextOccurrences(text, 0, text.length(), searcher, index -> {
                    boolean isReferenceOK = (Boolean)this.myDumbService.runReadActionInSmartMode(() -> {
                        PsiReference referenceAt = psiFile.findReferenceAt(index);
                        return referenceAt == null || useScope == null || !PsiSearchScopeUtil.isInScope((SearchScope)useScope.intersectWith((SearchScope)initialScope), (PsiElement)psiFile);
                    });
                    if (isReferenceOK && !processor2.process(psiFile, index, index + patternLength)) {
                        stopped.set((Object)Boolean.TRUE);
                        return false;
                    }
                    return true;
                });
                if (((Boolean)stopped.get()).booleanValue()) {
                    break;
                }
                progress2.setFraction((double)(i2 + 1) / (double)files2.length);
            }
        }
        finally {
            progress2.popState();
        }
        return (Boolean)stopped.get() == false;
    }

    public boolean processAllFilesWithWord(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiFile> processor2, boolean caseSensitively) {
        return CacheManager.getInstance(this.myManager.getProject()).processFilesWithWord(processor2, word, (short)1, scope, caseSensitively);
    }

    public boolean processAllFilesWithWordInText(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiFile> processor2, boolean caseSensitively) {
        return CacheManager.getInstance(this.myManager.getProject()).processFilesWithWord(processor2, word, (short)16, scope, caseSensitively);
    }

    public boolean processAllFilesWithWordInComments(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiFile> processor2) {
        return CacheManager.getInstance(this.myManager.getProject()).processFilesWithWord(processor2, word, (short)2, scope, true);
    }

    public boolean processAllFilesWithWordInLiterals(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiFile> processor2) {
        return CacheManager.getInstance(this.myManager.getProject()).processFilesWithWord(processor2, word, (short)4, scope, true);
    }

    public boolean processRequests(@NotNull SearchRequestCollector collector, @NotNull Processor<? super PsiReference> processor2) {
        QueryRequestsRunResult result2;
        HashMap<SearchRequestCollector, Processor<? super PsiReference>> collectors = new HashMap<SearchRequestCollector, Processor<? super PsiReference>>();
        collectors.put(collector, processor2);
        ProgressIndicator progress2 = PsiSearchHelperImpl.getOrCreateIndicator();
        if (PsiSearchHelperImpl.appendCollectorsFromQueryRequests(progress2, collectors) == QueryRequestsRunResult.STOPPED) {
            return false;
        }
        do {
            HashMap<Set<IdIndexEntry>, Collection<RequestWithProcessor>> globals = new HashMap<Set<IdIndexEntry>, Collection<RequestWithProcessor>>();
            ArrayList customs = new ArrayList();
            LinkedHashSet<RequestWithProcessor> locals = new LinkedHashSet<RequestWithProcessor>();
            THashMap localProcessors = new THashMap();
            PsiSearchHelperImpl.distributePrimitives(collectors, locals, globals, customs, (Map<RequestWithProcessor, Processor<? super PsiElement>>)localProcessors);
            if (!this.processGlobalRequestsOptimized(globals, progress2, (Map<RequestWithProcessor, Processor<? super PsiElement>>)localProcessors)) {
                return false;
            }
            for (RequestWithProcessor local : locals) {
                progress2.checkCanceled();
                if (this.processSingleRequest(local.request, (Processor<? super PsiReference>)local.refProcessor)) continue;
                return false;
            }
            for (Computable custom : customs) {
                progress2.checkCanceled();
                if (((Boolean)custom.compute()).booleanValue()) continue;
                return false;
            }
            result2 = PsiSearchHelperImpl.appendCollectorsFromQueryRequests(progress2, collectors);
            if (result2 != QueryRequestsRunResult.STOPPED) continue;
            return false;
        } while (result2 != QueryRequestsRunResult.UNCHANGED);
        return true;
    }

    @NotNull
    public AsyncFuture<Boolean> processRequestsAsync(@NotNull SearchRequestCollector collector, @NotNull Processor<? super PsiReference> processor2) {
        return AsyncUtil.wrapBoolean((boolean)this.processRequests(collector, processor2));
    }

    @NotNull
    private static QueryRequestsRunResult appendCollectorsFromQueryRequests(@NotNull ProgressIndicator progress2, @NotNull Map<SearchRequestCollector, Processor<? super PsiReference>> collectors) {
        boolean changed2 = false;
        LinkedList<SearchRequestCollector> queue = new LinkedList<SearchRequestCollector>(collectors.keySet());
        while (!queue.isEmpty()) {
            progress2.checkCanceled();
            SearchRequestCollector each = (SearchRequestCollector)queue.removeFirst();
            for (QuerySearchRequest request2 : each.takeQueryRequests()) {
                progress2.checkCanceled();
                if (!request2.runQuery()) {
                    return QueryRequestsRunResult.STOPPED;
                }
                assert (!collectors.containsKey(request2.collector) || collectors.get(request2.collector) == request2.processor);
                collectors.put(request2.collector, (Processor<? super PsiReference>)request2.processor);
                queue.addLast(request2.collector);
                changed2 = true;
            }
        }
        return changed2 ? QueryRequestsRunResult.CHANGED : QueryRequestsRunResult.UNCHANGED;
    }

    private boolean processGlobalRequestsOptimized(@NotNull Map<Set<IdIndexEntry>, Collection<RequestWithProcessor>> singles, @NotNull ProgressIndicator progress2, @NotNull Map<RequestWithProcessor, Processor<? super PsiElement>> localProcessors) {
        Collection<RequestWithProcessor> requests;
        if (singles.isEmpty()) {
            return true;
        }
        if (singles.size() == 1 && (requests = singles.values().iterator().next()).size() == 1) {
            RequestWithProcessor theOnly = requests.iterator().next();
            return this.processSingleRequest(theOnly.request, (Processor<? super PsiReference>)theOnly.refProcessor);
        }
        return this.processGlobalRequests(singles, progress2, localProcessors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends WordRequestInfo> boolean processGlobalRequests(@NotNull Map<Set<IdIndexEntry>, Collection<T>> singles, @NotNull ProgressIndicator progress2, @NotNull Map<T, Processor<? super PsiElement>> localProcessors) {
        boolean result2;
        progress2.pushState();
        progress2.setText(IndexingBundle.message((String)"psi.scanning.files.progress", (Object[])new Object[0]));
        try {
            HashMap<VirtualFile, Collection<T>> targetFiles = new HashMap<VirtualFile, Collection<T>>();
            HashMap<VirtualFile, Collection<T>> nearDirectoryFiles = new HashMap<VirtualFile, Collection<T>>();
            HashMap<VirtualFile, Collection<T>> intersectionCandidateFiles = new HashMap<VirtualFile, Collection<T>>();
            HashMap<VirtualFile, Collection<T>> restCandidateFiles = new HashMap<VirtualFile, Collection<T>>();
            int totalSize = this.collectFiles(singles, targetFiles, nearDirectoryFiles, intersectionCandidateFiles, restCandidateFiles);
            if (totalSize == 0) {
                boolean bl = true;
                return bl;
            }
            TreeSet<String> allWords = new TreeSet<String>();
            for (WordRequestInfo singleRequest : localProcessors.keySet()) {
                ProgressManager.checkCanceled();
                allWords.add(singleRequest.getWord());
            }
            progress2.setText(IndexingBundle.message((String)"psi.search.for.word.progress", (Object[])new Object[]{PsiSearchHelperImpl.concat(allWords), totalSize}));
            int alreadyProcessedFiles = 0;
            if (!targetFiles.isEmpty()) {
                result2 = this.processCandidates(localProcessors, targetFiles, progress2, totalSize, alreadyProcessedFiles);
                if (!result2) {
                    boolean bl = false;
                    return bl;
                }
                alreadyProcessedFiles += targetFiles.size();
            }
            if (!nearDirectoryFiles.isEmpty()) {
                result2 = this.processCandidates(localProcessors, nearDirectoryFiles, progress2, totalSize, alreadyProcessedFiles);
                if (!result2) {
                    boolean bl = false;
                    return bl;
                }
                alreadyProcessedFiles += nearDirectoryFiles.size();
            }
            if (!intersectionCandidateFiles.isEmpty()) {
                result2 = this.processCandidates(localProcessors, intersectionCandidateFiles, progress2, totalSize, alreadyProcessedFiles);
                if (!result2) {
                    boolean bl = false;
                    return bl;
                }
                alreadyProcessedFiles += intersectionCandidateFiles.size();
            }
            result2 = this.processCandidates(localProcessors, restCandidateFiles, progress2, totalSize, alreadyProcessedFiles);
        }
        finally {
            progress2.popState();
        }
        return result2;
    }

    private <T> boolean processCandidates(@NotNull Map<T, Processor<? super PsiElement>> localProcessors, @NotNull Map<VirtualFile, Collection<T>> candidateFiles, @NotNull ProgressIndicator progress2, int totalSize, int alreadyProcessedFiles) {
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>(candidateFiles.keySet());
        return this.processPsiFileRoots(files2, totalSize, alreadyProcessedFiles, progress2, (Processor<? super PsiFile>)((Processor)psiRoot -> {
            VirtualFile vfile = psiRoot.getVirtualFile();
            for (Object singleRequest : (Collection)candidateFiles.get(vfile)) {
                ProgressManager.checkCanceled();
                Processor localProcessor = (Processor)localProcessors.get(singleRequest);
                if (localProcessor.process(psiRoot)) continue;
                return false;
            }
            return true;
        }));
    }

    @NotNull
    private static CharSequence concat(@NotNull Set<String> allWords) {
        StringBuilder result2 = new StringBuilder(50);
        for (String string : allWords) {
            ProgressManager.checkCanceled();
            if (string.isEmpty()) continue;
            if (result2.length() > 50) {
                result2.append("...");
                break;
            }
            if (result2.length() != 0) {
                result2.append(", ");
            }
            result2.append(string);
        }
        return result2;
    }

    @NotNull
    private static BulkOccurrenceProcessor adaptProcessor(@NotNull PsiSearchRequest singleRequest, final @NotNull Processor<? super PsiReference> consumer) {
        SearchScope searchScope = singleRequest.searchScope;
        final boolean ignoreInjectedPsi = searchScope instanceof LocalSearchScope && ((LocalSearchScope)searchScope).isIgnoreInjectedPsi();
        final RequestResultProcessor wrapped = singleRequest.processor;
        return new BulkOccurrenceProcessor(){

            @Override
            public boolean execute(@NotNull PsiElement scope, int @NotNull [] offsetsInScope, @NotNull StringSearcher searcher) {
                try {
                    ProgressManager.checkCanceled();
                    if (wrapped instanceof RequestResultProcessor.BulkResultProcessor) {
                        return ((RequestResultProcessor.BulkResultProcessor)wrapped).processTextOccurrences(scope, offsetsInScope, consumer);
                    }
                    return LowLevelSearchUtil.processElementsAtOffsets(scope, searcher, !ignoreInjectedPsi, PsiSearchHelperImpl.getOrCreateIndicator(), offsetsInScope, (element2, offsetInElement) -> {
                        if (ignoreInjectedPsi && element2 instanceof PsiLanguageInjectionHost) {
                            return true;
                        }
                        return wrapped.processTextOccurrence(element2, offsetInElement, consumer);
                    });
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Error | Exception e) {
                    PsiFile file2 = scope.getContainingFile();
                    LOG.error("Error during processing of: " + (file2 != null ? file2.getName() : scope), e);
                    return true;
                }
            }

            public String toString() {
                return consumer.toString();
            }
        };
    }

    private <T extends WordRequestInfo> int collectFiles(@NotNull Map<Set<IdIndexEntry>, Collection<T>> singles, @NotNull Map<VirtualFile, Collection<T>> targetFiles, @NotNull Map<VirtualFile, Collection<T>> nearDirectoryFiles, @NotNull Map<VirtualFile, Collection<T>> containerNameFiles, @NotNull Map<VirtualFile, Collection<T>> restFiles) {
        int totalSize = 0;
        for (Map.Entry<Set<IdIndexEntry>, Collection<T>> entry : singles.entrySet()) {
            ProgressManager.checkCanceled();
            Set<IdIndexEntry> keys2 = entry.getKey();
            if (keys2.isEmpty()) continue;
            Collection processors = entry.getValue();
            GlobalSearchScope commonScope = PsiSearchHelperImpl.uniteScopes(processors);
            Set thisTargetFiles = (Set)ReadAction.compute(() -> processors.stream().flatMap(p -> p.getSearchSession().getTargetVirtualFiles().stream()).filter(arg_0 -> ((GlobalSearchScope)commonScope).contains(arg_0)).collect(Collectors.toSet()));
            Set thisTargetDirectories = ContainerUtil.map2SetNotNull((Collection)thisTargetFiles, f -> f.getParent());
            Set<VirtualFile> intersectionWithContainerNameFiles = this.intersectionWithContainerNameFiles(commonScope, processors, keys2);
            ArrayList allFilesForKeys = new ArrayList();
            PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), commonScope, null, keys2, (Processor<? super VirtualFile>)Processors.cancelableCollectProcessor(allFilesForKeys));
            ObjectIntHashMap file2Mask = new ObjectIntHashMap();
            IntRef maskRef = new IntRef();
            for (VirtualFile file3 : allFilesForKeys) {
                ProgressManager.checkCanceled();
                for (IdIndexEntry indexEntry : keys2) {
                    ProgressManager.checkCanceled();
                    maskRef.set(0);
                    this.myDumbService.runReadActionInSmartMode(() -> FileBasedIndex.getInstance().processValues(IdIndex.NAME, (Object)indexEntry, file3, (__, value2) -> {
                        maskRef.set(value2.intValue());
                        return true;
                    }, commonScope));
                    int oldMask = file2Mask.get((Object)file3, 255);
                    file2Mask.put((Object)file3, oldMask & maskRef.get());
                }
            }
            file2Mask.forEachEntry((file2, mask) -> {
                this.myDumbService.runReadActionInSmartMode(() -> {
                    Map result2 = thisTargetFiles.contains(file2) ? targetFiles : (thisTargetDirectories.contains(file2.getParent()) ? nearDirectoryFiles : (intersectionWithContainerNameFiles != null && intersectionWithContainerNameFiles.contains(file2) ? containerNameFiles : restFiles));
                    for (WordRequestInfo single : processors) {
                        ProgressManager.checkCanceled();
                        if ((mask & single.getSearchContext()) == 0 || !single.getSearchScope().contains(file2)) continue;
                        result2.computeIfAbsent(file2, ___ -> new SmartList()).add(single);
                    }
                });
                return true;
            });
            totalSize += allFilesForKeys.size();
        }
        return totalSize;
    }

    @Nullable(value="null means we did not find common container files")
    private @Nullable(value="null means we did not find common container files") Set<VirtualFile> intersectionWithContainerNameFiles(@NotNull GlobalSearchScope commonScope, @NotNull Collection<? extends WordRequestInfo> data2, @NotNull Set<IdIndexEntry> keys2) {
        String commonName = null;
        short searchContext = 0;
        boolean caseSensitive = true;
        for (WordRequestInfo wordRequestInfo : data2) {
            ProgressManager.checkCanceled();
            String containerName = wordRequestInfo.getContainerName();
            if (containerName == null) continue;
            if (commonName == null) {
                commonName = containerName;
                searchContext = wordRequestInfo.getSearchContext();
                caseSensitive = wordRequestInfo.isCaseSensitive();
                continue;
            }
            if (commonName.equals(containerName)) {
                searchContext = (short)(searchContext | wordRequestInfo.getSearchContext());
                caseSensitive &= wordRequestInfo.isCaseSensitive();
                continue;
            }
            return null;
        }
        if (commonName == null) {
            return null;
        }
        List<IdIndexEntry> entries = PsiSearchHelperImpl.getWordEntries(commonName, caseSensitive);
        if (entries.isEmpty()) {
            return null;
        }
        entries.addAll(keys2);
        Condition<Integer> condition = PsiSearchHelperImpl.matchContextCondition(searchContext);
        THashSet containerFiles = new THashSet();
        Processor processor2 = Processors.cancelableCollectProcessor((Collection)containerFiles);
        PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), commonScope, condition, entries, (Processor<? super VirtualFile>)processor2);
        return containerFiles;
    }

    @NotNull
    private static Condition<Integer> matchContextCondition(short searchContext) {
        return context -> (context & searchContext) != 0;
    }

    @NotNull
    private static GlobalSearchScope uniteScopes(@NotNull Collection<? extends WordRequestInfo> requests) {
        Set scopes = ContainerUtil.map2LinkedSet(requests, r -> (GlobalSearchScope)r.getSearchScope());
        return GlobalSearchScope.union((GlobalSearchScope[])scopes.toArray(GlobalSearchScope.EMPTY_ARRAY));
    }

    private static void distributePrimitives(@NotNull Map<SearchRequestCollector, Processor<? super PsiReference>> collectors, @NotNull Set<RequestWithProcessor> locals, @NotNull Map<Set<IdIndexEntry>, Collection<RequestWithProcessor>> globals, @NotNull List<? super Computable<Boolean>> customs, @NotNull Map<RequestWithProcessor, Processor<? super PsiElement>> localProcessors) {
        for (Map.Entry<SearchRequestCollector, Processor<? super PsiReference>> entry : collectors.entrySet()) {
            ProgressManager.checkCanceled();
            Processor<? super PsiReference> processor2 = entry.getValue();
            SearchRequestCollector collector = entry.getKey();
            for (PsiSearchRequest primitive : collector.takeSearchRequests()) {
                ProgressManager.checkCanceled();
                SearchScope scope = primitive.searchScope;
                if (scope instanceof LocalSearchScope) {
                    PsiSearchHelperImpl.registerRequest(locals, primitive, processor2);
                    continue;
                }
                HashSet<IdIndexEntry> key = new HashSet<IdIndexEntry>(PsiSearchHelperImpl.getWordEntries(primitive.word, primitive.caseSensitive));
                PsiSearchHelperImpl.registerRequest(globals.computeIfAbsent(key, __ -> new SmartList()), primitive, processor2);
            }
            for (Processor customAction : collector.takeCustomSearchActions()) {
                ProgressManager.checkCanceled();
                customs.add((Computable<Boolean>)((Computable)() -> customAction.process((Object)processor2)));
            }
        }
        for (Map.Entry<Object, Object> entry : globals.entrySet()) {
            ProgressManager.checkCanceled();
            for (RequestWithProcessor singleRequest : (Collection)entry.getValue()) {
                ProgressManager.checkCanceled();
                PsiSearchRequest primitive = singleRequest.request;
                StringSearcher searcher = new StringSearcher(primitive.word, primitive.caseSensitive, true, false);
                BulkOccurrenceProcessor adapted = PsiSearchHelperImpl.adaptProcessor(primitive, (Processor<? super PsiReference>)singleRequest.refProcessor);
                Processor<PsiElement> localProcessor = PsiSearchHelperImpl.localProcessor(searcher, adapted);
                assert (!localProcessors.containsKey(singleRequest) || localProcessors.get(singleRequest) == localProcessor);
                localProcessors.put(singleRequest, localProcessor);
            }
        }
    }

    private static void registerRequest(@NotNull Collection<RequestWithProcessor> collection, @NotNull PsiSearchRequest primitive, @NotNull Processor<? super PsiReference> processor2) {
        RequestWithProcessor singleRequest = new RequestWithProcessor(primitive, processor2);
        for (RequestWithProcessor existing : collection) {
            ProgressManager.checkCanceled();
            if (!existing.uniteWith(singleRequest)) continue;
            return;
        }
        collection.add(singleRequest);
    }

    private boolean processSingleRequest(@NotNull PsiSearchRequest single, @NotNull Processor<? super PsiReference> consumer) {
        EnumSet<Options> options2 = PsiSearchHelperImpl.makeOptions(single.caseSensitive, PsiSearchHelperImpl.shouldProcessInjectedPsi(single.searchScope));
        return this.bulkProcessElementsWithWord(single.searchScope, single.word, single.searchContext, options2, single.containerName, single.getSearchSession(), PsiSearchHelperImpl.adaptProcessor(single, consumer));
    }

    @NotNull
    public PsiSearchHelper.SearchCostResult isCheapEnoughToSearch(@NotNull String name, @NotNull GlobalSearchScope scope, final @Nullable PsiFile fileToIgnoreOccurrencesIn, @Nullable ProgressIndicator progress2) {
        boolean cheap;
        if (!((Boolean)ReadAction.compute(() -> scope.getUnloadedModulesBelongingToScope().isEmpty())).booleanValue()) {
            return PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
        }
        final AtomicInteger filesCount = new AtomicInteger();
        final AtomicLong filesSizeToProcess = new AtomicLong();
        Processor<VirtualFile> processor2 = new Processor<VirtualFile>(){
            private final VirtualFile virtualFileToIgnoreOccurrencesIn;
            private final int maxFilesToProcess;
            private final int maxFilesSizeToProcess;
            {
                this.virtualFileToIgnoreOccurrencesIn = fileToIgnoreOccurrencesIn == null ? null : fileToIgnoreOccurrencesIn.getVirtualFile();
                this.maxFilesToProcess = Registry.intValue((String)"ide.unused.symbol.calculation.maxFilesToSearchUsagesIn", (int)10);
                this.maxFilesSizeToProcess = Registry.intValue((String)"ide.unused.symbol.calculation.maxFilesSizeToSearchUsagesIn", (int)524288);
            }

            public boolean process(VirtualFile file2) {
                ProgressManager.checkCanceled();
                if (Comparing.equal((Object)file2, (Object)this.virtualFileToIgnoreOccurrencesIn)) {
                    return true;
                }
                int currentFilesCount = filesCount.incrementAndGet();
                long accumulatedFileSizeToProcess = filesSizeToProcess.addAndGet(file2.isDirectory() ? 0L : file2.getLength());
                return currentFilesCount < this.maxFilesToProcess && accumulatedFileSizeToProcess < (long)this.maxFilesSizeToProcess;
            }
        };
        List<IdIndexEntry> keys2 = PsiSearchHelperImpl.getWordEntries(name, true);
        boolean bl = cheap = keys2.isEmpty() || PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), scope, null, keys2, (Processor<? super VirtualFile>)processor2);
        if (!cheap) {
            return PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
        }
        return filesCount.get() == 0 ? PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES : PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES;
    }

    private static boolean processFilesContainingAllKeys(@NotNull Project project, @NotNull GlobalSearchScope scope, @Nullable Condition<? super Integer> checker, @NotNull Collection<IdIndexEntry> keys2, @NotNull Processor<? super VirtualFile> processor2) {
        Computable query = () -> FileBasedIndex.getInstance().processFilesContainingAllKeys(IdIndex.NAME, keys2, scope, checker, processor2);
        if (FileBasedIndex.isIndexAccessDuringDumbModeEnabled() && FileBasedIndex.getInstance().getCurrentDumbModeAccessType() == null) {
            return (Boolean)ReadAction.nonBlocking(() -> (Boolean)FileBasedIndex.getInstance().ignoreDumbMode(DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE, () -> (Boolean)query.compute())).executeSynchronously();
        }
        if (FileBasedIndex.isIndexAccessDuringDumbModeEnabled()) {
            return (Boolean)ReadAction.nonBlocking(() -> (Boolean)query.compute()).executeSynchronously();
        }
        return (Boolean)DumbService.getInstance((Project)project).runReadActionInSmartMode(query);
    }

    @NotNull
    static List<IdIndexEntry> getWordEntries(@NotNull String name, boolean caseSensitively) {
        String trimmed;
        List<String> words = StringUtil.getWordsInStringLongestFirst((String)name);
        if (words.isEmpty() && StringUtil.isNotEmpty((String)(trimmed = name.trim()))) {
            words = Collections.singletonList(trimmed);
        }
        if (words.isEmpty()) {
            return Collections.emptyList();
        }
        return ContainerUtil.map2List((Collection)words, word -> new IdIndexEntry((String)word, caseSensitively));
    }

    private static /* synthetic */ List lambda$computePriorities$6(Set allFiles, GlobalSearchScope directoryNearTargetScope, List targets2) throws RuntimeException {
        return ContainerUtil.filter((Collection)allFiles, f -> directoryNearTargetScope.contains(f) && !targets2.contains(f));
    }

    private static enum QueryRequestsRunResult {
        STOPPED,
        UNCHANGED,
        CHANGED;

    }

    private static class RequestWithProcessor
    implements WordRequestInfo {
        @NotNull
        private final PsiSearchRequest request;
        @NotNull
        private Processor<? super PsiReference> refProcessor;

        private RequestWithProcessor(@NotNull PsiSearchRequest request2, @NotNull Processor<? super PsiReference> processor2) {
            this.request = request2;
            this.refProcessor = processor2;
        }

        private boolean uniteWith(@NotNull RequestWithProcessor another) {
            if (this.request.equals((Object)another.request)) {
                Processor<? super PsiReference> myProcessor = this.refProcessor;
                if (myProcessor != another.refProcessor) {
                    this.refProcessor = psiReference -> myProcessor.process(psiReference) && another.refProcessor.process(psiReference);
                }
                return true;
            }
            return false;
        }

        public String toString() {
            return this.request.toString();
        }

        @Override
        @NotNull
        public String getWord() {
            return this.request.word;
        }

        @Override
        @NotNull
        public SearchScope getSearchScope() {
            return this.request.searchScope;
        }

        @Override
        public short getSearchContext() {
            return this.request.searchContext;
        }

        @Override
        public boolean isCaseSensitive() {
            return this.request.caseSensitive;
        }

        @Override
        @NotNull
        public SearchSession getSearchSession() {
            return this.request.getSearchSession();
        }

        @Override
        @Nullable
        public String getContainerName() {
            return this.request.containerName;
        }
    }

    public static enum Options {
        PROCESS_INJECTED_PSI,
        CASE_SENSITIVE_SEARCH,
        PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE;

    }
}

