/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.include;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeInfoImpl;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.CompositeDataIndexer;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class FileIncludeIndex
extends FileBasedIndexExtension<String, List<FileIncludeInfoImpl>> {
    public static final ID<String, List<FileIncludeInfoImpl>> INDEX_ID = ID.create((String)"fileIncludes");
    private static final int BASE_VERSION = 6;

    @NotNull
    public static List<FileIncludeInfo> getIncludes(@NotNull VirtualFile file2, @NotNull Project project) {
        Map data2 = FileBasedIndex.getInstance().getFileData(INDEX_ID, file2, project);
        return ContainerUtil.flatten(data2.values());
    }

    @NotNull
    public static MultiMap<VirtualFile, FileIncludeInfoImpl> getIncludingFileCandidates(String fileName, @NotNull GlobalSearchScope scope) {
        MultiMap result2 = new MultiMap();
        FileBasedIndex.getInstance().processValues(INDEX_ID, (Object)fileName, null, (file2, value2) -> {
            result2.put((Object)file2, (Collection)value2);
            return true;
        }, scope);
        return result2;
    }

    @NotNull
    public ID<String, List<FileIncludeInfoImpl>> getName() {
        return INDEX_ID;
    }

    @NotNull
    public DataIndexer<String, List<FileIncludeInfoImpl>, FileContent> getIndexer() {
        return new CompositeDataIndexer<String, List<FileIncludeInfoImpl>, Set<FileIncludeProvider>, Set<String>>(){

            @NotNull
            public Set<FileIncludeProvider> calculateSubIndexer(@NotNull IndexedFile file2) {
                return FileIncludeProvider.EP_NAME.getExtensionList().stream().filter(provider -> provider.acceptFile(file2.getFile())).collect(Collectors.toSet());
            }

            @NotNull
            public Set<String> getSubIndexerVersion(@NotNull Set<FileIncludeProvider> providers) {
                return ContainerUtil.map2Set(providers, provider -> provider.getId() + ":" + provider.getVersion());
            }

            @NotNull
            public KeyDescriptor<Set<String>> getSubIndexerVersionDescriptor() {
                return new StringSetDescriptor();
            }

            @NotNull
            public Map<String, List<FileIncludeInfoImpl>> map(@NotNull FileContent inputData, @NotNull Set<FileIncludeProvider> providers) {
                Map map2 = FactoryMap.create(key -> new ArrayList());
                for (FileIncludeProvider provider : providers) {
                    for (FileIncludeInfo info : provider.getIncludeInfos(inputData)) {
                        FileIncludeInfoImpl impl = new FileIncludeInfoImpl(info.path, info.offset, info.runtimeOnly, provider.getId());
                        ((List)map2.get(info.fileName)).add(impl);
                    }
                }
                return map2;
            }
        };
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        return EnumeratorStringDescriptor.INSTANCE;
    }

    @NotNull
    public DataExternalizer<List<FileIncludeInfoImpl>> getValueExternalizer() {
        return new DataExternalizer<List<FileIncludeInfoImpl>>(){

            public void save(@NotNull DataOutput out, List<FileIncludeInfoImpl> value2) throws IOException {
                out.writeInt(value2.size());
                for (FileIncludeInfoImpl info : value2) {
                    IOUtil.writeUTF((DataOutput)out, (String)info.path);
                    out.writeInt(info.offset);
                    out.writeBoolean(info.runtimeOnly);
                    IOUtil.writeUTF((DataOutput)out, (String)info.providerId);
                }
            }

            public List<FileIncludeInfoImpl> read(@NotNull DataInput in) throws IOException {
                int size = in.readInt();
                ArrayList<FileIncludeInfoImpl> infos = new ArrayList<FileIncludeInfoImpl>(size);
                for (int i2 = 0; i2 < size; ++i2) {
                    infos.add(new FileIncludeInfoImpl(IOUtil.readUTF((DataInput)in), in.readInt(), in.readBoolean(), IOUtil.readUTF((DataInput)in)));
                }
                return infos;
            }
        };
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new FileBasedIndex.FileTypeSpecificInputFilter(){

            public boolean acceptInput(@NotNull VirtualFile file2) {
                if (file2.getFileSystem() == JarFileSystem.getInstance()) {
                    return false;
                }
                for (FileIncludeProvider provider : FileIncludeProvider.EP_NAME.getExtensionList()) {
                    if (!provider.acceptFile(file2)) continue;
                    return true;
                }
                return false;
            }

            public void registerFileTypesUsedForIndexing(@NotNull Consumer<? super FileType> fileTypeSink) {
                for (FileIncludeProvider provider : FileIncludeProvider.EP_NAME.getExtensionList()) {
                    provider.registerFileTypesUsedForIndexing(fileTypeSink);
                }
            }
        };
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 6;
    }

    private static class StringSetDescriptor
    implements KeyDescriptor<Set<String>> {
        private StringSetDescriptor() {
        }

        public int getHashCode(Set<String> value2) {
            return value2.hashCode();
        }

        public boolean isEqual(Set<String> val1, Set<String> val2) {
            return val1.equals(val2);
        }

        public void save(@NotNull DataOutput out, Set<String> value2) throws IOException {
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value2.size());
            for (String s : value2) {
                IOUtil.writeUTF((DataOutput)out, (String)s);
            }
        }

        public Set<String> read(@NotNull DataInput in) throws IOException {
            int size = DataInputOutputUtil.readINT((DataInput)in);
            THashSet result2 = new THashSet(size);
            for (int i2 = 0; i2 < size; ++i2) {
                result2.add((Object)IOUtil.readUTF((DataInput)in));
            }
            return result2;
        }
    }
}

