/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IndexCacheManagerImpl
implements CacheManager {
    @NotNull
    private final Project myProject;

    public IndexCacheManagerImpl(@NotNull Project project) {
        this.myProject = project;
    }

    @Override
    public PsiFile @NotNull [] getFilesWithWord(@NotNull String word, short occurenceMask, @NotNull GlobalSearchScope scope, boolean caseSensitively) {
        if (this.myProject.isDefault()) {
            return PsiFile.EMPTY_ARRAY;
        }
        ArrayList result2 = new ArrayList();
        Processor processor2 = Processors.cancelableCollectProcessor(result2);
        this.processFilesWithWord((Processor<? super PsiFile>)processor2, word, occurenceMask, scope, caseSensitively);
        return result2.isEmpty() ? PsiFile.EMPTY_ARRAY : result2.toArray(PsiFile.EMPTY_ARRAY);
    }

    @Override
    public VirtualFile @NotNull [] getVirtualFilesWithWord(@NotNull String word, short occurenceMask, @NotNull GlobalSearchScope scope, boolean caseSensitively) {
        if (this.myProject.isDefault()) {
            return VirtualFile.EMPTY_ARRAY;
        }
        ArrayList result2 = new ArrayList(5);
        Processor processor2 = Processors.cancelableCollectProcessor(result2);
        FileBasedIndex.getInstance().ignoreDumbMode(() -> this.collectVirtualFilesWithWord(word, occurenceMask, scope, caseSensitively, (Processor<? super VirtualFile>)processor2), DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE);
        return result2.isEmpty() ? VirtualFile.EMPTY_ARRAY : result2.toArray(VirtualFile.EMPTY_ARRAY);
    }

    @Override
    public boolean processVirtualFilesWithAllWords(@NotNull Collection<String> words, short occurenceMask, @NotNull GlobalSearchScope scope, boolean caseSensitively, @NotNull Processor<? super VirtualFile> processor2) {
        List entries = ContainerUtil.map(words, w -> new IdIndexEntry((String)w, caseSensitively));
        return FileBasedIndex.getInstance().processFilesContainingAllKeys(IdIndex.NAME, (Collection)entries, scope, valueMask -> (occurenceMask & valueMask) != 0, processor2);
    }

    private boolean collectVirtualFilesWithWord(@NotNull String word, short occurrenceMask, @NotNull GlobalSearchScope scope, boolean caseSensitively, @NotNull Processor<? super VirtualFile> fileProcessor) {
        if (this.myProject.isDefault()) {
            return true;
        }
        try {
            return (Boolean)ReadAction.compute(() -> FileBasedIndex.getInstance().processValues(IdIndex.NAME, (Object)new IdIndexEntry(word, caseSensitively), null, (file2, value2) -> {
                ProgressIndicatorProvider.checkCanceled();
                int mask = value2;
                return (mask & occurrenceMask) == 0 || fileProcessor.process((Object)file2);
            }, scope));
        }
        catch (IndexNotReadyException e) {
            throw new ProcessCanceledException();
        }
    }

    @Override
    public boolean processFilesWithWord(final @NotNull Processor<? super PsiFile> psiFileProcessor, @NotNull String word, short occurrenceMask, @NotNull GlobalSearchScope scope, boolean caseSensitively) {
        ArrayList result2 = new ArrayList(5);
        Processor processor2 = Processors.cancelableCollectProcessor(result2);
        this.collectVirtualFilesWithWord(word, occurrenceMask, scope, caseSensitively, (Processor<? super VirtualFile>)processor2);
        if (result2.isEmpty()) {
            return true;
        }
        final PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        ReadActionProcessor<VirtualFile> virtualFileProcessor = new ReadActionProcessor<VirtualFile>(){

            public boolean processInReadAction(VirtualFile virtualFile) {
                if (virtualFile.isValid()) {
                    PsiFile psiFile = psiManager.findFile(virtualFile);
                    return psiFile == null || psiFileProcessor.process((Object)psiFile);
                }
                return true;
            }
        };
        for (VirtualFile vFile : result2) {
            ProgressIndicatorProvider.checkCanceled();
            if (virtualFileProcessor.process((Object)vFile)) continue;
            return false;
        }
        return true;
    }
}

