/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.IgnorePsiEventsMarker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiDocumentTransactionListener;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.ImmutableCharSequence;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiToDocumentSynchronizer
extends PsiTreeChangeAdapter {
    private static final Logger LOG = Logger.getInstance(PsiToDocumentSynchronizer.class);
    private static final Key<Boolean> PSI_DOCUMENT_ATOMIC_ACTION = Key.create((String)"PSI_DOCUMENT_ATOMIC_ACTION");
    private final PsiDocumentManagerBase myPsiDocumentManager;
    private final MessageBus myBus;
    private final Map<Document, Pair<DocumentChangeTransaction, Integer>> myTransactionsMap = new ConcurrentHashMap<Document, Pair<DocumentChangeTransaction, Integer>>();
    private volatile Document mySyncDocument;
    private boolean myIgnorePsiEvents;

    PsiToDocumentSynchronizer(@NotNull PsiDocumentManagerBase psiDocumentManager, @NotNull MessageBus bus) {
        this.myPsiDocumentManager = psiDocumentManager;
        this.myBus = bus;
    }

    @Nullable
    public DocumentChangeTransaction getTransaction(@NotNull Document document) {
        Pair<DocumentChangeTransaction, Integer> pair = this.myTransactionsMap.get(document);
        return (DocumentChangeTransaction)Pair.getFirst(pair);
    }

    public boolean isInSynchronization(@NotNull Document document) {
        return this.mySyncDocument == document;
    }

    void cleanupForNextTest() {
        this.myTransactionsMap.clear();
        this.mySyncDocument = null;
    }

    private void checkPsiModificationAllowed(@NotNull PsiTreeChangeEvent event) {
        if (!this.toProcessPsiEvent()) {
            return;
        }
        PsiFile psiFile = event.getFile();
        if (!(psiFile instanceof PsiFileEx) || !((PsiFileEx)psiFile).isContentsLoaded()) {
            return;
        }
        Document document = this.myPsiDocumentManager.getCachedDocument(psiFile);
        if (document != null && this.myPsiDocumentManager.isUncommited(document)) {
            throw new IllegalStateException("Attempt to modify PSI for non-committed Document!");
        }
    }

    private DocumentEx getCachedDocument(PsiFile psiFile, boolean force) {
        DocumentEx document = (DocumentEx)this.myPsiDocumentManager.getCachedDocument(psiFile);
        if (document == null || document instanceof DocumentWindow || !force && this.getTransaction(document) == null) {
            return null;
        }
        return document;
    }

    private void doSync(@NotNull PsiTreeChangeEvent event, boolean force, @NotNull DocSyncAction syncAction) {
        if (!this.toProcessPsiEvent()) {
            return;
        }
        PsiFile psiFile = event.getFile();
        if (!(psiFile instanceof PsiFileEx) || !((PsiFileEx)psiFile).isContentsLoaded()) {
            return;
        }
        DocumentEx document = this.getCachedDocument(psiFile, force);
        if (document == null) {
            return;
        }
        PsiToDocumentSynchronizer.performAtomically(psiFile, () -> syncAction.syncDocument(document, (PsiTreeChangeEventImpl)event));
        boolean insideTransaction = this.myTransactionsMap.containsKey(document);
        if (!insideTransaction) {
            document.setModificationStamp(psiFile.getViewProvider().getModificationStamp());
        }
    }

    static boolean isInsideAtomicChange(@NotNull PsiFile file2) {
        return file2.getUserData(PSI_DOCUMENT_ATOMIC_ACTION) == Boolean.TRUE;
    }

    public static void performAtomically(@NotNull PsiFile file2, @NotNull Runnable runnable2) {
        PsiUtilCore.ensureValid((PsiElement)file2);
        assert (!PsiToDocumentSynchronizer.isInsideAtomicChange(file2));
        file2.putUserData(PSI_DOCUMENT_ATOMIC_ACTION, (Object)Boolean.TRUE);
        try {
            runnable2.run();
        }
        finally {
            file2.putUserData(PSI_DOCUMENT_ATOMIC_ACTION, null);
        }
    }

    public void beforeChildAddition(@NotNull PsiTreeChangeEvent event) {
        this.checkPsiModificationAllowed(event);
    }

    public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
        this.checkPsiModificationAllowed(event);
    }

    public void beforeChildReplacement(@NotNull PsiTreeChangeEvent event) {
        this.checkPsiModificationAllowed(event);
    }

    public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
        this.checkPsiModificationAllowed(event);
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        if (!(event.getChild() instanceof ForeignLeafPsiElement)) {
            this.doSync(event, false, (document, event1) -> this.insertString(document, event1.getOffset(), event1.getChild().getText()));
        }
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        if (!(event.getChild() instanceof ForeignLeafPsiElement)) {
            this.doSync(event, false, (document, event1) -> this.deleteString(document, event1.getOffset(), event1.getOffset() + event1.getOldLength()));
        }
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        this.doSync(event, false, (document, event1) -> {
            int oldLength = event1.getOldChild() instanceof ForeignLeafPsiElement ? 0 : event1.getOldLength();
            String newText = event1.getNewChild() instanceof ForeignLeafPsiElement ? "" : event1.getNewChild().getText();
            this.replaceString(document, event1.getOffset(), event1.getOffset() + oldLength, newText, event1.getNewChild());
        });
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        this.doSync(event, false, (document, event1) -> this.replaceString(document, event1.getOffset(), event1.getOffset() + event1.getOldLength(), event1.getParent().getText(), event1.getParent()));
    }

    public void setIgnorePsiEvents(boolean ignorePsiEvents) {
        this.myIgnorePsiEvents = ignorePsiEvents;
    }

    public boolean isIgnorePsiEvents() {
        return this.myIgnorePsiEvents;
    }

    public boolean toProcessPsiEvent() {
        return !this.myIgnorePsiEvents && !this.myPsiDocumentManager.isCommitInProgress() && !ApplicationManager.getApplication().hasWriteAction(IgnorePsiEventsMarker.class);
    }

    public void replaceString(@NotNull Document document, int startOffset, int endOffset, @NotNull String s) {
        this.replaceString(document, startOffset, endOffset, s, null);
    }

    private void replaceString(@NotNull Document document, int startOffset, int endOffset, @NotNull String s, @Nullable PsiElement replacement) {
        DocumentChangeTransaction documentChangeTransaction = this.getTransaction(document);
        if (documentChangeTransaction != null) {
            documentChangeTransaction.replace(startOffset, endOffset - startOffset, s, replacement);
        }
    }

    public void insertString(@NotNull Document document, int offset, @NotNull String s) {
        DocumentChangeTransaction documentChangeTransaction = this.getTransaction(document);
        if (documentChangeTransaction != null) {
            documentChangeTransaction.replace(offset, 0, s, null);
        }
    }

    private void deleteString(@NotNull Document document, int startOffset, int endOffset) {
        DocumentChangeTransaction documentChangeTransaction = this.getTransaction(document);
        if (documentChangeTransaction != null) {
            documentChangeTransaction.replace(startOffset, endOffset - startOffset, "", null);
        }
    }

    public void startTransaction(@NotNull Project project, @NotNull Document doc, @NotNull PsiElement scope) {
        Pair pair;
        LOG.assertTrue(!project.isDisposed());
        Pair prev = pair = this.myTransactionsMap.get(doc);
        if (pair == null) {
            PsiFile psiFile = scope.getContainingFile();
            pair = new Pair((Object)new DocumentChangeTransaction(doc, psiFile), (Object)0);
            ((PsiDocumentTransactionListener)this.myBus.syncPublisher(PsiDocumentTransactionListener.TOPIC)).transactionStarted(doc, psiFile);
        } else {
            pair = new Pair(pair.getFirst(), (Object)((Integer)pair.getSecond() + 1));
        }
        LOG.assertTrue(this.myTransactionsMap.put(doc, (Pair<DocumentChangeTransaction, Integer>)pair) == prev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commitTransaction(@NotNull Document document) {
        ApplicationManager.getApplication().assertIsWriteThread();
        DocumentChangeTransaction documentChangeTransaction = this.removeTransaction(document);
        if (documentChangeTransaction == null) {
            return false;
        }
        PsiFile changeScope = documentChangeTransaction.myChangeScope;
        try {
            this.mySyncDocument = document;
            PsiTreeChangeEventImpl fakeEvent = new PsiTreeChangeEventImpl(changeScope.getManager());
            fakeEvent.setParent((PsiElement)changeScope);
            fakeEvent.setFile(changeScope);
            this.checkPsiModificationAllowed(fakeEvent);
            this.doSync(fakeEvent, true, (document1, event) -> PsiToDocumentSynchronizer.doCommitTransaction(document1, documentChangeTransaction));
            ((PsiDocumentTransactionListener)this.myBus.syncPublisher(PsiDocumentTransactionListener.TOPIC)).transactionCompleted(document, changeScope);
        }
        catch (Throwable e) {
            this.myPsiDocumentManager.forceReload(changeScope.getViewProvider().getVirtualFile(), changeScope.getViewProvider());
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)e);
        }
        finally {
            this.mySyncDocument = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCommitTransaction(@NotNull Document document, @NotNull DocumentChangeTransaction documentChangeTransaction) {
        DocumentEx ex = (DocumentEx)document;
        ex.suppressGuardedExceptions();
        try {
            boolean isReadOnly = !document.isWritable();
            ex.setReadOnly(false);
            for (Map.Entry entry : documentChangeTransaction.myAffectedFragments.descendingMap().entrySet()) {
                ex.replaceString(((TextRange)entry.getKey()).getStartOffset(), ((TextRange)entry.getKey()).getEndOffset(), (CharSequence)entry.getValue());
            }
            ex.setReadOnly(isReadOnly);
        }
        finally {
            ex.unSuppressGuardedExceptions();
        }
    }

    @Nullable
    private DocumentChangeTransaction removeTransaction(@NotNull Document doc) {
        Pair pair = this.myTransactionsMap.get(doc);
        if (pair == null) {
            return null;
        }
        int nestedCount = (Integer)pair.getSecond();
        if (nestedCount > 0) {
            pair = Pair.create((Object)pair.getFirst(), (Object)(nestedCount - 1));
            this.myTransactionsMap.put(doc, (Pair<DocumentChangeTransaction, Integer>)pair);
            return null;
        }
        this.myTransactionsMap.remove(doc);
        return (DocumentChangeTransaction)pair.getFirst();
    }

    public boolean isDocumentAffectedByTransactions(@NotNull Document document) {
        return this.myTransactionsMap.containsKey(document);
    }

    public static class DocumentChangeTransaction {
        private final TreeMap<TextRange, CharSequence> myAffectedFragments = new TreeMap(Comparator.comparingInt(TextRange::getStartOffset));
        private final PsiFile myChangeScope;
        private ImmutableCharSequence myPsiText;

        DocumentChangeTransaction(@NotNull Document doc, @NotNull PsiFile scope) {
            this.myChangeScope = scope;
            this.myPsiText = CharArrayUtil.createImmutableCharSequence((CharSequence)doc.getImmutableCharSequence());
        }

        @NotNull
        public Map<TextRange, CharSequence> getAffectedFragments() {
            return this.myAffectedFragments;
        }

        public void replace(int psiStart, int length, @NotNull String replace, @Nullable PsiElement replacement) {
            int newEndInReplace;
            int newStartInReplace;
            int start2 = 0;
            int end = start2 + length;
            CharSequence chars = this.myPsiText.subSequence(psiStart, psiStart + length);
            if (StringUtil.equals((CharSequence)chars, (CharSequence)replace)) {
                return;
            }
            int replaceLength = replace.length();
            for (newStartInReplace = 0; newStartInReplace < replaceLength && start2 < end && replace.charAt(newStartInReplace) == chars.charAt(start2); ++start2, ++newStartInReplace) {
            }
            for (newEndInReplace = replaceLength; start2 < end && newStartInReplace < newEndInReplace && replace.charAt(newEndInReplace - 1) == chars.charAt(end - 1); --newEndInReplace, --end) {
            }
            if (replacement != null && (newStartInReplace > 0 || newEndInReplace < replaceLength)) {
                PsiElement startLeaf = replacement.findElementAt(newStartInReplace);
                PsiElement endLeaf = replacement.findElementAt(newEndInReplace - 1);
                if (startLeaf != null && endLeaf != null) {
                    int leafStart = startLeaf.getTextRange().getStartOffset() - replacement.getTextRange().getStartOffset();
                    int leafEnd = endLeaf.getTextRange().getEndOffset() - replacement.getTextRange().getStartOffset();
                    start2 += leafStart - newStartInReplace;
                    end += leafEnd - newEndInReplace;
                    newStartInReplace = leafStart;
                    newEndInReplace = leafEnd;
                }
            }
            if (newStartInReplace == newEndInReplace && start2 > 0 && start2 < end && StringUtil.indexOf((CharSequence)chars, (char)'\n', (int)start2, (int)end) != -1) {
                while (start2 > 0 && newStartInReplace > 0 && chars.charAt(start2 - 1) == chars.charAt(end - 1) && chars.charAt(end - 1) != '\n') {
                    --start2;
                    --end;
                    --newStartInReplace;
                    --newEndInReplace;
                }
            }
            start2 += psiStart;
            end += psiStart;
            ImmutableCharSequence charsSequence = this.myPsiText;
            while (start2 < charsSequence.length() && end < charsSequence.length() && start2 > 0 && charsSequence.subSequence(start2, end).toString().endsWith("><") && charsSequence.charAt(start2 - 1) == '<') {
                --start2;
                --newStartInReplace;
                --end;
                --newEndInReplace;
            }
            this.updateFragments(start2, end, replace.substring(newStartInReplace, newEndInReplace));
        }

        private void updateFragments(int start2, int end, @NotNull String replace) {
            int docStart = this.psiToDocumentOffset(start2);
            int docEnd = this.psiToDocumentOffset(end);
            TextRange startRange = this.findFragment(docStart);
            TextRange endRange = this.findFragment(docEnd);
            this.myPsiText = this.myPsiText.delete(start2, end).insert(start2, (CharSequence)replace);
            TextRange newFragment = new TextRange(startRange != null ? startRange.getStartOffset() : docStart, endRange != null ? endRange.getEndOffset() : docEnd);
            CharSequence newReplacement = this.myPsiText.subSequence(this.documentToPsiOffset(newFragment.getStartOffset(), false), this.documentToPsiOffset(newFragment.getEndOffset(), true) + replace.length() - (end - start2));
            this.myAffectedFragments.keySet().removeIf(range2 -> range2.intersects(newFragment));
            this.myAffectedFragments.put(newFragment, newReplacement);
        }

        private TextRange findFragment(int docOffset) {
            return (TextRange)ContainerUtil.find(this.myAffectedFragments.keySet(), range2 -> range2.containsOffset(docOffset));
        }

        private int psiToDocumentOffset(int offset) {
            for (Map.Entry<TextRange, CharSequence> entry : this.myAffectedFragments.entrySet()) {
                int lengthAfter = entry.getValue().length();
                TextRange range2 = entry.getKey();
                if (range2.getStartOffset() + lengthAfter < offset) {
                    offset += range2.getLength() - lengthAfter;
                    continue;
                }
                return Math.min(range2.getStartOffset(), offset);
            }
            return offset;
        }

        private int documentToPsiOffset(int offset, boolean greedyRight) {
            int delta = 0;
            for (Map.Entry<TextRange, CharSequence> entry : this.myAffectedFragments.entrySet()) {
                int lengthAfter = entry.getValue().length();
                TextRange range2 = entry.getKey();
                if (range2.containsOffset(offset)) {
                    return range2.getStartOffset() + delta + (greedyRight ? lengthAfter : 0);
                }
                if (range2.getStartOffset() > offset) break;
                delta += lengthAfter - range2.getLength();
            }
            return offset + delta;
        }
    }

    @FunctionalInterface
    private static interface DocSyncAction {
        public void syncDocument(@NotNull Document var1, @NotNull PsiTreeChangeEventImpl var2);
    }
}

