/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.util.StandardProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.BlockSupportImpl;
import com.intellij.psi.impl.BooleanRunnable;
import com.intellij.psi.impl.ChangedPsiRangeUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DiffLog;
import com.intellij.psi.impl.DocumentCommitProcessor;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.text.BlockSupport;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public final class DocumentCommitThread
implements Disposable,
DocumentCommitProcessor {
    private static final Logger LOG = Logger.getInstance(DocumentCommitThread.class);
    private static final String SYNC_COMMIT_REASON = "Sync commit";
    private final ExecutorService executor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Document Committing Pool", (Executor)PooledThreadExecutor.INSTANCE, (int)1, (Disposable)this);
    private volatile boolean isDisposed;

    static DocumentCommitThread getInstance() {
        return (DocumentCommitThread)ServiceManager.getService(DocumentCommitProcessor.class);
    }

    DocumentCommitThread() {
    }

    public void dispose() {
        this.isDisposed = true;
    }

    @Override
    public void commitAsynchronously(@NotNull Project project, @NotNull Document document, @NonNls @NotNull Object reason, @NotNull ModalityState modality) {
        assert (!this.isDisposed) : "already disposed";
        if (!project.isInitialized()) {
            return;
        }
        PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)project);
        assert (documentManager.isEventSystemEnabled(document)) : "Asynchronous commit is only supported for physical PSI";
        TransactionGuard.getInstance().assertWriteSafeContext(modality);
        PsiFile psiFile = documentManager.getCachedPsiFile(document);
        if (psiFile == null || psiFile instanceof PsiCompiledElement) {
            return;
        }
        CommitTask task2 = new CommitTask(project, document, reason, modality, documentManager.getLastCommittedText(document));
        ReadAction.nonBlocking(() -> this.commitUnderProgress(task2, false)).expireWhen(() -> project.isDisposed() || this.isDisposed || !documentManager.isInUncommittedSet(document) || !task2.isStillValid()).coalesceBy(new Object[]{task2}).finishOnUiThread(modality, Runnable::run).submit((Executor)this.executor);
    }

    private void log(Project project, @NonNls String msg, @Nullable CommitTask task2, Object ... args) {
    }

    @Override
    public void commitSynchronously(@NotNull Document document, @NotNull Project project, @NotNull PsiFile psiFile) {
        assert (!this.isDisposed);
        if (!project.isInitialized() && !project.isDefault()) {
            String s = project + "; Disposed: " + project.isDisposed() + "; Open: " + project.isOpen();
            try {
                Disposer.dispose((Disposable)project);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new RuntimeException(s);
        }
        CommitTask task2 = new CommitTask(project, document, SYNC_COMMIT_REASON, ModalityState.defaultModalityState(), PsiDocumentManager.getInstance((Project)project).getLastCommittedText(document));
        this.commitUnderProgress(task2, true).run();
    }

    @NotNull
    private Runnable commitUnderProgress(@NotNull CommitTask task2, boolean synchronously) {
        Document document = task2.getDocument();
        Project project = task2.project;
        PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)project);
        SmartList finishProcessors = new SmartList();
        SmartList reparseInjectedProcessors = new SmartList();
        FileViewProvider viewProvider = documentManager.getCachedViewProvider(document);
        if (viewProvider == null) {
            finishProcessors.add(this.handleCommitWithoutPsi(documentManager, task2));
        } else {
            for (PsiFile file2 : viewProvider.getAllFiles()) {
                FileASTNode oldFileNode = file2.getNode();
                ProperTextRange changedPsiRange = ChangedPsiRangeUtil.getChangedPsiRange(file2, task2.document, task2.myLastCommittedText, document.getImmutableCharSequence());
                if (changedPsiRange == null) continue;
                BooleanRunnable finishProcessor = DocumentCommitThread.doCommit(task2, file2, oldFileNode, changedPsiRange, (List<? super BooleanRunnable>)reparseInjectedProcessors);
                finishProcessors.add(finishProcessor);
            }
        }
        return this.createFinishCommitRunnable(task2, synchronously, (List<? extends BooleanRunnable>)finishProcessors, (List<? extends BooleanRunnable>)reparseInjectedProcessors);
    }

    @NotNull
    private Runnable createFinishCommitRunnable(@NotNull CommitTask task2, boolean synchronously, @NotNull List<? extends BooleanRunnable> finishProcessors, @NotNull List<? extends BooleanRunnable> reparseInjectedProcessors) {
        return () -> {
            Document document = task2.getDocument();
            Project project = task2.project;
            if (project.isDisposed()) {
                return;
            }
            PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)project);
            if (documentManager.isEventSystemEnabled(document)) {
                ApplicationManager.getApplication().assertIsWriteThread();
            }
            boolean success = documentManager.finishCommit(document, finishProcessors, reparseInjectedProcessors, synchronously, task2.reason);
            if (synchronously) assert (success);
            if (synchronously || success) assert (!documentManager.isInUncommittedSet(document));
            if (success) {
                this.log(project, "Commit finished", task2, new Object[0]);
            } else {
                this.commitAsynchronously(project, document, "Re-added back", task2.myCreationModality);
            }
        };
    }

    @NotNull
    private BooleanRunnable handleCommitWithoutPsi(@NotNull PsiDocumentManagerBase documentManager, @NotNull CommitTask task2) {
        return () -> {
            this.log(task2.project, "Finishing without PSI", task2, new Object[0]);
            Document document = task2.getDocument();
            if (!task2.isStillValid() || documentManager.getCachedViewProvider(document) != null) {
                return false;
            }
            documentManager.handleCommitWithoutPsi(document);
            return true;
        };
    }

    public String toString() {
        return "Document commit thread; application: " + ApplicationManager.getApplication() + "; isDisposed: " + this.isDisposed;
    }

    public void waitForAllCommits(long timeout, @NotNull TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        ApplicationManager.getApplication().assertIsWriteThread();
        assert (!ApplicationManager.getApplication().isWriteAccessAllowed());
        UIUtil.dispatchAllInvocationEvents();
        while (!((BoundedTaskExecutor)this.executor).isEmpty()) {
            ((BoundedTaskExecutor)this.executor).waitAllTasksExecuted(timeout, timeUnit);
            UIUtil.dispatchAllInvocationEvents();
        }
    }

    @NotNull
    private static BooleanRunnable doCommit(@NotNull CommitTask task2, @NotNull PsiFile file2, @NotNull FileASTNode oldFileNode, @NotNull ProperTextRange changedPsiRange, @NotNull List<? super BooleanRunnable> outReparseInjectedProcessors) {
        DiffLog diffLog;
        Document document = task2.getDocument();
        CharSequence newDocumentText = document.getImmutableCharSequence();
        Boolean data2 = (Boolean)document.getUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY);
        if (data2 != null) {
            document.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, null);
            file2.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, (Object)data2);
        }
        PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)task2.project);
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (indicator == null) {
            indicator = new EmptyProgressIndicator();
        }
        try {
            BlockSupportImpl.ReparseResult result2 = BlockSupportImpl.reparse(file2, oldFileNode, (TextRange)changedPsiRange, newDocumentText, indicator, task2.myLastCommittedText);
            diffLog = result2.log;
            List<BooleanRunnable> injectedRunnables = documentManager.reparseChangedInjectedFragments(document, file2, (TextRange)changedPsiRange, indicator, result2.oldRoot, result2.newRoot);
            outReparseInjectedProcessors.addAll(injectedRunnables);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return () -> {
                documentManager.forceReload(file2.getViewProvider().getVirtualFile(), file2.getViewProvider());
                return true;
            };
        }
        return () -> {
            FileViewProvider viewProvider = file2.getViewProvider();
            if (!task2.isStillValid() || documentManager.getCachedViewProvider(document) != viewProvider) {
                return false;
            }
            if (!ApplicationManager.getApplication().isWriteAccessAllowed() && documentManager.isEventSystemEnabled(document)) {
                VirtualFile vFile = viewProvider.getVirtualFile();
                LOG.error("Write action expected; document=" + document + "; file=" + file2 + " of " + file2.getClass() + "; file.valid=" + file2.isValid() + "; file.eventSystemEnabled=" + viewProvider.isEventSystemEnabled() + "; viewProvider=" + viewProvider + " of " + viewProvider.getClass() + "; language=" + file2.getLanguage() + "; vFile=" + vFile + " of " + vFile.getClass() + "; free-threaded=" + AbstractFileViewProvider.isFreeThreaded(viewProvider));
            }
            diffLog.doActualPsiChange(file2);
            DocumentCommitThread.assertAfterCommit(document, file2, (FileElement)oldFileNode);
            return true;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertAfterCommit(@NotNull Document document, @NotNull PsiFile file2, @NotNull FileElement oldFileNode) {
        if (oldFileNode.getTextLength() != document.getTextLength()) {
            String documentText = document.getText();
            String fileText = file2.getText();
            boolean sameText = Objects.equals(fileText, documentText);
            String errorMessage = "commitDocument() left PSI inconsistent: " + DebugUtil.diagnosePsiDocumentInconsistency((PsiElement)file2, document) + "; node.length=" + oldFileNode.getTextLength() + "; doc.text" + (sameText ? "==" : "!=") + "file.text; file name:" + file2.getName() + "; type:" + file2.getFileType() + "; lang:" + file2.getLanguage();
            PluginException.logPluginError((Logger)LOG, (String)errorMessage, null, file2.getLanguage().getClass());
            file2.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, (Object)Boolean.TRUE);
            try {
                BlockSupport blockSupport = BlockSupport.getInstance(file2.getProject());
                DiffLog diffLog = blockSupport.reparseRange(file2, file2.getNode(), new TextRange(0, documentText.length()), documentText, new StandardProgressIndicatorBase(), oldFileNode.getText());
                diffLog.doActualPsiChange(file2);
                if (oldFileNode.getTextLength() != document.getTextLength()) {
                    PluginException.logPluginError((Logger)LOG, (String)("PSI is broken beyond repair in: " + file2), null, file2.getLanguage().getClass());
                }
            }
            finally {
                file2.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, null);
            }
        }
    }

    private static class CommitTask {
        @NotNull
        private final Document document;
        @NotNull
        final Project project;
        private final int modificationSequence;
        @NotNull
        final Object reason;
        @NotNull
        final ModalityState myCreationModality;
        private final CharSequence myLastCommittedText;

        CommitTask(@NotNull Project project, @NotNull Document document, @NotNull Object reason, @NotNull ModalityState modality, @NotNull CharSequence lastCommittedText) {
            this.document = document;
            this.project = project;
            this.reason = reason;
            this.myCreationModality = modality;
            this.myLastCommittedText = lastCommittedText;
            this.modificationSequence = ((DocumentEx)document).getModificationSequence();
        }

        @NonNls
        public String toString() {
            Document document = this.getDocument();
            String reasonInfo = " task reason: " + StringUtil.first((String)String.valueOf(this.reason), (int)180, (boolean)true) + (this.isStillValid() ? "" : "; changed: old seq=" + this.modificationSequence + ", new seq=" + ((DocumentEx)document).getModificationSequence());
            String contextInfo = " modality: " + this.myCreationModality;
            return System.identityHashCode(this) + "; " + contextInfo + reasonInfo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CommitTask)) {
                return false;
            }
            CommitTask task2 = (CommitTask)o;
            return Comparing.equal((Object)this.getDocument(), (Object)task2.getDocument()) && this.project.equals(task2.project);
        }

        public int hashCode() {
            int result2 = this.getDocument().hashCode();
            result2 = 31 * result2 + this.project.hashCode();
            return result2;
        }

        boolean isStillValid() {
            Document document = this.getDocument();
            return ((DocumentEx)document).getModificationSequence() == this.modificationSequence;
        }

        @NotNull
        Document getDocument() {
            return this.document;
        }
    }
}

