/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.core.CoreBundle;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public final class CheckUtil {
    private CheckUtil() {
    }

    public static void checkWritable(@NotNull PsiElement element2) throws IncorrectOperationException {
        if (!element2.isWritable()) {
            if (element2 instanceof PsiDirectory) {
                String url = ((PsiDirectory)element2).getVirtualFile().getPresentableUrl();
                throw new IncorrectOperationException(CoreBundle.message((String)"cannot.modify.a.read.only.directory", (Object[])new Object[]{url}));
            }
            PsiFile file2 = element2.getContainingFile();
            if (file2 == null) {
                throw new IncorrectOperationException();
            }
            VirtualFile virtualFile = file2.getVirtualFile();
            if (virtualFile == null) {
                throw new IncorrectOperationException();
            }
            throw new IncorrectOperationException(CoreBundle.message((String)"cannot.modify.a.read.only.file", (Object[])new Object[]{virtualFile.getPresentableUrl()}));
        }
    }

    public static void checkDelete(@NotNull VirtualFile file2) throws IncorrectOperationException {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS}){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (FileTypeRegistry.getInstance().isFileIgnored(file2)) {
                    return false;
                }
                if (!file2.isWritable()) {
                    throw new IncorrectOperationException(CoreBundle.message((String)"cannot.delete.a.read.only.file", (Object[])new Object[]{file2.getPresentableUrl()}));
                }
                return true;
            }
        });
    }
}

