/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.autodetect;

import com.intellij.psi.codeStyle.autodetect.IndentUsageInfo;
import com.intellij.psi.codeStyle.autodetect.IndentUsageStatistics;
import com.intellij.psi.codeStyle.autodetect.LineIndentInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntIntIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IndentUsageStatisticsImpl
implements IndentUsageStatistics {
    private static final Comparator<IndentUsageInfo> DECREASING_ORDER = (o1, o2) -> Integer.compare(o2.getTimesUsed(), o1.getTimesUsed());
    private final List<? extends LineIndentInfo> myLineInfos;
    private int myPreviousLineIndent;
    private int myPreviousRelativeIndent;
    private int myTotalLinesWithTabs = 0;
    private int myTotalLinesWithWhiteSpaces = 0;
    private final TIntIntHashMap myIndentToUsagesMap = new TIntIntHashMap();
    private List<IndentUsageInfo> myIndentUsages = new ArrayList<IndentUsageInfo>();
    private final Stack<IndentData> myParentIndents = new Stack((Object[])new IndentData[]{new IndentData(0, 0)});

    public IndentUsageStatisticsImpl(@NotNull List<? extends LineIndentInfo> lineInfos) {
        this.myLineInfos = lineInfos;
        this.buildIndentToUsagesMap();
        this.myIndentUsages = IndentUsageStatisticsImpl.toIndentUsageList(this.myIndentToUsagesMap);
        ContainerUtil.sort(this.myIndentUsages, DECREASING_ORDER);
    }

    @NotNull
    private static List<IndentUsageInfo> toIndentUsageList(@NotNull TIntIntHashMap indentToUsages) {
        ArrayList<IndentUsageInfo> indentUsageInfos = new ArrayList<IndentUsageInfo>();
        TIntIntIterator it = indentToUsages.iterator();
        while (it.hasNext()) {
            it.advance();
            indentUsageInfos.add(new IndentUsageInfo(it.key(), it.value()));
        }
        return indentUsageInfos;
    }

    public void buildIndentToUsagesMap() {
        this.myPreviousLineIndent = 0;
        this.myPreviousRelativeIndent = 0;
        for (LineIndentInfo lineIndentInfo : this.myLineInfos) {
            if (lineIndentInfo.isLineWithTabs()) {
                ++this.myTotalLinesWithTabs;
                continue;
            }
            if (!lineIndentInfo.isLineWithNormalIndent()) continue;
            this.handleNormalIndent(lineIndentInfo.getIndentSize());
        }
    }

    @NotNull
    private IndentData findParentIndent(int indent) {
        while (this.myParentIndents.size() != 1 && ((IndentData)this.myParentIndents.peek()).indent > indent) {
            this.myParentIndents.pop();
        }
        return (IndentData)this.myParentIndents.peek();
    }

    private void handleNormalIndent(int currentIndent) {
        int relativeIndent = currentIndent - this.myPreviousLineIndent;
        if (relativeIndent < 0) {
            IndentData indentData = this.findParentIndent(currentIndent);
            this.myPreviousLineIndent = indentData.indent;
            this.myPreviousRelativeIndent = indentData.relativeIndent;
            relativeIndent = currentIndent - this.myPreviousLineIndent;
        }
        if (relativeIndent == 0) {
            relativeIndent = this.myPreviousRelativeIndent;
        } else {
            this.myParentIndents.push((Object)new IndentData(currentIndent, relativeIndent));
        }
        this.increaseIndentUsage(relativeIndent);
        this.myPreviousRelativeIndent = relativeIndent;
        this.myPreviousLineIndent = currentIndent;
        if (currentIndent > 0) {
            ++this.myTotalLinesWithWhiteSpaces;
        }
    }

    private void increaseIndentUsage(int relativeIndent) {
        int timesUsed = this.myIndentToUsagesMap.get(relativeIndent);
        this.myIndentToUsagesMap.put(relativeIndent, ++timesUsed);
    }

    public int getTotalLinesWithLeadingTabs() {
        return this.myTotalLinesWithTabs;
    }

    public int getTotalLinesWithLeadingSpaces() {
        return this.myTotalLinesWithWhiteSpaces;
    }

    public IndentUsageInfo getKMostUsedIndentInfo(int k) {
        return this.myIndentUsages.get(k);
    }

    public int getTimesIndentUsed(int indent) {
        return this.myIndentToUsagesMap.get(indent);
    }

    public int getTotalIndentSizesDetected() {
        return this.myIndentToUsagesMap.size();
    }

    private static class IndentData {
        public final int indent;
        public final int relativeIndent;

        IndentData(int indent, int relativeIndent) {
            this.indent = indent;
            this.relativeIndent = relativeIndent;
        }
    }
}

