/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.psi.codeStyle.SequentialTaskWithFixedIterationsNumber;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class CompositeSequentialTask
implements SequentialTask {
    private final List<SequentialTaskWithFixedIterationsNumber> myUnfinishedTasks = new ArrayList<SequentialTaskWithFixedIterationsNumber>();
    private SequentialTask myCurrentTask = null;
    private int myIterationsFinished;
    private int myTotalIterations = 0;
    private final SequentialModalProgressTask myProgressTask;
    private String myProgressText;
    private String myProgressText2;

    CompositeSequentialTask(@NotNull SequentialModalProgressTask progressTask2) {
        this.myProgressTask = progressTask2;
    }

    public void addTask(@NotNull SequentialTaskWithFixedIterationsNumber task2) {
        this.myUnfinishedTasks.add(task2);
        this.myTotalIterations += task2.getTotalIterationsNumber();
    }

    public void setProgressText(@NotNull String progressText) {
        this.myProgressText = progressText;
    }

    public boolean isDone() {
        return this.myCurrentTask == null && this.myUnfinishedTasks.size() == 0;
    }

    public boolean iteration() {
        this.popUntilCurrentTaskUnfinishedOrNull();
        if (this.myCurrentTask != null) {
            ProgressIndicator indicator = this.myProgressTask.getIndicator();
            if (indicator != null) {
                if (this.myProgressText != null) {
                    indicator.setText(this.myProgressText);
                }
                if (this.myProgressText2 != null) {
                    indicator.setText2(this.myProgressText2);
                }
                indicator.setFraction((double)this.myIterationsFinished++ / (double)this.myTotalIterations);
            }
            this.myCurrentTask.iteration();
        }
        return true;
    }

    private void popUntilCurrentTaskUnfinishedOrNull() {
        if (this.myCurrentTask != null) {
            if (!this.myCurrentTask.isDone()) {
                return;
            }
            this.myCurrentTask = null;
            this.popUntilCurrentTaskUnfinishedOrNull();
        } else if (this.myUnfinishedTasks.size() > 0) {
            this.myCurrentTask = this.myUnfinishedTasks.get(0);
            this.myUnfinishedTasks.remove(0);
            this.popUntilCurrentTaskUnfinishedOrNull();
        }
    }

    public void stop() {
        if (this.myCurrentTask != null) {
            this.myCurrentTask.stop();
        }
        for (SequentialTaskWithFixedIterationsNumber task2 : this.myUnfinishedTasks) {
            task2.stop();
        }
    }

    public void setProgressText2(String progressText2) {
        this.myProgressText2 = progressText2;
    }
}

