/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.application.options.CodeStyle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.util.projectWizard.ExistingModuleLoader;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectTemplateParameterFactory;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.util.projectWizard.WizardInputField;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.platform.templates.ArchivedProjectTemplate;
import com.intellij.platform.templates.LocalArchivedTemplate;
import com.intellij.platform.templates.SaveProjectAsTemplateAction;
import com.intellij.platform.templates.github.ZipUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.zip.ZipInputStream;
import javax.swing.Icon;
import org.apache.velocity.exception.VelocityException;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateModuleBuilder
extends ModuleBuilder {
    private static final Logger LOG = Logger.getInstance(TemplateModuleBuilder.class);
    private final ModuleType<?> myType;
    private final List<WizardInputField<?>> myAdditionalFields;
    private final ArchivedProjectTemplate myTemplate;
    private boolean myProjectMode;

    public TemplateModuleBuilder(ArchivedProjectTemplate template, ModuleType<?> moduleType, @NotNull List<WizardInputField<?>> additionalFields) {
        this.myTemplate = template;
        this.myType = moduleType;
        this.myAdditionalFields = additionalFields;
    }

    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        ModuleBuilder builder2 = this.myType.createModuleBuilder();
        return builder2.createWizardSteps(wizardContext, modulesProvider);
    }

    public ModuleWizardStep[] createFinishingSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        ModuleBuilder builder2 = this.myType.createModuleBuilder();
        return builder2.createFinishingSteps(wizardContext, modulesProvider);
    }

    @NotNull
    protected List<WizardInputField<?>> getAdditionalFields() {
        return this.myAdditionalFields;
    }

    public Module commitModule(@NotNull Project project, ModifiableModuleModel model) {
        if (this.myProjectMode) {
            Module[] modules2 = ModuleManager.getInstance((Project)project).getModules();
            if (modules2.length > 0) {
                Module module = modules2[0];
                ApplicationManager.getApplication().runWriteAction(() -> {
                    try {
                        this.setupModule(module);
                    }
                    catch (ConfigurationException e) {
                        LOG.error((Throwable)e);
                    }
                });
                StartupManager.getInstance((Project)project).registerPostStartupActivity(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                    try {
                        ModifiableModuleModel modifiableModuleModel = ModuleManager.getInstance((Project)project).getModifiableModel();
                        modifiableModuleModel.renameModule(module, module.getProject().getName());
                        modifiableModuleModel.commit();
                        this.fixModuleName(module);
                    }
                    catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
                        // empty catch block
                    }
                }));
                return module;
            }
            return null;
        }
        return super.commitModule(project, model);
    }

    @NotNull
    public String getBuilderId() {
        return this.myTemplate.getName();
    }

    public ModuleType<?> getModuleType() {
        return this.myType;
    }

    public Icon getNodeIcon() {
        return this.myTemplate.getIcon();
    }

    public boolean isTemplateBased() {
        return true;
    }

    @NotNull
    public Module createModule(@NotNull ModifiableModuleModel moduleModel) throws InvalidDataException, IOException, ModuleWithNameAlreadyExists, JDOMException, ConfigurationException {
        String path = this.getContentEntryPath();
        ExistingModuleLoader loader = ExistingModuleLoader.setUpLoader(this.getModuleFilePath());
        this.unzip(loader.getName(), path, true, null, true);
        Module module = loader.createModule(moduleModel);
        if (this.myProjectMode) {
            moduleModel.renameModule(module, module.getProject().getName());
        }
        this.fixModuleName(module);
        return module;
    }

    private void fixModuleName(@NotNull Module module) {
        ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        for (WizardInputField<?> field : this.myAdditionalFields) {
            ProjectTemplateParameterFactory factory2 = WizardInputField.getFactoryById((String)field.getId());
            if (factory2 == null) continue;
            factory2.applyResult(field.getValue(), model);
        }
        TemplateModuleBuilder.applyProjectDefaults(module.getProject());
        for (ProjectTemplateParameterFactory factory3 : ProjectTemplateParameterFactory.EP_NAME.getExtensionList()) {
            String value2 = factory3.getImmediateValue();
            if (value2 == null) continue;
            factory3.applyResult(value2, model);
        }
        model.commit();
        RunManager runManager = RunManager.getInstance((Project)module.getProject());
        for (RunConfiguration configuration : runManager.getAllConfigurationsList()) {
            if (!(configuration instanceof ModuleBasedConfiguration)) continue;
            ((ModuleBasedConfiguration)configuration).getConfigurationModule().setModule(module);
        }
    }

    private static void applyProjectDefaults(@NotNull Project project) {
        Project defaultProject = ProjectManager.getInstance().getDefaultProject();
        String charset = EncodingProjectManager.getInstance((Project)defaultProject).getDefaultCharsetName();
        EncodingProjectManager.getInstance((Project)project).setDefaultCharsetName(charset);
        RunnerAndConfigurationSettings selectedConfiguration2 = RunManager.getInstance((Project)project).getSelectedConfiguration();
        RunManagerImpl.getInstanceImpl(defaultProject).copyTemplatesToProjectFromTemplate(project);
        RunManager.getInstance((Project)project).setSelectedConfiguration(selectedConfiguration2);
    }

    @Nullable
    private WizardInputField<?> getBasePackageField() {
        for (WizardInputField<?> field : this.getAdditionalFields()) {
            if (!"IJ_BASE_PACKAGE".equals(field.getId())) continue;
            return field;
        }
        return null;
    }

    private void unzip(final @Nullable String projectName, String path, final boolean isModuleMode, final @Nullable ProgressIndicator pI, final boolean reportFailuresWithDialog) {
        final WizardInputField<?> basePackage = this.getBasePackageField();
        try {
            File to;
            File from;
            final File dir = new File(path);
            class ExceptionConsumer
            implements Consumer<VelocityException> {
                private String myPath;
                private String myText;
                private final SmartList<Trinity<String, String, VelocityException>> myFailures = new SmartList();

                ExceptionConsumer() {
                }

                public void consume(VelocityException e) {
                    this.myFailures.add((Object)Trinity.create((Object)this.myPath, (Object)this.myText, (Object)((Object)e)));
                }

                private void setCurrentFile(String path, String text) {
                    this.myPath = path;
                    this.myText = text;
                }

                private void reportFailures() {
                    if (this.myFailures.isEmpty()) {
                        return;
                    }
                    if (reportFailuresWithDialog) {
                        String dialogMessage;
                        if (this.myFailures.size() == 1) {
                            dialogMessage = LangBundle.message((String)"dialog.message.failed.to.decode.file", (Object[])new Object[]{((Trinity)this.myFailures.get(0)).getFirst()});
                        } else {
                            StringBuilder dialogMessageBuilder = new StringBuilder();
                            dialogMessageBuilder.append("Failed to decode files: \n");
                            for (Trinity failure : this.myFailures) {
                                dialogMessageBuilder.append((String)failure.getFirst()).append("\n");
                            }
                            dialogMessage = dialogMessageBuilder.toString();
                        }
                        Messages.showErrorDialog((String)dialogMessage, (String)LangBundle.message((String)"dialog.title.decoding.template", (Object[])new Object[0]));
                    }
                    StringBuilder reportBuilder = new StringBuilder();
                    for (Trinity failure : this.myFailures) {
                        reportBuilder.append("File: ").append((String)failure.getFirst()).append("\n");
                        reportBuilder.append("Exception:\n").append(ExceptionUtil.getThrowableText((Throwable)((Throwable)failure.getThird()))).append("\n");
                        reportBuilder.append("File content:\n'").append((String)failure.getSecond()).append("'\n");
                        reportBuilder.append("\n===========================================\n");
                    }
                    LOG.error("Cannot decode files in template", (Throwable)null, new Attachment[]{new Attachment("Files in template", reportBuilder.toString())});
                }
            }
            final ExceptionConsumer consumer = new ExceptionConsumer();
            final ArrayList filesToRefresh = new ArrayList();
            this.myTemplate.processStream(new ArchivedProjectTemplate.StreamProcessor<Void>(){
                {
                }

                @Override
                public Void consume(@NotNull ZipInputStream stream) throws IOException {
                    ZipUtil.unzip(ProgressManager.getInstance().getProgressIndicator(), dir, stream, (NullableFunction<? super String, String>)((NullableFunction)path1 -> {
                        if (isModuleMode && path1.contains(".idea")) {
                            return null;
                        }
                        if (basePackage != null) {
                            return path1.replace(TemplateModuleBuilder.getPathFragment(basePackage.getDefaultValue()), TemplateModuleBuilder.getPathFragment(basePackage.getValue()));
                        }
                        return path1;
                    }), new ZipUtil.ContentProcessor(){

                        @Override
                        public byte[] processContent(byte[] content2, File file2) throws IOException {
                            if (pI != null) {
                                pI.checkCanceled();
                            }
                            FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(file2.getName());
                            String text = new String(content2, StandardCharsets.UTF_8);
                            consumer.setCurrentFile(file2.getName(), text);
                            return fileType.isBinary() ? content2 : TemplateModuleBuilder.this.processTemplates(projectName, text, file2, (Consumer<? super VelocityException>)consumer);
                        }
                    }, true);
                    TemplateModuleBuilder.this.myTemplate.handleUnzippedDirectories(dir, filesToRefresh);
                    return null;
                }
            });
            if (pI != null) {
                pI.setText(LangBundle.message((String)"progress.title.refreshing", (Object[])new Object[0]));
            }
            String iml = (String)ContainerUtil.find((Object[])((Object[])ObjectUtils.chooseNotNull((Object)dir.list(), (Object)ArrayUtilRt.EMPTY_STRING_ARRAY)), s -> s.endsWith(".iml"));
            if (isModuleMode && !(from = new File(path, Objects.requireNonNull(iml))).renameTo(to = new File(this.getModuleFilePath()))) {
                throw new IOException("Can't rename " + from + " to " + to);
            }
            RefreshQueue refreshQueue = RefreshQueue.getInstance();
            LOG.assertTrue(!filesToRefresh.isEmpty());
            for (File file2 : filesToRefresh) {
                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
                if (virtualFile == null) {
                    throw new IOException("Can't find " + file2);
                }
                refreshQueue.refresh(false, true, null, new VirtualFile[]{virtualFile});
            }
            consumer.reportFailures();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private static String getPathFragment(@NotNull String value2) {
        return "/" + value2.replace('.', '/') + "/";
    }

    private byte @Nullable [] processTemplates(@Nullable String projectName, String content2, File file2, Consumer<? super VelocityException> exceptionConsumer) throws IOException {
        String patchedContent = content2;
        if (!(this.myTemplate instanceof LocalArchivedTemplate) || ((LocalArchivedTemplate)this.myTemplate).isEscaped()) {
            for (WizardInputField<?> wizardInputField : this.myAdditionalFields) {
                if (wizardInputField.acceptFile(file2)) continue;
                return null;
            }
            Properties properties = FileTemplateManager.getDefaultInstance().getDefaultProperties();
            for (WizardInputField<?> wizardInputField : this.myAdditionalFields) {
                properties.putAll((Map<?, ?>)wizardInputField.getValues());
            }
            if (projectName != null) {
                properties.put("IJ_PROJECT_NAME", projectName);
            }
            String string = FileTemplateUtil.mergeTemplate(properties, content2, true, exceptionConsumer);
            patchedContent = string.replace("\\$", "$").replace("\\#", "#");
        } else {
            int i2 = content2.indexOf("<IntelliJ_File_Header>");
            if (i2 != -1) {
                FileTemplate fileTemplate = FileTemplateManager.getDefaultInstance().getDefaultTemplate(SaveProjectAsTemplateAction.getFileHeaderTemplateName());
                Properties properties = FileTemplateManager.getDefaultInstance().getDefaultProperties();
                String templateText = fileTemplate.getText(properties);
                patchedContent = patchedContent.substring(0, i2) + templateText + patchedContent.substring(i2 + "<IntelliJ_File_Header>".length());
            }
        }
        return StringUtilRt.convertLineSeparators((String)patchedContent, (String)CodeStyle.getDefaultSettings().getLineSeparator()).getBytes(StandardCharsets.UTF_8);
    }

    public boolean isSuitableSdkType(SdkTypeId sdkType) {
        return this.myType.createModuleBuilder().isSuitableSdkType(sdkType);
    }

    @Nullable
    public Project createProject(final String name, final @NotNull String path) {
        List children2;
        final Path baseDir = Paths.get(path, new String[0]);
        LOG.assertTrue(Files.isDirectory(baseDir, new LinkOption[0]));
        try (DirectoryStream<Path> childrenIterator = Files.newDirectoryStream(baseDir);){
            children2 = ContainerUtil.collect(childrenIterator.iterator());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        final boolean isSomehowOverwriting = children2.size() > 1 || children2.size() == 1 && !".idea".equals(((Path)children2.get(0)).getFileName().toString());
        return (Project)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<Project, RuntimeException>(null, LangBundle.message((String)"progress.title.applying.template", (Object[])new Object[0]), true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Project compute(@NotNull ProgressIndicator indicator) {
                try {
                    TemplateModuleBuilder.this.myProjectMode = true;
                    TemplateModuleBuilder.this.unzip(name, path, false, indicator, false);
                    Project project = ProjectManagerEx.getInstanceEx().loadProject(baseDir);
                    return project;
                }
                finally {
                    TemplateModuleBuilder.this.cleanup();
                    if (indicator.isCanceled() && !isSomehowOverwriting) {
                        try {
                            FileUtil.delete((Path)baseDir);
                        }
                        catch (IOException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
            }
        });
    }
}

