/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.io.InputStream;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

public class WelcomeScreenUIManager {
    @NotNull
    static Font getProductFont(int size) {
        try {
            return WelcomeScreenUIManager.loadFont().deriveFont((float)JBUIScale.scale((int)size));
        }
        catch (Throwable t) {
            Logger.getInstance(AppUIUtil.class).warn(t);
            return StartupUiUtil.getLabelFont().deriveFont(JBUIScale.scale((float)size));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static Font loadFont() {
        String fontPath = "/fonts/Roboto-Light.ttf";
        URL url = AppUIUtil.class.getResource(fontPath);
        if (url == null) {
            Logger.getInstance(AppUIUtil.class).warn("Resource missing: " + fontPath);
            return StartupUiUtil.getLabelFont();
        }
        try (InputStream is = url.openStream();){
            Font font = Font.createFont(0, is);
            return font;
        }
        catch (Throwable t) {
            Logger.getInstance(AppUIUtil.class).warn("Cannot load font: " + url, t);
        }
        return StartupUiUtil.getLabelFont();
    }

    public static Color getMainBackground() {
        return JBColor.namedColor((String)"WelcomeScreen.background", (Color)new JBColor(0xF7F7F7, 4540234));
    }

    public static Color getMainTabListBackground() {
        return JBColor.namedColor((String)"WelcomeScreen.List.background", (Color)new JBColor(0xF2F2F2, 0x393939));
    }

    public static Color getProjectsBackground() {
        if (Registry.is((String)"use.tabbed.welcome.screen")) {
            return WelcomeScreenUIManager.getMainAssociatedComponentBackground();
        }
        return JBColor.namedColor((String)"WelcomeScreen.Projects.background", (Color)new JBColor((Color)Gray.xFF, (Color)Gray.x39));
    }

    public static Color getProjectsSelectionBackground(boolean hasFocus) {
        if (Registry.is((String)"use.tabbed.welcome.screen")) {
            return ListPluginComponent.HOVER_COLOR;
        }
        return hasFocus ? JBColor.namedColor((String)"WelcomeScreen.Projects.selectionBackground", (Color)new JBColor(3700182, 4943535)) : JBColor.namedColor((String)"WelcomeScreen.Projects.selectionInactiveBackground", (Color)new JBColor((Color)Gray.xDD, (Color)Gray.x45));
    }

    @NotNull
    public static Color getProjectsSelectionForeground(boolean isSelected, boolean hasFocus) {
        if (Registry.is((String)"use.tabbed.welcome.screen")) {
            return UIUtil.getListForeground();
        }
        return UIUtil.getListForeground((isSelected && hasFocus ? 1 : 0) != 0, (boolean)true);
    }

    public static Color getMainAssociatedComponentBackground() {
        return JBColor.namedColor((String)"WelcomeScreen.AssociatedComponent.background", (Color)JBColor.WHITE);
    }

    public static Color getLinkNormalColor() {
        return new JBColor((Color)Gray._0, (Color)Gray.xBB);
    }

    public static Color getActionLinkSelectionColor() {
        return new JBColor(14411253, 4741237);
    }

    public static JBColor getSeparatorColor() {
        return JBColor.namedColor((String)"WelcomeScreen.separatorColor", (Color)new JBColor((Color)Gray.xEC, new Color(72, 75, 78)));
    }

    public static JBColor getActionsButtonBackground(boolean isSelected) {
        return isSelected ? JBColor.namedColor((String)"WelcomeScreen.Projects.actions.selectionBackground", (Color)new JBColor(5215976, 3305409)) : JBColor.namedColor((String)"WelcomeScreen.Projects.actions.background", (Color)new JBColor(14478846, 3955846));
    }
}

