/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status.widget;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.StatusBarWidgetProvider;
import com.intellij.openapi.wm.WindowManager;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class StatusBarWidgetProviderToFactoryAdapter
implements StatusBarWidgetFactory {
    @NotNull
    private final Project myProject;
    @NotNull
    private final StatusBarWidgetProvider myProvider;
    private boolean widgetWasCreated;
    @Nullable
    private StatusBarWidget myWidget;

    public StatusBarWidgetProviderToFactoryAdapter(@NotNull Project project, @NotNull StatusBarWidgetProvider provider) {
        this.myProject = project;
        this.myProvider = provider;
    }

    @NotNull
    public String getId() {
        StatusBarWidget widget = this.getWidget();
        return widget != null ? widget.ID() : this.myProvider.getClass().getName();
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        StatusBarWidget widget = this.getWidget();
        if (widget != null) {
            String result2;
            StatusBarWidget.WidgetPresentation presentation2 = widget.getPresentation();
            String string = result2 = presentation2 != null ? StringUtil.notNullize((String)presentation2.getTooltipText()) : "";
            if (!result2.isEmpty()) {
                return result2;
            }
            if (ApplicationManager.getApplication().isInternal()) {
                return widget.ID();
            }
        }
        return "";
    }

    public boolean isAvailable(@NotNull Project project) {
        IdeFrame frame = WindowManager.getInstance().getIdeFrame(this.myProject);
        if (frame == null || !this.myProvider.isCompatibleWith(frame)) {
            return false;
        }
        return this.getWidget() != null;
    }

    public boolean isConfigurable() {
        return !this.getDisplayName().isEmpty();
    }

    public boolean canBeEnabledOn(@NotNull StatusBar statusBar) {
        return true;
    }

    @NotNull
    public StatusBarWidget createWidget(@NotNull Project project) {
        return Objects.requireNonNull(this.getWidget());
    }

    @Nullable
    private StatusBarWidget getWidget() {
        if (!this.widgetWasCreated) {
            this.myWidget = this.myProvider.getWidget(this.myProject);
            this.widgetWasCreated = true;
        }
        return this.myWidget;
    }

    public void disposeWidget(@NotNull StatusBarWidget widget) {
        this.myWidget = null;
        this.widgetWasCreated = false;
        Disposer.dispose((Disposable)widget);
    }

    @NotNull
    public String getAnchor() {
        return this.myProvider.getAnchor();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusBarWidgetProviderToFactoryAdapter adapter2 = (StatusBarWidgetProviderToFactoryAdapter)o;
        return this.myProvider.equals(adapter2.myProvider) && this.myProject.equals(adapter2.myProject);
    }

    public int hashCode() {
        return Objects.hash(this.myProvider, this.myProject);
    }
}

