/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.PowerSaveMode;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.service.fus.collectors.UIEventId;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.impl.ProgressSuspender;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.panel.ProgressPanel;
import com.intellij.openapi.ui.panel.ProgressPanelBuilder;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonHandler;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.impl.status.InlineProgressIndicator;
import com.intellij.openapi.wm.impl.status.PresentationModeProgressPanel;
import com.intellij.openapi.wm.impl.status.ProcessBalloon;
import com.intellij.openapi.wm.impl.status.ProcessPopup;
import com.intellij.openapi.wm.impl.status.ProgressButton;
import com.intellij.openapi.wm.impl.status.StatusPanel;
import com.intellij.reference.SoftReference;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InfoAndProgressPanel
extends JPanel
implements CustomStatusBarWidget {
    private final ProcessPopup myPopup;
    private final ProcessBalloon myBalloon = new ProcessBalloon(3);
    private final StatusPanel myInfoPanel = new StatusPanel();
    private final JPanel myRefreshAndInfoPanel = new JPanel();
    private final InlineProgressPanel myInlinePanel = new InlineProgressPanel();
    private final NotNullLazyValue<AsyncProcessIcon> myProgressIcon = new NotNullLazyValue<AsyncProcessIcon>(){

        @NotNull
        protected AsyncProcessIcon compute() {
            AsyncProcessIcon icon2 = new AsyncProcessIcon("Background process");
            icon2.setOpaque(false);
            icon2.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    InfoAndProgressPanel.this.handle(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    InfoAndProgressPanel.this.handle(e);
                }
            });
            icon2.setCursor(Cursor.getPredefinedCursor(12));
            icon2.setBorder(StatusBarWidget.WidgetBorder.INSTANCE);
            icon2.setToolTipText(ActionsBundle.message((String)"action.ShowProcessWindow.double.click", (Object[])new Object[0]));
            return icon2;
        }
    };
    private final List<ProgressIndicatorEx> myOriginals = new ArrayList<ProgressIndicatorEx>();
    private final List<TaskInfo> myInfos = new ArrayList<TaskInfo>();
    private final Map<InlineProgressIndicator, ProgressIndicatorEx> myInlineToOriginal = new HashMap<InlineProgressIndicator, ProgressIndicatorEx>();
    private final Map<ProgressIndicatorEx, Set<MyInlineProgressIndicator>> myOriginalToInlines = new HashMap<ProgressIndicatorEx, Set<MyInlineProgressIndicator>>();
    private final MergingUpdateQueue myUpdateQueue;
    private final Alarm myQueryAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private boolean myShouldClosePopupAndOnProcessFinish;
    private final JLabel myRefreshIcon = new JLabel((Icon)new AnimatedIcon.FS());
    private String myCurrentRequestor;
    private boolean myDisposed;
    private WeakReference<Balloon> myLastShownBalloon;
    private final Set<InlineProgressIndicator> myDirtyIndicators = ContainerUtil.newIdentityTroveSet();
    private final Update myUpdateIndicators = new Update("UpdateIndicators", false, 1){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ArrayList indicators;
            Set set = InfoAndProgressPanel.this.myDirtyIndicators;
            synchronized (set) {
                indicators = new ArrayList(InfoAndProgressPanel.this.myDirtyIndicators);
                InfoAndProgressPanel.this.myDirtyIndicators.clear();
            }
            for (InlineProgressIndicator indicator : indicators) {
                indicator.updateAndRepaint();
            }
        }
    };

    InfoAndProgressPanel() {
        this.setOpaque(false);
        this.setBorder((Border)JBUI.Borders.empty());
        this.myRefreshIcon.setVisible(false);
        this.myRefreshAndInfoPanel.setLayout(new BorderLayout());
        this.myRefreshAndInfoPanel.setOpaque(false);
        this.myRefreshAndInfoPanel.add((Component)this.myRefreshIcon, "West");
        this.myRefreshAndInfoPanel.add((Component)this.myInfoPanel, "Center");
        this.myUpdateQueue = new MergingUpdateQueue("Progress indicator", 50, true, MergingUpdateQueue.ANY_COMPONENT);
        this.myPopup = new ProcessPopup(this);
        this.setRefreshVisible(false);
        this.setLayout((LayoutManager)((Object)new InlineLayout()));
        this.add(this.myRefreshAndInfoPanel);
        this.add((Component)((Object)this.myInlinePanel));
        this.myRefreshAndInfoPanel.revalidate();
        this.myRefreshAndInfoPanel.repaint();
        this.runOnProgressRelatedChange(this::updateProgressIcon, (Disposable)this, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOnProgressRelatedChange(final @NotNull Runnable runnable2, @NotNull Disposable parentDisposable, boolean powerSaveMode) {
        List<ProgressIndicatorEx> list2 = this.myOriginals;
        synchronized (list2) {
            if (!this.myDisposed) {
                MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect(parentDisposable);
                if (powerSaveMode) {
                    connection.subscribe(PowerSaveMode.TOPIC, () -> UIUtil.invokeLaterIfNeeded((Runnable)runnable2));
                }
                connection.subscribe(ProgressSuspender.TOPIC, (Object)new ProgressSuspender.SuspenderListener(){

                    @Override
                    public void suspendableProgressAppeared(@NotNull ProgressSuspender suspender) {
                        UIUtil.invokeLaterIfNeeded((Runnable)runnable2);
                    }

                    @Override
                    public void suspendedStatusChanged(@NotNull ProgressSuspender suspender) {
                        UIUtil.invokeLaterIfNeeded((Runnable)runnable2);
                    }
                });
            }
        }
    }

    private void handle(@NotNull MouseEvent e) {
        if (UIUtil.isActionClick((MouseEvent)e, (int)501)) {
            this.triggerPopupShowing();
        }
    }

    @NotNull
    public String ID() {
        return "InfoAndProgress";
    }

    public StatusBarWidget.WidgetPresentation getPresentation() {
        return null;
    }

    public void install(@NotNull StatusBar statusBar) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.setRefreshVisible(false);
        List<ProgressIndicatorEx> list2 = this.myOriginals;
        synchronized (list2) {
            this.restoreEmptyStatus();
            for (InlineProgressIndicator indicator : this.myInlineToOriginal.keySet()) {
                Disposer.dispose((Disposable)indicator);
            }
            this.myInlineToOriginal.clear();
            this.myOriginalToInlines.clear();
            this.myDisposed = true;
        }
    }

    public JComponent getComponent() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    List<Pair<TaskInfo, ProgressIndicator>> getBackgroundProcesses() {
        List<ProgressIndicatorEx> list2 = this.myOriginals;
        synchronized (list2) {
            if (this.myOriginals.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Pair> result2 = new ArrayList<Pair>(this.myOriginals.size());
            for (int i2 = 0; i2 < this.myOriginals.size(); ++i2) {
                result2.add(Pair.create((Object)this.myInfos.get(i2), (Object)this.myOriginals.get(i2)));
            }
            return Collections.unmodifiableList(result2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addProgress(@NotNull ProgressIndicatorEx original, @NotNull TaskInfo info) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        List<ProgressIndicatorEx> list2 = this.myOriginals;
        synchronized (list2) {
            this.myOriginals.add(original);
            this.myInfos.add(info);
            MyInlineProgressIndicator expanded = this.createInlineDelegate(info, original, false);
            MyInlineProgressIndicator compact = this.createInlineDelegate(info, original, true);
            this.myPopup.addIndicator(expanded);
            this.myBalloon.addIndicator(this.getRootPane(), compact);
            this.updateProgressIcon();
            if (this.myOriginals.size() == 1) {
                this.myInlinePanel.updateState(compact);
            } else {
                this.myInlinePanel.updateState();
            }
            if (this.myInfos.size() > 1 && Registry.is((String)"ide.windowSystem.autoShowProcessPopup")) {
                this.openProcessPopup(false);
            }
            this.runQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasProgressIndicators() {
        List<ProgressIndicatorEx> list2 = this.myOriginals;
        synchronized (list2) {
            return !this.myOriginals.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProgress(@NotNull MyInlineProgressIndicator progress2) {
        List<ProgressIndicatorEx> list2 = this.myOriginals;
        synchronized (list2) {
            ProgressIndicatorEx original;
            boolean last;
            if (!this.myInlineToOriginal.containsKey(progress2)) {
                return;
            }
            boolean bl = last = this.myOriginals.size() == 1;
            if (!progress2.isCompact()) {
                this.myPopup.removeIndicator(progress2);
            }
            if (this.myOriginals.contains(original = this.removeFromMaps(progress2))) {
                Disposer.dispose((Disposable)progress2);
                if (progress2.isCompact()) {
                    this.myBalloon.removeIndicator(this.getRootPane(), progress2);
                }
                return;
            }
            if (last) {
                this.myInlinePanel.updateState(null);
                if (this.myShouldClosePopupAndOnProcessFinish) {
                    this.hideProcessPopup();
                }
            } else {
                this.myInlinePanel.updateState(this.createInlineDelegate(this.myInfos.get(0), this.myOriginals.get(0), true));
            }
            this.runQuery();
        }
        Disposer.dispose((Disposable)progress2);
        if (progress2.isCompact()) {
            this.myBalloon.removeIndicator(this.getRootPane(), progress2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProgressIndicatorEx removeFromMaps(@NotNull MyInlineProgressIndicator progress2) {
        ProgressIndicatorEx original = this.myInlineToOriginal.get(progress2);
        this.myInlineToOriginal.remove(progress2);
        Set<InlineProgressIndicator> set = this.myDirtyIndicators;
        synchronized (set) {
            this.myDirtyIndicators.remove(progress2);
        }
        Set<MyInlineProgressIndicator> set2 = this.myOriginalToInlines.get(original);
        if (set2 != null) {
            set2.remove(progress2);
            if (set2.isEmpty()) {
                set2 = null;
                this.myOriginalToInlines.remove(original);
            }
        }
        if (set2 == null) {
            int originalIndex = this.myOriginals.indexOf(original);
            this.myOriginals.remove(originalIndex);
            this.myInfos.remove(originalIndex);
        }
        return original;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openProcessPopup(boolean requestFocus) {
        List<ProgressIndicatorEx> list2 = this.myOriginals;
        synchronized (list2) {
            if (this.myPopup.isShowing()) {
                return;
            }
            this.myPopup.show(requestFocus);
            this.myShouldClosePopupAndOnProcessFinish = this.hasProgressIndicators();
            this.myInlinePanel.updateState(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void hideProcessPopup() {
        List<ProgressIndicatorEx> list2 = this.myOriginals;
        synchronized (list2) {
            if (!this.myPopup.isShowing()) {
                return;
            }
            this.myPopup.hide();
            this.myInlinePanel.updateState(false);
        }
    }

    @NotNull
    public Pair<String, String> setText(@Nullable String text, @Nullable String requestor) {
        if (StringUtil.isEmpty((String)text) && !Objects.equals(requestor, this.myCurrentRequestor) && !"Internal log requestor".equals(requestor)) {
            return new Pair((Object)this.myInfoPanel.getText(), (Object)this.myCurrentRequestor);
        }
        boolean logMode = this.myInfoPanel.updateText("Internal log requestor".equals(requestor) ? "" : text);
        this.myCurrentRequestor = logMode ? "Internal log requestor" : requestor;
        return new Pair((Object)text, (Object)requestor);
    }

    void setRefreshVisible(boolean visible) {
        UIUtil.invokeLaterIfNeeded(() -> this.myRefreshIcon.setVisible(visible));
    }

    void setRefreshToolTipText(String tooltip) {
        this.myRefreshIcon.setToolTipText(tooltip);
    }

    public BalloonHandler notifyByBalloon(@NotNull MessageType type, @NotNull @NlsContexts.PopupContent String htmlBody, @Nullable Icon icon2, @Nullable HyperlinkListener listener2) {
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(htmlBody.replace("\n", "<br>"), icon2 != null ? icon2 : type.getDefaultIcon(), type.getPopupBackground(), listener2).createBalloon();
        SwingUtilities.invokeLater(() -> {
            Balloon oldBalloon = (Balloon)SoftReference.dereference(this.myLastShownBalloon);
            if (oldBalloon != null) {
                balloon.setAnimationEnabled(false);
                oldBalloon.setAnimationEnabled(false);
                oldBalloon.hide();
            }
            this.myLastShownBalloon = new WeakReference<Balloon>(balloon);
            InfoAndProgressPanel comp = this;
            if (comp.isShowing()) {
                int offset = ((Component)comp).getHeight() / 2;
                Point point = new Point(((Component)comp).getWidth() - offset, ((Component)comp).getHeight() - offset);
                balloon.show(new RelativePoint((Component)comp, point), Balloon.Position.above);
            } else {
                JRootPane rootPane = SwingUtilities.getRootPane(comp);
                if (rootPane != null && rootPane.isShowing()) {
                    Container contentPane = rootPane.getContentPane();
                    Rectangle bounds2 = contentPane.getBounds();
                    Point target2 = StartupUiUtil.getCenterPoint((Rectangle)bounds2, (Dimension)JBUI.size((int)1, (int)1));
                    target2.y = bounds2.height - 3;
                    balloon.show(new RelativePoint((Component)contentPane, target2), Balloon.Position.above);
                }
            }
        });
        return () -> SwingUtilities.invokeLater(() -> ((Balloon)balloon).hide());
    }

    @NotNull
    private MyInlineProgressIndicator createInlineDelegate(@NotNull TaskInfo info, @NotNull ProgressIndicatorEx original, boolean compact) {
        Set inlines = this.myOriginalToInlines.computeIfAbsent(original, __ -> new HashSet());
        if (!inlines.isEmpty()) {
            for (MyInlineProgressIndicator eachInline : inlines) {
                if (eachInline.isCompact() != compact) continue;
                return eachInline;
            }
        }
        MyInlineProgressIndicator inline = compact ? new MyInlineProgressIndicator(info, original) : new ProgressPanelProgressIndicator(info, original);
        this.myInlineToOriginal.put(inline, original);
        inlines.add(inline);
        if (compact) {
            inline.getComponent().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    InfoAndProgressPanel.this.handle(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    InfoAndProgressPanel.this.handle(e);
                }
            });
        }
        return inline;
    }

    private void triggerPopupShowing() {
        if (this.myPopup.isShowing()) {
            this.hideProcessPopup();
        } else {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("bg.progress.window.show.from.status.bar");
            this.openProcessPopup(true);
        }
    }

    private void updateProgressIcon() {
        AsyncProcessIcon progressIcon;
        AsyncProcessIcon asyncProcessIcon = progressIcon = this.myProgressIcon.isComputed() ? (AsyncProcessIcon)this.myProgressIcon.getValue() : null;
        if (progressIcon == null) {
            return;
        }
        if (this.myOriginals.isEmpty() || PowerSaveMode.isEnabled() || this.myOriginals.stream().map(ProgressSuspender::getSuspender).allMatch(s -> s != null && s.isSuspended())) {
            progressIcon.suspend();
        } else {
            progressIcon.resume();
        }
    }

    private void restoreEmptyStatus() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add((Component)this.myRefreshAndInfoPanel, "Center");
        this.myRefreshAndInfoPanel.revalidate();
        this.myRefreshAndInfoPanel.repaint();
    }

    boolean isProcessWindowOpen() {
        return this.myPopup.isShowing();
    }

    void setProcessWindowOpen(boolean open2) {
        if (open2) {
            this.openProcessPopup(true);
        } else {
            this.hideProcessPopup();
        }
    }

    private void runQuery() {
        if (this.getRootPane() == null) {
            return;
        }
        Set<InlineProgressIndicator> indicators = this.getCurrentInlineIndicators();
        if (indicators.isEmpty()) {
            return;
        }
        for (InlineProgressIndicator each : indicators) {
            each.updateProgress();
        }
        this.myQueryAlarm.cancelAllRequests();
        this.myQueryAlarm.addRequest(this::runQuery, 2000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Set<InlineProgressIndicator> getCurrentInlineIndicators() {
        List<ProgressIndicatorEx> list2 = this.myOriginals;
        synchronized (list2) {
            return this.myInlineToOriginal.keySet();
        }
    }

    private static class InlineLayout
    extends AbstractLayoutManager {
        private InlineLayout() {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension result2 = new Dimension();
            int count = parent.getComponentCount();
            for (int i2 = 0; i2 < count; ++i2) {
                Dimension size = parent.getComponent(i2).getPreferredSize();
                result2.width += size.width;
                result2.height = Math.max(result2.height, size.height);
            }
            return result2;
        }

        public void layoutContainer(Container parent) {
            if (parent.getComponentCount() != 2) {
                return;
            }
            Component infoPanel = parent.getComponent(0);
            Component progressPanel = parent.getComponent(1);
            Dimension size = parent.getSize();
            int progressWidth = progressPanel.getPreferredSize().width;
            if (progressWidth > size.width) {
                infoPanel.setBounds(0, 0, 0, 0);
                progressPanel.setBounds(0, 0, size.width, size.height);
            } else {
                infoPanel.setBounds(0, 0, size.width - progressWidth, size.height);
                progressPanel.setBounds(size.width - progressWidth, 0, progressWidth, size.height);
            }
        }
    }

    private class InlineProgressPanel
    extends NonOpaquePanel {
        private MyInlineProgressIndicator myIndicator;
        private AsyncProcessIcon myProcessIconComponent;
        private final LinkLabel<?> myMultiProcessLink = new LinkLabel<Object>("", null, (__, ___) -> InfoAndProgressPanel.access$1800(InfoAndProgressPanel.this), null, null){

            public void updateUI() {
                super.updateUI();
                this.setFont((Font)(SystemInfo.isMac ? JBUI.Fonts.label((float)11.0f) : JBFont.label()));
            }
        };

        InlineProgressPanel() {
            this.setLayout((LayoutManager)new AbstractLayoutManager(){

                public Dimension preferredLayoutSize(Container parent) {
                    JComponent component2;
                    Dimension result2 = new Dimension();
                    if (InlineProgressPanel.this.myIndicator != null && (component2 = InlineProgressPanel.this.myIndicator.getComponent()).isVisible()) {
                        Dimension size = component2.getPreferredSize();
                        result2.width += size.width;
                        result2.height = Math.max(result2.height, size.height);
                    }
                    if (InlineProgressPanel.this.myMultiProcessLink.isVisible()) {
                        Dimension size = InlineProgressPanel.this.myMultiProcessLink.getPreferredSize();
                        result2.width = result2.width + ((result2.width > 0 ? InlineProgressPanel.this.getGap() : 0) + size.width);
                        result2.height = Math.max(result2.height, size.height);
                    }
                    if (InlineProgressPanel.this.myProcessIconComponent != null) {
                        result2.height = Math.max(result2.height, ((InlineProgressPanel)InlineProgressPanel.this).myProcessIconComponent.getPreferredSize().height);
                    }
                    JBInsets.addTo((Dimension)result2, (Insets)parent.getInsets());
                    return result2;
                }

                public void layoutContainer(Container parent) {
                    if (InlineProgressPanel.this.myIndicator == null) {
                        InlineProgressPanel.this.hideProcessIcon();
                        return;
                    }
                    Insets insets = parent.getInsets();
                    int x = insets.left;
                    int centerY = (parent.getHeight() + insets.top - insets.bottom) / 2;
                    int width = parent.getWidth() - insets.left - insets.right;
                    int rightX = parent.getWidth() - insets.right;
                    int gap = InlineProgressPanel.this.getGap();
                    JComponent indicator = InlineProgressPanel.this.myIndicator.getComponent();
                    if (indicator.isVisible()) {
                        int progressWidth2x;
                        int preferredWidth = this.preferredLayoutSize((Container)parent).width - insets.left - insets.right;
                        Dimension indicatorSize = null;
                        if (preferredWidth > width && width > (progressWidth2x = ((InlineProgressPanel)InlineProgressPanel.this).myIndicator.myProgress.getPreferredSize().width * 2) && ((InlineProgressPanel)InlineProgressPanel.this).myIndicator.myText.getPreferredSize().width > progressWidth2x) {
                            preferredWidth = width;
                            indicatorSize = new Dimension(width, indicator.getPreferredSize().height);
                            if (InlineProgressPanel.this.myMultiProcessLink.isVisible()) {
                                indicatorSize.width -= ((InlineProgressPanel)InlineProgressPanel.this).myMultiProcessLink.getPreferredSize().width + gap;
                            }
                        }
                        if (preferredWidth > width) {
                            indicator.setBounds(0, 0, 0, 0);
                            InlineProgressPanel.this.addProcessIcon();
                            Dimension iconSize = InlineProgressPanel.this.myProcessIconComponent.getPreferredSize();
                            preferredWidth = iconSize.width;
                            if (InlineProgressPanel.this.myMultiProcessLink.isVisible()) {
                                preferredWidth += gap + ((InlineProgressPanel)InlineProgressPanel.this).myMultiProcessLink.getPreferredSize().width;
                            }
                            if (preferredWidth > width) {
                                if (InlineProgressPanel.this.myMultiProcessLink.isVisible()) {
                                    InlineProgressPanel.this.myMultiProcessLink.setBounds(0, 0, 0, 0);
                                }
                                InlineProgressPanel.this.setBounds((JComponent)InlineProgressPanel.this.myProcessIconComponent, 0, centerY, iconSize, false);
                            } else {
                                boolean minisWidth = true;
                                if (InlineProgressPanel.this.myMultiProcessLink.isVisible()) {
                                    rightX = InlineProgressPanel.this.setBounds((JComponent)InlineProgressPanel.this.myMultiProcessLink, rightX, centerY, null, true) - gap;
                                } else if (width < 60) {
                                    rightX = 0;
                                    minisWidth = false;
                                }
                                InlineProgressPanel.this.setBounds((JComponent)InlineProgressPanel.this.myProcessIconComponent, rightX, centerY, iconSize, minisWidth);
                            }
                            InlineProgressPanel.this.myProcessIconComponent.setVisible(true);
                        } else {
                            InlineProgressPanel.this.hideProcessIcon();
                            if (InlineProgressPanel.this.myMultiProcessLink.isVisible()) {
                                rightX = InlineProgressPanel.this.setBounds((JComponent)InlineProgressPanel.this.myMultiProcessLink, rightX, centerY, null, true) - gap;
                            }
                            InlineProgressPanel.this.setBounds(indicator, rightX, centerY, indicatorSize, true);
                        }
                    } else {
                        Dimension linkSize = InlineProgressPanel.this.myMultiProcessLink.getPreferredSize();
                        int preferredWidth = linkSize.width;
                        if (preferredWidth > width) {
                            InlineProgressPanel.this.myMultiProcessLink.setBounds(0, 0, 0, 0);
                            InlineProgressPanel.this.addProcessIcon();
                            InlineProgressPanel.this.setBounds((JComponent)InlineProgressPanel.this.myProcessIconComponent, x, centerY, null, false);
                            InlineProgressPanel.this.myProcessIconComponent.setVisible(true);
                        } else {
                            InlineProgressPanel.this.hideProcessIcon();
                            InlineProgressPanel.this.setBounds((JComponent)InlineProgressPanel.this.myMultiProcessLink, rightX, centerY, linkSize, true);
                        }
                    }
                }
            });
            this.setBorder((Border)JBUI.Borders.empty((int)0, (int)20, (int)0, (int)4));
            this.add((Component)this.myMultiProcessLink);
            this.myMultiProcessLink.setVisible(false);
        }

        private int getGap() {
            return JBUI.scale((int)10);
        }

        private int setBounds(@NotNull JComponent component2, int x, int centerY, @Nullable Dimension size, boolean minusWidth) {
            if (size == null) {
                size = component2.getPreferredSize();
            }
            if (minusWidth) {
                x -= size.width;
            }
            component2.setBounds(x, centerY - size.height / 2, size.width, size.height);
            return x;
        }

        private void addProcessIcon() {
            if (this.myProcessIconComponent == null) {
                this.myProcessIconComponent = (AsyncProcessIcon)InfoAndProgressPanel.this.myProgressIcon.getValue();
                this.add((Component)this.myProcessIconComponent);
            }
        }

        private void hideProcessIcon() {
            if (this.myProcessIconComponent != null) {
                this.myProcessIconComponent.setVisible(false);
            }
        }

        void updateState(@Nullable MyInlineProgressIndicator indicator) {
            if (this.getRootPane() == null) {
                return;
            }
            if (this.myIndicator != null) {
                this.remove(this.myIndicator.getComponent());
            }
            this.myIndicator = indicator;
            if (indicator == null) {
                this.myMultiProcessLink.setVisible(false);
                this.doLayout();
                this.revalidate();
                this.repaint();
            } else {
                this.add(indicator.getComponent());
                this.updateState();
            }
        }

        void updateState() {
            this.updateState(InfoAndProgressPanel.this.myPopup.isShowing());
        }

        void updateState(boolean showPopup) {
            if (this.myIndicator == null) {
                return;
            }
            int size = InfoAndProgressPanel.this.myOriginals.size();
            this.myIndicator.getComponent().setVisible(!showPopup);
            this.myMultiProcessLink.setVisible(showPopup || size > 1);
            if (showPopup) {
                this.myMultiProcessLink.setText("Hide processes (" + size + ")");
            } else if (size > 1) {
                this.myMultiProcessLink.setText("Show all (" + size + ")");
            }
            this.doLayout();
            this.revalidate();
            this.repaint();
        }
    }

    class MyInlineProgressIndicator
    extends InlineProgressIndicator {
        private ProgressIndicatorEx myOriginal;
        PresentationModeProgressPanel myPresentationModeProgressPanel;
        Balloon myPresentationModeBalloon;
        boolean myPresentationModeShowBalloon;

        MyInlineProgressIndicator(@NotNull TaskInfo task2, ProgressIndicatorEx original) {
            this(true, task2, original);
        }

        MyInlineProgressIndicator(@NotNull boolean compact, @NotNull TaskInfo task2, ProgressIndicatorEx original) {
            super(compact, task2);
            this.myOriginal = original;
            original.addStateDelegate(this);
            this.addStateDelegate(new AbstractProgressIndicatorExBase(){

                @Override
                public void cancel() {
                    super.cancel();
                    MyInlineProgressIndicator.this.updateProgress();
                }
            });
            InfoAndProgressPanel.this.runOnProgressRelatedChange(this::queueProgressUpdate, this, this.canCheckPowerSaveMode());
        }

        @Override
        protected void createCompactTextAndProgress() {
            this.myText.setTextAlignment(1.0f);
            this.myText.recomputeSize();
            UIUtil.setCursor((Component)((Object)this.myText), (Cursor)Cursor.getPredefinedCursor(12));
            UIUtil.setCursor((Component)this.myProgress, (Cursor)Cursor.getPredefinedCursor(12));
            super.createCompactTextAndProgress();
            ((JComponent)this.myProgress.getParent()).setBorder((Border)JBUI.Borders.empty((int)0, (int)8, (int)0, (int)4));
        }

        protected boolean canCheckPowerSaveMode() {
            return true;
        }

        @Override
        public String getText() {
            String text = StringUtil.notNullize((String)super.getText());
            ProgressSuspender suspender = this.getSuspender();
            return suspender != null && suspender.isSuspended() ? suspender.getSuspendedText() : text;
        }

        @Override
        protected JBIterable<ProgressButton> createEastButtons() {
            return JBIterable.of((Object)this.createSuspendButton()).append(super.createEastButtons());
        }

        protected void updateCancelButton(@NotNull InplaceButton suspend, @NotNull InplaceButton cancel) {
            boolean painting = this.getInfo().isCancellable() && !this.isStopping();
            cancel.setPainting(painting);
            cancel.setVisible(painting || !suspend.isVisible());
        }

        JBIterable<ProgressButton> createPresentationButtons() {
            ProgressButton suspend = this.createSuspendButton();
            ProgressButton cancel = this.createCancelButton();
            return JBIterable.of((Object)suspend).append((Object)new ProgressButton(cancel.button, () -> this.updateCancelButton(suspend.button, cancel.button)));
        }

        private ProgressButton createSuspendButton() {
            InplaceButton suspendButton = new InplaceButton("", AllIcons.Actions.Pause, e -> this.createSuspendRunnable().run()).setFillBg(false);
            return new ProgressButton(suspendButton, this.createSuspendUpdateRunnable(suspendButton));
        }

        @NotNull
        protected Runnable createSuspendRunnable() {
            return () -> {
                ProgressSuspender suspender = this.getSuspender();
                if (suspender == null) {
                    return;
                }
                if (suspender.isSuspended()) {
                    suspender.resumeProcess();
                } else {
                    suspender.suspendProcess(null);
                }
                UIEventLogger.logUIEvent((UIEventId)(suspender.isSuspended() ? UIEventId.ProgressPaused : UIEventId.ProgressResumed));
            };
        }

        @NotNull
        protected Runnable createSuspendUpdateRunnable(@NotNull InplaceButton suspendButton) {
            suspendButton.setVisible(false);
            return () -> {
                ProgressSuspender suspender = this.getSuspender();
                suspendButton.setVisible(suspender != null);
                if (suspender != null) {
                    String toolTipText;
                    String string = toolTipText = suspender.isSuspended() ? "Resume" : "Pause";
                    if (!toolTipText.equals(suspendButton.getToolTipText())) {
                        InfoAndProgressPanel.this.updateProgressIcon();
                        if (suspender.isSuspended()) {
                            this.showResumeIcons(suspendButton);
                        } else {
                            this.showPauseIcons(suspendButton);
                        }
                        suspendButton.setToolTipText(toolTipText);
                    }
                }
            };
        }

        private void showPauseIcons(InplaceButton button2) {
            this.setIcons(button2, AllIcons.Process.ProgressPauseSmall, AllIcons.Process.ProgressPause, AllIcons.Process.ProgressPauseSmallHover, AllIcons.Process.ProgressPauseHover);
        }

        private void showResumeIcons(InplaceButton button2) {
            this.setIcons(button2, AllIcons.Process.ProgressResumeSmall, AllIcons.Process.ProgressResume, AllIcons.Process.ProgressResumeSmallHover, AllIcons.Process.ProgressResumeHover);
        }

        private void setIcons(InplaceButton button2, Icon compactRegular, Icon regular, Icon compactHovered, Icon hovered2) {
            button2.setIcons(this.isCompact() ? compactRegular : regular, null, this.isCompact() ? compactHovered : hovered2);
            button2.revalidate();
            button2.repaint();
        }

        @Nullable
        protected ProgressSuspender getSuspender() {
            ProgressIndicatorEx original = this.myOriginal;
            return original == null ? null : ProgressSuspender.getSuspender(original);
        }

        @Override
        public void stop() {
            super.stop();
            this.updateProgress();
        }

        @Override
        protected boolean isFinished() {
            TaskInfo info = this.getInfo();
            return info == null || this.isFinished(info);
        }

        @Override
        public void finish(@NotNull TaskInfo task2) {
            super.finish(task2);
            this.queueRunningUpdate(() -> InfoAndProgressPanel.this.removeProgress(this));
        }

        @Override
        public void dispose() {
            super.dispose();
            this.myOriginal = null;
        }

        @Override
        protected void cancelRequest() {
            this.myOriginal.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void queueProgressUpdate() {
            Set set = InfoAndProgressPanel.this.myDirtyIndicators;
            synchronized (set) {
                InfoAndProgressPanel.this.myDirtyIndicators.add(this);
            }
            InfoAndProgressPanel.this.myUpdateQueue.queue(InfoAndProgressPanel.this.myUpdateIndicators);
        }

        @Override
        protected void queueRunningUpdate(final @NotNull Runnable update2) {
            InfoAndProgressPanel.this.myUpdateQueue.queue(new Update(new Object(), false, 0){

                public void run() {
                    ApplicationManager.getApplication().invokeLater(update2);
                }
            });
        }

        @Override
        public void updateProgressNow() {
            this.myProgress.setVisible(!PowerSaveMode.isEnabled() || !this.isPaintingIndeterminate());
            super.updateProgressNow();
            if (this.myPresentationModeProgressPanel != null) {
                this.myPresentationModeProgressPanel.update();
            }
        }

        public boolean showInPresentationMode() {
            return !InfoAndProgressPanel.this.isProcessWindowOpen();
        }
    }

    private class ProgressPanelProgressIndicator
    extends MyInlineProgressIndicator {
        private final ProgressPanel myProgressPanel;
        private final InplaceButton myCancelButton;
        private final InplaceButton mySuspendButton;
        private final Runnable mySuspendUpdateRunnable;

        ProgressPanelProgressIndicator(@NotNull TaskInfo task2, ProgressIndicatorEx original) {
            super(false, task2, original);
            ProgressPanelBuilder builder2 = new ProgressPanelBuilder(this.myProgress).withTopSeparator();
            builder2.withText2();
            builder2.withCancel(this::cancelRequest);
            Runnable suspendRunnable = this.createSuspendRunnable();
            builder2.withPause(suspendRunnable).withResume(suspendRunnable);
            this.myComponent = builder2.createPanel();
            this.myProgressPanel = Objects.requireNonNull(ProgressPanel.getProgressPanel((JComponent)this.myProgress));
            UIUtil.putClientProperty((JComponent)this.myComponent, ProcessPopup.KEY, (Object)this.myProgressPanel);
            this.myCancelButton = Objects.requireNonNull(this.myProgressPanel.getCancelButton());
            this.myCancelButton.setPainting(task2.isCancellable());
            this.mySuspendButton = Objects.requireNonNull(this.myProgressPanel.getSuspendButton());
            this.mySuspendUpdateRunnable = this.createSuspendUpdateRunnable(this.mySuspendButton);
            this.setProcessNameValue(task2.getTitle());
        }

        @Override
        @NotNull
        protected Runnable createSuspendUpdateRunnable(@NotNull InplaceButton suspendButton) {
            suspendButton.setVisible(false);
            return () -> {
                ProgressSuspender suspender = this.getSuspender();
                suspendButton.setVisible(suspender != null);
                if (suspender != null && this.myProgressPanel.getState() == ProgressPanel.State.PAUSED != suspender.isSuspended()) {
                    this.myProgressPanel.setState(suspender.isSuspended() ? ProgressPanel.State.PAUSED : ProgressPanel.State.PLAYING);
                    InfoAndProgressPanel.this.updateProgressIcon();
                }
            };
        }

        @Override
        protected boolean canCheckPowerSaveMode() {
            return false;
        }

        @Override
        protected void createComponent() {
        }

        @Override
        @Nullable
        protected String getTextValue() {
            return this.myProgressPanel.getCommentText();
        }

        @Override
        protected void setTextValue(@NotNull String text) {
            this.myProgressPanel.setCommentText(text);
        }

        @Override
        protected void setTextEnabled(boolean value2) {
            this.myProgressPanel.setCommentEnabled(value2);
        }

        @Override
        protected void setText2Value(@NotNull String text) {
            this.myProgressPanel.setText2(text);
        }

        @Override
        protected void setText2Enabled(boolean value2) {
            this.myProgressPanel.setText2Enabled(value2);
        }

        @Override
        protected void setProcessNameValue(@NotNull String text) {
            this.myProgressPanel.setLabelText(text);
        }

        @Override
        public void updateProgressNow() {
            super.updateProgressNow();
            this.mySuspendUpdateRunnable.run();
            this.updateCancelButton(this.mySuspendButton, this.myCancelButton);
        }
    }
}

