/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.openapi.wm.impl.FrameTitleBuilder;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class PlatformFrameTitleBuilder
extends FrameTitleBuilder {
    @Override
    public String getProjectTitle(@NotNull Project project) {
        String basePath = project.getBasePath();
        if (basePath == null) {
            return project.getName();
        }
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        int sameNamedProjects = ContainerUtil.count(Arrays.asList(projects), it -> it.getName().equals(project.getName()));
        if (sameNamedProjects == 1 && !UISettings.getInstance().getFullPathsInWindowHeader()) {
            return project.getName();
        }
        if ((basePath = FileUtil.toSystemDependentName((String)basePath)).equals(project.getName()) && !UISettings.getInstance().getFullPathsInWindowHeader()) {
            return "[" + FileUtil.getLocationRelativeToUserHome((String)basePath) + "]";
        }
        return project.getName() + " [" + FileUtil.getLocationRelativeToUserHome((String)basePath) + "]";
    }

    @Override
    public String getFileTitle(@NotNull Project project, @NotNull VirtualFile file2) {
        String fileTitle = VfsPresentationUtil.getPresentableNameForUI(project, file2);
        if (!fileTitle.endsWith(file2.getPresentableName()) || file2.getParent() == null) {
            return fileTitle;
        }
        if (UISettings.getInstance().getFullPathsInWindowHeader()) {
            return ProjectUtilCore.displayUrlRelativeToProject((VirtualFile)file2, (String)file2.getPresentableUrl(), (Project)project, (boolean)true, (boolean)false);
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (!fileIndex.isInContent(file2)) {
            String pathWithLibrary = ProjectUtilCore.decorateWithLibraryName((VirtualFile)file2, (Project)project, (String)file2.getPresentableName());
            if (pathWithLibrary != null) {
                return pathWithLibrary;
            }
            return FileUtil.getLocationRelativeToUserHome((String)file2.getPresentableUrl());
        }
        if (PlatformUtils.isCidr() || PlatformUtils.isRider()) {
            return fileTitle;
        }
        return ProjectUtilCore.appendModuleName((VirtualFile)file2, (Project)project, (String)fileTitle, (boolean)false);
    }
}

