/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.actions.CustomizeUIAction;
import com.intellij.ide.actions.ViewToolbarAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.jdkEx.JdkEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.IdeRootPaneNorthExtension;
import com.intellij.openapi.wm.impl.FrameInfoHelper;
import com.intellij.openapi.wm.impl.GlobalMenuLinux;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.openapi.wm.impl.IdeFrameDecorator;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.ToolWindowsPane;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomHeader;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.MainFrameHeader;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.components.JBBox;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeRootPane
extends JRootPane
implements UISettingsListener {
    private JComponent myToolbar;
    private IdeStatusBarImpl myStatusBar;
    private boolean myStatusBarDisposed;
    private final JBBox myNorthPanel = JBBox.createVerticalBox();
    private final List<IdeRootPaneNorthExtension> myNorthComponents = new ArrayList<IdeRootPaneNorthExtension>();
    private ToolWindowsPane myToolWindowsPane;
    private JBPanel<?> myContentPane;
    private final boolean myGlassPaneInitialized;
    private boolean myFullScreen;
    private MainFrameHeader myCustomFrameTitlePane;
    private final boolean myDecoratedMenu;

    protected IdeRootPane(@NotNull JFrame frame, @NotNull IdeFrame frameHelper, @NotNull Disposable parentDisposable) {
        if (SystemInfo.isWindows && (StartupUiUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF())) {
            try {
                this.setWindowDecorationStyle(1);
            }
            catch (Exception e) {
                Logger.getInstance(IdeRootPane.class).error((Throwable)e);
            }
        }
        this.myContentPane.add((Component)this.myNorthPanel, (Object)"North");
        this.myContentPane.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){});
        IdeMenuBar menu = this.createMenuBar();
        this.myDecoratedMenu = IdeFrameDecorator.isCustomDecorationActive();
        if (!this.isDecoratedMenu() && !FrameInfoHelper.isFloatingMenuBarSupported()) {
            this.setJMenuBar(menu);
        } else {
            if (this.isDecoratedMenu()) {
                JdkEx.setHasCustomDecoration(frame);
                this.myCustomFrameTitlePane = CustomHeader.createMainFrameHeader(frame, menu);
                this.getLayeredPane().add((Component)this.myCustomFrameTitlePane, JLayeredPane.DEFAULT_LAYER - 2);
                menu.setVisible(false);
            }
            if (FrameInfoHelper.isFloatingMenuBarSupported()) {
                this.menuBar = menu;
                this.getLayeredPane().add((Component)this.menuBar, new Integer(JLayeredPane.DEFAULT_LAYER - 1));
            }
            this.addPropertyChangeListener("ide.frame.full.screen", __ -> this.updateScreenState(frameHelper));
            this.updateScreenState(frameHelper);
        }
        IdeGlassPaneImpl glassPane = new IdeGlassPaneImpl(this, true);
        this.setGlassPane(glassPane);
        this.myGlassPaneInitialized = true;
        UIUtil.decorateWindowHeader((JRootPane)this);
        glassPane.setVisible(false);
        this.setBorder(UIManager.getBorder("Window.border"));
        UIUtil.setCustomTitleBar((Window)frame, (JRootPane)this, runnable2 -> Disposer.register((Disposable)parentDisposable, runnable2::run));
        this.updateMainMenuVisibility();
        this.myContentPane.add(this.getCenterComponent(frame, parentDisposable), (Object)"Center");
    }

    @NotNull
    protected IdeMenuBar createMenuBar() {
        return IdeMenuBar.createMenuBar();
    }

    @NotNull
    protected Component getCenterComponent(@NotNull JFrame frame, @NotNull Disposable parentDisposable) {
        this.myToolWindowsPane = new ToolWindowsPane(frame, parentDisposable);
        return this.myToolWindowsPane;
    }

    @NotNull
    public ToolWindowsPane getToolWindowPane() {
        return this.myToolWindowsPane;
    }

    public void init(@NotNull ProjectFrameHelper frame, @NotNull Disposable parentDisposable) {
        this.createAndConfigureStatusBar(frame, parentDisposable);
    }

    private void updateScreenState(@NotNull IdeFrame helper) {
        this.myFullScreen = helper.isInFullScreen();
        if (this.isDecoratedMenu()) {
            JMenuBar bar = this.getJMenuBar();
            if (bar != null) {
                bar.setVisible(this.myFullScreen);
            }
            if (this.myCustomFrameTitlePane != null) {
                this.myCustomFrameTitlePane.setVisible(!this.myFullScreen);
            }
        }
    }

    @Override
    protected LayoutManager createRootLayout() {
        return FrameInfoHelper.isFloatingMenuBarSupported() ? new MyRootLayout() : super.createRootLayout();
    }

    @Override
    public void setGlassPane(Component glass) {
        if (this.myGlassPaneInitialized) {
            throw new IllegalStateException("Setting of glass pane for IdeFrame is prohibited");
        }
        super.setGlassPane(glass);
    }

    @Override
    public final void addNotify() {
        super.addNotify();
    }

    @Override
    public final void removeNotify() {
        if (ScreenUtil.isStandardAddRemoveNotify((Component)this)) {
            if (!this.myStatusBarDisposed) {
                this.myStatusBarDisposed = true;
                Disposer.dispose((Disposable)this.myStatusBar);
            }
            this.setJMenuBar(null);
            if (this.myCustomFrameTitlePane != null) {
                this.layeredPane.remove(this.myCustomFrameTitlePane);
                Disposer.dispose((Disposable)this.myCustomFrameTitlePane);
            }
        }
        super.removeNotify();
    }

    @Override
    protected JLayeredPane createLayeredPane() {
        JBLayeredPane p = new JBLayeredPane();
        p.setName(this.getName() + ".layeredPane");
        return p;
    }

    @Override
    protected final Container createContentPane() {
        this.myContentPane = new JBPanel((LayoutManager)new BorderLayout());
        this.myContentPane.setBackground(IdeBackgroundUtil.getIdeBackgroundColor());
        return this.myContentPane;
    }

    void updateToolbar() {
        this.removeToolbar();
        this.myToolbar = IdeRootPane.createToolbar();
        this.myNorthPanel.add((Component)this.myToolbar, 0);
        this.updateToolbarVisibility();
        this.myContentPane.revalidate();
    }

    public void removeToolbar() {
        if (this.myToolbar != null) {
            this.myNorthPanel.remove((Component)this.myToolbar);
            this.myToolbar = null;
        }
    }

    protected void updateNorthComponents() {
        for (IdeRootPaneNorthExtension northComponent : this.myNorthComponents) {
            northComponent.revalidate();
        }
        this.myContentPane.revalidate();
    }

    void updateMainMenuActions() {
        ((IdeMenuBar)this.menuBar).updateMenuActions();
        this.menuBar.repaint();
    }

    @NotNull
    private static JComponent createToolbar() {
        ActionGroup group = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction("MainToolBar");
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        ActionToolbar toolBar = actionManager.createActionToolbar("MainToolbar", Objects.requireNonNull(group), true);
        toolBar.setLayoutPolicy(1);
        DefaultActionGroup menuGroup = new DefaultActionGroup();
        menuGroup.add((AnAction)new ViewToolbarAction());
        menuGroup.add((AnAction)new CustomizeUIAction());
        PopupHandler.installUnknownPopupHandler((JComponent)toolBar.getComponent(), (ActionGroup)menuGroup, (ActionManager)actionManager);
        return toolBar.getComponent();
    }

    private void createAndConfigureStatusBar(@NotNull IdeFrame frame, @NotNull Disposable parentDisposable) {
        this.myStatusBar = this.createStatusBar(frame);
        Disposer.register((Disposable)parentDisposable, (Disposable)this.myStatusBar);
        this.updateStatusBarVisibility();
        this.myContentPane.add((Component)this.myStatusBar, (Object)"South");
    }

    @NotNull
    protected IdeStatusBarImpl createStatusBar(@NotNull IdeFrame frame) {
        return new IdeStatusBarImpl(frame, true);
    }

    @Nullable
    final IdeStatusBarImpl getStatusBar() {
        return this.myStatusBar;
    }

    public int getStatusBarHeight() {
        IdeStatusBarImpl statusBar = this.myStatusBar;
        return statusBar != null && statusBar.isVisible() ? statusBar.getHeight() : 0;
    }

    private void updateToolbarVisibility() {
        UISettings uiSettings = UISettings.getShadowInstance();
        if (this.myToolbar != null) {
            this.myToolbar.setVisible(uiSettings.getShowMainToolbar() && !uiSettings.getPresentationMode());
        }
    }

    private void updateStatusBarVisibility() {
        UISettings uiSettings = UISettings.getShadowInstance();
        this.myStatusBar.setVisible(uiSettings.getShowStatusBar() && !uiSettings.getPresentationMode());
    }

    private void updateMainMenuVisibility() {
        boolean visible;
        UISettings uiSettings = UISettings.getShadowInstance();
        if (uiSettings.getPresentationMode() || IdeFrameDecorator.isCustomDecorationActive()) {
            return;
        }
        boolean globalMenuVisible = SystemInfo.isLinux && GlobalMenuLinux.isPresented();
        boolean bl = visible = SystemInfo.isMacSystemMenu || !globalMenuVisible && uiSettings.getShowMainMenu();
        if (visible != this.menuBar.isVisible()) {
            this.menuBar.setVisible(visible);
        }
    }

    void setProject(Project project) {
        if (this.myCustomFrameTitlePane != null) {
            this.myCustomFrameTitlePane.setProject(project);
        }
    }

    protected void installNorthComponents(@NotNull Project project) {
        this.myNorthComponents.addAll(IdeRootPaneNorthExtension.EP_NAME.getExtensionList((AreaInstance)project));
        if (this.myNorthComponents.isEmpty()) {
            return;
        }
        UISettings uiSettings = UISettings.getShadowInstance();
        for (IdeRootPaneNorthExtension northComponent : this.myNorthComponents) {
            this.myNorthPanel.add((Component)northComponent.getComponent());
            northComponent.uiSettingsChanged(uiSettings);
        }
    }

    protected void deinstallNorthComponents() {
        int count = this.myNorthPanel.getComponentCount();
        for (int i2 = count - 1; i2 >= 0; --i2) {
            if (this.myNorthPanel.getComponent(i2) == this.myToolbar) continue;
            this.myNorthPanel.remove(i2);
        }
        for (IdeRootPaneNorthExtension northComponent : this.myNorthComponents) {
            if (!(northComponent instanceof Disposable) || Disposer.isDisposed((Disposable)((Disposable)northComponent))) continue;
            Disposer.dispose((Disposable)((Disposable)northComponent));
        }
        this.myNorthComponents.clear();
    }

    @Nullable
    public IdeRootPaneNorthExtension findByName(@NotNull String name) {
        for (IdeRootPaneNorthExtension northComponent : this.myNorthComponents) {
            if (!northComponent.getKey().equals(name)) continue;
            return northComponent;
        }
        return null;
    }

    public void uiSettingsChanged(@NotNull UISettings uiSettings) {
        UIUtil.decorateWindowHeader((JRootPane)this);
        this.updateToolbarVisibility();
        this.updateStatusBarVisibility();
        this.updateMainMenuVisibility();
        for (IdeRootPaneNorthExtension component2 : this.myNorthComponents) {
            component2.uiSettingsChanged(uiSettings);
        }
        IdeFrameImpl frame = (IdeFrameImpl)ComponentUtil.getParentOfType(IdeFrameImpl.class, (Component)this);
        if (frame == null) {
            return;
        }
        frame.setBackground(UIUtil.getPanelBackground());
        BalloonLayout layout = frame.getBalloonLayout();
        if (layout instanceof BalloonLayoutImpl) {
            ((BalloonLayoutImpl)layout).queueRelayout();
        }
    }

    private boolean isDecoratedMenu() {
        return IdeFrameDecorator.isCustomDecorationActive() && this.myDecoratedMenu;
    }

    private class MyRootLayout
    extends JRootPane.RootLayout {
        private MyRootLayout() {
            super(IdeRootPane.this);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Insets i2 = IdeRootPane.this.getInsets();
            Dimension rd = IdeRootPane.this.contentPane != null ? IdeRootPane.this.contentPane.getPreferredSize() : parent.getSize();
            Object dimension = IdeRootPane.this.myCustomFrameTitlePane != null && IdeRootPane.this.myCustomFrameTitlePane.isVisible() ? IdeRootPane.this.myCustomFrameTitlePane.getPreferredSize() : JBUI.emptySize();
            Object mbd = IdeRootPane.this.menuBar != null && IdeRootPane.this.menuBar.isVisible() && !IdeRootPane.this.myFullScreen && !IdeRootPane.this.isDecoratedMenu() ? IdeRootPane.this.menuBar.getPreferredSize() : JBUI.emptySize();
            return new Dimension(Math.max(rd.width, mbd.width) + i2.left + i2.right + dimension.width, rd.height + mbd.height + i2.top + i2.bottom + dimension.height);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Insets i2 = IdeRootPane.this.getInsets();
            Dimension rd = IdeRootPane.this.contentPane != null ? IdeRootPane.this.contentPane.getMinimumSize() : parent.getSize();
            Object dimension = IdeRootPane.this.isDecoratedMenu() && IdeRootPane.this.myCustomFrameTitlePane != null && IdeRootPane.this.myCustomFrameTitlePane.isVisible() ? IdeRootPane.this.myCustomFrameTitlePane.getPreferredSize() : JBUI.emptySize();
            Object mbd = IdeRootPane.this.menuBar != null && IdeRootPane.this.menuBar.isVisible() && !IdeRootPane.this.myFullScreen && !IdeRootPane.this.isDecoratedMenu() ? IdeRootPane.this.menuBar.getMinimumSize() : JBUI.emptySize();
            return new Dimension(Math.max(rd.width, mbd.width) + i2.left + i2.right + dimension.width, rd.height + mbd.height + i2.top + i2.bottom + dimension.height);
        }

        @Override
        public Dimension maximumLayoutSize(Container target2) {
            Insets i2 = IdeRootPane.this.getInsets();
            Object mbd = IdeRootPane.this.menuBar != null && IdeRootPane.this.menuBar.isVisible() && !IdeRootPane.this.myFullScreen && !IdeRootPane.this.isDecoratedMenu() ? IdeRootPane.this.menuBar.getMaximumSize() : JBUI.emptySize();
            Object dimension = IdeRootPane.this.isDecoratedMenu() && IdeRootPane.this.myCustomFrameTitlePane != null && IdeRootPane.this.myCustomFrameTitlePane.isVisible() ? IdeRootPane.this.myCustomFrameTitlePane.getPreferredSize() : JBUI.emptySize();
            Dimension rd = IdeRootPane.this.contentPane != null ? IdeRootPane.this.contentPane.getMaximumSize() : new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE - i2.top - i2.bottom - mbd.height - 1);
            return new Dimension(Math.min(rd.width, mbd.width) + i2.left + i2.right + dimension.width, rd.height + mbd.height + i2.top + i2.bottom + dimension.height);
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension tpd;
            Rectangle b = parent.getBounds();
            Insets i2 = IdeRootPane.this.getInsets();
            int w = b.width - i2.right - i2.left;
            int h = b.height - i2.top - i2.bottom;
            if (IdeRootPane.this.layeredPane != null) {
                IdeRootPane.this.layeredPane.setBounds(i2.left, i2.top, w, h);
            }
            if (IdeRootPane.this.glassPane != null) {
                IdeRootPane.this.glassPane.setBounds(i2.left, i2.top, w, h);
            }
            int contentY = 0;
            if (IdeRootPane.this.menuBar != null && IdeRootPane.this.menuBar.isVisible()) {
                Dimension mbd = IdeRootPane.this.menuBar.getPreferredSize();
                IdeRootPane.this.menuBar.setBounds(0, 0, w, mbd.height);
                if (!IdeRootPane.this.myFullScreen && !IdeRootPane.this.isDecoratedMenu()) {
                    contentY += mbd.height;
                }
            }
            if (IdeRootPane.this.myCustomFrameTitlePane != null && IdeRootPane.this.myCustomFrameTitlePane.isVisible() && (tpd = IdeRootPane.this.myCustomFrameTitlePane.getPreferredSize()) != null) {
                int tpHeight = tpd.height;
                IdeRootPane.this.myCustomFrameTitlePane.setBounds(0, 0, w, tpHeight);
                contentY += tpHeight;
            }
            if (IdeRootPane.this.contentPane != null) {
                IdeRootPane.this.contentPane.setBounds(0, contentY, w, h - contentY);
            }
        }
    }
}

