/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.BitUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.keyFMap.KeyFMap;
import com.intellij.util.text.ByteArrayCharSequence;
import com.intellij.util.text.CharSequenceHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsData {
    private static final Logger LOG = Logger.getInstance(VfsData.class);
    private static final int SEGMENT_BITS = 9;
    private static final int SEGMENT_SIZE = 512;
    private static final int OFFSET_MASK = 511;
    private final Object myDeadMarker = ObjectUtils.sentinel((String)"dead file");
    private final ConcurrentIntObjectMap<Segment> mySegments = ContainerUtil.createConcurrentIntObjectMap();
    private final ConcurrentBitSet myInvalidatedIds = new ConcurrentBitSet();
    private TIntHashSet myDyingIds = new TIntHashSet();
    private final IntObjectMap<VirtualDirectoryImpl> myChangedParents = ContainerUtil.createConcurrentIntObjectMap();

    public VfsData() {
        ApplicationManager.getApplication().addApplicationListener(new ApplicationListener(){

            public void writeActionFinished(@NotNull Object action2) {
                if (!ApplicationManager.getApplication().isWriteAccessAllowed()) {
                    VfsData.this.killInvalidatedFiles();
                }
            }
        }, (Disposable)ApplicationManager.getApplication());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killInvalidatedFiles() {
        Object object = this.myDeadMarker;
        synchronized (object) {
            if (!this.myDyingIds.isEmpty()) {
                for (int id2 : this.myDyingIds.toArray()) {
                    Segment segment = Objects.requireNonNull(this.getSegment(id2, false));
                    segment.myObjectArray.set(VfsData.getOffset(id2), this.myDeadMarker);
                    this.myChangedParents.remove(id2);
                }
                this.myDyingIds = new TIntHashSet();
            }
        }
    }

    @Nullable
    VirtualFileSystemEntry getFileById(int id2, @NotNull VirtualDirectoryImpl parent, boolean putToMemoryCache) {
        PersistentFSImpl persistentFS = (PersistentFSImpl)PersistentFS.getInstance();
        VirtualFileSystemEntry dir = persistentFS.getCachedDir(id2);
        if (dir != null) {
            return dir;
        }
        Segment segment = this.getSegment(id2, false);
        if (segment == null) {
            return null;
        }
        int offset = VfsData.getOffset(id2);
        Object o = segment.myObjectArray.get(offset);
        if (o == null) {
            return null;
        }
        if (o == this.myDeadMarker) {
            throw VfsData.reportDeadFileAccess(new VirtualFileImpl(id2, segment, parent));
        }
        int nameId = segment.getNameId(id2);
        if (nameId <= 0) {
            FSRecords.invalidateCaches();
            throw new AssertionError((Object)("nameId=" + nameId + "; data=" + o + "; parent=" + (Object)((Object)parent) + "; parent.id=" + parent.getId() + "; db.parent=" + FSRecords.getParent(id2)));
        }
        if (o instanceof DirectoryData) {
            if (putToMemoryCache) {
                return persistentFS.getOrCacheDir(id2, new VirtualDirectoryImpl(id2, segment, (DirectoryData)o, parent, parent.getFileSystem()));
            }
            VirtualFileSystemEntry entry = persistentFS.getCachedDir(id2);
            if (entry != null) {
                return entry;
            }
            return new VirtualDirectoryImpl(id2, segment, (DirectoryData)o, parent, parent.getFileSystem());
        }
        return new VirtualFileImpl(id2, segment, parent);
    }

    @NotNull
    private static InvalidVirtualFileAccessException reportDeadFileAccess(@NotNull VirtualFileSystemEntry file2) {
        return new InvalidVirtualFileAccessException("Accessing dead virtual file: " + file2.getUrl());
    }

    private static int getOffset(int id2) {
        if (id2 <= 0) {
            throw new IllegalArgumentException("invalid argument id: " + id2);
        }
        return id2 & 0x1FF;
    }

    @Nullable
    @Contract(value="_,true->!null")
    public Segment getSegment(int id2, boolean create2) {
        int key = id2 >>> 9;
        Segment segment = (Segment)this.mySegments.get(key);
        if (segment != null || !create2) {
            return segment;
        }
        return (Segment)this.mySegments.cacheOrGet(key, (Object)new Segment(this));
    }

    public boolean hasLoadedFile(int id2) {
        Segment segment = this.getSegment(id2, false);
        return segment != null && segment.myObjectArray.get(VfsData.getOffset(id2)) != null;
    }

    static void initFile(int id2, @NotNull Segment segment, int nameId, @NotNull Object data2) throws FileAlreadyCreatedException {
        int offset = VfsData.getOffset(id2);
        segment.setNameId(id2, nameId);
        Object existingData = segment.myObjectArray.get(offset);
        if (existingData != null) {
            String msg = FSRecords.diagnosticsForAlreadyCreatedFile(id2, nameId, existingData);
            throw new FileAlreadyCreatedException(msg);
        }
        segment.myObjectArray.set(offset, data2);
    }

    @NotNull
    CharSequence getNameByFileId(int id2) {
        return FileNameCache.getVFileName(this.getNameId(id2));
    }

    int getNameId(int id2) {
        return Objects.requireNonNull(this.getSegment(id2, false)).getNameId(id2);
    }

    boolean isFileValid(int id2) {
        return !this.myInvalidatedIds.get(id2);
    }

    @Nullable
    private VirtualDirectoryImpl getChangedParent(int id2) {
        return (VirtualDirectoryImpl)((Object)this.myChangedParents.get(id2));
    }

    private void changeParent(int id2, @NotNull VirtualDirectoryImpl parent) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.myChangedParents.put(id2, (Object)parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidateFile(int id2) {
        this.myInvalidatedIds.set(id2);
        Object object = this.myDeadMarker;
        synchronized (object) {
            this.myDyingIds.add(id2);
        }
    }

    static class DirectoryData {
        private static final AtomicFieldUpdater<DirectoryData, KeyFMap> MY_USER_MAP_UPDATER = AtomicFieldUpdater.forFieldOfType(DirectoryData.class, KeyFMap.class);
        @NotNull
        volatile KeyFMap myUserMap = KeyFMap.EMPTY_MAP;
        volatile int @NotNull [] myChildrenIds = ArrayUtilRt.EMPTY_INT_ARRAY;
        private volatile Set<CharSequence> myAdoptedNames;

        DirectoryData() {
        }

        VirtualFileSystemEntry @NotNull [] getFileChildren(@NotNull VirtualDirectoryImpl parent, boolean putToMemoryCache) {
            int[] ids = this.myChildrenIds;
            VirtualFileSystemEntry[] children2 = new VirtualFileSystemEntry[ids.length];
            for (int i2 = 0; i2 < ids.length; ++i2) {
                int childId = ids[i2];
                VirtualFileSystemEntry child2 = parent.mySegment.vfsData.getFileById(childId, parent, putToMemoryCache);
                if (child2 == null) {
                    throw new AssertionError((Object)("No file for id " + childId + ", parentId = " + parent.myId));
                }
                children2[i2] = child2;
            }
            return children2;
        }

        boolean changeUserMap(@NotNull KeyFMap oldMap, @NotNull KeyFMap newMap) {
            return MY_USER_MAP_UPDATER.compareAndSet((Object)this, (Object)oldMap, (Object)newMap);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isAdoptedName(@NotNull CharSequence name) {
            Set<CharSequence> adopted = this.myAdoptedNames;
            if (adopted == null) {
                return false;
            }
            Set<CharSequence> set = adopted;
            synchronized (set) {
                return adopted.contains(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeAdoptedName(@NotNull CharSequence name) {
            Set<CharSequence> adopted = this.myAdoptedNames;
            if (adopted == null) {
                return;
            }
            Set<CharSequence> set = adopted;
            synchronized (set) {
                boolean removed = adopted.remove(name);
                if (removed && adopted.isEmpty()) {
                    this.myAdoptedNames = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addAdoptedName(@NotNull CharSequence name, boolean caseSensitive) {
            Set<CharSequence> adopted = this.getOrCreateAdoptedNames(caseSensitive);
            CharSequence sequence = ByteArrayCharSequence.convertToBytesIfPossible((CharSequence)name);
            Set<CharSequence> set = adopted;
            synchronized (set) {
                adopted.add(sequence);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addAdoptedNames(@NotNull Collection<? extends CharSequence> names2, boolean caseSensitive) {
            Set<CharSequence> adopted;
            Set<CharSequence> set = adopted = this.getOrCreateAdoptedNames(caseSensitive);
            synchronized (set) {
                adopted.addAll(names2);
            }
        }

        @NotNull
        private Set<CharSequence> getOrCreateAdoptedNames(boolean caseSensitive) {
            THashSet adopted = this.myAdoptedNames;
            if (adopted == null) {
                this.myAdoptedNames = adopted = new THashSet(0, (TObjectHashingStrategy)(caseSensitive ? CharSequenceHashingStrategy.CASE_SENSITIVE : CharSequenceHashingStrategy.CASE_INSENSITIVE));
            }
            return adopted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        List<String> getAdoptedNames() {
            Set<CharSequence> adopted = this.myAdoptedNames;
            if (adopted == null) {
                return Collections.emptyList();
            }
            Set<CharSequence> set = adopted;
            synchronized (set) {
                return ContainerUtil.map(adopted, (Function)Functions.TO_STRING());
            }
        }

        void clearAdoptedNames() {
            this.myAdoptedNames = null;
        }

        public String toString() {
            return "DirectoryData{myUserMap=" + this.myUserMap + ", myChildrenIds=" + Arrays.toString(this.myChildrenIds) + ", myAdoptedNames=" + this.myAdoptedNames + '}';
        }
    }

    static class Segment {
        private final AtomicReferenceArray<Object> myObjectArray = new AtomicReferenceArray(512);
        private final AtomicIntegerArray myIntArray = new AtomicIntegerArray(1024);
        @NotNull
        final VfsData vfsData;
        ConcurrentBitSet changedParents;

        Segment(@NotNull VfsData vfsData) {
            this.vfsData = vfsData;
        }

        int getNameId(int fileId) {
            return this.myIntArray.get(VfsData.getOffset(fileId) * 2);
        }

        void setNameId(int fileId, int nameId) {
            if (fileId <= 0 || nameId <= 0) {
                throw new IllegalArgumentException("invalid arguments id: " + fileId + "; nameId: " + nameId);
            }
            this.myIntArray.set(VfsData.getOffset(fileId) * 2, nameId);
        }

        void setUserMap(int fileId, @NotNull KeyFMap map2) {
            this.myObjectArray.set(VfsData.getOffset(fileId), map2);
        }

        @NotNull
        KeyFMap getUserMap(@NotNull VirtualFileSystemEntry file2, int id2) {
            Object o = this.myObjectArray.get(VfsData.getOffset(id2));
            if (!(o instanceof KeyFMap)) {
                throw VfsData.reportDeadFileAccess(file2);
            }
            return (KeyFMap)o;
        }

        boolean changeUserMap(int fileId, KeyFMap oldMap, KeyFMap newMap) {
            return this.myObjectArray.compareAndSet(VfsData.getOffset(fileId), oldMap, newMap);
        }

        boolean getFlag(int id2, int mask) {
            assert ((mask & 0xFFFFFF) == 0) : "Unexpected flag";
            return (this.myIntArray.get(VfsData.getOffset(id2) * 2 + 1) & mask) != 0;
        }

        void setFlag(int id2, int mask, boolean value2) {
            int updated;
            int oldInt;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Set flag " + Integer.toHexString(mask) + "=" + value2 + " for id=" + id2);
            }
            assert ((mask & 0xFFFFFF) == 0) : "Unexpected flag";
            int offset = VfsData.getOffset(id2) * 2 + 1;
            while (!this.myIntArray.compareAndSet(offset, oldInt = this.myIntArray.get(offset), updated = BitUtil.set((int)oldInt, (int)mask, (boolean)value2))) {
            }
        }

        long getModificationStamp(int id2) {
            return this.myIntArray.get(VfsData.getOffset(id2) * 2 + 1) & 0xFFFFFF;
        }

        void setModificationStamp(int id2, long stamp) {
            int updated;
            int oldInt;
            int offset = VfsData.getOffset(id2) * 2 + 1;
            while (!this.myIntArray.compareAndSet(offset, oldInt = this.myIntArray.get(offset), updated = oldInt & 0xFF000000 | (int)stamp & 0xFFFFFF)) {
            }
        }

        void changeParent(int fileId, VirtualDirectoryImpl directory) {
            this.vfsData.changeParent(fileId, directory);
            if (this.changedParents == null) {
                this.changedParents = new ConcurrentBitSet();
            }
            this.changedParents.set(VfsData.getOffset(fileId));
        }

        @Nullable
        VirtualDirectoryImpl getChangedParent(int fileId) {
            ConcurrentBitSet bits = this.changedParents;
            return bits == null || !bits.get(VfsData.getOffset(fileId)) ? null : this.vfsData.getChangedParent(fileId);
        }
    }

    public static class FileAlreadyCreatedException
    extends RuntimeException {
        private FileAlreadyCreatedException(@NotNull String message) {
            super(message);
        }
    }
}

